/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler.dsbref;

import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.IPrepareDataable;
import com.kingdee.bos.qing.dashboard.reference.IPublishPrepareDataable;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.RefHandlerFactory;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.imexport.util.QHFDsbUtil;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.PublishedNotExistPrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.PublishedPrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.SubjectModelParseException;
import com.kingdee.bos.qing.preparedata.handler.AbstractPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.handler.dsbref.DsbRefPrepareDataContext;
import com.kingdee.bos.qing.preparedata.preparedatacontext.IPrepareDataContext;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.model.PublishPO;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DsbRefPrepareDataHandler
extends AbstractPrepareDataHandler {
    private CommonPublishDomain commonPublishDomain;
    private Map<RefTypeEnum, IRefHandler> refHandlerMap;
    private DsbRefPrepareDataContext dsbRefPrepareDataContext;

    public DsbRefPrepareDataHandler(IPrepareDataContext extractContext) {
        super(extractContext);
        this.dsbRefPrepareDataContext = (DsbRefPrepareDataContext)extractContext;
    }

    private CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.getPrepareContext().getQingContext(), this.getPrepareContext().getTransManagement(), this.getPrepareContext().getDBExecuter());
        }
        return this.commonPublishDomain;
    }

    private IRefHandler getRefHandler(RefTypeEnum refType) {
        IRefHandler refHandler;
        if (this.refHandlerMap == null) {
            this.refHandlerMap = new HashMap<RefTypeEnum, IRefHandler>();
        }
        if ((refHandler = this.refHandlerMap.get(refType)) == null) {
            refHandler = RefHandlerFactory.createHandler(refType, this.getPrepareContext().getDBExecuter(), this.getPrepareContext().getQingContext(), this.getPrepareContext().getTransManagement());
            this.refHandlerMap.put(refType, refHandler);
        }
        return refHandler;
    }

    @Override
    public void createDataSource() throws PrepareDataException {
        boolean isPublished = this.dsbRefPrepareDataContext.isPublished();
        if (isPublished) {
            String dashboardUniqueId = this.dsbRefPrepareDataContext.getDashboardUniqueId();
            PublishPO publishPO = null;
            try {
                publishPO = this.getCommonPublishDomain().loadPublishInfo(dashboardUniqueId);
            }
            catch (AbstractQingIntegratedException e) {
                throw new PublishedPrepareDataException(e);
            }
            catch (SQLException e) {
                throw new PublishedPrepareDataException(e);
            }
            if (publishPO == null) {
                throw new PublishedNotExistPrepareDataException();
            }
            if (publishPO.isCarryData()) {
                this.carryDataDataPrepare(publishPO);
            } else {
                this.prepareDataNow();
            }
        } else {
            this.prepareDataNow();
        }
        this.cacheQHFExportDataSource();
    }

    private void prepareDataNow() throws PrepareDataException {
        ReferenceMap referenceMap = this.dsbRefPrepareDataContext.getReferenceMap();
        this.dsbRefPrepareDataContext.getProgressModel();
        String refType = referenceMap.getRefType();
        String refToId = referenceMap.getRefToId();
        RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)refType);
        IRefHandler refHandler = this.getRefHandler(refTypeEnum);
        if (refHandler instanceof IPrepareDataable) {
            IPrepareDataable refPrepareDataHandler = (IPrepareDataable)((Object)refHandler);
            IPrepareDataContext prepareDataContext = refPrepareDataHandler.getDataPrepareContext(this.dsbRefPrepareDataContext.getTag(), refToId, false, this.dsbRefPrepareDataContext.isFirstFromCache(), this.dsbRefPrepareDataContext.getProgressModel());
            this.dsbRefPrepareDataContext.setRelatedPrepareDataContext(prepareDataContext);
            AbstractPrepareDataHandler prepareDataHandler = refPrepareDataHandler.getDataPrepareHandler(prepareDataContext);
            prepareDataHandler.createDataSource();
        }
    }

    private void carryDataDataPrepare(PublishPO publishPO) throws PrepareDataException {
        String tag = this.dsbRefPrepareDataContext.getTag();
        ReferenceMap referenceMap = this.dsbRefPrepareDataContext.getReferenceMap();
        String refType = referenceMap.getRefType();
        RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)refType);
        IRefHandler refHandler = this.getRefHandler(refTypeEnum);
        if (refHandler instanceof IPublishPrepareDataable) {
            IPublishPrepareDataable refPrepareDataHandler = (IPublishPrepareDataable)((Object)refHandler);
            try {
                refPrepareDataHandler.createPublishedCarryDataDataSource(tag, publishPO, referenceMap);
            }
            catch (AbstractQingIntegratedException e) {
                throw new PublishedPrepareDataException(e);
            }
            catch (SQLException e) {
                throw new PublishedPrepareDataException(e);
            }
            catch (ModelParseException e) {
                throw new SubjectModelParseException(e);
            }
            catch (IOException e) {
                throw new PublishedPrepareDataException(e);
            }
        }
    }

    private void cacheQHFExportDataSource() {
        String dashboardUniqueId = this.dsbRefPrepareDataContext.getDashboardUniqueId();
        boolean isPublished = this.dsbRefPrepareDataContext.isPublished();
        String tag = this.dsbRefPrepareDataContext.getTag();
        ReferenceMap referenceMap = this.dsbRefPrepareDataContext.getReferenceMap();
        String uid = referenceMap.getUid();
        String uniqueKey = QHFDsbUtil.getRefUniqueKey(dashboardUniqueId, isPublished, uid);
        QingSessionUtil.set((String)uniqueKey, (String)tag);
    }
}

