/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.handler.subject;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.cache.LinkageContext;
import com.kingdee.bos.qing.common.cache.ThemeDataSource;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.data.domain.source.AbstractDataSourceDomain;
import com.kingdee.bos.qing.data.domain.source.SourceDomainFactory;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.preparedata.cache.ProgressModel;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.PrepareEncryptedLicenseCheckException;
import com.kingdee.bos.qing.preparedata.exception.PublishedPrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.SubjectModelNoEntityException;
import com.kingdee.bos.qing.preparedata.exception.SubjectModelNoEntityOwnerException;
import com.kingdee.bos.qing.preparedata.exception.SubjectModelNotDefinedException;
import com.kingdee.bos.qing.preparedata.exception.SubjectModelNotDefinedOwnerException;
import com.kingdee.bos.qing.preparedata.exception.SubjectModelParseException;
import com.kingdee.bos.qing.preparedata.exception.SubjectNotFoundPrepareDataException;
import com.kingdee.bos.qing.preparedata.exception.SubjectPrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.AbstractPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.handler.publish.IPublishDataPrepareHandler;
import com.kingdee.bos.qing.preparedata.handler.publish.PublishPrepareDataContext;
import com.kingdee.bos.qing.preparedata.handler.subject.AbstractSubjectDataExtractor;
import com.kingdee.bos.qing.preparedata.handler.subject.ISubjectCallbackFunction;
import com.kingdee.bos.qing.preparedata.handler.subject.ShareSubjectExtractor;
import com.kingdee.bos.qing.preparedata.handler.subject.SubjectDataExtractor;
import com.kingdee.bos.qing.preparedata.preparedatacontext.IPrepareDataContext;
import com.kingdee.bos.qing.preparedata.preparedatacontext.SubjectPrepareDataContext;
import com.kingdee.bos.qing.publish.dao.PublishSubjectFileDao;
import com.kingdee.bos.qing.publish.dao.PublishSubjectModelDao;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSubjectFilePO;
import com.kingdee.bos.qing.subject.domain.SubjectRuntimeDomain;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.FileNotFoundException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubjectPrepareDataHandler
extends AbstractPrepareDataHandler
implements IPublishDataPrepareHandler {
    private QingContext qingContext;
    private IDBExcuter dbExcuter;
    private SubjectRuntimeDomain subjectDomain;
    private PublishSubjectModelDao publishSubjectModelDao;
    private PublishSubjectFileDao publishSubjectFileDao;
    private ISubjectCallbackFunction callBackFunction;
    private ProgressModel progressModel;
    private boolean startBySchedule;
    private Boolean isEnableClippingOptimization = Boolean.parseBoolean(System.getProperty("qing.clipping.enable", "true"));

    public SubjectPrepareDataHandler(IPrepareDataContext extractContext) {
        super(extractContext);
        this.qingContext = this.getPrepareContext().getQingContext();
        this.dbExcuter = this.getPrepareContext().getDBExecuter();
        this.startBySchedule = this.getPrepareContext().isStartBySchedule();
        this.subjectDomain = new SubjectRuntimeDomain(this.getPrepareContext().getQingContext(), this.getPrepareContext().getTransManagement(), this.getPrepareContext().getDBExecuter());
        this.progressModel = this.getPrepareContext().getProgressModel();
        if (this.getPrepareContext() instanceof SubjectPrepareDataContext) {
            SubjectPrepareDataContext subjectPrepareDataContext = (SubjectPrepareDataContext)extractContext;
            this.callBackFunction = subjectPrepareDataContext.getSubjectPrepareDataCallBackImpl();
        } else if (this.getPrepareContext() instanceof PublishPrepareDataContext) {
            SubjectPrepareDataContext subjectPrepareDataContext = new SubjectPrepareDataContext();
            subjectPrepareDataContext.setQingContext(this.qingContext);
            subjectPrepareDataContext.setDbExcuter(this.dbExcuter);
            subjectPrepareDataContext.setStartBySchedule(this.getPrepareContext().isStartBySchedule());
            subjectPrepareDataContext.setTx(this.getPrepareContext().getTransManagement());
            subjectPrepareDataContext.setDealProgresss(this.getPrepareContext().isDealProgresss());
            subjectPrepareDataContext.setProgressModel(this.getPrepareContext().getProgressModel());
            subjectPrepareDataContext.setTag(this.getPrepareContext().getTag());
            subjectPrepareDataContext.setFirstFromCache(this.getPrepareContext().isFirstFromCache());
            this.callBackFunction = subjectPrepareDataContext.getSubjectPrepareDataCallBackImpl();
            this.prepareContext = subjectPrepareDataContext;
            PublishPrepareDataContext publishPrepareDataContext = (PublishPrepareDataContext)extractContext;
            publishPrepareDataContext.setGeneralPrepareDataContext(subjectPrepareDataContext);
        }
    }

    private PublishSubjectModelDao getPublishSubjectModelDao() {
        if (this.publishSubjectModelDao == null) {
            this.publishSubjectModelDao = new PublishSubjectModelDao(this.dbExcuter);
        }
        return this.publishSubjectModelDao;
    }

    private PublishSubjectFileDao getPublishSubjectFileDao() {
        if (this.publishSubjectFileDao == null) {
            this.publishSubjectFileDao = new PublishSubjectFileDao(this.dbExcuter);
        }
        return this.publishSubjectFileDao;
    }

    public void setCallBackFunction(ISubjectCallbackFunction callBackFunction) {
        this.callBackFunction = callBackFunction;
    }

    public void setProgressModel(ProgressModel progressModel) {
        this.progressModel = progressModel;
    }

    @Override
    public void createDataSource() {
        SubjectPrepareDataContext subjectPrepareDataContext = (SubjectPrepareDataContext)this.getPrepareContext();
        String subjectId = subjectPrepareDataContext.getThemeId();
        String creatorId = subjectPrepareDataContext.getCreatorId();
        boolean isSaveMode = subjectPrepareDataContext.isSaveMode();
        this.createDataSource(subjectId, creatorId, isSaveMode, null);
    }

    private void createDataSource(String subjectId, String creatorId, boolean isSaveModel, String schemaId) {
        String cacheKey;
        ThemeDataSource datasourceCache;
        SubjectPrepareDataContext subjectPrepareDataContext = (SubjectPrepareDataContext)this.getPrepareContext();
        String tag = subjectPrepareDataContext.getTag();
        boolean isFirstFromCache = subjectPrepareDataContext.isFirstFromCache();
        if (isFirstFromCache && (datasourceCache = (ThemeDataSource)QingSessionUtil.getCache((String)(cacheKey = ThemeDataSource.getCacheKey(tag)), ThemeDataSource.class)) != null) {
            this.callBackFunction.finishAll(null);
            return;
        }
        String ownerId = null;
        ThemePO themePO = null;
        Box box = null;
        AbstractSubjectDataExtractor subjectDataExtractor = null;
        try {
            themePO = this.loadAndCheckThemePo(subjectId);
            ownerId = themePO.getUserID();
            box = this.loadAndCheckBoxModel(subjectId, ownerId);
            subjectDataExtractor = this.startBySchedule ? new SubjectDataExtractor(this.qingContext, this.subjectDomain, this.progressModel, themePO, box, this.startBySchedule, isSaveModel, creatorId, null) : new ShareSubjectExtractor(this.qingContext, this.subjectDomain, this.progressModel, themePO, box, this.startBySchedule, isSaveModel, creatorId, schemaId, this.dbExcuter);
            subjectDataExtractor.setCallBackFunction(this.callBackFunction);
            boolean success = subjectDataExtractor.tryToGetDataSourceFromTemp();
            if (success) {
                return;
            }
        }
        catch (PrepareDataException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)e));
            return;
        }
        catch (ModelParseException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectModelParseException(e)));
            return;
        }
        catch (Exception e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectPrepareDataException(e)));
            return;
        }
        subjectDataExtractor.extract();
    }

    private List<AbstractEntity> selectEntityToFixIfSchedule(Box box) {
        List entities = box.getEntities();
        ArrayList<AbstractEntity> entityToFix = new ArrayList<AbstractEntity>();
        block6: for (AbstractEntity abstractEntity : entities) {
            switch (abstractEntity.getEntityType()) {
                case BIZ_UNION: {
                    entityToFix.add(abstractEntity);
                    break;
                }
                case SINGLE: {
                    Entity entity = (Entity)abstractEntity;
                    AbstractSource source = box.getSource(entity.getSource());
                    AbstractDataSourceDomain sourceDomain = null;
                    try {
                        sourceDomain = SourceDomainFactory.getSourceDomain((AbstractSource)source);
                        if (!sourceDomain.supportEntityFixOnSchedule()) continue block6;
                        entityToFix.add((AbstractEntity)entity);
                        break;
                    }
                    catch (UnSupportDataSourceException e) {
                        LogUtil.error((String)"", (Throwable)e);
                    }
                }
            }
        }
        return entityToFix;
    }

    private Box loadAndCheckBoxModel(String subjectId, String ownerId) throws AbstractQingIntegratedException, ModelParseException, SQLException, PrepareDataException {
        Box box = null;
        try {
            box = this.subjectDomain.loadModelIncludePreset(ownerId, subjectId);
        }
        catch (EncryptedLicenseCheckException e) {
            throw new PrepareEncryptedLicenseCheckException(e.getMessage(), e.getErrorCode());
        }
        if (box == null) {
            if (ownerId.equals(this.qingContext.getUserId())) {
                throw new SubjectModelNotDefinedOwnerException();
            }
            throw new SubjectModelNotDefinedException();
        }
        if (box.getEntities().isEmpty()) {
            if (ownerId.equals(this.qingContext.getUserId())) {
                throw new SubjectModelNoEntityOwnerException();
            }
            throw new SubjectModelNoEntityException();
        }
        return box;
    }

    private ThemePO loadAndCheckThemePo(String subjectId) throws AbstractQingIntegratedException, SQLException, SubjectNotFoundPrepareDataException {
        ThemePO themePO = this.subjectDomain.getThemeByID(subjectId);
        if (themePO == null || !"0".equals(themePO.getThemeType())) {
            throw new SubjectNotFoundPrepareDataException();
        }
        return themePO;
    }

    @Override
    public void createPublishDataSource(PublishPO publishPO, boolean bEditScene) {
        if (publishPO.isCarryData()) {
            this.createDataSourceWitdData(publishPO);
        } else if (!bEditScene && this.isEnableClippingOptimization.booleanValue() && Integer.parseInt("2") == publishPO.getPublishTargetType()) {
            this.createDataSource(publishPO.getTagId(), publishPO.getCreatorId(), true, publishPO.getSchemaId());
        } else {
            this.createDataSource(publishPO.getTagId(), publishPO.getCreatorId(), true, null);
        }
    }

    private void createDataSourceWitdData(PublishPO publishPO) {
        String tag = this.progressModel.getTag();
        try {
            String publishId = publishPO.getId();
            Box box = this.getPublishSubjectModelDao().loadBoxByPublishId(publishId);
            List<PublishSubjectFilePO> publishSubjectFilePOs = this.getPublishSubjectFileDao().loadPublishSubjectFile(publishId);
            long extractDataTime = System.currentTimeMillis();
            HashMap<String, String> dataPathMap = new HashMap<String, String>(publishSubjectFilePOs.size());
            for (int i = 0; i < publishSubjectFilePOs.size(); ++i) {
                PublishSubjectFilePO publishSubjectFilePO = publishSubjectFilePOs.get(i);
                dataPathMap.put(publishSubjectFilePO.getEntityName(), publishSubjectFilePO.getFilePath());
                if (publishSubjectFilePO.getExtractDataTime() == null) continue;
                extractDataTime = publishSubjectFilePO.getExtractDataTime().getTime();
            }
            HashMap<String, String> newTempDataFiles = new HashMap<String, String>();
            for (Map.Entry entry : dataPathMap.entrySet()) {
                String dataFileName = (String)dataPathMap.get(entry.getKey());
                IQingFileVisitor dataFile = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)dataFileName);
                if (dataFile.exists()) {
                    IGlobalQingSession globalQingSession = QingSessionUtil.getGlobalQingSessionImpl();
                    String cachekey = "Qing.TempQsFile." + dataFileName;
                    String tempDataFileName = globalQingSession.get(cachekey);
                    IQingFileVisitor tmpDataFile = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.TEMP_QS, (String)tempDataFileName);
                    if (tempDataFileName == null || !tmpDataFile.exists()) {
                        IQingFile tempDataFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.TEMP_QS);
                        FileFactory.copy((IQingFileVisitor)dataFile, (IQingFile)tempDataFile, (boolean)true);
                        tempDataFileName = tempDataFile.getName();
                        globalQingSession.set(cachekey, tempDataFileName);
                    }
                    newTempDataFiles.put((String)entry.getKey(), tempDataFileName);
                    continue;
                }
                throw new FileNotFoundException(dataFileName);
            }
            ThemeDataSource dataSource = new ThemeDataSource();
            dataSource.setTag(tag);
            dataSource.setOriginalCreatorId(publishPO.getCreatorId());
            dataSource.setDataFiles(newTempDataFiles);
            dataSource.setLastVisitTime(System.currentTimeMillis());
            dataSource.setExtractDataTime(extractDataTime);
            dataSource.setBox(box);
            LinkageContext linkageContext = this.subjectDomain.getLinkageContext(box);
            dataSource.addAllLinkageFormInfo(linkageContext.getLinkageFormInfos());
            QingSessionUtil.setCache((ISessionCacheable)dataSource);
            this.callBackFunction.finishAll(null);
        }
        catch (EncryptedLicenseCheckException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)e));
        }
        catch (ModelParseException e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new SubjectModelParseException(e)));
        }
        catch (Exception e) {
            this.callBackFunction.finishAll((AbstractQingException)((Object)new PublishedPrepareDataException(e)));
        }
    }
}

