/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.preparedata.task;

import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.framework.server.msgpublish.ServerChannelMessagePublisher;
import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.preparedata.cache.ProgressModel;
import com.kingdee.bos.qing.preparedata.exception.PrepareDataException;
import com.kingdee.bos.qing.preparedata.handler.AbstractPrepareDataHandler;
import com.kingdee.bos.qing.preparedata.handler.PrepareDataHandlerFactory;
import com.kingdee.bos.qing.preparedata.preparedatacontext.AbstractPrepareDataContext;

public class DataExtractTask {
    public static final String EXTRACTDATA_LOCK_KEY = "qing_extractData_lock_";
    private AbstractPrepareDataContext prepareDataContext;
    private String lockKey;
    private String progressModelCacheKey;

    public DataExtractTask(AbstractPrepareDataContext prepareDataContext) {
        this.prepareDataContext = prepareDataContext;
        String tag = prepareDataContext.getTag();
        String safeTag = tag.replaceAll("\\/", "");
        this.lockKey = EXTRACTDATA_LOCK_KEY + safeTag;
        this.progressModelCacheKey = ProgressModel.getCacheKey(tag);
    }

    private Boolean requireLock(ILock lock) throws QingLockRequireException, InterruptedException {
        ProgressModel processModel = (ProgressModel)QingSessionUtil.getCache((String)this.progressModelCacheKey, ProgressModel.class);
        if (processModel != null && processModel.getTimeStamp() > this.prepareDataContext.getTimeStamp()) {
            return null;
        }
        return lock.tryLock(3000L);
    }

    public ProgressModel call() throws AbstractQingException {
        ILock lock = LockFactory.createLock((String)this.lockKey);
        ProgressModel progressModel = this.prepareDataContext.getProgressModel();
        try {
            Boolean isLock = lock.tryLock();
            while (!isLock.booleanValue()) {
                isLock = this.requireLock(lock);
                if (isLock != null) continue;
                ProgressModel progressModel2 = progressModel;
                return progressModel2;
            }
            if (progressModel.isNeedDealProgress()) {
                ServerChannelMessagePublisher.publish((String)progressModel.getChannel(), (String)progressModel.toJson());
            }
            AbstractPrepareDataHandler prepareDataHandler = PrepareDataHandlerFactory.newPrepareHandlerInstance(this.prepareDataContext.getFromType(), this.prepareDataContext);
            prepareDataHandler.createDataSource();
        }
        catch (Exception e) {
            if (e instanceof AbstractQingException) {
                throw (AbstractQingException)((Object)e);
            }
            throw new PrepareDataException(e);
        }
        finally {
            lock.unlock();
        }
        this.throwErrorIfExist(this.prepareDataContext);
        return progressModel;
    }

    private void throwErrorIfExist(AbstractPrepareDataContext prepareDataContext) throws AbstractQingException {
        AbstractQingException e = prepareDataContext.getException();
        if (e != null) {
            throw e;
        }
    }
}

