/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.publish.model.PublishDsbRefBillFile;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PublishDsbRefBillFileDao {
    private IDBExcuter dbExcuter;

    public PublishDsbRefBillFileDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void insertBillFile(PublishDsbRefBillFile fileModel) throws AbstractQingIntegratedException, SQLException {
        String blockSql = "INSERT INTO T_QING_PUB_DSB_REF_BFILE(FID, FPUBLISHID, FREFUID, FQSPATH, FEXTRACTDATATIME) VALUES (?, ?, ?, ?, ?)";
        Object[] param = new Object[]{this.dbExcuter.genStringId("T_QING_PUB_DSB_REF_BFILE"), fileModel.getPublishId(), fileModel.getRefUid(), fileModel.getQsFileName(), fileModel.getExtractDataTime()};
        this.dbExcuter.execute(blockSql, param);
    }

    public PublishDsbRefBillFile loadBillFile(String publishId, String refUid) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FREFUID, FQSPATH, FEXTRACTDATATIME FROM T_QING_PUB_DSB_REF_BFILE WHERE FPUBLISHID = ? AND FREFUID = ?";
        return (PublishDsbRefBillFile)this.dbExcuter.query(sql, new Object[]{publishId, refUid}, (ResultHandler)new ResultHandler<PublishDsbRefBillFile>(){

            public PublishDsbRefBillFile handle(ResultSet rs) throws SQLException {
                PublishDsbRefBillFile fileModel = new PublishDsbRefBillFile();
                if (rs.next()) {
                    fileModel.setId(rs.getString("FID"));
                    fileModel.setRefUid(rs.getString("FREFUID"));
                    fileModel.setQsFileName(rs.getString("FQSPATH"));
                    fileModel.setExtractDataTime(rs.getTimestamp("FEXTRACTDATATIME"));
                }
                return fileModel;
            }
        });
    }

    public List<PublishDsbRefBillFile> loadBillFileByPublishId(String publishId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FREFUID, FQSPATH, FEXTRACTDATATIME FROM T_QING_PUB_DSB_REF_BFILE WHERE FPUBLISHID = ?";
        return (List)this.dbExcuter.query(sql, new Object[]{publishId}, (ResultHandler)new ResultHandler<List<PublishDsbRefBillFile>>(){

            public List<PublishDsbRefBillFile> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishDsbRefBillFile> list = new ArrayList<PublishDsbRefBillFile>(10);
                while (rs.next()) {
                    PublishDsbRefBillFile fileModel = new PublishDsbRefBillFile();
                    fileModel.setId(rs.getString("FID"));
                    fileModel.setRefUid(rs.getString("FREFUID"));
                    fileModel.setQsFileName(rs.getString("FQSPATH"));
                    fileModel.setExtractDataTime(rs.getTimestamp("FEXTRACTDATATIME"));
                    list.add(fileModel);
                }
                return list;
            }
        });
    }

    public void deleteByPublishId(String publishId) throws AbstractQingIntegratedException, SQLException {
        String sqlDelBill = "DELETE T_QING_PUB_DSB_REF_BFILE WHERE FPUBLISHID = ?";
        this.dbExcuter.execute(sqlDelBill, new Object[]{publishId});
    }
}

