/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.domain;

import com.kingdee.bos.qing.common.cache.AbstractDataSource;
import com.kingdee.bos.qing.common.cache.MultiFileDataSource;
import com.kingdee.bos.qing.common.cache.ReportDataSource;
import com.kingdee.bos.qing.common.cache.SingleFileDataSource;
import com.kingdee.bos.qing.common.cache.ThemeDataSource;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.common.ref.model.RefTypeEnum;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.dashboard.cache.DashboardModelBookCache;
import com.kingdee.bos.qing.dashboard.dao.DashboardDao;
import com.kingdee.bos.qing.dashboard.dao.DashboardSerializationUtil;
import com.kingdee.bos.qing.dashboard.exception.PersistentModelParseException;
import com.kingdee.bos.qing.dashboard.model.DashboardModel;
import com.kingdee.bos.qing.dashboard.model.DashboardModelUtil;
import com.kingdee.bos.qing.dashboard.model.ModelJsonDecoder;
import com.kingdee.bos.qing.dashboard.model.ReferenceMap;
import com.kingdee.bos.qing.dashboard.reference.IExImportPublishable;
import com.kingdee.bos.qing.dashboard.reference.IPrepareDataable;
import com.kingdee.bos.qing.dashboard.reference.IPublishable;
import com.kingdee.bos.qing.dashboard.reference.IRefHandler;
import com.kingdee.bos.qing.dashboard.reference.impl.RefHandlerFactory;
import com.kingdee.bos.qing.data.exception.ModelPersistenceException;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLogCache;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingAppLocalTempFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.manager.model.ResourceFromType;
import com.kingdee.bos.qing.imagelibrary.exception.QingImglibException;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.manage.exception.ExportThemeException;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.exception.ThemeManagementException;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.DsbWidgetSchemaCollecor;
import com.kingdee.bos.qing.manage.imexport.collector.dashboard.DsbWidgetSchemaPropertyCollector;
import com.kingdee.bos.qing.manage.imexport.collector.util.ImportUtil;
import com.kingdee.bos.qing.manage.imexport.model.po.IDashboardExportFilePathGetter;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.AbstractExportRefProperty;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.ExportDsbRefProperty;
import com.kingdee.bos.qing.manage.imexport.model.po.dashboard.ExportDsbSchemaProperty;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardPublishImportModel;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.map.dao.MapManageDao;
import com.kingdee.bos.qing.map.model.MapVO;
import com.kingdee.bos.qing.publish.dao.DashboardPublishDao;
import com.kingdee.bos.qing.publish.dao.PubDsbRefExtractDataExceptionLogDao;
import com.kingdee.bos.qing.publish.dao.PublishDsbRefBillFileDao;
import com.kingdee.bos.qing.publish.dao.PublishDsbRefSubjectFileDao;
import com.kingdee.bos.qing.publish.dao.PublishDsbRefSubjectModelDao;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.domain.IPublishSourceDomain;
import com.kingdee.bos.qing.publish.exception.PublishEncryptedLicenseException;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishSourceDsbNotExistException;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.PubDsbRefExtractDataExceptionLog;
import com.kingdee.bos.qing.publish.model.PublishDashboardModel;
import com.kingdee.bos.qing.publish.model.PublishDsbRefBillFile;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishSubjectFilePO;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.schema.dao.ExtReportSchemaManageDao;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.schema.domain.SchemaDomain;
import com.kingdee.bos.qing.subject.dao.ISubjectDao;
import com.kingdee.bos.qing.subject.dao.impl.SubjectDaoImpl;
import com.kingdee.bos.qing.util.BoxUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom2.Element;

public class DashboardPublishSourceDomain
implements IPublishSourceDomain {
    private static final String REFTYPE = "refType";
    private QingContext context;
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private DashboardPublishDao dashboardPublishDao;
    private DashboardDao dashboardDao;
    private SchemaManageDao schemaManageDao;
    private ExtReportSchemaManageDao extRptSchemaManageDao;
    private IThemeDao iThemeDao;
    private ISubjectDao iSubjectDao;
    private PublishInfoDao publishInfoDao;
    private SchemaDomain schemaDomain;
    private PublishDsbRefSubjectModelDao publishDsbRefSubjectModelDao;
    private PublishDsbRefSubjectFileDao publishDsbRefSubjectFileDao;
    private PublishDsbRefBillFileDao PublishDsbRefBillFileDao;
    private PubDsbRefExtractDataExceptionLogDao pubDsbRefExtractDataExceptionLogDao;
    private Map<RefTypeEnum, IRefHandler> refHandlerMap;
    private MapManageDao mapManageDao;

    public DashboardPublishSourceDomain(QingContext context, IDBExcuter dbExcuter, ITransactionManagement tx) {
        this.context = context;
        this.dbExcuter = dbExcuter;
        this.tx = tx;
    }

    private DashboardPublishDao getDashboardPublishDao() {
        if (this.dashboardPublishDao == null) {
            this.dashboardPublishDao = new DashboardPublishDao(this.dbExcuter);
        }
        return this.dashboardPublishDao;
    }

    private SchemaDomain getSchemaDomain() {
        if (this.schemaDomain == null) {
            this.schemaDomain = new SchemaDomain();
            this.schemaDomain.setTx(this.tx);
            this.schemaDomain.setDbExcuter(this.dbExcuter);
        }
        return this.schemaDomain;
    }

    private DashboardDao getDashboardDao() {
        if (this.dashboardDao == null) {
            this.dashboardDao = new DashboardDao(this.dbExcuter);
        }
        return this.dashboardDao;
    }

    private SchemaManageDao getSchemaManageDao() {
        if (this.schemaManageDao == null) {
            this.schemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaManageDao;
    }

    private ExtReportSchemaManageDao getExtRptSchemaManageDao() {
        if (this.extRptSchemaManageDao == null) {
            this.extRptSchemaManageDao = new ExtReportSchemaManageDao(this.dbExcuter);
        }
        return this.extRptSchemaManageDao;
    }

    private IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    private ISubjectDao getSubjectDao() {
        if (this.iSubjectDao == null) {
            this.iSubjectDao = new SubjectDaoImpl(this.dbExcuter);
        }
        return this.iSubjectDao;
    }

    protected PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private IRefHandler getRefHandler(RefTypeEnum refType) {
        IRefHandler refHandler;
        if (this.refHandlerMap == null) {
            this.refHandlerMap = new HashMap<RefTypeEnum, IRefHandler>();
        }
        if ((refHandler = this.refHandlerMap.get(refType)) == null) {
            refHandler = RefHandlerFactory.createHandler(refType, this.dbExcuter, this.context, this.tx);
            this.refHandlerMap.put(refType, refHandler);
        }
        return refHandler;
    }

    private PublishDsbRefSubjectModelDao getPublishDsbRefSubjectModelDao() {
        if (this.publishDsbRefSubjectModelDao == null) {
            this.publishDsbRefSubjectModelDao = new PublishDsbRefSubjectModelDao(this.dbExcuter);
        }
        return this.publishDsbRefSubjectModelDao;
    }

    private PublishDsbRefSubjectFileDao getPublishDsbRefSubjectFileDao() {
        if (this.publishDsbRefSubjectFileDao == null) {
            this.publishDsbRefSubjectFileDao = new PublishDsbRefSubjectFileDao(this.dbExcuter);
        }
        return this.publishDsbRefSubjectFileDao;
    }

    private PublishDsbRefBillFileDao getPublishDsbRefBillFileDao() {
        if (this.PublishDsbRefBillFileDao == null) {
            this.PublishDsbRefBillFileDao = new PublishDsbRefBillFileDao(this.dbExcuter);
        }
        return this.PublishDsbRefBillFileDao;
    }

    private PubDsbRefExtractDataExceptionLogDao getPubDsbRefExtractDataExceptionLogDao() {
        if (this.pubDsbRefExtractDataExceptionLogDao == null) {
            this.pubDsbRefExtractDataExceptionLogDao = new PubDsbRefExtractDataExceptionLogDao(this.dbExcuter);
        }
        return this.pubDsbRefExtractDataExceptionLogDao;
    }

    protected MapManageDao getMapManageDao() {
        if (this.mapManageDao == null) {
            this.mapManageDao = new MapManageDao();
            this.mapManageDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapManageDao;
    }

    public AbstractPublishSourceModel parsePublishSourceModel(String modelJsonString) {
        DashboardModel dsbModel = ModelJsonDecoder.decode((String)modelJsonString);
        PublishDashboardModel importDashboardSource = new PublishDashboardModel();
        importDashboardSource.setDsbModel(dsbModel);
        return importDashboardSource;
    }

    public PublishPO savePublish(String tag, String bizTag, PublishPO publishInfo, List<AbstractPublishSourceModel> abstractPublishSourceModelList, List<IQingFile> savedQingFiles) throws PublishException, AbstractQingIntegratedException {
        try {
            this.checkSourceIsExist(bizTag);
            PublishDashboardModel publishDashboardModel = (PublishDashboardModel)abstractPublishSourceModelList.get(0);
            String publishId = publishInfo.getId();
            this.savePublish(publishId, publishDashboardModel, publishInfo.getTagId());
            if (publishInfo.isTimingPush()) {
                this.saveDataSource(tag, publishInfo, publishDashboardModel.getDsbModel(), savedQingFiles);
            } else {
                this.savePersistentFileAndData(publishInfo, publishDashboardModel.getDsbModel(), savedQingFiles);
            }
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
        catch (ModelPersistenceException e) {
            throw new PublishException((Throwable)e);
        }
        return publishInfo;
    }

    private void savePublish(String publishId, PublishDashboardModel publishDashboardModel, String dsbId) throws PublishException, AbstractQingIntegratedException {
        try {
            DashboardModel dsbModel = publishDashboardModel.getDsbModel();
            Map<String, ModelBook> allRefContents = publishDashboardModel.getAllRefContents();
            InputStream dbStream = publishDashboardModel.getDashboardStream();
            if (dbStream == null) {
                dbStream = this.getDashboardDao().loadDashboardStream(dsbId);
            }
            try {
                this.getDashboardPublishDao().saveDsbModelContent(publishId, dsbModel, dbStream);
            }
            catch (EncryptedLicenseCheckException e) {
                throw new PublishEncryptedLicenseException(e.getMessage(), e.getErrorCode());
            }
            List refItems = new ArrayList();
            refItems = dsbModel.pickReferences();
            for (int i = 0; i < refItems.size(); ++i) {
                IRefHandler refHandler;
                ReferenceMap refItem = (ReferenceMap)refItems.get(i);
                ModelBook modelBook = null;
                if (allRefContents != null && allRefContents.size() > 0) {
                    modelBook = allRefContents.get(refItem.getUid());
                }
                if (!((refHandler = this.getRefHandler(RefTypeEnum.valueOf((String)refItem.getRefType()))) instanceof IPublishable)) continue;
                ((IPublishable)((Object)refHandler)).savePublishReference(dsbId, publishId, refItem, modelBook);
            }
        }
        catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e) {
            throw new PublishException((Throwable)e);
        }
        catch (PersistentModelTooModernException e) {
            throw new PublishException((Throwable)e);
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
        catch (PersistentModelParseException e) {
            throw new PublishException((Throwable)e);
        }
    }

    private void saveDataSource(String tag, PublishPO publishInfo, DashboardModel dsbModel, List<IQingFile> savedQingFiles) throws AbstractQingIntegratedException, SQLException, PublishException, ModelPersistenceException {
        if (publishInfo.isCarryData()) {
            HashMap<String, String> distinctDiskFiles = new HashMap<String, String>();
            for (ReferenceMap referenceMap : dsbModel.pickReferences()) {
                String refTag;
                String refType = referenceMap.getRefType();
                RefTypeEnum refTypeEnum = RefTypeEnum.valueOf((String)refType);
                IRefHandler refHandler = this.getRefHandler(refTypeEnum);
                if (!(refHandler instanceof IPrepareDataable) || (refTag = ((IPrepareDataable)((Object)refHandler)).getPrepareDataTag(tag, referenceMap.getRefToId())) == null) continue;
                this.saveDsbRefDataSource(refTag, referenceMap, publishInfo, savedQingFiles, distinctDiskFiles);
            }
        }
    }

    private void savePersistentFileAndData(PublishPO publishInfo, DashboardModel dsbModel, List<IQingFile> savedQingFiles) throws AbstractQingIntegratedException, SQLException, PublishException, ModelPersistenceException {
        if (publishInfo.isCarryData()) {
            Map executingTagMap = publishInfo.getExecutingTagMap();
            HashMap<String, String> distinctDiskFiles = new HashMap<String, String>();
            for (ReferenceMap referenceMap : dsbModel.pickReferences()) {
                String tag = (String)executingTagMap.get(referenceMap.getUid());
                if (tag == null || referenceMap.getRefToId() == null) continue;
                this.saveDsbRefDataSource(tag, referenceMap, publishInfo, savedQingFiles, distinctDiskFiles);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void saveDsbRefDataSource(String tag, ReferenceMap referenceMap, PublishPO publishInfo, List<IQingFile> savedQingFiles, Map<String, String> distinctDiskFiles) throws PublishException, AbstractQingIntegratedException, SQLException, ModelPersistenceException {
        String uid = referenceMap.getUid();
        String publishId = publishInfo.getId();
        IQingSession qingSession = QingSessionUtil.getQingSessionImpl();
        AbstractDataSource dataSource = (AbstractDataSource)qingSession.getCache(AbstractDataSource.getCacheKey(tag), AbstractDataSource.class);
        if (dataSource == null) {
            ExceptionLogCache exceptionLogCache = (ExceptionLogCache)qingSession.getCache(ExceptionLogCache.getCacheKey((String)tag), ExceptionLogCache.class);
            if (exceptionLogCache == null) throw new PublishException("not find dataSource, publishId:" + publishId + ", uid:" + uid + ", tag:" + tag);
            PubDsbRefExtractDataExceptionLog exceptionLog = new PubDsbRefExtractDataExceptionLog();
            exceptionLog.setPublishId(publishId);
            exceptionLog.setRefUid(uid);
            exceptionLog.setErrorCode(exceptionLogCache.getErrorCode());
            exceptionLog.setErrorMessage(exceptionLogCache.getErrorMessage());
            exceptionLog.setErrorStackTrace(exceptionLogCache.getErrorStackTrace());
            this.getPubDsbRefExtractDataExceptionLogDao().insert(exceptionLog);
            return;
        }
        if (dataSource instanceof ThemeDataSource || dataSource instanceof ReportDataSource) {
            this.saveSubjectOrReportDataSource(dataSource, referenceMap.getRefToId(), uid, publishInfo, savedQingFiles, distinctDiskFiles);
            return;
        }
        if (dataSource instanceof SingleFileDataSource) {
            this.saveSingleFileDataSource(dataSource, uid, publishInfo, savedQingFiles, distinctDiskFiles);
            return;
        }
        PubDsbRefExtractDataExceptionLog exceptionLog = new PubDsbRefExtractDataExceptionLog();
        exceptionLog.setPublishId(publishId);
        exceptionLog.setRefUid(uid);
        exceptionLog.setErrorCode(0x200B20);
        exceptionLog.setErrorMessage("\u9884\u7b97\u5361\u7247\u548c\u63a7\u4ef6\u5361\u7247\u6682\u65f6\u4e0d\u652f\u6301\u53d1\u5e03\u548c\u5b9a\u65f6\u63a8\u9001");
        exceptionLog.setErrorStackTrace("");
        this.getPubDsbRefExtractDataExceptionLogDao().insert(exceptionLog);
        throw new PublishException(exceptionLog.getErrorMessage());
    }

    private void saveSubjectOrReportDataSource(AbstractDataSource dataSource, String refToID, String uid, PublishPO publishInfo, List<IQingFile> savedQingFile, Map<String, String> distinctDiskFiles) throws PublishException, AbstractQingIntegratedException, SQLException, ModelPersistenceException {
        PublishPO oldInfo;
        String publishId = publishInfo.getId();
        MultiFileDataSource multiFileDataSource = (MultiFileDataSource)dataSource;
        Map<String, String> dataFiles = multiFileDataSource.getDataFiles();
        for (Map.Entry<String, String> entry : dataFiles.entrySet()) {
            String fileName = null;
            String fileKey = entry.getValue();
            if (distinctDiskFiles.containsKey(fileKey)) {
                fileName = distinctDiskFiles.get(fileKey);
            } else {
                String filePath = dataFiles.get(entry.getKey());
                IQingFileVisitor qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.TEMP_QS, (String)filePath);
                if (!qingFileVisitor.exists()) {
                    qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)filePath);
                    if (dataSource instanceof ReportDataSource) {
                        qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.EMBEDDED_PUB_QS, (String)filePath);
                    }
                }
                QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
                resourceInfo.setDisplayName(entry.getKey());
                resourceInfo.setFromId(publishId);
                if (publishInfo.isTimingPush()) {
                    resourceInfo.setFromType(ResourceFromType.TIMINGPUSH);
                } else {
                    resourceInfo.setFromType(ResourceFromType.PUBLISHED);
                }
                IQingFile qingFile = FileFactory.newPersistentFile((QingContext)this.context, (QingFileResourceInfo)resourceInfo, (QingPersistentFileType)QingPersistentFileType.DATAMODELING_QS);
                if (dataSource instanceof ReportDataSource) {
                    qingFile = FileFactory.newPersistentFile((QingContext)this.context, (QingFileResourceInfo)resourceInfo, (QingPersistentFileType)QingPersistentFileType.EMBEDDED_PUB_QS);
                }
                try {
                    FileFactory.copy((IQingFileVisitor)qingFileVisitor, (IQingFile)qingFile, (boolean)true);
                }
                catch (IOException e) {
                    throw new PublishException((Throwable)e);
                }
                savedQingFile.add(qingFile);
                fileName = qingFile.getName();
                distinctDiskFiles.put(fileKey, fileName);
            }
            PublishSubjectFilePO publishSubjectFilePO = new PublishSubjectFilePO();
            publishSubjectFilePO.setFilePath(fileName);
            publishSubjectFilePO.setPublishId(publishId);
            publishSubjectFilePO.setEntityName(entry.getKey());
            publishSubjectFilePO.setExtractDataTime(new Date(multiFileDataSource.getExtractDataTime()));
            this.getPublishDsbRefSubjectFileDao().insert(publishSubjectFilePO, uid);
        }
        Box box = multiFileDataSource.getBoxModel();
        String themeID = refToID;
        if (PublishUtil.isPublish((String)refToID) && (oldInfo = this.getPublishInfoDao().getPublishInfoByInfoId(refToID)) != null) {
            themeID = oldInfo.getTagId();
        }
        InputStream dbStream = this.getSubjectDao().loadSubjectModelStreamByThemeID(themeID);
        try {
            this.getPublishDsbRefSubjectModelDao().insert(publishId, uid, box, dbStream);
        }
        catch (EncryptedLicenseCheckException e) {
            throw new PublishEncryptedLicenseException(e.getMessage(), e.getErrorCode());
        }
    }

    private void saveSingleFileDataSource(AbstractDataSource dataSource, String uid, PublishPO publishInfo, List<IQingFile> savedQingFiles, Map<String, String> distinctDiskFiles) throws AbstractQingIntegratedException, SQLException, PublishException {
        String publishId = publishInfo.getId();
        SingleFileDataSource singleFileDataSource = (SingleFileDataSource)dataSource;
        String fileName = null;
        String qsFileName = singleFileDataSource.getFileName();
        String fileKey = qsFileName;
        if (distinctDiskFiles.containsKey(fileKey)) {
            fileName = distinctDiskFiles.get(fileKey);
        } else {
            IQingFileVisitor qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingTempFileType.TEMP_QS, (String)qsFileName);
            if (!qingFileVisitor.exists()) {
                qingFileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)QingPersistentFileType.EMBEDDED_PUB_QS, (String)qsFileName);
            }
            QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
            resourceInfo.setDisplayName(publishInfo.getName());
            resourceInfo.setFromId(publishId);
            if (publishInfo.isTimingPush()) {
                resourceInfo.setFromType(ResourceFromType.TIMINGPUSH);
            } else {
                resourceInfo.setFromType(ResourceFromType.PUBLISHED);
            }
            IQingFile qingFile = FileFactory.newPersistentFile((QingContext)this.context, (QingFileResourceInfo)resourceInfo, (QingPersistentFileType)QingPersistentFileType.EMBEDDED_PUB_QS);
            try {
                FileFactory.copy((IQingFileVisitor)qingFileVisitor, (IQingFile)qingFile, (boolean)true);
            }
            catch (IOException e) {
                throw new PublishException((Throwable)e);
            }
            savedQingFiles.add(qingFile);
            fileName = qingFile.getName();
            distinctDiskFiles.put(fileKey, fileName);
        }
        PublishDsbRefBillFile fileModel = new PublishDsbRefBillFile();
        fileModel.setPublishId(publishId);
        fileModel.setRefUid(uid);
        fileModel.setQsFileName(fileName);
        fileModel.setExtractDataTime(new Date(singleFileDataSource.getExtractDataTime()));
        this.getPublishDsbRefBillFileDao().insertBillFile(fileModel);
    }

    public void deletePublish(PublishPO publishInfo) throws AbstractQingIntegratedException, PublishException {
        try {
            RefTypeEnum[] refTypes;
            String publishId = publishInfo.getId();
            List<ReferenceMap> refList = this.getDashboardPublishDao().getRefList(publishId);
            for (ReferenceMap refItem : refList) {
                this.getDashboardPublishDao().deleteOuterRefOfUser((String)refItem.get((Object)"id"));
                this.getDashboardPublishDao().deleteOuterRef((String)refItem.get((Object)"id"));
                if (!this.getExtRptSchemaManageDao().isFromExtReport(refItem.getRefToId())) continue;
                String extReportSchemeId = publishId + "/" + refItem.getUid();
                this.getExtRptSchemaManageDao().clearExtRptSchemaInfos(extReportSchemeId);
            }
            this.getDashboardPublishDao().deletePublishedByPublishId(publishId);
            for (RefTypeEnum refType : refTypes = RefTypeEnum.values()) {
                IRefHandler refHandler = this.getRefHandler(refType);
                if (!(refHandler instanceof IPublishable)) continue;
                ((IPublishable)((Object)refHandler)).deletePublishContent(publishId);
            }
            this.deletePersistentFileAndData(publishInfo.isCarryData(), publishInfo.getId());
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
    }

    private void deletePersistentFileAndData(boolean isCarryDataOld, String publishId) throws AbstractQingIntegratedException, SQLException {
        if (isCarryDataOld) {
            List<PublishSubjectFilePO> publishSubjectFilePOs = this.getPublishDsbRefSubjectFileDao().loadPublishSubjectFileByPublishId(publishId);
            for (int i = 0; i < publishSubjectFilePOs.size(); ++i) {
                PublishSubjectFilePO publishSubjectFilePO = publishSubjectFilePOs.get(i);
                String qsFileName = publishSubjectFilePO.getFilePath();
                if (!StringUtils.isNotBlank((CharSequence)qsFileName)) continue;
                IQingFileUpdater fileUpdater = FileFactory.newFileUpdater((QingContext)this.context, (AbstractQingFileType)QingPersistentFileType.DATAMODELING_QS, (String)qsFileName);
                fileUpdater.delete();
            }
            List<PublishDsbRefBillFile> publishDsbRefBillFiles = this.getPublishDsbRefBillFileDao().loadBillFileByPublishId(publishId);
            for (int i = 0; i < publishDsbRefBillFiles.size(); ++i) {
                PublishDsbRefBillFile publishDsbRefBillFile = publishDsbRefBillFiles.get(i);
                String qsFileName = publishDsbRefBillFile.getQsFileName();
                if (!StringUtils.isNotBlank((CharSequence)qsFileName)) continue;
                IQingFileUpdater fileUpdater = FileFactory.newFileUpdater((QingContext)this.context, (AbstractQingFileType)QingPersistentFileType.EMBEDDED_PUB_QS, (String)qsFileName);
                fileUpdater.delete();
            }
            this.getPublishDsbRefSubjectModelDao().deleteByPublishId(publishId);
            this.getPublishDsbRefSubjectFileDao().deleteByPublishId(publishId);
            this.getPublishDsbRefBillFileDao().deleteByPublishId(publishId);
        }
    }

    public void updatePublish(int updateType, PublishPO publishInfoNew, PublishPO publishInfoOld, List<AbstractPublishSourceModel> abstractPublishSourceModelList) throws AbstractQingIntegratedException, PublishException {
        AbstractPublishSourceModel abstractPublishSourceModel = abstractPublishSourceModelList.get(0);
        PublishDashboardModel dsbModel = (PublishDashboardModel)abstractPublishSourceModel;
        switch (updateType) {
            case 4: 
            case 6: {
                String publishId = publishInfoNew.getId();
                this.deletePublish(publishInfoNew);
                this.savePublish(publishId, dsbModel, publishInfoOld.getTagId());
                break;
            }
        }
    }

    public void overwritePublish(String tag, PublishPO publishInfoNew, PublishPO publishInfoOld, List<AbstractPublishSourceModel> abstractPublishSourceModelList, List<IQingFile> savedQingFiles) throws AbstractQingIntegratedException, PublishException {
        try {
            String publishId = publishInfoNew.getId();
            String dsbId = publishInfoNew.getTagId();
            this.getDashboardPublishDao().overwriteDeletePublishedContentByPublishId(publishId);
            List<ReferenceMap> oldRefItems = this.getDashboardPublishDao().getRefList(publishId);
            DashboardModel dsbModel = ((PublishDashboardModel)abstractPublishSourceModelList.get(0)).getDsbModel();
            List newRefItems = dsbModel.pickReferences();
            for (int i = 0; i < oldRefItems.size(); ++i) {
                ReferenceMap oldRefItem = oldRefItems.get(i);
                String oldRefUid = oldRefItem.getUid();
                boolean isNeedDelete = true;
                for (int j = 0; j < newRefItems.size(); ++j) {
                    ReferenceMap newRefItem = (ReferenceMap)newRefItems.get(j);
                    String newRefUid = newRefItem.getUid();
                    if (!oldRefUid.equals(newRefUid)) continue;
                    isNeedDelete = false;
                    break;
                }
                if (!isNeedDelete) continue;
                String refId = (String)oldRefItem.get((Object)"id");
                this.getDashboardPublishDao().deleteRefById(refId);
                this.getDashboardPublishDao().deleteOuterRef(refId);
                this.getSchemaManageDao().deleteSchemaByBizTag(refId);
                this.getDashboardPublishDao().deleteRefContentUser(this.context.getUserId(), publishId, oldRefUid);
            }
            this.deletePersistentFileAndData(publishInfoOld.isCarryData(), publishInfoNew.getId());
            InputStream dsbStream = ((PublishDashboardModel)abstractPublishSourceModelList.get(0)).getDashboardStream();
            if (dsbStream == null && !PublishUtil.isPublish((String)publishId)) {
                dsbStream = this.getDashboardDao().loadDashboardStream(publishId);
            }
            this.getDashboardPublishDao().saveDsbModelContent(publishId, dsbModel, dsbStream);
            for (int i = 0; i < newRefItems.size(); ++i) {
                String fId;
                ReferenceMap refItem = (ReferenceMap)newRefItems.get(i);
                String refUid = refItem.getUid();
                List<Object> outsideRefList = new ArrayList();
                ModelBook modelBook = null;
                String oldFId = (String)refItem.get((Object)"id");
                boolean isExistRefInfo = this.getDashboardPublishDao().isExistRefInfo(refUid, publishId);
                if (!isExistRefInfo) {
                    this.getDashboardPublishDao().saveRefInfo(refItem, publishId);
                    fId = (String)refItem.get((Object)"id");
                } else {
                    refItem.put((Object)"publishId", (Object)publishId);
                    this.getDashboardPublishDao().updateRef(refItem);
                    fId = this.getDashboardPublishDao().getRefPK(publishId, refUid);
                    outsideRefList = this.getDashboardPublishDao().loadSchemaRef(fId);
                    this.getDashboardPublishDao().deleteOuterRef(fId);
                }
                if (RefTypeEnum.valueOf((String)refItem.getRefType()) == RefTypeEnum.picture) continue;
                DashboardModelBookCache dashboardCache = new DashboardModelBookCache(refItem.getFileKey());
                if (dashboardCache.exists()) {
                    modelBook = dashboardCache.toModelBook();
                    outsideRefList = DashboardModelUtil.getOuterRefList(refItem);
                } else if (FileFactory.newFileVisitor((AbstractQingFileType)QingAppLocalTempFileType.LOCAL_TEMP, (String)refItem.getFileKey()).exists()) {
                    modelBook = DashboardModelUtil.getFileModelBook(refItem.getFileKey());
                    outsideRefList = DashboardModelUtil.getOuterRefList(refItem);
                } else {
                    byte[] schemaContent = this.getDashboardDao().loadShemaContent(refItem.getUid(), dsbId);
                    if (outsideRefList.size() == 0) {
                        if (oldFId == null) {
                            oldFId = (String)this.getDashboardDao().loadRef(dsbId, refItem.getUid()).get((Object)"id");
                        }
                        outsideRefList = this.getDashboardDao().loadSchemaRef(oldFId);
                    }
                    if (schemaContent != null) {
                        modelBook = DashboardModelUtil.byteToSchemaModel(schemaContent);
                    }
                }
                this.savePublishOuterRef(outsideRefList, fId);
                if (modelBook == null) continue;
                this.getDashboardPublishDao().saveRefContent(publishId, refItem.getUid(), modelBook);
            }
            this.savePersistentFileAndData(publishInfoNew, dsbModel, savedQingFiles);
            this.getPublishInfoDao().updatePublishInfo(10, publishInfoNew);
        }
        catch (com.kingdee.bos.qing.core.exception.PersistentModelParseException e) {
            throw new PublishException((Throwable)e);
        }
        catch (PersistentModelTooModernException e) {
            throw new PublishException((Throwable)e);
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
        catch (PersistentModelParseException e) {
            throw new PublishException((Throwable)e);
        }
        catch (EncryptedLicenseCheckException e) {
            throw new PublishEncryptedLicenseException(e.getMessage(), e.getErrorCode());
        }
        catch (ModelPersistenceException e) {
            throw new PublishException((Throwable)e);
        }
    }

    public void savePublishOuterRef(List<OutsideReference> outsideRefList, String fId) throws AbstractQingIntegratedException, SQLException {
        for (int i = 0; i < outsideRefList.size(); ++i) {
            OutsideReference outsideRef = outsideRefList.get(i);
            ReferenceMap newRefMap = new ReferenceMap();
            newRefMap.setRefToFullPath(outsideRef.getRefToFullPath());
            newRefMap.setRefToId(outsideRef.getRefToId());
            newRefMap.setRefType(outsideRef.getRefType());
            newRefMap.setUid(outsideRef.getUid());
            this.getDashboardPublishDao().saveRefInfo(newRefMap, fId);
        }
    }

    public void doExport(ZipOutputStream zos, String publishId, String publishPrefixPath, IDashboardExportFilePathGetter dashboardExportFilePathGetter) throws AbstractQingIntegratedException, ThemeManagementException {
        try {
            List<ReferenceMap> refItems = this.getDashboardPublishDao().getRefList(publishId);
            List<Map<String, String>> refListMap = this.createRefMap(refItems);
            ExportDsbRefProperty exportDsbRefProperty = new ExportDsbRefProperty();
            exportDsbRefProperty.setReference(refListMap);
            Element dsbPropertyElement = exportDsbRefProperty.toXml();
            zos.putNextEntry(new ZipEntry(dashboardExportFilePathGetter.getDsbRefInfoPath(publishPrefixPath)));
            XmlUtil.save((Element)dsbPropertyElement, (OutputStream)zos);
            InputStream dashboardModelContent = this.getDashboardPublishDao().loadDsbModelContentStream(publishId);
            if (dashboardModelContent != null) {
                DashboardModel dashboardModel = DashboardSerializationUtil.toModel(dashboardModelContent);
                dashboardModel.fixReferences(refItems);
                Element dsbModelElement = dashboardModel.toXml();
                zos.putNextEntry(new ZipEntry(dashboardExportFilePathGetter.getDsbModelPath(publishPrefixPath)));
                XmlUtil.save((Element)dsbModelElement, (OutputStream)zos);
            }
            for (int i = 0; i < refListMap.size(); ++i) {
                ReferenceMap refMap = (ReferenceMap)refListMap.get(i);
                ReferenceMap ref = new ReferenceMap();
                ref.setUid((String)refMap.get((Object)"uid"));
                ref.setRefType((String)refMap.get((Object)REFTYPE));
                String uuid = UUID.randomUUID().toString();
                String prefixPath = publishPrefixPath + File.separator + uuid;
                RefTypeEnum refType = RefTypeEnum.valueOf((String)((String)refMap.get((Object)REFTYPE)));
                IRefHandler refHandler = this.getRefHandler(refType);
                if (!(refHandler instanceof IExImportPublishable)) continue;
                ((IExImportPublishable)((Object)refHandler)).exportPublishedRefContent(publishId, prefixPath, refMap, dashboardExportFilePathGetter, zos);
            }
        }
        catch (SQLException e) {
            throw new ExportThemeException(e);
        }
        catch (IOException e) {
            throw new ExportThemeException(e);
        }
        catch (QingImglibException e) {
            throw new ExportThemeException((Throwable)((Object)e));
        }
        catch (PersistentModelParseException e) {
            throw new ExportThemeException(e);
        }
    }

    public PublishDashboardModel getImportDashboardSource(String publishId, DashboardImportModel dashboardImportModel, DashboardPublishImportModel dashboardPublishImportModel, List<IQingFile> saveSuccessFiles) throws AbstractQingIntegratedException, ThemeManagementException {
        ArrayList<ReferenceMap> refItems = new ArrayList<ReferenceMap>(10);
        Set<RefTypeEnum> refTypes = dashboardPublishImportModel.getImportRefTypes();
        ExportDsbRefProperty dsbRef = dashboardPublishImportModel.getDsbRefProperty();
        this.separateImportModel(dashboardPublishImportModel);
        HashSet<RefTypeEnum> refTypesCopy = new HashSet<RefTypeEnum>(refTypes.size());
        for (RefTypeEnum refType : refTypes) {
            refTypesCopy.add(refType);
        }
        if (dsbRef != null) {
            List<Map<String, String>> ref = dsbRef.getReference();
            int c = ref.size();
            for (int i = 0; i < c; ++i) {
                refTypesCopy.add(RefTypeEnum.valueOf((String)((String)((Map)ref.get(i)).get(REFTYPE))));
            }
        }
        for (RefTypeEnum refType : refTypesCopy) {
            IRefHandler refHandler = this.getRefHandler(refType);
            if (!(refHandler instanceof IExImportPublishable)) continue;
            List<ReferenceMap> importResult = ((IExImportPublishable)((Object)refHandler)).importPublishedRefContent(publishId, dashboardImportModel, dashboardPublishImportModel, saveSuccessFiles);
            refItems.addAll(importResult);
        }
        try {
            byte[] dsbModelBytes = dashboardPublishImportModel.getDsbContent();
            DashboardModel dashboardModel = DashboardSerializationUtil.toModel(BoxUtil.parseByteToInputStream(dsbModelBytes));
            dashboardModel.fixReferences(refItems);
            PublishDashboardModel importDashboardSource = new PublishDashboardModel();
            importDashboardSource.setDsbModel(dashboardModel);
            importDashboardSource.setDashboardStream(BoxUtil.parseByteToInputStream(dsbModelBytes));
            return importDashboardSource;
        }
        catch (PersistentModelParseException e) {
            throw new ImportThemeException(e);
        }
    }

    private void separateImportModel(DashboardPublishImportModel dashboardPublishImportModel) {
        RefTypeEnum typeWhenCollectProp = DsbWidgetSchemaPropertyCollector.refType;
        List<AbstractExportRefProperty> schemaPropertys = dashboardPublishImportModel.getContentProperties(typeWhenCollectProp);
        RefTypeEnum typeWhenCollectFile = DsbWidgetSchemaCollecor.refType;
        List<String> schemaFileKeys = dashboardPublishImportModel.getFileKeys(typeWhenCollectFile);
        if (schemaPropertys != null && schemaFileKeys != null) {
            for (int i = 0; i < schemaPropertys.size(); ++i) {
                ExportDsbSchemaProperty dsbSchemaProperty = (ExportDsbSchemaProperty)schemaPropertys.get(i);
                RefTypeEnum refType = RefTypeEnum.valueOf((String)dsbSchemaProperty.getRefType());
                IRefHandler refHandler = this.getRefHandler(refType);
                String schemaFileKey = schemaFileKeys.get(i);
                if (!(refHandler instanceof IExImportPublishable)) continue;
                ((IExImportPublishable)((Object)refHandler)).separateImportModel(dashboardPublishImportModel, dsbSchemaProperty, schemaFileKey);
            }
        }
    }

    private List<Map<String, String>> createRefMap(List<ReferenceMap> referenceList) throws AbstractQingIntegratedException, SQLException, QingImglibException {
        String userId = this.context.getUserId();
        ArrayList<Map<String, String>> listMap = new ArrayList<Map<String, String>>(referenceList.size());
        int c = referenceList.size();
        for (int j = 0; j < c; ++j) {
            ReferenceMap ref = referenceList.get(j);
            HashMap<String, String> item = new HashMap<String, String>();
            String refType = ref.getRefType();
            String refToId = ref.getRefToId();
            String fId = (String)ref.get((Object)"id");
            item.put("id", fId);
            item.put("fileKey", ref.getFileKey());
            item.put("uid", ref.getUid());
            item.put(REFTYPE, refType);
            item.put("refToId", ref.getRefToId());
            String fullPath = ref.getRefToFullPath();
            IRefHandler refHandler = this.getRefHandler(RefTypeEnum.valueOf((String)refType));
            ISwitchPathAndIdHandler switchPathAndIdHandler = refHandler.getSwitchPathAndIdHandler();
            if (switchPathAndIdHandler != null) {
                String path = switchPathAndIdHandler.switchRefIdToPath(refToId, userId);
                fullPath = path != null ? path : fullPath;
            }
            item.put("fullPath", fullPath);
            List<OutsideReference> outSideRefList = this.getDashboardPublishDao().loadSchemaRef(fId);
            this.setMapFullPath(outSideRefList);
            item.put("outSideRef", JsonUtil.encodeToString(ImportUtil.createRefMap(outSideRefList)));
            listMap.add(item);
        }
        return listMap;
    }

    private void setMapFullPath(List<OutsideReference> outSideRefList) throws AbstractQingIntegratedException, SQLException {
        for (int j = 0; j < outSideRefList.size(); ++j) {
            OutsideReference outSideRef = outSideRefList.get(j);
            if (!StringUtils.isBlank((CharSequence)outSideRef.getRefToFullPath())) continue;
            String mapId = outSideRef.getRefToId();
            MapVO mapVO = this.getMapManageDao().getMapPath(mapId);
            String mapNameSpace = NameSpace.getNameSpace((String)mapVO.getNameSpace()).toPersistance();
            String mapPath = mapNameSpace + "/" + mapVO.getMapGroupName() + "/" + mapVO.getMapName();
            outSideRef.setRefToFullPath(mapPath);
        }
    }

    private void checkSourceIsExist(String bizTag) throws AbstractQingIntegratedException, SQLException, PublishSourceDsbNotExistException {
        ThemePO theme = this.getThemeDao().getThemeByID(bizTag);
        if (theme == null) {
            throw new PublishSourceDsbNotExistException();
        }
    }

    public void addPublicSchemaInfo(Map<String, String> result) throws AbstractQingIntegratedException, SQLException {
        result.put("schemaType", "dashboard");
    }

    public String getPublishSourceName(String bizTag, String publishSourceType) throws SQLException, AbstractQingIntegratedException {
        ThemePO themePO = this.getThemeDao().getThemeByID(bizTag);
        if (themePO != null) {
            return themePO.getThemeName();
        }
        return null;
    }

    public String getPublishSourceGroupName(String bizTag, String publishSourceType) throws SQLException, AbstractQingIntegratedException {
        ThemePO themePO = this.getThemeDao().getThemeByID(bizTag);
        if (themePO != null) {
            return themePO.getThemeGroupName();
        }
        return null;
    }

    public PublishSourceEnum confirmSourceTypeByPublishInfo(PublishPO publishInfo) throws AbstractQingIntegratedException, SQLException {
        String tagId = publishInfo.getTagId();
        ThemePO themePO = this.getThemeDao().getThemeByID(tagId);
        if (themePO != null) {
            if ("1".equals(themePO.getThemeType())) {
                return PublishSourceEnum.dashboard;
            }
            if ("0".equals(themePO.getThemeType())) {
                return PublishSourceEnum.subject;
            }
            throw new SQLException("can't confirm SourceType");
        }
        return null;
    }

    public byte[] getAllSchemaAttrs(String bizTag, int source, String userId, boolean isEditPublishInfo) {
        return new byte[0];
    }

    public byte[] setPublicPlanDefaultAttr(String bizTag, String modelJsonString, String userId) {
        return new byte[0];
    }

    public byte[] getSchemaAttrByPublishId(String fid, String userId, int source) {
        return new byte[0];
    }

    public List<String> getPublishedRecordNameByInputText(String userId, String inputText, String publishSourceType, String publishTargetType) throws AbstractQingIntegratedException, SQLException {
        return this.getSchemaDomain().getPublishedRecordNameByInputText(userId, inputText, publishSourceType, publishTargetType);
    }

    public boolean checkBeforeEditAndPublishInfo(PublishPO publishPO, List<AbstractPublishSourceModel> abstractPublishSourceModelList) throws SQLException, PublishException, AbstractQingIntegratedException {
        return false;
    }

    public boolean checkBeforeMovingRight(PublishPO publishPO, List<AbstractPublishSourceModel> abstractPublishSourceModelList) throws AbstractQingIntegratedException, SQLException, PublishException {
        return false;
    }
}

