/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.imexport.model.po.AbstractPublishModel;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.exception.ImportThemeException;
import com.kingdee.bos.qing.manage.exception.ThemeManagementException;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractPublishImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.AbstractThemeImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.DashboardPublishImportModel;
import com.kingdee.bos.qing.manage.imexport.model.runtime.SubjectPublishImportModel;
import com.kingdee.bos.qing.manage.imexport.model.vo.ExportPublishConflictVO;
import com.kingdee.bos.qing.manage.model.ThemeVO;
import com.kingdee.bos.qing.publish.PublishManageDomianFactory;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.dao.PublishPermissionDao;
import com.kingdee.bos.qing.publish.domain.AbstractPublishManageDomain;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.domain.DashboardPublishSourceDomain;
import com.kingdee.bos.qing.publish.domain.SubjectPublishSourceDomain;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishNameDuplicateException;
import com.kingdee.bos.qing.publish.exception.PublishSameSourceNameDuplicateException;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.PermissionInfo;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishTarget;
import com.kingdee.bos.qing.publish.target.card.dao.PublishCardDao;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public abstract class AbstractPublishTargetImexportDomain {
    protected QingContext qingContext;
    protected IDBExcuter dbExcuter;
    protected ITransactionManagement tx;
    protected IScheduleEngine scheduleEngine;
    private PublishPermissionDao publishPermissionDao;
    private PublishInfoDao publishInfoDao;
    private IThemeDao iThemeDao;
    private SchemaManageDao schemaManageDao;
    private SubjectPublishSourceDomain subjectPublishSourceDomain;
    private DashboardPublishSourceDomain dashboardPublishSourceDomain;
    private PublishCardDao cardDao;
    private CommonPublishDomain commonPublishDomain;

    public AbstractPublishTargetImexportDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        this.qingContext = qingContext;
        this.dbExcuter = dbExcuter;
        this.tx = tx;
        this.scheduleEngine = scheduleEngine;
    }

    protected PublishPermissionDao getPublishPermissionDao() {
        if (this.publishPermissionDao == null) {
            this.publishPermissionDao = new PublishPermissionDao(this.dbExcuter);
        }
        return this.publishPermissionDao;
    }

    protected PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    protected IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    protected SubjectPublishSourceDomain getSubjectPublishSourceDomain() {
        if (this.subjectPublishSourceDomain == null) {
            this.subjectPublishSourceDomain = new SubjectPublishSourceDomain(this.qingContext, this.dbExcuter, this.tx);
        }
        return this.subjectPublishSourceDomain;
    }

    protected DashboardPublishSourceDomain getDashboardPublishSourceDomain() {
        if (this.dashboardPublishSourceDomain == null) {
            this.dashboardPublishSourceDomain = new DashboardPublishSourceDomain(this.qingContext, this.dbExcuter, this.tx);
        }
        return this.dashboardPublishSourceDomain;
    }

    protected SchemaManageDao getSchemaManageDao() {
        if (this.schemaManageDao == null) {
            this.schemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaManageDao;
    }

    protected PublishCardDao getPublishCardDao() {
        if (this.cardDao == null) {
            this.cardDao = new PublishCardDao(this.qingContext, this.dbExcuter);
        }
        return this.cardDao;
    }

    protected CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    protected final void savePublishImportInfo(AbstractThemeImportModel themeImportModel, AbstractPublishImportModel publishImportModel, PublishPO publishInfo, List<IQingFile> saveSuccessFiles) throws AbstractQingIntegratedException, ThemeManagementException, PublishSameSourceNameDuplicateException, PublishNameDuplicateException {
        AbstractPublishModel publishModel = publishImportModel.getPublishModel();
        String userId = this.qingContext.getUserId();
        publishInfo.toPO(publishModel);
        publishInfo.setCreatorId(userId);
        publishInfo.setCreateTime(new Date());
        publishInfo.setUpdateTime(new Date());
        publishInfo.setSchemaId("currentAnalysisState");
        publishInfo.setImport(true);
        List authorizedRoleViewerIds = publishModel.getAuthorizedRoleViewerId();
        List authorizedUserViewerIds = publishModel.getAuthorizedUserViewerId();
        ArrayList permInfos = new ArrayList();
        permInfos.addAll(this.getCommonPublishDomain().createPermissionInfoByRoles(publishModel.getPublishId(), authorizedRoleViewerIds));
        permInfos.addAll(this.getCommonPublishDomain().createPermissionInfoByUsers(publishModel.getPublishId(), authorizedUserViewerIds));
        try {
            AbstractPublishSourceModel abstractImporSourceModel = null;
            String tag = null;
            if ("0".equals(themeImportModel.getThemeType())) {
                tag = this.getSubjectPublishSourceDomain().cachePublishCarrayData((SubjectPublishImportModel)publishImportModel);
                abstractImporSourceModel = this.getSubjectPublishSourceDomain().getImportSubjectSource((SubjectPublishImportModel)publishImportModel);
            } else if ("1".equals(themeImportModel.getThemeType())) {
                abstractImporSourceModel = this.getDashboardPublishSourceDomain().getImportDashboardSource(publishInfo.getId(), (DashboardImportModel)themeImportModel, (DashboardPublishImportModel)publishImportModel, saveSuccessFiles);
            } else {
                throw new ImportThemeException(new RuntimeException("TODO dosomething"));
            }
            AbstractPublishManageDomain publishManageDomain = PublishManageDomianFactory.getPublishManageDomian((Integer)publishInfo.getPublishTargetType(), (QingContext)this.qingContext, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, (IScheduleEngine)this.scheduleEngine);
            if (publishManageDomain != null) {
                boolean publishOverwrite = themeImportModel.publishOverwrite();
                publishInfo.setOverwrite(publishOverwrite);
                publishInfo.setAddOldPermission(false);
                ArrayList<AbstractPublishSourceModel> abstractPublishSourceModelList = new ArrayList<AbstractPublishSourceModel>(1);
                abstractPublishSourceModelList.add(abstractImporSourceModel);
                publishManageDomain.savePublishInfoNotTx(tag, publishInfo, permInfos, abstractPublishSourceModelList, saveSuccessFiles, null, null);
            }
        }
        catch (SQLException e) {
            throw new ImportThemeException(e);
        }
        catch (PublishSameSourceNameDuplicateException e) {
            throw e;
        }
        catch (PublishNameDuplicateException e) {
            throw e;
        }
        catch (PublishException e) {
            throw new ImportThemeException(e);
        }
    }

    protected abstract AbstractPublishModel createNewPublishModel();

    protected AbstractPublishModel initPublishModel(PublishPO publishInfo, String themeGroupName, ThemeVO themeVO) throws AbstractQingIntegratedException, SQLException {
        AbstractPublishModel publishModel = this.createNewPublishModel();
        publishInfo.copyToExportModel(publishModel);
        publishModel.setThemeName(themeVO.getThemeName());
        publishModel.setThemeGroupName(themeGroupName);
        publishModel.setThemeType(themeVO.getThemeType());
        String nameSpace = publishInfo.isPreset() ? NameSpace.system.toPersistance() : NameSpace.user.toPersistance();
        publishModel.setNameSpace(nameSpace);
        String publishId = publishInfo.getId();
        List permPublish = this.getPublishPermissionDao().loadPublishPermissionInfo(publishId);
        for (int permPublishIndex = 0; permPublishIndex < permPublish.size(); ++permPublishIndex) {
            PermissionInfo permPublishItem = (PermissionInfo)permPublish.get(permPublishIndex);
            String viewerId = permPublishItem.getViewerId();
            if (1 == permPublishItem.getType()) {
                publishModel.addAuthorizedRoleViewerId(viewerId);
                continue;
            }
            publishModel.addAuthorizedUserViewerId(viewerId);
        }
        return publishModel;
    }

    public abstract void doExportPublishInfo(ZipOutputStream var1, String var2, PublishPO var3, ThemeVO var4, String var5) throws AbstractQingIntegratedException, ThemeManagementException;

    public abstract void collectPublishInfo(ZipInputStream var1, String[] var2, AbstractThemeImportModel var3) throws ImportThemeException, AbstractQingIntegratedException;

    public abstract void doImportPublishInfo(AbstractThemeImportModel var1, AbstractPublishImportModel var2, List<IQingFile> var3) throws ThemeManagementException, AbstractQingIntegratedException;

    public abstract PublishPO loadNewPublishPO(PublishTarget var1, Map<String, String> var2) throws AbstractQingIntegratedException, SQLException;

    public abstract void doPublishNameDuplicate(List<ExportPublishConflictVO> var1, ThemeVO var2, String var3, String var4) throws AbstractQingIntegratedException, ImportThemeException;
}

