/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.card;

import com.kingdee.bos.qing.common.framework.server.msgpublish.ServerChannelMessagePublisher;
import com.kingdee.bos.qing.publish.AbstractPublishManageService;
import com.kingdee.bos.qing.publish.target.card.domain.AbstractCardManageDomain;
import com.kingdee.bos.qing.publish.target.card.model.CardGroupVO;
import com.kingdee.bos.qing.publish.target.card.model.CardVO;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.List;
import java.util.Map;

public abstract class AbstractCardManageService
extends AbstractPublishManageService {
    protected AbstractCardManageDomain getAbstractCardManageDomain() {
        return (AbstractCardManageDomain)this.getPublishManageDomain();
    }

    public byte[] loadImage(Map<String, String> params) {
        String fileName = params.get("fileName");
        try {
            return this.getAbstractCardManageDomain().loadImage(fileName);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] updateCardThumbnail(Map<String, String> params) {
        String tag = params.get("tag");
        String publishId = params.get("publishId");
        String subscribeKey = params.get("subscribeKey");
        String clientId = params.get("fromPageClientId");
        try {
            String newImageName = this.getAbstractCardManageDomain().updateCardThumbnail(tag, publishId);
            if (!StringUtils.isEmpty((CharSequence)newImageName)) {
                ServerChannelMessagePublisher.publish((String)clientId, (String)subscribeKey, (String)newImageName);
            }
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)newImageName));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadGroups(Map<String, String> params) {
        try {
            List<CardGroupVO> groups = this.getAbstractCardManageDomain().loadGroups();
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(groups));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadPublishInfos(Map<String, String> params) {
        try {
            String path = params.get("path");
            boolean isPreset = "true".equals(params.get("isPreset"));
            List<CardVO> cards = this.getAbstractCardManageDomain().loadPublishInfos(path, isPreset);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(cards));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadAllPublishInfos(Map<String, String> params) {
        try {
            boolean isPresetPublish = Boolean.parseBoolean(params.get("isPresetPublish"));
            List<CardVO> cards = this.getAbstractCardManageDomain().loadAllPublishInfos(isPresetPublish);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(cards));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadAllSelectorPublishInfos(Map<String, String> params) {
        try {
            boolean showDSBCard = Boolean.parseBoolean(params.get("showDSBCard"));
            List<CardVO> cards = this.getAbstractCardManageDomain().loadAllSelectorPublishInfos(showDSBCard);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(cards));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] saveGroup(Map<String, String> params) {
        String name = params.get("name");
        try {
            CardGroupVO vo = new CardGroupVO();
            vo.setName(name);
            vo = this.getAbstractCardManageDomain().saveGroup(vo);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)vo));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] updateGroup(Map<String, String> params) {
        String id = params.get("id");
        String name = params.get("name");
        try {
            CardGroupVO vo = new CardGroupVO();
            vo.setId(id);
            vo.setName(name);
            vo = this.getAbstractCardManageDomain().updateGroup(vo);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)vo.getId()));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] deleteGroup(Map<String, String> params) {
        String id = params.get("id");
        try {
            this.getAbstractCardManageDomain().deleteGroup(id);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)id));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadOtherOnesCardGroup(Map<String, String> params) {
        try {
            boolean showDSBCard = Boolean.parseBoolean(params.get("showDSBCard"));
            List<CardGroupVO> cardGroups = this.getAbstractCardManageDomain().loadOtherOnesCardGroup(showDSBCard);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(cardGroups));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadCardGroupByPerson(Map<String, String> params) {
        try {
            boolean showDSBCard = Boolean.parseBoolean(params.get("showDSBCard"));
            List<CardGroupVO> cardGroups = this.getAbstractCardManageDomain().loadCardGroupByPerson(showDSBCard);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(cardGroups));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadCardGroupByDirectory(Map<String, String> params) {
        try {
            boolean showDSBCard = Boolean.parseBoolean(params.get("showDSBCard"));
            List<CardGroupVO> cardGroups = this.getAbstractCardManageDomain().loadCardGroupByDirectory(showDSBCard);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(cardGroups));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadOtherShareCardBaseInfo(Map<String, String> params) {
        String cardOwnerId = params.get("ownerId");
        try {
            List<CardVO> rs = this.getAbstractCardManageDomain().loadOtherShareCardBaseInfo(cardOwnerId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(rs));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] exportEmbeddedPublishInfo(Map<String, String> params) {
        List selectedPublishModelIds = (List)JsonUtil.decodeFromString((String)params.get("selectedPublishModelIds"), List.class);
        try {
            String fileName = this.getAbstractCardManageDomain().doHiddenExport(selectedPublishModelIds);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)fileName));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

