/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.card.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.model.analysis.IPreferences;
import com.kingdee.bos.qing.core.model.analysis.IQingModel;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.dashboard.reference.impl.CardSwitchPathAndIdHandler;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.domain.ExportDomain;
import com.kingdee.bos.qing.domain.SquareExecuteDomain;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.manager.model.ResourceFromType;
import com.kingdee.bos.qing.imexport.exporter.pkg.domain.ExportPKGDomain;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.publish.domain.AbstractPublishManageDomain;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishNotFoundException;
import com.kingdee.bos.qing.publish.exception.PublishSameSourceNameDuplicateException;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishVO;
import com.kingdee.bos.qing.publish.oplog.PublishOpLog;
import com.kingdee.bos.qing.publish.target.card.dao.PublishCardDao;
import com.kingdee.bos.qing.publish.target.card.exception.CardException;
import com.kingdee.bos.qing.publish.target.card.exception.CardGroupNameDuplicateException;
import com.kingdee.bos.qing.publish.target.card.exception.CardGroupNotEmptyException;
import com.kingdee.bos.qing.publish.target.card.exception.CardImageAccessException;
import com.kingdee.bos.qing.publish.target.card.exception.CardImageNotFoundException;
import com.kingdee.bos.qing.publish.target.card.model.CardGroupPO;
import com.kingdee.bos.qing.publish.target.card.model.CardGroupVO;
import com.kingdee.bos.qing.publish.target.card.model.CardVO;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.schema.domain.SchemaDomain;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.jdom2.JDOMException;

public abstract class AbstractCardManageDomain
extends AbstractPublishManageDomain {
    private SchemaManageDao schemaManageDao;
    private PublishCardDao cardDao;
    private ISwitchPathAndIdHandler switchPathAndIdHandler;
    private ExportPKGDomain exportPKGDomain;

    public AbstractCardManageDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    private PublishCardDao getPublishCardDao() {
        if (this.cardDao == null) {
            this.cardDao = new PublishCardDao(this.qingContext, this.dbExcuter);
        }
        return this.cardDao;
    }

    public ISwitchPathAndIdHandler getSwitchPathAndIdHandler() {
        if (this.switchPathAndIdHandler == null) {
            this.switchPathAndIdHandler = new CardSwitchPathAndIdHandler(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.switchPathAndIdHandler;
    }

    private SchemaManageDao getSchemaManageDao() {
        if (this.schemaManageDao == null) {
            this.schemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaManageDao;
    }

    private ExportPKGDomain getExportPKGDomain() {
        if (this.exportPKGDomain == null) {
            this.exportPKGDomain = new ExportPKGDomain();
            this.exportPKGDomain.setDbExcuter(this.dbExcuter);
            this.exportPKGDomain.setQingContext(this.qingContext);
            this.exportPKGDomain.setTx(this.tx);
            this.exportPKGDomain.setScheduleEngine(this.scheduleEngine);
        }
        return this.exportPKGDomain;
    }

    public List<CardGroupVO> loadGroups() throws CardException, AbstractQingIntegratedException {
        ArrayList<CardGroupVO> groupVOs = new ArrayList<CardGroupVO>();
        String userId = this.qingContext.getUserId();
        try {
            List userGroupVOs = this.getPublishCardDao().loadGroups(userId);
            if (userGroupVOs.size() == 0) {
                CardGroupVO vo = new CardGroupVO();
                vo.setName(Messages.getMLS((String)"myCard", (String)"\u6211\u7684\u5361\u7247", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
                vo = this.saveGroup(vo);
                groupVOs.add(vo);
            } else {
                groupVOs.addAll(userGroupVOs);
            }
            boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter);
            if (isCurrentUserInQingAdminRole) {
                List presetGroupVOs = this.getPublishCardDao().loadPresetGroups();
                groupVOs.addAll(0, presetGroupVOs);
            }
        }
        catch (SQLException e) {
            throw new CardException(e);
        }
        return groupVOs;
    }

    public String loadPublishId(String groupName, String presetUserId, String cardName, int publishTargetType) throws CardException, AbstractQingIntegratedException {
        String publishId = null;
        try {
            publishId = this.getPublishCardDao().loadPublishId(groupName, cardName, presetUserId, publishTargetType);
        }
        catch (SQLException e) {
            throw new CardException(e);
        }
        return publishId;
    }

    public CardGroupVO saveGroup(CardGroupVO vo) throws CardException, AbstractQingIntegratedException {
        String userId = this.qingContext.getUserId();
        CardGroupPO po = vo.toPO();
        String fId = UUID.randomUUID().toString();
        po.setfId(fId);
        po.setUserId(userId);
        try {
            boolean groupNameExist = this.getPublishCardDao().isGroupNameExist(userId, null, po.getName());
            if (groupNameExist) {
                throw new CardGroupNameDuplicateException();
            }
        }
        catch (SQLException e) {
            throw new CardException(e);
        }
        try {
            this.tx.beginRequired();
            this.getPublishCardDao().saveGroup(po);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new CardException(e);
        }
        finally {
            this.tx.end();
        }
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(po.getName());
        PublishOpLog publishOpLog = PublishOpLog.CARD_PUBLISH_MANAGE_DIR;
        publishOpLog.setLogScene("\u53d1\u5e03\u7ba1\u7406\u76ee\u5f55");
        publishOpLog.setParamsDesc("\u201c$param\u201d");
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.NEW, (IOpLogConstant)publishOpLog, params));
        return po.toVO();
    }

    public CardGroupVO updateGroup(CardGroupVO vo) throws CardException, AbstractQingIntegratedException {
        String userId = this.qingContext.getUserId();
        CardGroupPO po = vo.toPO();
        po.setUserId(userId);
        String oldName = null;
        try {
            boolean groupNameExist = this.getPublishCardDao().isGroupNameExist(userId, po.getfId(), po.getName());
            if (groupNameExist) {
                throw new CardGroupNameDuplicateException();
            }
        }
        catch (SQLException e) {
            throw new CardException(e);
        }
        try {
            this.tx.beginRequired();
            CardGroupPO groupPO = this.getPublishCardDao().loadGroupByIdForExport(vo.getId());
            if (groupPO != null) {
                oldName = groupPO.getName();
            }
            this.getPublishCardDao().updateGroup(po);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new CardException(e);
        }
        finally {
            this.tx.end();
        }
        this.updateRefToId(vo);
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(oldName);
        params.add(vo.getName());
        PublishOpLog publishManageDir = PublishOpLog.CARD_PUBLISH_MANAGE_DIR;
        publishManageDir.setLogScene("\u53d1\u5e03\u7ba1\u7406\u76ee\u5f55");
        publishManageDir.setParamsDesc("\u201c$param\u201d\u7684\u540d\u79f0\u4e3a\u201c$param\u201d");
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.EDIT, (IOpLogConstant)publishManageDir, params));
        return po.toVO();
    }

    public void deleteGroup(String cardGroupId) throws CardException, AbstractQingIntegratedException {
        CardGroupPO groupPO;
        String userId = this.qingContext.getUserId();
        try {
            boolean isGroupEmpty = this.getPublishCardDao().isGroupEmpty(userId, cardGroupId);
            if (isGroupEmpty) {
                throw new CardGroupNotEmptyException();
            }
            groupPO = this.getPublishCardDao().loadGroupByIdForExport(cardGroupId);
        }
        catch (SQLException e) {
            throw new CardException(e);
        }
        try {
            this.tx.beginRequired();
            this.getPublishCardDao().deleteGroup(userId, cardGroupId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new CardException(e);
        }
        finally {
            this.tx.end();
        }
        if (groupPO != null) {
            ArrayList<String> params = new ArrayList<String>(1);
            params.add(groupPO.getName());
            PublishOpLog publishManageDir = PublishOpLog.CARD_PUBLISH_MANAGE_DIR;
            publishManageDir.setLogScene("\u53d1\u5e03\u7ba1\u7406\u76ee\u5f55");
            publishManageDir.setParamsDesc("\u201c$param\u201d");
            OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.DELETE, (IOpLogConstant)publishManageDir, params));
        }
    }

    public List<CardVO> loadPublishInfos(String path, boolean isPreset) throws CardException, AbstractQingIntegratedException {
        String userId = this.qingContext.getUserId();
        String publishPersonName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)userId);
        try {
            List publishVOs = isPreset ? this.getPublishCardDao().loadPresetPublishInfos(path, this.qingContext) : this.getPublishCardDao().loadPublishInfos(userId, path, this.qingContext);
            for (CardVO publishVO : publishVOs) {
                publishVO.setCreatorName(publishPersonName);
            }
            this.setPublishPermissionInfo(publishVOs);
            return publishVOs;
        }
        catch (PublishException e) {
            throw new CardException(e);
        }
        catch (SQLException e) {
            throw new CardException(e);
        }
    }

    public List<CardVO> loadAllPublishInfos(boolean isPresetPublish) throws CardException, AbstractQingIntegratedException {
        String userId = this.qingContext.getUserId();
        String publishPersonName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)userId);
        try {
            List publishVOs = this.getPublishCardDao().loadAllPublishInfos(userId, this.qingContext, isPresetPublish);
            for (CardVO publishVO : publishVOs) {
                publishVO.setCreatorName(publishPersonName);
                publishVO.setCreatorId(userId);
            }
            this.setPublishPermissionInfo(publishVOs);
            return publishVOs;
        }
        catch (PublishException e) {
            throw new CardException(e);
        }
        catch (SQLException e) {
            throw new CardException(e);
        }
    }

    public List<CardVO> loadAllSelectorPublishInfos(boolean showDSBCard) throws CardException, AbstractQingIntegratedException {
        String userId = this.qingContext.getUserId();
        try {
            ArrayList<CardVO> publishVOs = new ArrayList<CardVO>(40);
            Set roleIds = IntegratedHelper.getUserRoleIds((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter);
            boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter);
            Set cardOwnerIds = this.getPublishCardDao().loadOtherOnesCardOwnersId(userId, roleIds, isCurrentUserInQingAdminRole, showDSBCard);
            List allSelectorPublishInfos = this.getPublishCardDao().loadAllSelectorPublishInfos(cardOwnerIds, userId, roleIds, Boolean.valueOf(isCurrentUserInQingAdminRole), this.qingContext);
            for (CardVO cardVO : allSelectorPublishInfos) {
                String creatorID = cardVO.getCreatorId();
                String creatorName = IntegratedHelper.getUserName((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter, (String)creatorID);
                cardVO.setCreatorName(creatorName);
            }
            publishVOs.addAll(allSelectorPublishInfos);
            return publishVOs;
        }
        catch (SQLException e) {
            throw new CardException(e);
        }
    }

    public List<CardGroupVO> loadCardGroupByPerson(boolean showDSBCard) throws CardException, AbstractQingIntegratedException {
        String userId = this.qingContext.getUserId();
        boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter);
        CardGroupVO myGroupVO = new CardGroupVO();
        myGroupVO.setName(Messages.getMLS((String)"myRelease", (String)"\u6211\u7684\u53d1\u5e03", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
        myGroupVO.setId(userId);
        List<CardGroupVO> cardGroups = this.loadOtherOnesCardGroup(showDSBCard);
        cardGroups.add(0, myGroupVO);
        if (isCurrentUserInQingAdminRole) {
            CardGroupVO qingAdmin = new CardGroupVO();
            qingAdmin.setName(Messages.getMLS((String)"systemPreset", (String)"\u7cfb\u7edf\u9884\u7f6e", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
            qingAdmin.setId("100000");
            qingAdmin.setPreset(true);
            cardGroups.add(0, qingAdmin);
        }
        CardGroupVO AllGroupVO = new CardGroupVO();
        AllGroupVO.setName(Messages.getMLS((String)"all", (String)"\u5168\u90e8", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
        AllGroupVO.setId("allCard");
        cardGroups.add(0, AllGroupVO);
        return cardGroups;
    }

    public List<CardGroupVO> loadCardGroupByDirectory(boolean showDSBCard) throws CardException, AbstractQingIntegratedException {
        String userId = this.qingContext.getUserId();
        boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter);
        Set roleIds = IntegratedHelper.getUserRoleIds((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter);
        ArrayList<CardGroupVO> groupVOs = new ArrayList<CardGroupVO>();
        try {
            Set cardOwnerIds = this.getPublishCardDao().loadOtherOnesCardOwnersId(userId, roleIds, isCurrentUserInQingAdminRole, showDSBCard);
            List sharedGroupVOs = this.getPublishCardDao().loadOtherSharedCardGroup(cardOwnerIds, userId, roleIds, showDSBCard);
            if (isCurrentUserInQingAdminRole) {
                List presetGroupVOs = this.getPublishCardDao().loadPresetGroups(showDSBCard);
                groupVOs.addAll(0, presetGroupVOs);
            }
            List<CardGroupVO> userGroupVOs = this.getPublishCardDao().loadGroups(userId, showDSBCard);
            userGroupVOs = this.deDuplicationGroupVOs(userGroupVOs);
            userGroupVOs.addAll(sharedGroupVOs);
            List<CardGroupVO> deduplicatedGroupVOs = this.handleGroupVOs(userGroupVOs);
            if (deduplicatedGroupVOs.size() == 0) {
                CardGroupVO vo = new CardGroupVO();
                vo.setName(Messages.getMLS((String)"myCard", (String)"\u6211\u7684\u5361\u7247", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
                deduplicatedGroupVOs.add(vo);
            }
            groupVOs.addAll(deduplicatedGroupVOs);
            CardGroupVO AllGroupVO = new CardGroupVO();
            AllGroupVO.setName(Messages.getMLS((String)"all", (String)"\u5168\u90e8", (Messages.ProjectName)Messages.ProjectName.QING_THEME));
            AllGroupVO.setId("allCard");
            groupVOs.add(0, AllGroupVO);
        }
        catch (SQLException e) {
            LogUtil.error((String)"error", (Throwable)e);
            throw new CardException(e);
        }
        return groupVOs;
    }

    private List<CardGroupVO> deDuplicationGroupVOs(List<CardGroupVO> userGroupVOs) {
        HashMap<String, CardGroupVO> userGroupVOMap = new HashMap<String, CardGroupVO>(userGroupVOs.size());
        for (int i = 0; i < userGroupVOs.size(); ++i) {
            userGroupVOMap.put(userGroupVOs.get(i).getId(), userGroupVOs.get(i));
        }
        userGroupVOs = new ArrayList(userGroupVOMap.values());
        return userGroupVOs;
    }

    private List<CardGroupVO> handleGroupVOs(List<CardGroupVO> userTotalGroupVOs) {
        ArrayList<CardGroupVO> deduplicatedGroupVOs = new ArrayList<CardGroupVO>();
        HashMap<String, ArrayList<CardGroupVO>> cardGroupVOMap = new HashMap<String, ArrayList<CardGroupVO>>();
        for (CardGroupVO userGroupVO : userTotalGroupVOs) {
            ArrayList<CardGroupVO> tmpList = (ArrayList<CardGroupVO>)cardGroupVOMap.get(userGroupVO.getName());
            if (tmpList == null) {
                tmpList = new ArrayList<CardGroupVO>();
                tmpList.add(userGroupVO);
                cardGroupVOMap.put(userGroupVO.getName(), tmpList);
                continue;
            }
            tmpList.add(userGroupVO);
        }
        for (List value : cardGroupVOMap.values()) {
            if (value.size() > 1) {
                CardGroupVO tmpCardGroupVO = (CardGroupVO)value.get(0);
                for (int i = 1; i < value.size(); ++i) {
                    tmpCardGroupVO.setId(tmpCardGroupVO.getId() + "," + ((CardGroupVO)value.get(i)).getId());
                }
                deduplicatedGroupVOs.add(tmpCardGroupVO);
                continue;
            }
            deduplicatedGroupVOs.add((CardGroupVO)value.get(0));
        }
        return deduplicatedGroupVOs;
    }

    public List<CardGroupVO> loadOtherOnesCardGroup(boolean showDSBCard) throws CardException, AbstractQingIntegratedException {
        Set cardOwnerIds;
        String userId = this.qingContext.getUserId();
        boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter);
        Set roleIds = IntegratedHelper.getUserRoleIds((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter);
        ArrayList<CardGroupVO> cardGroups = new ArrayList<CardGroupVO>(10);
        try {
            cardOwnerIds = this.getPublishCardDao().loadOtherOnesCardOwnersId(userId, roleIds, isCurrentUserInQingAdminRole, showDSBCard);
        }
        catch (SQLException e) {
            throw new CardException(e);
        }
        for (String cardOwnerId : cardOwnerIds) {
            CardGroupVO groupVO = new CardGroupVO();
            groupVO.setId(cardOwnerId);
            groupVO.setName(this.getUserName(cardOwnerId));
            cardGroups.add(groupVO);
        }
        return cardGroups;
    }

    protected abstract String getUserName(String var1) throws CardException, IntegratedRuntimeException;

    public List<CardVO> loadOtherShareCardBaseInfo(String ownerId) throws CardException, AbstractQingIntegratedException {
        String userId = this.qingContext.getUserId();
        Set roleIds = IntegratedHelper.getUserRoleIds((QingContext)this.qingContext, (IDBExcuter)this.dbExcuter);
        try {
            return this.getPublishCardDao().loadOtherShareCardBaseInfo(ownerId, userId, roleIds, this.qingContext);
        }
        catch (SQLException e) {
            throw new CardException(e);
        }
    }

    public byte[] loadImage(String fileName) throws CardImageAccessException {
        try {
            return FileFactory.getFileContent((AbstractQingFileType)QingPersistentFileType.CARD_THUMBNAIL, (String)fileName);
        }
        catch (FileNotFoundException e) {
            throw new CardImageNotFoundException(e);
        }
        catch (IOException e) {
            throw new CardImageAccessException(e);
        }
    }

    public String updateCardThumbnail(String tag, String publishId) throws CardException, PublishNotFoundException {
        Object modelBook;
        IQingFile exportFile = null;
        CardVO cardVO = null;
        try {
            cardVO = this.getPublishCardDao().loadPublishCardBaseInfo(publishId);
            if (cardVO == null) {
                throw new PublishNotFoundException();
            }
            String schemaId = cardVO.getSchemaId();
            byte[] modelBookContent = this.getSchemaManageDao().loadSchemaContent(schemaId);
            List<OutsideReference> outSideRefList = this.getSchemaManageDao().loadSchemaRef(schemaId);
            modelBook = SchemaDomain.byteToModel(modelBookContent);
            modelBook.fixReferences(outSideRefList);
            Meta meta = modelBook.getMeta();
            ModelBook.ModelPage modelPage = (ModelBook.ModelPage)modelBook.getPages().get(0);
            SquareModel squareModel = (SquareModel)modelPage.getModel();
            ModelBook.ModelPage.prepareForExecuting((Meta)meta, (IQingModel)squareModel, (IPreferences)modelPage.getPreferences());
            exportFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
            SquareExecuteDomain executeDomain = new SquareExecuteDomain(this.getDataSourceCreator(tag));
            executeDomain.setI18nContext(this.qingContext.getIi18nContext());
            ExportDomain exportDomain = new ExportDomain();
            exportDomain.doExportSquareImage(230, 115, exportFile, squareModel, executeDomain, "png");
        }
        catch (AbstractQingIntegratedException e) {
            throw new CardException(e);
        }
        catch (SQLException e) {
            throw new CardException(e);
        }
        catch (AnalysisException e) {
            throw new CardException(e);
        }
        String oldImagePath = cardVO.getImagePath();
        if (exportFile != null) {
            QingFileResourceInfo resourceInfo = new QingFileResourceInfo();
            resourceInfo.setFromId(cardVO.getId());
            resourceInfo.setDisplayName(cardVO.getName());
            resourceInfo.setFromType(ResourceFromType.CARDTHUMBNAIL);
            IQingFile imageFile = FileFactory.newPersistentFile((QingContext)this.qingContext, (QingFileResourceInfo)resourceInfo, (QingPersistentFileType)QingPersistentFileType.CARD_THUMBNAIL);
            try {
                FileFactory.copy((IQingFileVisitor)exportFile, (IQingFile)imageFile, (boolean)true);
                cardVO.setImagePath(imageFile.getName());
                this.tx.beginRequired();
                this.getPublishCardDao().updateCardInfo(cardVO.toPO(this.qingContext.getUserId()));
                FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.CARD_THUMBNAIL, (String)oldImagePath).delete();
                modelBook = imageFile.getName();
                return modelBook;
            }
            catch (IOException e) {
                throw new CardException(e);
            }
            catch (SQLException e) {
                this.tx.markRollback();
                FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.CARD_THUMBNAIL, (String)imageFile.getName()).delete();
                throw new CardException(e);
            }
            catch (AbstractQingIntegratedException e) {
                this.tx.markRollback();
                FileFactory.newFileUpdater((QingContext)this.qingContext, (AbstractQingFileType)QingPersistentFileType.CARD_THUMBNAIL, (String)imageFile.getName()).delete();
                throw new CardException(e);
            }
            finally {
                exportFile.delete();
                this.tx.end();
            }
        }
        return oldImagePath;
    }

    protected abstract AbstractDomain.IDataSourceCreator getDataSourceCreator(String var1);

    private void updateRefToId(CardGroupVO vo) throws AbstractQingIntegratedException {
        try {
            this.tx.beginRequired();
            String groupName = vo.getName();
            String groupId = vo.getId();
            int type = 5;
            String publishSourceType = PublishSourceEnum.subject.toString();
            String userId = this.qingContext.getUserId();
            List publishPOs = this.getPublishInfoDao().loadPublishInfo(type, groupId, userId, publishSourceType);
            for (int i = 0; i < publishPOs.size(); ++i) {
                PublishPO publishPO = (PublishPO)publishPOs.get(i);
                String fullPath = groupName + "/" + publishPO.getName();
                String publishId = publishPO.getId();
                this.getSwitchPathAndIdHandler().replacePersistentPathToId(fullPath, publishId, this.qingContext.getUserId());
            }
        }
        catch (SQLException e) {
            this.tx.markRollback();
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public PublishVO getPublishVO(String fid) throws AbstractQingIntegratedException, SQLException {
        return this.getPublishCardDao().loadPublishCardInfo(this.qingContext.getUserId(), fid, this.qingContext);
    }

    public void addPublishOpLog(OpLogActionType opLogActionType, List<String> params, String opLogParam) {
        try {
            PublishOpLog cardPublishLogDir = PublishOpLog.CARD_PUBLISH_LOG_DIR;
            cardPublishLogDir.setParamsDesc(opLogParam);
            cardPublishLogDir.setLogScene("\u53d1\u5e03\u8bb0\u5f55");
            OpLogUtil.addLog((OpLogBO)new OpLogBO(opLogActionType, (IOpLogConstant)cardPublishLogDir, params));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addPublishOpLogWithPath(OpLogActionType opLogActionType, List<String> params, String opLogParam) {
        try {
            PublishOpLog cardPublishLogDir = PublishOpLog.CARD_PUBLISH_MANAGE_DIR;
            cardPublishLogDir.setParamsDesc(opLogParam);
            cardPublishLogDir.setLogScene("\u53d1\u5e03\u8bb0\u5f55");
            OpLogUtil.addLog((OpLogBO)new OpLogBO(opLogActionType, (IOpLogConstant)cardPublishLogDir, params));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void verifyPublishInfoWhenUpdate(PublishPO publishPO, String bizTag) throws PublishException, AbstractQingIntegratedException, SQLException {
        String fId;
        boolean isSameSourceNameExist = this.getPublishInfoDao().checkSameSourceNameExist(publishPO, bizTag, false);
        if (!isSameSourceNameExist && ((fId = this.getPublishInfoDao().loadPublishId(publishPO.getPublishTargetType(), publishPO.getName(), publishPO.getPath(), this.qingContext.getUserId())) == null || fId.equals(publishPO.getId()))) {
            return;
        }
        throw new PublishSameSourceNameDuplicateException();
    }

    public String doHiddenExport(List<String> selectedPublishModelIds) throws SQLException, AbstractQingException, IOException, JDOMException {
        return this.getExportPKGDomain().doHiddenExport(selectedPublishModelIds);
    }
}

