/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.card.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishNotFoundException;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.target.card.dao.PublishCardDao;
import com.kingdee.bos.qing.publish.target.card.exception.CardException;
import com.kingdee.bos.qing.publish.target.card.model.CardVO;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.schema.domain.SchemaDomain;
import com.kingdee.bos.qing.schema.exception.SchemaManagerException;
import com.kingdee.bos.qing.schema.model.SchemaAttrVO;
import com.kingdee.bos.qing.schema.model.SchemaContentVO;
import com.kingdee.bos.qing.schema.model.SchemaTypeEnum;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CardRuntimeDomain {
    private QingContext context;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private SchemaManageDao schemaManageDao;
    private PublishCardDao cardDao;
    private PublishInfoDao publishInfoDao;
    private IThemeDao themeDao;
    private SchemaDomain schemaDomain;

    public CardRuntimeDomain(QingContext context, ITransactionManagement tx, IDBExcuter dbExcuter) {
        this.context = context;
        this.tx = tx;
        this.dbExcuter = dbExcuter;
    }

    private PublishCardDao getPublishCardDao() {
        if (this.cardDao == null) {
            this.cardDao = new PublishCardDao(this.context, this.dbExcuter);
        }
        return this.cardDao;
    }

    private SchemaManageDao getSchemaManageDao() {
        if (this.schemaManageDao == null) {
            this.schemaManageDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaManageDao;
    }

    private SchemaDomain getSchemaDomain() {
        if (this.schemaDomain == null) {
            this.schemaDomain = new SchemaDomain();
            this.schemaDomain.setDbExcuter(this.dbExcuter);
            this.schemaDomain.setTx(this.tx);
        }
        return this.schemaDomain;
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private IThemeDao getThemeDao() {
        if (this.themeDao == null) {
            this.themeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.themeDao;
    }

    public SchemaContentVO loadSquareSchema(String publishId, String bizTag, String additionalBizTag) throws AbstractQingIntegratedException, PersistentModelParseException, PersistentModelTooModernException, CardException, SchemaManagerException {
        String userId = this.context.getUserId();
        try {
            String fullBizTag = StringUtils.isEmpty((CharSequence)additionalBizTag) ? bizTag : bizTag + additionalBizTag;
            String schemaId = this.getSchemaManageDao().getDefaultUserSchemaId(fullBizTag, userId, 1);
            if (schemaId == null) {
                schemaId = this.getSchemaManageDao().getDefaultUserSchemaId(bizTag, userId, 1);
            }
            if (schemaId == null) {
                PublishPO po = this.getPublishInfoDao().getPublishInfoByInfoId(publishId);
                schemaId = po.getSchemaId();
            }
            return this.getSchemaDomain().loadSchemaContent(schemaId, fullBizTag, userId, 1);
        }
        catch (SQLException e) {
            throw new CardException(e);
        }
        catch (SchemaManagerException e) {
            throw e;
        }
    }

    public SchemaContentVO loadDefaultSchemaContent(String bizTag, String userId, int source) throws AbstractQingIntegratedException, SchemaManagerException {
        try {
            String fId = this.getSchemaManageDao().getDefaultUserSchemaId(bizTag, userId, source);
            if (fId == null || fId.length() == 0) {
                return null;
            }
            SchemaContentVO contentVO = this.getSchemaDomain().loadSchemaContent(fId, bizTag, userId, 1);
            return contentVO;
        }
        catch (SQLException e) {
            throw new SchemaManagerException(e);
        }
    }

    public Map<String, String> loadCardInfo(String publishId) throws AbstractQingIntegratedException, PublishException {
        try {
            ThemePO themePO;
            PublishPO publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(publishId);
            if (publishPO == null) {
                throw new PublishNotFoundException();
            }
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("id", publishPO.getId());
            result.put("name", publishPO.getName());
            result.put("publishSourceType", publishPO.getPublishSourceType().name());
            result.put("haveToCarryData", publishPO.isCarryData() + "");
            result.put("isPreset", "" + publishPO.isPreset());
            if (PublishSourceEnum.subject == publishPO.getPublishSourceType() && (themePO = this.getThemeDao().getThemeByID(publishPO.getTagId())) != null) {
                result.put("themeID", themePO.getThemeID());
                result.put("themeName", themePO.getThemeName());
            }
            return result;
        }
        catch (SQLException e) {
            throw new CardException(e);
        }
    }

    public void removeCardFromHomepage(String userId, Map<String, String> deleteQingCardConfigs) throws CardException {
        if (deleteQingCardConfigs != null && !deleteQingCardConfigs.isEmpty()) {
            try {
                this.tx.beginRequired();
                for (Map.Entry<String, String> entry : deleteQingCardConfigs.entrySet()) {
                    String deleteQingCardConfig = deleteQingCardConfigs.get(entry.getKey());
                    Map oneCardConfigMap = (Map)JsonUtil.decodeFromString((String)deleteQingCardConfig, Map.class);
                    String cardId = (String)oneCardConfigMap.get("HomepageCardId");
                    String publishId = (String)oneCardConfigMap.get("QingCardId");
                    String schemaBizTag = publishId + cardId;
                    this.getSchemaManageDao().deleteSchemaByBizTag(schemaBizTag);
                }
            }
            catch (AbstractQingIntegratedException e) {
                this.tx.markRollback();
                throw new CardException(e);
            }
            catch (SQLException e) {
                this.tx.markRollback();
                throw new CardException(e);
            }
            finally {
                this.tx.end();
            }
        }
    }

    public List<CardVO> loadAllPermCardBaseInfoByCardName(String cardName) throws CardException, AbstractQingIntegratedException {
        String userId = this.context.getUserId();
        Set roleIds = IntegratedHelper.getUserRoleIds((QingContext)this.context, (IDBExcuter)this.dbExcuter, (String)userId);
        try {
            return this.getPublishCardDao().loadAllPermCardBaseInfoByCardName(cardName, userId, roleIds);
        }
        catch (SQLException e) {
            throw new CardException(e);
        }
    }

    public void cleanEmptyGroupByUserId(String presetUserId) throws CardException {
        try {
            this.tx.beginRequired();
            this.getPublishCardDao().cleanEmptyGroupByUserId(presetUserId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw new CardException(e);
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new CardException(e);
        }
        finally {
            this.tx.end();
        }
    }

    public void resetCustomSquare(String bizTag) throws SchemaManagerException, AbstractQingIntegratedException {
        String userId = this.context.getUserId();
        ArrayList<SchemaAttrVO> schemaAttrs = this.getSchemaDomain().loadSchemaAttrs(bizTag, userId, SchemaTypeEnum.square.getType());
        for (SchemaAttrVO schemaAttr : schemaAttrs) {
            this.getSchemaDomain().deleteSchema(schemaAttr.getfId(), userId);
        }
    }
}

