/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.email;

import com.kingdee.bos.qing.behavior.BehaviorAssociate;
import com.kingdee.bos.qing.core.model.ModelJsonDecoder;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.data.exception.CronExpressionParseException;
import com.kingdee.bos.qing.exceptionlog.domain.ExceptionLogDomain;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLog;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLogBizTypeEnum;
import com.kingdee.bos.qing.publish.AbstractPublishManageService;
import com.kingdee.bos.qing.publish.model.PublishOperModelVO;
import com.kingdee.bos.qing.publish.model.PushRecordConfig;
import com.kingdee.bos.qing.publish.target.email.domain.EmailConfigManageDomain;
import com.kingdee.bos.qing.publish.target.email.domain.EmailSenderManageDomain;
import com.kingdee.bos.qing.publish.target.email.model.EmailConfig;
import com.kingdee.bos.qing.publish.target.email.model.EmailSendLog;
import com.kingdee.bos.qing.publish.target.email.model.EmailSenderVO;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.schedule.AbstractScheduleEngine;
import com.kingdee.bos.qing.util.JsonUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractEmailManageService
extends AbstractPublishManageService {
    private static final String PUBLISHED_RUNTIME_URL = "publishedRuntimeUrl";
    private static final String CONFIG_ID = "configId";
    private EmailConfigManageDomain emailConfigManageDomain;
    private EmailSenderManageDomain emailSenderManageDomain;
    private ExceptionLogDomain exceptionLogDomain;

    protected EmailConfigManageDomain getPublishManageDomain() {
        if (this.emailConfigManageDomain == null) {
            this.emailConfigManageDomain = new EmailConfigManageDomain(this.qingContext, this.tx, this.dbExcuter, this.scheduleEngine);
        }
        return this.emailConfigManageDomain;
    }

    private EmailSenderManageDomain getEmailSenderManageDomain() {
        if (this.emailSenderManageDomain == null) {
            this.emailSenderManageDomain = new EmailSenderManageDomain(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.emailSenderManageDomain;
    }

    private ExceptionLogDomain getExceptionLogDomain() {
        if (this.exceptionLogDomain == null) {
            this.exceptionLogDomain = new ExceptionLogDomain(this.tx, this.dbExcuter);
        }
        return this.exceptionLogDomain;
    }

    @BehaviorAssociate(behavior=true)
    public byte[] getUserEmailSender(Map<String, String> params) {
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getEmailSenderManageDomain().getUserEmailSender());
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] saveEmailSender(Map<String, String> params) {
        try {
            String emailSenderStr = params.get("emailSender");
            EmailSenderVO emailSender = (EmailSenderVO)JsonUtil.decodeFromString((String)emailSenderStr, EmailSenderVO.class);
            String id = this.getEmailSenderManageDomain().saveEmailSender(emailSender);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)id);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] saveEmailConfig(Map<String, String> params) {
        try {
            String tag = params.get("tag");
            String publishedRuntimeUrl = params.get(PUBLISHED_RUNTIME_URL);
            String eamilConfModelStr = params.get("eamilConfModel");
            String dsbPublishId = params.get("dsbPublishId");
            String scene = params.get("scene");
            EmailConfig emailConfig = (EmailConfig)JsonUtil.decodeFromString((String)eamilConfModelStr, EmailConfig.class);
            String sceneModelJson = params.get("sceneModel");
            this.getPublishManageDomain().saveEmailConfig(tag, emailConfig, sceneModelJson, publishedRuntimeUrl, dsbPublishId, scene);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)true);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] updateEmailConfig(Map<String, String> params) {
        try {
            String publishedRuntimeUrl = params.get(PUBLISHED_RUNTIME_URL);
            String eamilConfModelStr = params.get("eamilConfModel");
            EmailConfig emailConfig = (EmailConfig)JsonUtil.decodeFromString((String)eamilConfModelStr, EmailConfig.class);
            this.getPublishManageDomain().updateEmailConfig(emailConfig, publishedRuntimeUrl);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)true);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] loadEmailConfigs(Map<String, String> params) {
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(this.getPublishManageDomain().loadEmailConfigs());
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] connectTest(Map<String, String> params) {
        try {
            String emailSenderStr = params.get("emailSender");
            EmailSenderVO emailSender = (EmailSenderVO)JsonUtil.decodeFromString((String)emailSenderStr, EmailSenderVO.class);
            this.getEmailSenderManageDomain().connectTest(emailSender);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)true);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] deleteEmailConfigById(Map<String, String> params) {
        try {
            String id = params.get("id");
            this.getPublishManageDomain().deleteEmailConfigById(id);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)true);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] loadPublishInfos(Map<String, String> params) {
        try {
            String path = params.get("path");
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getPublishManageDomain().loadPublishInfos(path)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] loadExceptionLog(Map<String, String> params) {
        try {
            String id = params.get("id");
            ExceptionLog exceptionLog = this.getExceptionLogDomain().selectByBizIdAndBizType(id, ExceptionLogBizTypeEnum.EMAIL_TIMING_PUSH);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)exceptionLog);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] deleteEmailPublishInfoById(Map<String, String> params) {
        try {
            String emailSendLogModelJsonString = params.get("arrEmailSendLogModel");
            List emailSendLogModelList = (List)JsonUtil.decodeFromString((String)emailSendLogModelJsonString, List.class);
            ArrayList<EmailSendLog> emailSendLogList = new ArrayList<EmailSendLog>(emailSendLogModelList.size());
            for (int i = 0; i < emailSendLogModelList.size(); ++i) {
                EmailSendLog emailSendLog = (EmailSendLog)ModelJsonDecoder.decode((String)JsonUtil.encodeToString(emailSendLogModelList.get(i)), EmailSendLog.class);
                emailSendLogList.add(emailSendLog);
            }
            this.getPublishManageDomain().deleteEmailPublishInfoById(emailSendLogList);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)true);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadPushRecordConfigInfo(Map<String, String> params) {
        try {
            int pushTargetType = Integer.parseInt(params.get("publishTargetType"));
            String userId = this.qingContext.getUserId();
            PushRecordConfig emailStorageSetVO = this.getPublishManageDomain().loadPushRecordConfigInfo(userId, pushTargetType);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)emailStorageSetVO);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] saveEmailPushRecordConfig(Map<String, String> params) {
        try {
            int pushTargetType = Integer.parseInt(params.get("publishTargetType"));
            String strategy = params.get("strategy");
            String value = params.get("value");
            PushRecordConfig emailPushRecordConfig = new PushRecordConfig();
            emailPushRecordConfig.setUserId(this.qingContext.getUserId());
            emailPushRecordConfig.setPushTargetType(pushTargetType);
            emailPushRecordConfig.setStrategy(strategy);
            emailPushRecordConfig.setValue(value);
            this.getPublishManageDomain().saveEmailPushRecordConfig(emailPushRecordConfig);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)true);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadPublishOperModel(Map<String, String> params) {
        try {
            String biztag = params.get("biztag");
            boolean isEdit = Boolean.parseBoolean(params.get("isEdit"));
            if (isEdit) {
                biztag = this.getPublishManageDomain().loadEmailPushTagIdByBizTag(biztag);
            }
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)(PublishUtil.isPublish((String)biztag) ? this.getPublishManageDomain().loadParentPublishPermissionInfo(biztag) : new PublishOperModelVO()));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @BehaviorAssociate(behavior=true)
    public byte[] updateScheduleState(Map<String, String> params) {
        String configId = params.get(CONFIG_ID);
        boolean openSchedule = Boolean.parseBoolean(params.get("openSchedule"));
        String publishedRuntimeUrl = params.get(PUBLISHED_RUNTIME_URL);
        try {
            this.getPublishManageDomain().updateScheduleState(openSchedule, configId, publishedRuntimeUrl);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] updatePushSchema(Map<String, String> params) {
        String configId = params.get(CONFIG_ID);
        String jsonModelBook = params.get("model");
        String publishSourceType = params.get("publishSourceType");
        try {
            this.getPublishManageDomain().updateEmailPushSchema(configId, publishSourceType, jsonModelBook);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadPushSchema(Map<String, String> params) {
        String configId = params.get(CONFIG_ID);
        String publishSourceType = params.get("publishSourceType");
        try {
            HashMap<String, ModelBook> rs = new HashMap<String, ModelBook>();
            rs.put("model", this.getPublishManageDomain().loadEmailPushSchema(configId, publishSourceType));
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(rs));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] isMyOwnPushConfig(String configId) {
        try {
            boolean rs = this.getPublishManageDomain().isMyOwnConfig(configId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)rs));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] cronExpression(Map<String, String> params) {
        String cronExpression = params.get("cron");
        try {
            List result = AbstractScheduleEngine.cronExpression((String)cronExpression);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)result);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (ParseException e) {
            CronExpressionParseException exception = new CronExpressionParseException((Throwable)e);
            return ResponseUtil.output((Exception)exception);
        }
    }
}

