/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.email.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.publish.model.TimingPushBillPO;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class EmailBillDao {
    private IDBExcuter dbExcuter;

    public EmailBillDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public byte[] loadFilterContent(String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FCTRLKEY, FFILTER FROM T_QING_PUB_EMAIL_BILL WHERE FCONFIGID = ? ORDER BY FFILTERINDEX ASC";
        return (byte[])this.dbExcuter.query(sql, new Object[]{configId}, (ResultHandler)new ResultHandler<byte[]>(){

            public byte[] handle(ResultSet rs) throws SQLException {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                while (rs.next()) {
                    try {
                        byte[] bytes = rs.getBytes("FFILTER");
                        if (bytes == null) continue;
                        os.write(bytes);
                    }
                    catch (IOException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                }
                return os.toByteArray();
            }
        });
    }

    public void insertBill(TimingPushBillPO emailBill) throws AbstractQingIntegratedException, SQLException {
        String blockSql = "INSERT INTO T_QING_PUB_EMAIL_BILL(FID, FCONFIGID, FFILTER, FFILTERINDEX, FCTRLKEY) VALUES (?,?,?,?,?)";
        byte[] blockData = emailBill.getFilterContent();
        Integer length = blockData == null ? 1 : blockData.length;
        int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
        int contentSize = 0;
        int offset = 0;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int i = 0; i < count; ++i) {
            Object[] param = new Object[5];
            contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
            param[0] = this.dbExcuter.genStringId("T_QING_PUB_EMAIL_BILL");
            param[1] = emailBill.getConfigId();
            param[2] = this.dbExcuter.createSqlParameterBytes(blockData, offset, contentSize);
            param[3] = i;
            param[4] = emailBill.getCtrKey();
            offset += contentSize;
            params.add(param);
        }
        this.dbExcuter.executeBatch(blockSql, params);
    }

    public TimingPushBillPO loadBillInfo(String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FCTRLKEY, FFILTER FROM T_QING_PUB_EMAIL_BILL WHERE FCONFIGID = ? ORDER BY FFILTERINDEX ASC";
        return (TimingPushBillPO)this.dbExcuter.query(sql, new Object[]{configId}, (ResultHandler)new ResultHandler<TimingPushBillPO>(){

            public TimingPushBillPO handle(ResultSet rs) throws SQLException {
                TimingPushBillPO bill = new TimingPushBillPO();
                if (rs.next()) {
                    bill.setCtrKey(rs.getString("FCTRLKEY"));
                }
                return bill;
            }
        });
    }

    public void delete(String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_PUB_EMAIL_BILL WHERE FCONFIGID=?";
        this.dbExcuter.execute(sql, new Object[]{configId});
    }
}

