/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.email.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class EmailSchemaContentDao {
    private IDBExcuter dbExcuter;

    public EmailSchemaContentDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void saveSchemaContent(String configId, byte[] blockData) throws AbstractQingIntegratedException, SQLException {
        Integer length = blockData.length;
        if (length > 0) {
            int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
            int contentSize = 0;
            int offset = 0;
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (int i = 0; i < count; ++i) {
                contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                Object[] param = new Object[]{this.dbExcuter.genStringId("T_QING_PUB_EMAIL_SCHEMA"), configId, i, this.dbExcuter.createSqlParameterBytes(blockData, offset, contentSize)};
                offset += contentSize;
                params.add(param);
            }
            this.dbExcuter.executeBatch("INSERT INTO T_QING_PUB_EMAIL_SCHEMA (FID, FCONFIGID, FCONTENTINDEX, FCONTENT) VALUES(?, ?, ?, ?)", params);
        }
    }

    public byte[] getSchemaContent(String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FCONTENT FROM T_QING_PUB_EMAIL_SCHEMA WHERE FCONFIGID=? ORDER BY FCONTENTINDEX ASC";
        return (byte[])this.dbExcuter.query(sql, new Object[]{configId}, (ResultHandler)new ResultHandler<byte[]>(){

            public byte[] handle(ResultSet rs) throws SQLException {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                while (rs.next()) {
                    try {
                        os.write(rs.getBytes("FCONTENT"));
                    }
                    catch (IOException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                }
                return os.toByteArray();
            }
        });
    }

    public void deleteSchemaContent(String configId) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_PUB_EMAIL_SCHEMA WHERE FCONFIGID=?";
        this.dbExcuter.execute(sql, new Object[]{configId});
    }
}

