/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.email.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.publish.domain.AbstractPublishManageDomain;
import com.kingdee.bos.qing.publish.exception.MismatchSourceTypeException;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.target.email.dao.EmailConfigDao;
import com.kingdee.bos.qing.publish.target.email.source.IEmailConfigSourceDomain;
import com.kingdee.bos.qing.publish.target.email.source.impl.BillEmailConfigSourceDomain;
import com.kingdee.bos.qing.publish.target.email.source.impl.DsbEmailConfigSourceDomain;
import com.kingdee.bos.qing.publish.target.email.source.impl.SubjectEmailConfigSourceDomain;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.exception.ScheduleEngineException;
import java.sql.SQLException;

public class AbstractEmailConfigDomain
extends AbstractPublishManageDomain {
    private EmailConfigDao emailConfigDao;

    public AbstractEmailConfigDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    protected EmailConfigDao getEmailConfigDao() {
        if (this.emailConfigDao == null) {
            this.emailConfigDao = new EmailConfigDao(this.qingContext, this.dbExcuter);
        }
        return this.emailConfigDao;
    }

    public IEmailConfigSourceDomain getSourceDomain(PublishSourceEnum publishSourceType) throws MismatchSourceTypeException {
        switch (publishSourceType) {
            case bill: {
                return new BillEmailConfigSourceDomain(this.dbExcuter, this.qingContext, this.tx);
            }
            case report: {
                return new BillEmailConfigSourceDomain(this.dbExcuter, this.qingContext, this.tx);
            }
            case subject: {
                return new SubjectEmailConfigSourceDomain(this.dbExcuter, this.qingContext, this.tx);
            }
            case dashboard: {
                return new DsbEmailConfigSourceDomain(this.dbExcuter, this.qingContext, this.tx);
            }
        }
        throw new MismatchSourceTypeException("mismatch source type");
    }

    public void closeSchedule(String id) throws AbstractQingIntegratedException, SQLException, ScheduleEngineException {
        try {
            this.tx.beginRequired();
            this.scheduleEngine.deleteJob(this.qingContext, null, id);
            this.getEmailConfigDao().updateScheduleSwitch(id, false);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }
}

