/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.email.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.publish.target.email.dao.EmailSenderDao;
import com.kingdee.bos.qing.publish.target.email.exception.EmailException;
import com.kingdee.bos.qing.publish.target.email.model.EmailSenderVO;
import com.kingdee.bos.qing.publish.target.email.util.RSAUtils;
import com.kingdee.bos.qing.publish.target.email.util.SendEmailUtil;
import java.sql.SQLException;

public class EmailSenderManageDomain {
    private IDBExcuter dbExcuter;
    private QingContext qingContext;
    private ITransactionManagement tx;
    private EmailSenderDao emailSenderDao;

    public EmailSenderManageDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter) {
        this.qingContext = qingContext;
        this.dbExcuter = dbExcuter;
        this.tx = tx;
    }

    private EmailSenderDao getEmailSenderDao() {
        if (this.emailSenderDao == null) {
            this.emailSenderDao = new EmailSenderDao(this.dbExcuter);
        }
        return this.emailSenderDao;
    }

    public EmailSenderVO getUserEmailSender() throws AbstractQingIntegratedException, EmailException {
        try {
            return this.getEmailSenderDao().getUserEmailSender(this.qingContext.getUserId(), true);
        }
        catch (SQLException e) {
            throw new EmailException(e);
        }
    }

    public String saveEmailSender(EmailSenderVO emailSender) throws EmailException, AbstractQingIntegratedException {
        try {
            this.tx.beginRequired();
            String id = emailSender.getId();
            if (emailSender.getId() == null || "".equals(emailSender.getId())) {
                emailSender.setUserId(this.qingContext.getUserId());
                id = this.getEmailSenderDao().insert(emailSender);
            } else {
                this.getEmailSenderDao().update(emailSender);
            }
            String string = id;
            return string;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new EmailException(e);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public void connectTest(EmailSenderVO emailSender) throws EmailException {
        String pwd = RSAUtils.decryptByPrivateKey(emailSender.getPwd(), EmailSenderVO.RSAPRIVATEKEY);
        emailSender.setPwd(pwd);
        SendEmailUtil.connectTest(emailSender);
    }

    public EmailSenderVO getEmailSenderById(String senderId, String userId) throws AbstractQingIntegratedException, SQLException {
        return this.getEmailSenderDao().getEmailSenderById(senderId, userId);
    }
}

