/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.email.source;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.publish.model.PublishSchemaModel;
import com.kingdee.bos.qing.publish.target.email.dao.EmailSchemaContentDao;
import com.kingdee.bos.qing.publish.target.email.source.IEmailConfigSourceDomain;
import com.kingdee.bos.qing.schema.model.SchemaAttrVO;
import com.kingdee.bos.qing.util.ModelBookUtil;
import java.io.IOException;
import java.sql.SQLException;
import org.jdom2.JDOMException;

public abstract class AbstractEmailConfigSourceDomain
implements IEmailConfigSourceDomain {
    protected IDBExcuter dbExcuter;
    protected ITransactionManagement tx;
    private EmailSchemaContentDao emailSchemaContentDao;

    public AbstractEmailConfigSourceDomain(IDBExcuter dbExcuter, ITransactionManagement tx) {
        this.dbExcuter = dbExcuter;
        this.tx = tx;
    }

    protected EmailSchemaContentDao getEmailSchemaContentDao() {
        if (this.emailSchemaContentDao == null) {
            this.emailSchemaContentDao = new EmailSchemaContentDao(this.dbExcuter);
        }
        return this.emailSchemaContentDao;
    }

    protected PublishSchemaModel getPublishSubectOrBillModel(String configId, int schemaSourceType) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException, PersistentModelTooModernException, JDOMException, IOException {
        byte[] schemaContentBytes = this.getEmailSchemaContentDao().getSchemaContent(configId);
        ModelBook modelBook = ModelBookUtil.fromByte(schemaContentBytes);
        SchemaAttrVO schemaAttr = new SchemaAttrVO();
        schemaAttr.setSource(schemaSourceType);
        schemaAttr.setSchemaType(2);
        schemaAttr.setIsDefault(true);
        PublishSchemaModel publishSubjectModel = new PublishSchemaModel();
        publishSubjectModel.setSchemaAttr(schemaAttr);
        publishSubjectModel.setSchemaContent(modelBook);
        return publishSubjectModel;
    }
}

