/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.email.source;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.core.model.ModelJsonDecoder;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.publish.target.email.dao.EmailConfigDao;
import com.kingdee.bos.qing.publish.target.email.domain.EmailConfigManageDomain;
import com.kingdee.bos.qing.publish.target.email.exception.NotFoundEmailConfigException;
import com.kingdee.bos.qing.publish.target.email.model.EmailConfig;
import com.kingdee.bos.qing.publish.target.email.source.AbstractEmailConfigSourceDomain;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.exception.ScheduleEngineException;
import com.kingdee.bos.qing.util.ModelBookUtil;
import java.io.IOException;
import java.sql.SQLException;
import org.jdom2.JDOMException;

public abstract class AbstractQingModelSchemaConfigSourceDomain
extends AbstractEmailConfigSourceDomain {
    private QingContext qingContext;
    private EmailConfigDao emailConfigDao;

    private EmailConfigDao getEmailConfigDao() {
        if (this.emailConfigDao == null) {
            this.emailConfigDao = new EmailConfigDao(this.qingContext, this.dbExcuter);
        }
        return this.emailConfigDao;
    }

    public AbstractQingModelSchemaConfigSourceDomain(IDBExcuter dbExcuter, QingContext qingContext, ITransactionManagement tx) {
        super(dbExcuter, tx);
        this.qingContext = qingContext;
    }

    public ModelBook loadSchema(String configId) throws SQLException, AbstractQingException, JDOMException, IOException {
        byte[] schemaContent = this.getEmailSchemaContentDao().getSchemaContent(configId);
        ModelBook modelBook = ModelBookUtil.fromByte(schemaContent);
        return modelBook;
    }

    public void updateSchema(String configId, String jsonModel, IScheduleEngine scheduleEngine) throws AbstractQingIntegratedException, SQLException, NotFoundEmailConfigException, ScheduleEngineException {
        try {
            this.tx.beginRequired();
            EmailConfig emailConfig = this.getEmailConfigDao().getEmailConfigById(configId);
            if (emailConfig == null) {
                throw new NotFoundEmailConfigException();
            }
            boolean warningRuleStatus = EmailConfigManageDomain.checkWarningRuleStatus(emailConfig, ModelJsonDecoder.decode((String)jsonModel));
            if (!emailConfig.getWarningRuleStatus() && warningRuleStatus) {
                this.getEmailConfigDao().updateWarningStatus(configId, true);
            }
            if (!warningRuleStatus) {
                this.getEmailConfigDao().updateScheduleSwitchAndWarningStatus(configId, false, false);
                scheduleEngine.deleteJob(this.qingContext, null, emailConfig.getId());
            }
            this.getEmailSchemaContentDao().deleteSchemaContent(configId);
            ModelBook modelBook = ModelJsonDecoder.decode((String)jsonModel);
            this.getEmailSchemaContentDao().saveSchemaContent(configId, ModelBookUtil.toByte(modelBook));
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (ScheduleEngineException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }
}

