/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.email.source.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.ModelJsonDecoder;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.publish.dao.BillManagerDao;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.TimingPushBillPO;
import com.kingdee.bos.qing.publish.target.email.dao.EmailBillDao;
import com.kingdee.bos.qing.publish.target.email.model.EmailConfig;
import com.kingdee.bos.qing.publish.target.email.source.AbstractQingModelSchemaConfigSourceDomain;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.schema.model.SchemaVO;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class BillEmailConfigSourceDomain
extends AbstractQingModelSchemaConfigSourceDomain {
    private BillManagerDao billManagerDao;
    private PublishInfoDao publishInfoDao;
    private EmailBillDao emailBillDao;

    public BillEmailConfigSourceDomain(IDBExcuter dbExcuter, QingContext qingContext, ITransactionManagement tx) {
        super(dbExcuter, qingContext, tx);
    }

    private BillManagerDao getBillManagerDao() {
        if (this.billManagerDao == null) {
            this.billManagerDao = new BillManagerDao(this.dbExcuter);
        }
        return this.billManagerDao;
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private EmailBillDao getEmailBillDao() {
        if (this.emailBillDao == null) {
            this.emailBillDao = new EmailBillDao(this.dbExcuter);
        }
        return this.emailBillDao;
    }

    @Override
    public EmailConfig insert(String tag, EmailConfig emailConfig, String sceneModelJson) throws PublishException, AbstractQingIntegratedException {
        try {
            this.insertPublishToEmailBill(tag, emailConfig);
            int schemaSourceType = this.saveEmailSchemaContent(emailConfig, sceneModelJson);
            emailConfig.setSchemaSourceType(schemaSourceType);
            return emailConfig;
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
    }

    private void insertPublishToEmailBill(String tag, EmailConfig emailConfig) throws AbstractQingIntegratedException, SQLException {
        String bizTag = emailConfig.getTagId();
        byte[] fFilter = null;
        String ctrKey = null;
        if (PublishUtil.isPublish((String)bizTag)) {
            PublishPO oldInfo = this.getPublishInfoDao().getPublishInfoByInfoId(bizTag);
            bizTag = oldInfo.getTagId();
            emailConfig.setTagId(bizTag);
            fFilter = this.getBillManagerDao().loadFilterContent(oldInfo.getId());
            ctrKey = this.getBillManagerDao().getBillCtrKey(oldInfo.getId());
        } else {
            String filterStr = QingSessionUtil.get((String)("qing_filter_" + tag));
            if (filterStr != null) {
                try {
                    fFilter = filterStr.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    LogUtil.error((String)e.getMessage(), (Throwable)e);
                }
            }
            ctrKey = QingSessionUtil.get((String)("qing_ctrl_tag_" + tag));
        }
        TimingPushBillPO bill = new TimingPushBillPO();
        bill.setCtrKey(ctrKey);
        bill.setConfigId(emailConfig.getId());
        bill.setFilterContent(fFilter);
        this.getEmailBillDao().insertBill(bill);
    }

    private int saveEmailSchemaContent(EmailConfig emailConfig, String sceneModelJson) throws AbstractQingIntegratedException, SQLException {
        SchemaVO schemaVO = (SchemaVO)ModelJsonDecoder.decode((String)sceneModelJson, SchemaVO.class);
        ModelBook modelBook = schemaVO.getSchemaContent();
        byte[] modelBookContentBytes = XmlUtil.toByteArray((Element)modelBook.toXml());
        this.getEmailSchemaContentDao().saveSchemaContent(emailConfig.getId(), modelBookContentBytes);
        int schemaSourceType = schemaVO.getSchemaAttr().getSource();
        return schemaSourceType;
    }

    @Override
    public void delete(String configId) throws AbstractQingIntegratedException, SQLException {
        this.getEmailBillDao().delete(configId);
    }

    @Override
    public AbstractPublishSourceModel loadPublishModel(EmailConfig emailConfig) throws PersistentModelParseException, PersistentModelTooModernException, AbstractQingIntegratedException, SQLException, JDOMException, IOException {
        return this.getPublishSubectOrBillModel(emailConfig.getId(), emailConfig.getSchemaSourceType());
    }
}

