/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.email.source.impl;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.ModelJsonDecoder;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishSourcePublishNotExistException;
import com.kingdee.bos.qing.publish.exception.PublishSourceSubjectNotExistException;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.target.email.model.EmailConfig;
import com.kingdee.bos.qing.publish.target.email.source.AbstractQingModelSchemaConfigSourceDomain;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.schema.model.SchemaVO;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.IOException;
import java.sql.SQLException;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class SubjectEmailConfigSourceDomain
extends AbstractQingModelSchemaConfigSourceDomain {
    private PublishInfoDao publishInfoDao;
    private IThemeDao themeDao;

    public SubjectEmailConfigSourceDomain(IDBExcuter dbExcuter, QingContext qingContext, ITransactionManagement tx) {
        super(dbExcuter, qingContext, tx);
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private IThemeDao getThemeDao() {
        if (this.themeDao == null) {
            this.themeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.themeDao;
    }

    @Override
    public EmailConfig insert(String tag, EmailConfig emailConfig, String sceneModelJson) throws PublishException, AbstractQingIntegratedException {
        try {
            String bizTag = emailConfig.getTagId();
            this.checkSourceIsExist(bizTag);
            SchemaVO schemaVO = (SchemaVO)ModelJsonDecoder.decode((String)sceneModelJson, SchemaVO.class);
            ModelBook modelBook = schemaVO.getSchemaContent();
            byte[] modelBookContentBytes = XmlUtil.toByteArray((Element)modelBook.toXml());
            this.getEmailSchemaContentDao().saveSchemaContent(emailConfig.getId(), modelBookContentBytes);
            int schemaSourceType = schemaVO.getSchemaAttr().getSource();
            emailConfig.setSchemaSourceType(schemaSourceType);
            return emailConfig;
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
    }

    @Override
    public void delete(String configId) throws AbstractQingIntegratedException, SQLException {
        this.getEmailSchemaContentDao().deleteSchemaContent(configId);
    }

    private void checkSourceIsExist(String bizTag) throws AbstractQingIntegratedException, SQLException, PublishSourcePublishNotExistException, PublishSourceSubjectNotExistException {
        ThemePO theme;
        if (PublishUtil.isPublish((String)bizTag)) {
            PublishPO oldInfo = this.getPublishInfoDao().getPublishInfoByInfoId(bizTag);
            if (oldInfo == null) {
                throw new PublishSourcePublishNotExistException();
            }
            bizTag = oldInfo.getTagId();
        }
        if ((theme = this.getThemeDao().getThemeByID(bizTag)) == null) {
            throw new PublishSourceSubjectNotExistException();
        }
    }

    @Override
    public AbstractPublishSourceModel loadPublishModel(EmailConfig emailConfig) throws PersistentModelParseException, PersistentModelTooModernException, AbstractQingIntegratedException, SQLException, JDOMException, IOException {
        return this.getPublishSubectOrBillModel(emailConfig.getId(), emailConfig.getSchemaSourceType());
    }
}

