/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.email.util;

import com.kingdee.bos.qing.util.LogUtil;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RSAUtils {
    public static final String KEY_ALGORTHM = "RSA";
    public static final String PUBLIC_KEY = "RSAPublicKey";
    public static final String PRIVATE_KEY = "RSAPrivateKey";

    public static Map<String, Object> initKey() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORTHM);
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        HashMap<String, Object> keyMap = new HashMap<String, Object>(2);
        keyMap.put(PUBLIC_KEY, publicKey);
        keyMap.put(PRIVATE_KEY, privateKey);
        return keyMap;
    }

    public static String getPublicKey(Map<String, Object> keyMap) {
        Key key = (Key)keyMap.get(PUBLIC_KEY);
        return RSAUtils.encryptBASE64(key.getEncoded());
    }

    public static String getPrivateKey(Map<String, Object> keyMap) {
        Key key = (Key)keyMap.get(PRIVATE_KEY);
        return RSAUtils.encryptBASE64(key.getEncoded());
    }

    public static String encryptByPublicKey(String data, String key) {
        try {
            byte[] dataBytes = data.getBytes();
            byte[] keyBytes = RSAUtils.decryptBASE64(key);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORTHM);
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, publicKey);
            return RSAUtils.encryptBASE64(cipher.doFinal(dataBytes));
        }
        catch (Exception e) {
            LogUtil.error((String)"RSA encryptByPublicKey erro", (Throwable)e);
            return null;
        }
    }

    public static String decryptByPrivateKey(String data, String key) {
        try {
            byte[] dataBytes = RSAUtils.decryptBASE64(data);
            byte[] keyBytes = RSAUtils.decryptBASE64(key);
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORTHM);
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, privateKey);
            return new String(cipher.doFinal(dataBytes));
        }
        catch (Exception e) {
            LogUtil.error((String)"RSA decryptByPrivateKey erro", (Throwable)e);
            return null;
        }
    }

    private static byte[] decryptBASE64(String key) {
        return Base64.decodeBase64((String)key);
    }

    private static String encryptBASE64(byte[] key) {
        return new String(Base64.encodeBase64((byte[])key));
    }
}

