/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.email.util;

import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.publish.target.email.exception.EmailException;
import com.kingdee.bos.qing.publish.target.email.exception.SendEmailsInvalidReceiversException;
import com.kingdee.bos.qing.publish.target.email.exception.SendEmailsOtherException;
import com.kingdee.bos.qing.publish.target.email.exception.SendEmailsSenderException;
import com.kingdee.bos.qing.publish.target.email.model.EmailSenderVO;
import com.kingdee.bos.qing.publish.target.email.model.SendEmailBO;
import com.kingdee.bos.qing.util.LogUtil;
import com.sun.mail.util.MailSSLSocketFactory;
import java.security.GeneralSecurityException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SendEmailUtil {
    private static final String RECEIVERSSPLIT = "\\;|\\,|\uff1b|\uff0c";

    public static void sendEmails(SendEmailBO sendEmail) throws SendEmailsOtherException, SendEmailsSenderException, SendEmailsInvalidReceiversException {
        Transport transport = null;
        try {
            Properties props = SendEmailUtil.buildPropertiesByBO(sendEmail);
            Session session = Session.getInstance((Properties)props);
            session.setDebug(false);
            MimeMessage message = new MimeMessage(session);
            String htmlContent = SendEmailUtil.getBodyHtmlContent(sendEmail);
            MimeMultipart allPart = new MimeMultipart("mixed");
            MimeBodyPart bodyPartContent = SendEmailUtil.createBodyPartContent(htmlContent);
            allPart.addBodyPart((BodyPart)bodyPartContent);
            message.setFrom((Address)new InternetAddress(sendEmail.getSenderAccount()));
            Address[] recipients = SendEmailUtil.getRecipients(sendEmail.getReceivers());
            message.setRecipients(Message.RecipientType.TO, recipients);
            message.setSubject(sendEmail.getSubject(), "UTF-8");
            message.setContent((Multipart)allPart);
            message.saveChanges();
            transport = session.getTransport();
            SendEmailUtil.transportConnect(transport, sendEmail.getSenderAccount(), sendEmail.getSenderPwd());
            try {
                SendEmailUtil.sendMessage(transport, message);
            }
            catch (SendFailedException e) {
                Address[] validUnsentAddresses = e.getValidUnsentAddresses();
                message.setRecipients(Message.RecipientType.TO, validUnsentAddresses);
                SendEmailUtil.sendMessage(transport, message);
                throw new SendEmailsInvalidReceiversException(e);
            }
        }
        catch (SendEmailsSenderException e) {
            throw e;
        }
        catch (SendEmailsInvalidReceiversException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SendEmailsOtherException(e);
        }
        finally {
            if (transport != null) {
                try {
                    transport.close();
                }
                catch (MessagingException e) {
                    LogUtil.error((String)"transport close error", (Throwable)e);
                }
            }
        }
    }

    private static void transportConnect(Transport transport, String account, String pwd) throws SendEmailsSenderException {
        boolean tryFlag = true;
        try {
            if (account.indexOf("@kingdee.com") > -1) {
                account = account.substring(0, account.indexOf("@"));
                tryFlag = false;
            }
            transport.connect(null, account, pwd);
        }
        catch (MessagingException e) {
            if (tryFlag) {
                try {
                    if (account.indexOf("@") > -1) {
                        account = account.substring(0, account.indexOf("@"));
                    }
                    transport.connect(null, account, pwd);
                }
                catch (MessagingException e1) {
                    throw new SendEmailsSenderException(e1);
                }
            }
            throw new SendEmailsSenderException(e);
        }
    }

    public static void connectTest(EmailSenderVO emailSender) throws SendEmailsSenderException {
        Transport transport = null;
        try {
            Properties props = SendEmailUtil.buildPropertiesByVO(emailSender);
            Session session = Session.getInstance((Properties)props);
            session.setDebug(false);
            transport = session.getTransport();
            SendEmailUtil.transportConnect(transport, emailSender.getAccount(), emailSender.getPwd());
        }
        catch (Exception e) {
            throw new SendEmailsSenderException(e);
        }
        finally {
            if (transport != null) {
                try {
                    transport.close();
                }
                catch (MessagingException e) {
                    LogUtil.error((String)"transport close", (Throwable)e);
                }
            }
        }
    }

    private static Properties buildPropertiesByVO(EmailSenderVO emailSender) throws GeneralSecurityException {
        Properties props = SendEmailUtil.buildProperties();
        if (emailSender.isSSL()) {
            props.setProperty("mail.smtp.ssl.enable", "true");
            MailSSLSocketFactory sf = new MailSSLSocketFactory();
            sf.setTrustAllHosts(true);
            props.put("mail.smtp.ssl.socketFactory", sf);
            props.setProperty("mail.smtp.socketFactory.port", "" + emailSender.getPort());
        }
        props.setProperty("mail.smtp.host", emailSender.getSmtpHost());
        props.setProperty("mail.smtp.port", "" + emailSender.getPort());
        return props;
    }

    private static Properties buildPropertiesByBO(SendEmailBO sendEmail) throws GeneralSecurityException {
        Properties props = SendEmailUtil.buildProperties();
        if (sendEmail.getSenderIsSSL()) {
            props.setProperty("mail.smtp.ssl.enable", "true");
            MailSSLSocketFactory sf = new MailSSLSocketFactory();
            sf.setTrustAllHosts(true);
            props.put("mail.smtp.ssl.socketFactory", sf);
            props.setProperty("mail.smtp.socketFactory.port", "" + sendEmail.getSenderPort());
        }
        props.setProperty("mail.smtp.host", sendEmail.getSenderSmtpHost());
        props.setProperty("mail.smtp.port", "" + sendEmail.getSenderPort());
        return props;
    }

    private static Properties buildProperties() {
        Properties props = new Properties();
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.smtp.localhost", "127.0.0.1");
        props.setProperty("mail.smtp.timeout", "10000");
        props.setProperty("mail.smtp.connectiontimeout", "5000");
        props.setProperty("mail.smtp.writetimeout", "10000");
        props.setProperty("mail.smtp.starttls.enable", "true");
        return props;
    }

    private static void sendMessage(Transport transport, MimeMessage message) throws MessagingException {
        transport.sendMessage((Message)message, message.getAllRecipients());
    }

    private static Address[] getRecipients(String sendEmailReceivers) throws AddressException {
        String[] receivers = sendEmailReceivers.split(RECEIVERSSPLIT);
        InternetAddress[] recipients = new InternetAddress[receivers.length];
        for (int i = 0; i < receivers.length; ++i) {
            recipients[i] = new InternetAddress(receivers[i]);
        }
        return recipients;
    }

    private static String getBodyHtmlContent(SendEmailBO sendEmail) {
        String enterQinganalysis = Messages.getMLS((String)"enterQinganalysis", (String)"\u8fdb\u5165\u8f7b\u5206\u6790\u67e5\u770b", (Messages.ProjectName)Messages.ProjectName.QING_THEME);
        StringBuilder sb = new StringBuilder();
        sb.append("<html>").append("<body>").append("<div style='font-family:Microsoft YaHei;width:100%; max-width:800px; display:inline-block; padding:10px; font-size:14px; text-decoration:none; '>").append("<pre>").append(sendEmail.getContent()).append("</pre>").append("<div style='padding-top:15px'>").append("<a style='background:#5582f3; border-radius:14px; padding: 6px 12px;color:#fff;text-decoration:none;font-size:12px;' href='").append(sendEmail.getRuntimeUrl()).append("' rel='noopener' target='_blank'>").append(enterQinganalysis).append("</a>").append("</div>").append("</div>").append("</body>").append("</html>");
        return sb.toString();
    }

    private static MimeBodyPart createBodyPartContent(String body) throws EmailException {
        MimeBodyPart contentBody = new MimeBodyPart();
        MimeMultipart contentMulti = new MimeMultipart("related");
        MimeBodyPart textBody = new MimeBodyPart();
        try {
            textBody.setContent((Object)body, "text/html;charset=gbk");
            contentMulti.addBodyPart((BodyPart)textBody);
            contentBody.setContent((Multipart)contentMulti);
        }
        catch (MessagingException e) {
            throw new EmailException(e);
        }
        return contentBody;
    }
}

