/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.lapp;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.map.MapRefUpdater;
import com.kingdee.bos.qing.publish.target.lapp.dao.LappDao;
import com.kingdee.bos.qing.util.LogUtil;
import java.sql.SQLException;
import java.util.List;

public class LappMapRefUpdater
implements MapRefUpdater {
    private IDBExcuter dbExcuter;
    private LappDao lappDao;

    @Override
    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    private LappDao getLappDao() {
        if (this.lappDao == null) {
            this.lappDao = new LappDao(this.dbExcuter);
        }
        return this.lappDao;
    }

    @Override
    public void updateMapIdOfRefWithoutTx(String mapId, String fullPath) {
        try {
            List<String> pushOutSideRefList = this.getLappDao().loadSchemaRefListByFullPath(fullPath);
            for (int i = 0; i < pushOutSideRefList.size(); ++i) {
                String fId = pushOutSideRefList.get(i);
                this.getLappDao().updateSchemaRefToIdByRefId(fId, mapId);
            }
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)"upadte config schema ref refToId error", (Throwable)e);
        }
        catch (SQLException e) {
            LogUtil.error((String)"upadte config schema ref refToId error", (Throwable)e);
        }
    }

    @Override
    public void updateMapFullPathOfRefWithoutTx(String mapId, String fullPath) {
        try {
            List<String> pushOutSideRefList = this.getLappDao().loadSchemaRefListByRefToId(mapId);
            for (int i = 0; i < pushOutSideRefList.size(); ++i) {
                String fId = pushOutSideRefList.get(i);
                this.getLappDao().updateRefFullPathByRefId(fId, fullPath);
            }
        }
        catch (AbstractQingIntegratedException e) {
            LogUtil.error((String)"upadte config schema ref reffullPath error", (Throwable)e);
        }
        catch (SQLException e) {
            LogUtil.error((String)"upadte config schema ref reffullPath error", (Throwable)e);
        }
    }
}

