/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.lapp;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.model.AbstractPublishSourceModel;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.target.AbstractPublishTargetDomain;
import com.kingdee.bos.qing.publish.thumbnail.domain.ThumbnailDomain;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.exception.ScheduleEngineException;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;

public class LappPublishTargetDomain
extends AbstractPublishTargetDomain {
    private ThumbnailDomain thumbnailDomain;
    public static final String PATH = "lightapp";

    public LappPublishTargetDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
        this.thumbnailDomain = new ThumbnailDomain(qingContext, tx, dbExcuter, scheduleEngine);
    }

    public PublishPO savePublish(String tag, PublishSourceEnum source, PublishPO publishInfo, List<AbstractPublishSourceModel> abstractPublishSourceModelList) {
        publishInfo.setName(publishInfo.getName() + UUID.randomUUID().toString());
        return publishInfo;
    }

    public void deletePublish(PublishPO info) throws AbstractQingIntegratedException, PublishException {
        try {
            this.thumbnailDomain.deleteByPublishIdWithoutTx(info.getId());
        }
        catch (SQLException e) {
            throw new PublishException((Throwable)e);
        }
        catch (ScheduleEngineException e) {
            throw new PublishException((Throwable)e);
        }
        catch (PersistentModelParseException e) {
            throw new PublishException((Throwable)e);
        }
        catch (PersistentModelTooModernException e) {
            throw new PublishException((Throwable)e);
        }
    }

    public void updatePublish(int updateType, PublishPO publishInfoNew) {
    }

    public void overwritePublish(String tag, int updateType, PublishPO publishInfoNew, List<AbstractPublishSourceModel> abstractPublishSourceModelList) throws AbstractQingIntegratedException, PublishException {
        publishInfoNew.setName(publishInfoNew.getName() + UUID.randomUUID().toString());
    }

    public String loadOrCreatePath(String userId, String pathId, String pathName) throws AbstractQingIntegratedException, SQLException {
        if (PATH.equals(pathId)) {
            return PATH;
        }
        return pathId;
    }

    public String loadPathNameByPath(String path, String publishId) {
        return PATH;
    }

    public String loadPathNamePOByPathId(String pathId) throws AbstractQingIntegratedException, SQLException {
        return PATH;
    }
}

