/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schema;

import com.kingdee.bos.qing.behavior.BehaviorAssociate;
import com.kingdee.bos.qing.behavior.impl.BehaviorService;
import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.core.model.ModelJsonDecoder;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.schema.ISchemaManageService;
import com.kingdee.bos.qing.schema.custom.ICustomSchemaStrategy;
import com.kingdee.bos.qing.schema.domain.SchemaDomain;
import com.kingdee.bos.qing.schema.exception.CustomSchemaException;
import com.kingdee.bos.qing.schema.exception.SchemaManagerException;
import com.kingdee.bos.qing.schema.model.SchemaAttrVO;
import com.kingdee.bos.qing.schema.model.SchemaAttrVOList;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.schema.model.SchemaContentVO;
import com.kingdee.bos.qing.schema.model.SchemaVO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SchemaManageService
extends BehaviorService
implements ISchemaManageService,
IQingContextable,
IDBAccessable {
    private QingContext context;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    protected SchemaDomain schemaDomain;

    public final void setQingContext(QingContext context) {
        this.context = context;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    private SchemaDomain getSchemaDomain() {
        if (this.schemaDomain == null) {
            this.schemaDomain = new SchemaDomain();
            this.schemaDomain.setTx(this.tx);
            this.schemaDomain.setQingContext(this.context);
            this.schemaDomain.setDbExcuter(this.dbExcuter);
        }
        return this.schemaDomain;
    }

    @Override
    @BehaviorAssociate(behavior=true)
    public final byte[] schemaManage_loadAttrs(Map<String, String> params) {
        String bizTag = params.get("bizTag");
        int source = 0;
        String sSource = params.get("source");
        if (sSource != null) {
            source = Integer.parseInt(sSource);
        }
        String userId = this.context.getUserId();
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)true);
            ArrayList<SchemaAttrVO> schemaAttrVOList = this.getSchemaDomain().loadSchemaAttrs(bizTag, userId, source);
            if (PublishUtil.isPublish((String)bizTag)) {
                String isSetDefaultSchema = this.checkCustomSetDefaultSchema(schemaAttrVOList);
                if (isSetDefaultSchema != null) {
                    wrap.setData(schemaAttrVOList);
                } else {
                    ArrayList<SchemaAttrVO> publishSchemaAttr = this.getSchemaDomain().loadSchemaAttrs(bizTag, "SystemUser", source);
                    String isPublishSetDefaultSchema = this.checkCustomSetDefaultSchema(publishSchemaAttr);
                    if (isPublishSetDefaultSchema != null) {
                        for (SchemaAttrVO schemaAttrVO : schemaAttrVOList) {
                            if (!isPublishSetDefaultSchema.equals(schemaAttrVO.getfId())) continue;
                            schemaAttrVO.setIsDefault(true);
                        }
                        wrap.setData(schemaAttrVOList);
                    } else {
                        ArrayList<SchemaAttrVO> schemaAttrVOS;
                        String isHaveDefaultSchema;
                        List<String> authorityRoles = this.getSchemaDomain().loadAuthorityRoles(bizTag);
                        Set userRoleIds = IntegratedHelper.getUserRoleIds((QingContext)this.context, (IDBExcuter)this.dbExcuter, (String)userId);
                        authorityRoles.retainAll(userRoleIds);
                        if (authorityRoles.size() > 0 && (isHaveDefaultSchema = this.checkCustomSetDefaultSchema(schemaAttrVOS = this.getSchemaDomain().loadSchemaAttrs(bizTag, authorityRoles.get(0), source))) != null) {
                            wrap.setData(schemaAttrVOS);
                        }
                    }
                    if (Boolean.parseBoolean(wrap.getData().toString())) {
                        wrap.setData(schemaAttrVOList);
                    }
                }
            } else {
                wrap.setData(schemaAttrVOList);
            }
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public String checkCustomSetDefaultSchema(ArrayList<SchemaAttrVO> schemaAttrVOList) {
        if (schemaAttrVOList.size() > 0) {
            for (SchemaAttrVO schemaAttrVO : schemaAttrVOList) {
                if (!schemaAttrVO.IsDefault().booleanValue()) continue;
                return schemaAttrVO.getfId();
            }
        }
        return null;
    }

    @Override
    @BehaviorAssociate(behavior=true)
    public final byte[] schemaManage_loadContent(Map<String, String> params) {
        String fId = params.get("fId");
        String bizTag = params.get("bizTag");
        int source = 0;
        String sSource = params.get("source");
        if (sSource != null) {
            source = Integer.parseInt(sSource);
        }
        String userId = this.context.getUserId();
        SchemaContentVO vo = null;
        try {
            vo = this.getSchemaDomain().loadSchemaContent(fId, bizTag, userId, source);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)vo);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    private SchemaContentVO loadDefaultSchemaContent(Map<String, String> params) throws AbstractQingIntegratedException, SchemaManagerException {
        String fId = params.get("fId");
        String bizTag = params.get("bizTag");
        String sSource = params.get("source");
        int source = Integer.parseInt(sSource);
        String userId = this.context.getUserId();
        return this.getSchemaDomain().loadSchemaContent(fId, bizTag, userId, source);
    }

    @Override
    public byte[] schemaManage_loadCustomContent(Map<String, String> params) {
        try {
            SchemaContentVO vo = this.loadDefaultSchemaContent(params);
            if (null == vo) {
                vo = this.loadTemplateSchemaContent(params);
            }
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)vo);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    private SchemaContentVO loadTemplateSchemaContent(Map<String, String> params) throws CustomSchemaException {
        ModelBook modelBook;
        ICustomSchemaStrategy customSchemaService = (ICustomSchemaStrategy)CustomStrategyRegistrar.getStrategy(ICustomSchemaStrategy.class);
        if (null != customSchemaService && null != (modelBook = customSchemaService.loadCustomModelBook(params))) {
            SchemaContentVO vo = new SchemaContentVO();
            vo.setSchemaType(3);
            vo.setSchemaContent(modelBook);
            return vo;
        }
        return null;
    }

    @Override
    @BehaviorAssociate(behavior=true)
    public final byte[] schemaManage_setDefaultAttr(Map<String, String> params) {
        String bizTag = params.get("bizTag");
        String modelJsonString = params.get("model");
        SchemaAttrVO vo = (SchemaAttrVO)JsonUtil.decodeFromString((String)modelJsonString, SchemaAttrVO.class);
        int source = vo.getSource();
        boolean editPublishSchema = Boolean.parseBoolean(params.get("editPublishSchema"));
        String userId = editPublishSchema ? "SystemUser" : this.context.getUserId();
        try {
            Boolean setSchemaDefaultResult = this.getSchemaDomain().setSchemaDefaultAttr(bizTag, userId, source, vo);
            if (editPublishSchema && this.getSchemaDomain().checkPublishInfoSource(bizTag, this.context.getUserId())) {
                List<SchemaBO> schemaByBiztagList;
                String schemaId = "";
                schemaId = vo.IsDefault() != false ? vo.getfId() : ((schemaByBiztagList = this.getSchemaDomain().findSchemaByBiztag(bizTag, userId, source, null)).size() > 0 ? schemaByBiztagList.get(0).getfId() : "");
                this.getSchemaDomain().updatePublishInfoByFid(bizTag, this.context.getUserId(), schemaId);
            }
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)setSchemaDefaultResult);
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    @BehaviorAssociate(behavior=true)
    public final byte[] schemaManage_deleteSchema(Map<String, String> params) {
        String fId = params.get("fId");
        boolean editPublishSchema = Boolean.parseBoolean(params.get("editPublishSchema"));
        String userId = this.context.getUserId();
        try {
            if (editPublishSchema) {
                List<SchemaBO> schemaByBiztagList;
                String bizTag = params.get("bizTag");
                int source = 0;
                String sSource = params.get("source");
                if (sSource != null) {
                    source = Integer.parseInt(sSource);
                }
                if ((schemaByBiztagList = this.getSchemaDomain().findSchemaByBiztag(bizTag, "SystemUser", source, fId)).size() == 0) {
                    ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)"noSchema");
                    this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
                    return ResponseUtil.output((IResponseWrap)wrap);
                }
                SchemaBO defaultSchema = this.getSchemaDomain().findDefaultSchemaInPublish(bizTag, userId, source);
                if (defaultSchema == null || defaultSchema != null && Objects.equals(defaultSchema.getfId(), fId)) {
                    String schemaId = schemaByBiztagList.get(0).getfId();
                    this.getSchemaDomain().updatePublishInfoByFid(bizTag, userId, schemaId);
                }
            }
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getSchemaDomain().deleteSchema(fId, userId));
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    @BehaviorAssociate(behavior=true)
    public final byte[] schemaManage_updateSchema(Map<String, String> params) {
        String bizTag = params.get("bizTag");
        String modelJsonString = params.get("model");
        String editPublishSchema = params.get("editPublishSchema");
        SchemaVO vo = (SchemaVO)ModelJsonDecoder.decode((String)modelJsonString, SchemaVO.class);
        String userId = "true".equals(editPublishSchema) ? "SystemUser" : this.context.getUserId();
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getSchemaDomain().saveSchema(bizTag, userId, vo));
            if ("true".equals(editPublishSchema)) {
                List<SchemaBO> schemaBOList = this.getSchemaDomain().loadAllPublishSchemaAttrByBizTag(bizTag, userId, 0);
                if (vo.getSchemaAttr().IsDefault().booleanValue() || !this.judgePublisherSetDefaultSchema(schemaBOList) && vo.getSchemaAttr().getSeq() == schemaBOList.size() - 1) {
                    this.getSchemaDomain().updatePublishInfoByBiztag(bizTag, this.context.getUserId(), vo.getSchemaAttr().getfId());
                }
            }
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    public final byte[] schemaManage_renameSchema(Map<String, String> params) {
        String fId = params.get("fId");
        String name = params.get("name");
        String bizTag = params.get("bizTag");
        String sSource = params.get("source");
        int schemaType = Integer.parseInt(params.get("schemaType"));
        int source = 0;
        if (sSource != null) {
            source = Integer.parseInt(sSource);
        }
        String userId = this.context.getUserId();
        try {
            this.getSchemaDomain().renameSchema(fId, name, bizTag, source, userId, schemaType);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)true);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    public byte[] schemaManage_exportSql(Map<String, String> params) {
        String fid = params.get("fId");
        IQingFile exportFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
        try {
            this.getSchemaDomain().export(exportFile, fid);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)exportFile.getName());
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    public byte[] schemaManage_updateSeq(Map<String, String> params) {
        String bizTag = params.get("bizTag");
        String clickPublishSchemaUpIcon = params.get("clickPublishSchemaUpIcon");
        String arrAllSchema = params.get("arrAllSchema");
        List<SchemaAttrVO> schemaAttrVOList = ((SchemaAttrVOList)JsonUtil.decodeFromString((String)params.get("schemaList"), SchemaAttrVOList.class)).getSchemaAttrVOList();
        try {
            String schemaId;
            List<SchemaAttrVO> arrAllSchemaList;
            boolean isSetDefaultSchema;
            if (arrAllSchema != null && !(isSetDefaultSchema = this.judgePublisherSetDefaultSchema(arrAllSchemaList = ((SchemaAttrVOList)JsonUtil.decodeFromString((String)arrAllSchema, SchemaAttrVOList.class)).getSchemaAttrVOList())) && "true".equals(clickPublishSchemaUpIcon) && (schemaId = this.judgeSchemaContainMaxSeq(schemaAttrVOList, arrAllSchemaList.size())) != null) {
                this.getSchemaDomain().updatePublishInfoByBiztag(bizTag, this.context.getUserId(), schemaAttrVOList.get(0).getfId());
            }
            this.getSchemaDomain().updateSeq(schemaAttrVOList);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)true);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    private String judgeSchemaContainMaxSeq(List<SchemaAttrVO> schemaAttrVOList, int length) {
        for (SchemaAttrVO schemaAttrVO : schemaAttrVOList) {
            if (schemaAttrVO.getSeq() != length - 1) continue;
            return schemaAttrVO.getfId();
        }
        return null;
    }

    private boolean judgePublisherSetDefaultSchema(List<?> schemaList) {
        for (int i = 0; i < schemaList.size(); ++i) {
            SchemaBO SchemaBO2;
            SchemaAttrVO schemaAttrVO;
            if (!(schemaList.get(i) instanceof SchemaAttrVO ? (schemaAttrVO = (SchemaAttrVO)schemaList.get(i)).IsDefault() != false : schemaList.get(i) instanceof SchemaBO && (SchemaBO2 = (SchemaBO)schemaList.get(i)).IsDefault() != false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[] judgePublishOper(Map<String, String> params) {
        try {
            String publishId = params.get("publishId");
            String dsbPublishId = params.get("dsbPublishId");
            String isEdit = params.get("isEdit");
            this.getSchemaDomain().judgePublishOper(publishId, dsbPublishId, isEdit);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)true);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    public byte[] judgeSchemaIsDel(Map<String, String> params) {
        try {
            String schemaId = params.get("schemaId");
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)this.getSchemaDomain().judgeSchemaIsDel(schemaId));
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    public byte[] loadAllPublishSchemaAttrByBizTag(Map<String, String> params) {
        String bizTag = params.get("bizTag");
        String sSource = params.get("source");
        int source = 0;
        if (sSource != null) {
            source = Integer.parseInt(sSource);
        }
        String userId = "SystemUser";
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(this.getSchemaDomain().loadAllPublishSchemaAttrByBizTag(bizTag, userId, source));
            this.interestInBehavior((AbstractResponseWrap)wrap, 0L, null);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    public byte[] checkPublishInfoAndAuthority(Map<String, String> params) {
        String bizTag = params.get("bizTag");
        String modelJsonString = params.get("model");
        String userId = this.context.getUserId();
        try {
            Map<String, String> checkResult = this.getSchemaDomain().checkPublishInfoAndPermission(bizTag, modelJsonString, userId);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(checkResult);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Override
    public byte[] getDefaultSchemaFid(Map<String, String> params) {
        String bizTag = params.get("bizTag");
        int source = 0;
        String sSource = params.get("source");
        if (sSource != null) {
            source = Integer.parseInt(sSource);
        }
        String userId = this.context.getUserId();
        try {
            String schemaFid = this.getSchemaDomain().getDefaultSchemaFid(bizTag, source, userId);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)schemaFid);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }
}

