/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schema.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ExtReportSchemaManageDao {
    private static final int BLOB_SIZE = 32768;
    private IDBExcuter dbExcuter;
    private PublishInfoDao publishInfoDao;

    public ExtReportSchemaManageDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    public Map<String, String> loadExtRptDefaultSchemaInfo(String extreportID) throws AbstractQingIntegratedException, SQLException {
        String loadExtRptDefaultSchemaSql = "SELECT R.FSCHEMEID, S.FNAME FROM T_QING_EXTRPT_SC_REL R  LEFT JOIN T_QING_EXTRPT_SCHEME S ON S.FID = R.FSCHEMEID WHERE R.FREPORTID = ? ";
        return (Map)this.dbExcuter.query(loadExtRptDefaultSchemaSql, new Object[]{extreportID}, (ResultHandler)new ResultHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> defaultSchemaInfoMap = new HashMap<String, String>(3);
                if (rs.next()) {
                    defaultSchemaInfoMap.put("defaultSchemaId", rs.getString("FSCHEMEID"));
                    defaultSchemaInfoMap.put("defaultSchemaName", rs.getString("FNAME"));
                }
                return defaultSchemaInfoMap;
            }
        });
    }

    public String saveExtReportSchemaInfo(String publishId, String schemaName, String userID) throws AbstractQingIntegratedException, SQLException {
        String insertExtreportDefaultSchemaInfoSql = "INSERT INTO T_QING_EXTRPT_SCHEME(FID, FCREATORID, FCREATEDATE, FUPDATERID, FMODIFYDATE, FREPORTID, FNAME, FSHARESTRATEGY, FOWNERID) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String newSchemaId = this.dbExcuter.genStringId("T_QING_EXTRPT_SCHEME");
        Date createTime = new Date();
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(newSchemaId);
        params.add(userID);
        params.add(createTime);
        params.add(userID);
        params.add(createTime);
        params.add(publishId);
        params.add(schemaName);
        params.add("0");
        params.add(userID);
        this.dbExcuter.execute(insertExtreportDefaultSchemaInfoSql, params.toArray());
        return newSchemaId;
    }

    public void saveExtReportDefaultSchemaConfig(String publishId, String schemaId, String userID) throws AbstractQingIntegratedException, SQLException {
        String insertExtRptDefaultSchemaRelSql = "INSERT INTO T_QING_EXTRPT_SC_REL (FID, FREPORTID, FUSERID, FSCHEMEID) VALUES(?, ?, ?, ?)";
        String schemaRelId = this.dbExcuter.genStringId("T_QING_EXTRPT_SC_REL");
        this.dbExcuter.execute(insertExtRptDefaultSchemaRelSql, new Object[]{schemaRelId, publishId, userID, schemaId});
    }

    public void saveExtReportDefaultSchemaContent(String defaultSchemaId, String newSchemaId) throws AbstractQingIntegratedException, SQLException {
        String loadExtRptDefaultSchemaContentSql = "SELECT FCONTENT, FCONTENTINDEX FROM T_QING_EXTRPT_SC_CONT WHERE FSCHEMEID = ? ORDER BY FCONTENTINDEX ASC ";
        byte[] defaultSchemaContent = this.readBlock(loadExtRptDefaultSchemaContentSql, defaultSchemaId);
        if (defaultSchemaContent != null) {
            String insertExtRptDefaultSchemaContentSql = "INSERT INTO T_QING_EXTRPT_SC_CONT (FID, FSCHEMEID, FCONTENTINDEX, FCONTENT) VALUES(?,?,?,?)";
            this.writeBlockWithPrimaryKey(insertExtRptDefaultSchemaContentSql, newSchemaId, defaultSchemaContent);
        }
    }

    public void clearExtRptSchemaInfos(String publishId) throws AbstractQingIntegratedException, SQLException {
        String deleteExtRptDefaultSchemaConfigSql = "DELETE FROM T_QING_EXTRPT_SC_REL WHERE FREPORTID = ?";
        this.dbExcuter.execute(deleteExtRptDefaultSchemaConfigSql, new Object[]{publishId});
        List<String> deletePublishSchemaIdList = this.loadExtRptSchemaIds(publishId);
        String deleteExtRptSchemaInfoSql = "DELETE FROM T_QING_EXTRPT_SCHEME WHERE FREPORTID = ?";
        this.dbExcuter.execute(deleteExtRptSchemaInfoSql, new Object[]{publishId});
        if (deletePublishSchemaIdList != null && deletePublishSchemaIdList.size() > 0) {
            StringBuilder deletePublishSchemaContentSql = new StringBuilder("DELETE FROM T_QING_EXTRPT_SC_CONT WHERE FSCHEMEID IN (");
            Object[] params = new Object[deletePublishSchemaIdList.size()];
            for (int i = 0; i < deletePublishSchemaIdList.size(); ++i) {
                params[i] = deletePublishSchemaIdList.get(i);
                deletePublishSchemaContentSql.append(i != deletePublishSchemaIdList.size() - 1 ? "?, " : "?)");
            }
            this.dbExcuter.execute(deletePublishSchemaContentSql.toString(), params);
        }
    }

    public Map<String, String> loadExtreportPathById(String extreportId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT G.fname AS GROUPNAME, I.fname AS EXTREPORTNAME FROM T_QING_EXTRPT_INFO I left join T_QING_EXTRPT_GROUP G ON I.fgroupid = G.fid WHERE I.fid = ?";
        return (Map)this.dbExcuter.query("SELECT G.fname AS GROUPNAME, I.fname AS EXTREPORTNAME FROM T_QING_EXTRPT_INFO I left join T_QING_EXTRPT_GROUP G ON I.fgroupid = G.fid WHERE I.fid = ?", new Object[]{extreportId}, (ResultHandler)new ResultHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> pathMap = new HashMap<String, String>(3);
                while (rs.next()) {
                    pathMap.put("groupName", rs.getString("GROUPNAME"));
                    pathMap.put("extreportName", rs.getString("EXTREPORTNAME"));
                }
                return pathMap;
            }
        });
    }

    private List<String> loadExtRptSchemaIds(String extreportID) throws AbstractQingIntegratedException, SQLException {
        String loadExtRptDefaultSchemaSql = "SELECT FID FROM T_QING_EXTRPT_SCHEME WHERE FREPORTID = ? ";
        return (List)this.dbExcuter.query(loadExtRptDefaultSchemaSql, new Object[]{extreportID}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> schemaIdList = new ArrayList<String>(10);
                while (rs.next()) {
                    schemaIdList.add(rs.getString("FID"));
                }
                return schemaIdList;
            }
        });
    }

    private byte[] readBlock(String sql, String fId) throws AbstractQingIntegratedException, SQLException {
        return (byte[])this.dbExcuter.query(sql, new Object[]{fId}, (ResultHandler)new ResultHandler<byte[]>(){

            public byte[] handle(ResultSet rs) throws SQLException {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                int iCurrentIdx = 0;
                while (rs.next()) {
                    try {
                        if (iCurrentIdx > rs.getInt("FCONTENTINDEX")) continue;
                        os.write(rs.getBytes("FCONTENT"));
                        ++iCurrentIdx;
                    }
                    catch (IOException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                }
                return os.toByteArray();
            }
        });
    }

    private void writeBlockWithPrimaryKey(String blockSql, String fSchemaId, byte[] blockData) throws AbstractQingIntegratedException, SQLException {
        Integer length = blockData.length;
        if (length > 0) {
            int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
            int contentSize = 0;
            int offset = 0;
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (int i = 0; i < count; ++i) {
                contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                int index = 0;
                Object[] param = new Object[4];
                param[index++] = UUID.randomUUID().toString();
                param[index++] = fSchemaId;
                param[index++] = i;
                param[index++] = this.dbExcuter.createSqlParameterBytes(blockData, offset, contentSize);
                offset += contentSize;
                params.add(param);
            }
            this.dbExcuter.executeBatch(blockSql, params);
        }
    }

    public boolean isFromExtReport(String refToId) {
        boolean isFromQingReport = false;
        try {
            PublishPO publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(refToId);
            if (publishPO != null) {
                if (PublishSourceEnum.extreport == publishPO.getPublishSourceType()) {
                    isFromQingReport = true;
                }
            } else if (this.isExtReport(refToId)) {
                isFromQingReport = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isFromQingReport;
    }

    private boolean isExtReport(String extreportID) throws SQLException, AbstractQingIntegratedException {
        String sql = "SELECT FID FROM T_QING_EXTRPT_INFO WHERE FID=?";
        return (Boolean)this.dbExcuter.query(sql, new Object[]{extreportID}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }
}

