/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schema.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.schema.model.SchemaAttrVO;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.schema.model.SchemaContentBO;
import com.kingdee.bos.qing.schema.model.SchemaModel;
import com.kingdee.bos.qing.schema.model.SchemaRefType;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.ModelBookUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.jdom2.JDOMException;

public class SchemaManageDao {
    private static final int BLOB_SIZE = 32768;
    private IDBExcuter dbExcuter;

    public SchemaManageDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public SchemaBO findSchemaById(String fId) throws AbstractQingIntegratedException, SQLException {
        return (SchemaBO)this.dbExcuter.query("SELECT FID,FSCHEMANAME,FBIZTAG,FSCHEMATYPE,FSOURCE FROM T_QING_SASchema where FID=?", new Object[]{fId}, (ResultHandler)new ResultHandler<SchemaBO>(){

            public SchemaBO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    SchemaBO bo = new SchemaBO();
                    bo.setfId(rs.getString("FID"));
                    bo.setSchemaName(rs.getString("FSCHEMANAME"));
                    bo.setBizTag(rs.getString("FBIZTAG"));
                    bo.setSchemaType(Integer.parseInt(rs.getString("FSCHEMATYPE")));
                    bo.setSource(rs.getInt("FSOURCE"));
                    return bo;
                }
                return null;
            }
        });
    }

    public boolean checkUserRelation(String fId, String userId) throws AbstractQingIntegratedException, SQLException {
        return (Boolean)this.dbExcuter.query("SELECT FSCHEMAID FROM T_QING_SARelation WHERE FSCHEMAID=? AND FUSERID=?", new Object[]{fId, userId}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    public void insertSchemaList(List<SchemaModel> schemaModelList) throws AbstractQingIntegratedException, SQLException {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(schemaModelList.size());
        for (int i = 0; i < schemaModelList.size(); ++i) {
            SchemaBO bo = schemaModelList.get(i).getSchemaBO();
            Date nowDate = new Date();
            Object[] params = new Object[8];
            int j = 0;
            params[j++] = bo.getfId();
            params[j++] = bo.getSchemaName();
            params[j++] = bo.getBizTag();
            params[j++] = "" + bo.getSource();
            params[j++] = "" + bo.getSchemaType();
            params[j++] = new Timestamp(nowDate.getTime());
            params[j++] = new Timestamp(nowDate.getTime());
            params[j++] = bo.getSeq();
            paramList.add(params);
        }
        this.dbExcuter.executeBatch("INSERT INTO T_QING_SASchema (FID, FSCHEMANAME,FBIZTAG,FSOURCE,FSCHEMATYPE,FCREATETIME,FLASTUPDATETIME,FSEQ) VALUES(?,?,?,?,?,?,?,?)", paramList);
        this.insertSchemaContentList(schemaModelList);
    }

    public void insertSchemaContentList(List<SchemaModel> schemaModelList) throws AbstractQingIntegratedException, SQLException {
        String contentSql = "INSERT INTO T_QING_SAContent (FID,FSCHEMAID,FCONTENTINDEX,FCONTENT) VALUES(?,?,?,?)";
        this.writeListBlock(contentSql, schemaModelList);
    }

    public void writeListBlock(String contentSql, List<SchemaModel> schemaModelList) throws AbstractQingIntegratedException, SQLException {
        ArrayList<Object[]> params = new ArrayList<Object[]>(20);
        for (SchemaModel schemaModel : schemaModelList) {
            String fId = schemaModel.getSchemaBO().getfId();
            byte[] schemaData = schemaModel.getSchemaContent();
            int length = schemaData.length;
            if (length <= 0) continue;
            int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
            int contentSize = 0;
            int offset = 0;
            for (int i = 0; i < count; ++i) {
                contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                int index = 0;
                Object[] param = new Object[4];
                param[index++] = UUID.randomUUID().toString();
                param[index++] = fId;
                param[index++] = i;
                param[index++] = this.dbExcuter.createSqlParameterBytes(schemaData, offset, contentSize);
                offset += contentSize;
                params.add(param);
            }
        }
        this.dbExcuter.executeBatch(contentSql, params);
    }

    public void insertSchema(SchemaBO bo, byte[] fContent) throws AbstractQingIntegratedException, SQLException {
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add("INSERT INTO T_QING_SASchema (FID, FSCHEMANAME,FBIZTAG,FSOURCE,FSCHEMATYPE,FCREATETIME,FLASTUPDATETIME,FSEQ) VALUES(?,?,?,?,?,?,?,?)");
        Date nowDate = new Date();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] params = new Object[8];
        int i = 0;
        params[i++] = bo.getfId();
        params[i++] = bo.getSchemaName();
        params[i++] = bo.getBizTag();
        params[i++] = "" + bo.getSource();
        params[i++] = "" + bo.getSchemaType();
        params[i++] = new Timestamp(nowDate.getTime());
        params[i++] = new Timestamp(nowDate.getTime());
        params[i++] = bo.getSeq();
        paramList.add(params);
        this.excuteBatch(sqls, paramList);
        this.insertSchemaContent(bo.getfId(), fContent);
    }

    public void deletePublishSchemaInfoById(List<String> deletePublishSchemaIdList) throws AbstractQingIntegratedException, SQLException {
        ArrayList<String> sqls = new ArrayList<String>(3);
        ArrayList<Object[]> params = new ArrayList<Object[]>(3);
        Object[] param = new Object[deletePublishSchemaIdList.size()];
        StringBuilder clearPublishSchemaRelation = new StringBuilder("DELETE FROM T_QING_SARelation WHERE FSCHEMAID IN ( ");
        StringBuilder clearPublishSchemaContent = new StringBuilder("DELETE FROM T_QING_SAContent WHERE FSCHEMAID IN ( ");
        StringBuilder ClearPublishSchemaAttr = new StringBuilder("DELETE FROM T_QING_SASchema WHERE FID IN ( ");
        for (int i = 0; i < deletePublishSchemaIdList.size(); ++i) {
            param[i] = deletePublishSchemaIdList.get(i);
            clearPublishSchemaRelation.append(i != deletePublishSchemaIdList.size() - 1 ? "?, " : "?)");
            clearPublishSchemaContent.append(i != deletePublishSchemaIdList.size() - 1 ? "?, " : "?)");
            ClearPublishSchemaAttr.append(i != deletePublishSchemaIdList.size() - 1 ? "?, " : "?)");
        }
        params.add(param);
        params.add(param);
        params.add(param);
        sqls.add(clearPublishSchemaRelation.toString());
        sqls.add(clearPublishSchemaContent.toString());
        sqls.add(ClearPublishSchemaAttr.toString());
        this.deletePublishSchemaRefById(deletePublishSchemaIdList);
        this.excuteBatch(sqls, params);
    }

    public void deletePublishSchemaRefById(List<String> deletePublishSchemaIdList) throws AbstractQingIntegratedException, SQLException {
        StringBuilder deletePublishSchemaRef = new StringBuilder("DELETE FROM T_QING_Schema_Ref WHERE FSCHEMAID IN ( ");
        Object[] params = new Object[deletePublishSchemaIdList.size()];
        for (int i = 0; i < deletePublishSchemaIdList.size(); ++i) {
            params[i] = deletePublishSchemaIdList.get(i);
            deletePublishSchemaRef.append(i != deletePublishSchemaIdList.size() - 1 ? "?, " : "?)");
        }
        this.dbExcuter.execute(deletePublishSchemaRef.toString(), params);
    }

    public void updateSchemaAttrList(List<SchemaAttrVO> updatePublishSchemaList) throws AbstractQingIntegratedException, SQLException {
        String sqlUpdatePublishName = "update t_qing_saschema SET FSCHEMANAME=? WHERE FID = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(updatePublishSchemaList.size());
        for (int i = 0; i < updatePublishSchemaList.size(); ++i) {
            SchemaAttrVO schemaAttrVO = updatePublishSchemaList.get(i);
            Object[] params = new Object[]{schemaAttrVO.getSchemaName(), schemaAttrVO.getfId()};
            paramsList.add(params);
        }
        this.dbExcuter.executeBatch(sqlUpdatePublishName, paramsList);
    }

    public void updateSchemaRelation(String DefaultSchemaId, String defaultState, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "update t_qing_sarelation set fisdefault = ? where fschemaid = ? and fuserid = ?";
        Object[] params = new Object[]{defaultState, DefaultSchemaId, userId};
        this.dbExcuter.execute(sql, params);
    }

    public void updateSchemaBo(SchemaBO bo) throws AbstractQingIntegratedException, SQLException {
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add("UPDATE T_QING_SASchema SET FSCHEMANAME = ? , FBIZTAG = ?, FSOURCE = ?, FSCHEMATYPE = ?, FLASTUPDATETIME = ?, FSEQ = ? WHERE FID = ?");
        Date nowDate = new Date();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] params = new Object[7];
        int i = 0;
        params[i++] = bo.getSchemaName();
        params[i++] = bo.getBizTag();
        params[i++] = "" + bo.getSource();
        params[i++] = "" + bo.getSchemaType();
        params[i++] = new Timestamp(nowDate.getTime());
        params[i++] = bo.getSeq();
        params[i++] = bo.getfId();
        paramList.add(params);
        this.excuteBatch(sqls, paramList);
    }

    public void insertSchemaContent(String schemaId, byte[] fContent) throws AbstractQingIntegratedException, SQLException {
        String contentSql = "INSERT INTO T_QING_SAContent (FID,FSCHEMAID,FCONTENTINDEX,FCONTENT) VALUES(?,?,?,?)";
        this.writeBlock(contentSql, schemaId, fContent);
    }

    public void insertSchemaContentAndRef(String schemaId, ModelBook modelBook) throws AbstractQingIntegratedException, SQLException {
        String contentSql = "INSERT INTO T_QING_SAContent (FID,FSCHEMAID,FCONTENTINDEX,FCONTENT) VALUES(?,?,?,?)";
        byte[] fContent = ModelBookUtil.toByte(modelBook);
        this.writeBlock(contentSql, schemaId, fContent);
        List outsideRefList = modelBook.pickReferences();
        for (int i = 0; i < outsideRefList.size(); ++i) {
            OutsideReference outsideRef = (OutsideReference)outsideRefList.get(i);
            this.saveSchemaRef(outsideRef, schemaId);
        }
    }

    public void insertSchemaRelation(SchemaBO bo) throws AbstractQingIntegratedException, SQLException {
        String relationSql = "INSERT INTO T_QING_SARelation (FID, FSCHEMAID, FUSERID, FISDEFAULT) VALUES(?,?,?,?)";
        int index = 0;
        Object[] reParams = new Object[4];
        reParams[index++] = UUID.randomUUID().toString();
        reParams[index++] = bo.getfId();
        reParams[index++] = bo.getUserId();
        reParams[index++] = bo.IsDefault() != false ? 1 : 0;
        this.dbExcuter.execute(relationSql, reParams);
    }

    public String genSchemaId() {
        return this.dbExcuter.genStringId("T_QING_SASchema");
    }

    public void deleteSchema(String fId, String userId) throws AbstractQingIntegratedException, SQLException {
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add("DELETE FROM T_QING_SASchema WHERE FID=?");
        sqls.add("DELETE FROM T_QING_SARelation WHERE FSCHEMAID=? AND FUSERID=?");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{fId});
        params.add(new Object[]{fId, userId});
        this.excuteBatch(sqls, params);
        this.deleteSchemaContent(fId);
        this.deleteSchemaRef(fId);
    }

    public void deleteSchemaContent(String fId) throws AbstractQingIntegratedException, SQLException {
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add("DELETE FROM T_QING_SAContent WHERE FSCHEMAID=?");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{fId});
        this.excuteBatch(sqls, params);
    }

    public void deleteSchemaContentAndRef(String fId) throws AbstractQingIntegratedException, SQLException {
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add("DELETE FROM T_QING_SAContent WHERE FSCHEMAID=?");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{fId});
        this.excuteBatch(sqls, params);
        this.deleteSchemaRef(fId);
    }

    public void deleteSchemaByBizTag(String bizTag) throws AbstractQingIntegratedException, SQLException {
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add("DELETE FROM T_QING_SARelation WHERE FSCHEMAID IN (SELECT FID FROM T_QING_SASCHEMA WHERE FBIZTAG = ?)");
        sqls.add("DELETE FROM T_QING_SAContent WHERE FSCHEMAID IN (SELECT FID FROM T_QING_SASCHEMA WHERE FBIZTAG = ?)");
        sqls.add("DELETE FROM T_QING_SASchema WHERE FBIZTAG=?");
        this.deleteSchemaRefByBizTag(bizTag);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{bizTag});
        params.add(new Object[]{bizTag});
        params.add(new Object[]{bizTag});
        this.excuteBatch(sqls, params);
    }

    public void deleteSchemaRefByBizTag(String bizTag) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_Schema_Ref WHERE FSCHEMAID IN (SELECT FID FROM T_QING_SASCHEMA WHERE FBIZTAG = ?)", new Object[]{bizTag});
    }

    public ArrayList<SchemaBO> loadSchemaAttrs(String bizTag, String userId, int source) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT DISTINCT T_QING_SASchema.FID,FSCHEMANAME,FBIZTAG,FSCHEMATYPE,FCREATETIME,FLASTUPDATETIME,FUSERID,FISDEFAULT,FSOURCE,FSEQ  FROM T_QING_SASchema  LEFT JOIN T_QING_SARelation ON T_QING_SASchema.FID = T_QING_SARelation.FSCHEMAID and (FUSERID = ? or FUSERID = ?) where FBIZTAG = ? and (FUSERID = ? or FUSERID = ? or (FUSERID is null and fschematype = '2')) and FSOURCE = ? ORDER BY FSEQ DESC, FSCHEMATYPE DESC , FCREATETIME DESC";
        Object[] params = new Object[]{userId, IntegratedHelper.getPresetUserId(), bizTag, userId, IntegratedHelper.getPresetUserId(), "" + source};
        return (ArrayList)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<ArrayList<SchemaBO>>(){

            public ArrayList<SchemaBO> handle(ResultSet rs) throws SQLException {
                ArrayList<SchemaBO> boList = new ArrayList<SchemaBO>();
                while (rs.next()) {
                    SchemaBO bo = new SchemaBO();
                    bo.setfId(rs.getString("FID"));
                    bo.setBizTag(rs.getString("FBIZTAG"));
                    bo.setSchemaName(rs.getString("FSCHEMANAME"));
                    bo.setSchemaType(Integer.parseInt(rs.getString("FSCHEMATYPE")));
                    bo.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    bo.setLastUpdateTime(rs.getTimestamp("FLASTUPDATETIME"));
                    bo.setSource(rs.getInt("FSOURCE"));
                    bo.setSeq(rs.getInt("FSEQ"));
                    if (rs.getString("FISDEFAULT") == null) {
                        bo.setIsDefault(false);
                    } else {
                        bo.setIsDefault(!"0".equals(rs.getString("FISDEFAULT")));
                    }
                    boList.add(bo);
                }
                return boList;
            }
        });
    }

    public List<SchemaBO> loadAllPublishSchemaAttrByBizTag(String bizTag, String userId, int source) throws AbstractQingIntegratedException, SQLException {
        List<SchemaBO> schemaByBiztagList = this.findSchemaByBiztag(bizTag, userId, source);
        return schemaByBiztagList;
    }

    public List<SchemaBO> findSchemaByBiztag(String bizTag, String userId, int source) throws AbstractQingIntegratedException, SQLException {
        String sql = "select t_qing_saschema.fid,fschemaname,fbiztag,fschematype,fsource,fseq,fuserid,fisdefault from t_qing_saschema left join t_qing_sarelation on t_qing_saschema.fid = t_qing_sarelation.fschemaid and fuserid = ? where fbiztag = ? and fsource = ? and fschematype = '2' ORDER BY FSEQ DESC , FSCHEMATYPE DESC , FCREATETIME DESC";
        Object[] params = new Object[]{userId, bizTag, "" + source};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<ArrayList<SchemaBO>>(){

            public ArrayList<SchemaBO> handle(ResultSet rs) throws SQLException {
                ArrayList<SchemaBO> boList = new ArrayList<SchemaBO>();
                while (rs.next()) {
                    SchemaBO bo = new SchemaBO();
                    bo.setfId(rs.getString("fid"));
                    bo.setSchemaName(rs.getString("fschemaname"));
                    bo.setSchemaType(rs.getInt("fschematype"));
                    bo.setSource(rs.getInt("fsource"));
                    bo.setBizTag(rs.getString("fbiztag"));
                    bo.setUserId(rs.getString("fuserid"));
                    if (rs.getString("fisdefault") == null) {
                        bo.setIsDefault(false);
                    } else {
                        bo.setIsDefault(!"0".equals(rs.getString("fisdefault")));
                    }
                    bo.setSeq(rs.getInt("fseq"));
                    boList.add(bo);
                }
                return boList;
            }
        });
    }

    public SchemaBO findDefaultSchemaInPublish(String bizTag, String userId, int source) throws AbstractQingIntegratedException, SQLException {
        String sql = "select t_qing_saschema.fid,fschemaname,fbiztag,fschematype,fsource,fseq,fuserid,fisdefault from t_qing_saschema left join t_qing_sarelation on t_qing_saschema.fid = t_qing_sarelation.fschemaid and fuserid = ? where fbiztag = ? and fsource = ? and fschematype = '2' and fisdefault = '1'";
        Object[] params = new Object[]{userId, bizTag, "" + source};
        return (SchemaBO)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<SchemaBO>(){

            public SchemaBO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    SchemaBO bo = new SchemaBO();
                    bo.setfId(rs.getString("fid"));
                    bo.setSchemaName(rs.getString("fschemaname"));
                    bo.setSchemaType(rs.getInt("fschematype"));
                    bo.setSource(rs.getInt("fsource"));
                    bo.setBizTag(rs.getString("fbiztag"));
                    bo.setUserId(rs.getString("fuserid"));
                    if (rs.getString("fisdefault") == null) {
                        bo.setIsDefault(false);
                    } else {
                        bo.setIsDefault(!"0".equals(rs.getString("fisdefault")));
                    }
                    bo.setSeq(rs.getInt("fseq"));
                    return bo;
                }
                return null;
            }
        });
    }

    public List<SchemaContentBO> getSchemaContent(String fid) throws SQLException, AbstractQingIntegratedException {
        String sql = "SELECT FID, FSCHEMAID, FCONTENTINDEX, FCONTENT FROM T_QING_SAContent WHERE FSCHEMAID=? ORDER BY FCONTENTINDEX ASC";
        Object[] params = new Object[]{fid};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<SchemaContentBO>>(){

            public List<SchemaContentBO> handle(ResultSet rs) throws SQLException {
                ArrayList<SchemaContentBO> boList = new ArrayList<SchemaContentBO>(10);
                while (rs.next()) {
                    SchemaContentBO bo = new SchemaContentBO();
                    String fID = rs.getString("FID");
                    bo.setFid(fID);
                    String fSchemaId = rs.getString("FSCHEMAID");
                    bo.setSchemaId(fSchemaId);
                    int index = rs.getInt("FCONTENTINDEX");
                    bo.setContentIndex(index);
                    byte[] fContent = rs.getBytes("FCONTENT");
                    bo.setContent(fContent);
                    boList.add(bo);
                }
                return boList;
            }
        });
    }

    public byte[] loadSchemaContent(String fId) throws AbstractQingIntegratedException, SQLException {
        return this.readBlock("SELECT FID, FSCHEMAID, FCONTENTINDEX, FCONTENT FROM T_QING_SAContent WHERE FSCHEMAID=? ORDER BY FCONTENTINDEX ASC", fId);
    }

    public ModelBook loadSchemaModelBook(String fId) throws AbstractQingIntegratedException, SQLException, PersistentModelParseException, PersistentModelTooModernException, JDOMException, IOException {
        byte[] schemaContent = this.readBlock("SELECT FID, FSCHEMAID, FCONTENTINDEX, FCONTENT FROM T_QING_SAContent WHERE FSCHEMAID=? ORDER BY FCONTENTINDEX ASC", fId);
        List<OutsideReference> refList = this.loadSchemaRef(fId);
        ModelBook modelBook = ModelBookUtil.fromByte(schemaContent);
        if (refList != null && refList.size() > 0) {
            modelBook.fixReferences(refList);
        }
        return modelBook;
    }

    public Boolean isNameExist(String schemaName, String bizTag, String userId, int source, int schemaType) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FSCHEMANAME from T_QING_SASchema  LEFT JOIN T_QING_SARelation ON T_QING_SASchema.FID = T_QING_SARelation.FSCHEMAID  where FSCHEMANAME=? and FBIZTAG = ?  and (FUSERID = ? or FUSERID is null) and FSOURCE = ? and fschematype = ?";
        Object[] params = new Object[]{schemaName, bizTag, userId, "" + source, "" + schemaType};
        return (Boolean)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    String name = rs.getString("FSCHEMANAME");
                    return name != null && name.length() != 0;
                }
                return false;
            }
        });
    }

    public String getDefaultPlanFidByUserId(String bizTag, String userId, int source, boolean isPublishPerson) throws AbstractQingIntegratedException, SQLException {
        String sql = isPublishPerson ? "select t_qing_saschema.fid from t_qing_saschema left join t_qing_sarelation on t_qing_saschema.fid = t_qing_sarelation.fschemaid where fisdefault = '1' and fbiztag = ? and fuserid = ? and fschematype = '2' and fsource = ?" : "SELECT T_QING_SASchema.FID FROM T_QING_SASchema LEFT JOIN T_QING_SARelation ON T_QING_SASchema.FID = T_QING_SARelation.FSCHEMAID where fisdefault = '1' and FBIZTAG = ? and FUSERID = ? and (FSCHEMATYPE ='2' or FSCHEMATYPE ='1') and FSOURCE = ?";
        Object[] params = new Object[]{bizTag, userId, Integer.toString(source)};
        return (String)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    String fid = rs.getString("fid");
                    return fid;
                }
                return null;
            }
        });
    }

    public String getDefaultUserSchemaId(String bizTag, String userId, int source) throws AbstractQingIntegratedException, SQLException {
        List<String> fIds;
        String sql = "SELECT T_QING_SASchema.FID from T_QING_SASchema  LEFT JOIN T_QING_SARelation ON T_QING_SASchema.FID = T_QING_SARelation.FSCHEMAID  where FISDEFAULT ='1' and FBIZTAG = ? and (FUSERID = ? or FUSERID = ?) and FSOURCE = ?";
        Object[] params = new Object[]{bizTag, IntegratedHelper.getPresetUserId(), userId, "" + source};
        String fid = (String)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("FID");
                }
                return null;
            }
        });
        if (fid == null && (fIds = this.getSystemSchemaIds(bizTag, source)) != null && !fIds.isEmpty()) {
            fid = fIds.get(0);
        }
        return fid;
    }

    public void updateSchema(String fId, byte[] fContent) throws AbstractQingIntegratedException, SQLException {
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add("DELETE FROM T_QING_SAContent WHERE FSCHEMAID=?");
        sqls.add("UPDATE T_QING_SASchema SET FLASTUPDATETIME =? WHERE FID= ?");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Object[] param1 = new Object[]{fId};
        Object[] param2 = new Object[]{new Timestamp(new Date().getTime()), fId};
        params.add(param1);
        params.add(param2);
        this.excuteBatch(sqls, params);
        this.insertSchemaContent(fId, fContent);
    }

    public ArrayList<SchemaBO> getSchemaByBiztag(String fbizTag, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT T_QING_SASchema.FID,FSCHEMANAME,FBIZTAG,FUSERID,FSCHEMATYPE,FSOURCE,FISDEFAULT,FSEQ  FROM T_QING_SASchema  LEFT JOIN T_QING_SARelation ON T_QING_SASchema.FID = T_QING_SARelation.FSCHEMAID  WHERE FBIZTAG = ? AND (FUSERID = ? or FUSERID = ?) ORDER BY T_QING_SASchema.FSCHEMATYPE ASC , T_QING_SASchema.FCREATETIME ASC";
        Object[] params = new Object[]{fbizTag, userId, IntegratedHelper.getPresetUserId()};
        return (ArrayList)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<ArrayList<SchemaBO>>(){

            public ArrayList<SchemaBO> handle(ResultSet rs) throws SQLException {
                ArrayList<SchemaBO> boList = new ArrayList<SchemaBO>();
                while (rs.next()) {
                    SchemaBO bo = new SchemaBO();
                    bo.setfId(rs.getString("FID"));
                    bo.setSchemaName(rs.getString("FSCHEMANAME"));
                    bo.setSchemaType(Integer.parseInt(rs.getString("FSCHEMATYPE")));
                    bo.setSource(rs.getInt("FSOURCE"));
                    if (rs.getString("FISDEFAULT") == null) {
                        bo.setIsDefault(false);
                    } else {
                        bo.setIsDefault(!"0".equals(rs.getString("FISDEFAULT")));
                    }
                    bo.setSeq(rs.getInt("FSEQ"));
                    boList.add(bo);
                }
                return boList;
            }
        });
    }

    public ArrayList<SchemaBO> loadSchemaAttrs(String bizTag, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT DISTINCT T_QING_SASchema.FID,FSCHEMANAME,FBIZTAG,FSCHEMATYPE,FCREATETIME,FLASTUPDATETIME,FUSERID,FISDEFAULT,FSOURCE,FSEQ  FROM T_QING_SASchema  LEFT JOIN T_QING_SARelation ON T_QING_SASchema.FID = T_QING_SARelation.FSCHEMAID and FUSERID = ? where FBIZTAG = ? and (FUSERID = ? or FUSERID = ? or (FSCHEMATYPE ='2' and FUSERID IS null )) ORDER BY FSEQ DESC, FSCHEMATYPE DESC , FCREATETIME DESC";
        Object[] params = new Object[]{userId, bizTag, userId, IntegratedHelper.getPresetUserId()};
        return (ArrayList)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<ArrayList<SchemaBO>>(){

            public ArrayList<SchemaBO> handle(ResultSet rs) throws SQLException {
                ArrayList<SchemaBO> boList = new ArrayList<SchemaBO>();
                while (rs.next()) {
                    SchemaBO bo = new SchemaBO();
                    bo.setfId(rs.getString("FID"));
                    bo.setBizTag(rs.getString("FBIZTAG"));
                    bo.setSchemaName(rs.getString("FSCHEMANAME"));
                    bo.setSchemaType(Integer.parseInt(rs.getString("FSCHEMATYPE")));
                    bo.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    bo.setLastUpdateTime(rs.getTimestamp("FLASTUPDATETIME"));
                    bo.setSource(rs.getInt("FSOURCE"));
                    bo.setSeq(rs.getInt("FSEQ"));
                    if (rs.getString("FISDEFAULT") == null) {
                        bo.setIsDefault(false);
                    } else {
                        bo.setIsDefault(!"0".equals(rs.getString("FISDEFAULT")));
                    }
                    boList.add(bo);
                }
                return boList;
            }
        });
    }

    public void saveSchemaAndContent(String userId, String bizTag, String schemaName, int schemaType, byte[] content, boolean isDefault) throws AbstractQingIntegratedException, SQLException {
        int source = schemaType;
        SchemaBO bo = new SchemaBO();
        bo.setfId(this.dbExcuter.genStringId("T_QING_SASchema"));
        bo.setSchemaName(schemaName);
        bo.setSchemaType(1);
        bo.setIsDefault(isDefault);
        bo.setUserId(userId);
        bo.setBizTag(bizTag);
        bo.setSource(source);
        while (this.isNameExist(schemaName, bizTag, userId, source, bo.getSchemaType()).booleanValue()) {
            if (schemaName.lastIndexOf("_") > 0) {
                String indexStr = schemaName.substring(schemaName.lastIndexOf("_") + 1, schemaName.length());
                schemaName = schemaName.substring(0, schemaName.lastIndexOf("_"));
                try {
                    Integer index = Integer.parseInt(indexStr);
                    index = index + 1;
                    schemaName = schemaName + "_" + index;
                }
                catch (NumberFormatException e) {
                    schemaName = schemaName + "_1";
                }
            } else {
                schemaName = schemaName + "_1";
            }
            bo.setSchemaName(schemaName);
        }
        this.insertSchema(bo, content);
        this.insertSchemaRelation(bo);
    }

    public void setNoDefaultSchema(String fbizTag, String userId, int source, String fId) throws AbstractQingIntegratedException, SQLException {
        String defaultFId = this.getDefaultUserSchemaId(fbizTag, userId, source);
        String sql = "";
        if (defaultFId != null) {
            sql = "UPDATE T_QING_SARelation SET FISDEFAULT ='0' WHERE FSCHEMAID =? AND (FUSERID=? or FUSERID=?)";
            Object[] param = new Object[]{defaultFId, userId, IntegratedHelper.getPresetUserId()};
            this.dbExcuter.execute(sql, param);
        }
    }

    public void setSchemaDefaultAttr(String fbizTag, String userId, int source, String fId, Boolean isDefault) throws AbstractQingIntegratedException, SQLException {
        this.setNoDefaultSchema(fbizTag, userId, source, fId);
        if (isDefault.booleanValue()) {
            String sql = "UPDATE T_QING_SARelation SET FISDEFAULT= ? WHERE FSCHEMAID= ? and FUSERID=?";
            Object[] param2 = new Object[]{1, fId, userId};
            this.dbExcuter.execute(sql, param2);
        }
    }

    public void renameSchema(String fid, String name) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("update t_qing_saschema SET FSCHEMANAME=? WHERE FID = ?", new Object[]{name, fid});
    }

    private void excuteBatch(ArrayList<String> sqls, ArrayList<Object[]> params) throws AbstractQingIntegratedException, SQLException {
        for (int i = 0; i < sqls.size(); ++i) {
            this.dbExcuter.execute(sqls.get(i), params.get(i));
        }
    }

    private void writeBlock(String blockSql, String fSchemaId, byte[] blockData) throws AbstractQingIntegratedException, SQLException {
        Integer length = blockData.length;
        if (length > 0) {
            int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
            int contentSize = 0;
            int offset = 0;
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (int i = 0; i < count; ++i) {
                contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                int index = 0;
                Object[] param = new Object[4];
                param[index++] = UUID.randomUUID().toString();
                param[index++] = fSchemaId;
                param[index++] = i;
                param[index++] = this.dbExcuter.createSqlParameterBytes(blockData, offset, contentSize);
                offset += contentSize;
                params.add(param);
            }
            this.dbExcuter.executeBatch(blockSql, params);
        }
    }

    private byte[] readBlock(String sql, String fId) throws AbstractQingIntegratedException, SQLException {
        return (byte[])this.dbExcuter.query(sql, new Object[]{fId}, (ResultHandler)new ResultHandler<byte[]>(){

            public byte[] handle(ResultSet rs) throws SQLException {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                int iCurrentIdx = 0;
                while (rs.next()) {
                    try {
                        if (iCurrentIdx > rs.getInt("FCONTENTINDEX") || rs.getBytes("FCONTENT") == null) continue;
                        os.write(rs.getBytes("FCONTENT"));
                        ++iCurrentIdx;
                    }
                    catch (IOException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                }
                return os.toByteArray();
            }
        });
    }

    public void copySchema(String userId, String oldBiztag, String newBiztag) throws AbstractQingIntegratedException, SQLException {
        ArrayList<SchemaBO> schemaList = this.getSchemaByBiztag(oldBiztag, userId);
        if (schemaList.size() == 0) {
            return;
        }
        for (SchemaBO oldSchemaBO : schemaList) {
            SchemaBO newSchemaBO = new SchemaBO();
            String newSchemaId = this.dbExcuter.genStringId("T_QING_SASchema");
            newSchemaBO.setfId(newSchemaId);
            newSchemaBO.setBizTag(newBiztag);
            newSchemaBO.setUserId(userId);
            newSchemaBO.setIsDefault(oldSchemaBO.IsDefault());
            newSchemaBO.setSchemaName(oldSchemaBO.getSchemaName());
            newSchemaBO.setSchemaType(oldSchemaBO.getSchemaType());
            newSchemaBO.setSource(oldSchemaBO.getSource());
            byte[] schemaContent = this.loadSchemaContent(oldSchemaBO.getfId());
            List<OutsideReference> outSideRefList = this.loadSchemaRef(oldSchemaBO.getfId());
            if (outSideRefList.size() > 0) {
                for (OutsideReference outsideRef : outSideRefList) {
                    this.saveSchemaRef(outsideRef, newSchemaId);
                }
            }
            this.insertSchema(newSchemaBO, schemaContent);
            this.insertSchemaRelation(newSchemaBO);
        }
    }

    public boolean hasUserDefalutSchema(String bizTag, String userId, int source) throws AbstractQingIntegratedException, SQLException {
        String sql = "select sar.FSCHEMAID from T_QING_SARelation sar left join T_QING_SASchema sa on sa.FID = sar.FSCHEMAID where fuserid = ? and FBIZTAG = ? and FSOURCE = ? and FISDEFAULT ='1'";
        Object[] params = new Object[]{userId, bizTag, "" + source};
        return (Boolean)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    public List<String> getSystemSchemaIds(String bizTag, int source) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT DISTINCT FID, FCREATETIME from T_QING_SASchema  where FSCHEMATYPE ='2' and FBIZTAG = ? and FSOURCE = ? ORDER BY FCREATETIME DESC";
        Object[] params = new Object[]{bizTag, "" + source};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> list = new ArrayList<String>(10);
                while (rs.next()) {
                    list.add(rs.getString("FID"));
                }
                return list;
            }
        });
    }

    public void saveSchemaRef(OutsideReference outsideRef, String schemaId) throws AbstractQingIntegratedException, SQLException {
        Object[] param = new Object[6];
        String fid = this.dbExcuter.genStringId("T_QING_Schema_Ref");
        param[0] = fid;
        param[1] = outsideRef.getUid();
        param[2] = schemaId;
        param[3] = StringUtils.isNotBlank((CharSequence)outsideRef.getRefToId()) ? outsideRef.getRefToId() : null;
        param[4] = StringUtils.isNotBlank((CharSequence)outsideRef.getRefToId()) ? null : outsideRef.getRefToFullPath();
        param[5] = SchemaRefType.valueOf(outsideRef.getRefType()).toPersistance();
        this.dbExcuter.execute("INSERT INTO T_QING_Schema_Ref (FID,FUID,FSchemaID,FRefToID,FFullPath,FRefType) VALUES(?,?,?,?,?,?)", param);
    }

    public List<OutsideReference> loadSchemaRef(String schemaId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FID, FUID,FRefToId,FFullPath,FRefType FROM T_QING_Schema_Ref WHERE FSchemaID=?", new Object[]{schemaId}, (ResultHandler)new ResultHandler<List<OutsideReference>>(){

            public List<OutsideReference> handle(ResultSet rs) throws SQLException {
                ArrayList<OutsideReference> list = new ArrayList<OutsideReference>(10);
                while (rs.next()) {
                    OutsideReference outsideRef = new OutsideReference();
                    outsideRef.setRefToId(rs.getString("FRefToId"));
                    outsideRef.setRefToFullPath(rs.getString("FFullPath"));
                    outsideRef.setRefType(SchemaRefType.getSchemaRefType(rs.getInt("FRefType")).toString());
                    outsideRef.setUid(rs.getString("FUID"));
                    list.add(outsideRef);
                }
                return list;
            }
        });
    }

    public void updateSchemaRef(String mapId, String fId) throws AbstractQingIntegratedException, SQLException {
        Object[] param = new Object[]{mapId, null, fId};
        this.dbExcuter.execute("UPDATE T_QING_Schema_Ref SET FRefToID = ?, FFullPath = ? WHERE FId = ?", param);
    }

    public Map<String, OutsideReference> loadSchemaRefWithFId(String schemaId, String refType) throws AbstractQingIntegratedException, SQLException {
        return (Map)this.dbExcuter.query("SELECT FID, FUID,FRefToId,FFullPath,FRefType FROM T_QING_Schema_Ref WHERE FSchemaID=? AND FRefType = ? AND (FRefToId IS NULL OR FRefToId=' ')", new Object[]{schemaId, refType}, (ResultHandler)new ResultHandler<Map<String, OutsideReference>>(){

            public Map<String, OutsideReference> handle(ResultSet rs) throws SQLException {
                HashMap<String, OutsideReference> list = new HashMap<String, OutsideReference>(16);
                while (rs.next()) {
                    String fId = rs.getString("FId");
                    OutsideReference outsideRef = new OutsideReference();
                    outsideRef.setRefToId(rs.getString("FRefToId"));
                    outsideRef.setRefToFullPath(rs.getString("FFullPath"));
                    outsideRef.setRefType(SchemaRefType.getSchemaRefType(rs.getInt("FRefType")).toString());
                    outsideRef.setUid(rs.getString("FUID"));
                    list.put(fId, outsideRef);
                }
                return list;
            }
        });
    }

    public List<OutsideReference> loadSchemaRefByTagId(String bizTag, int source) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{bizTag, "" + source};
        return (List)this.dbExcuter.query("SELECT ref.FUID,ref.FRefToId,ref.FFullPath,ref.FRefType FROM T_QING_Schema_Ref ref LEFT JOIN T_QING_SASchema sa ON ref.FSCHEMAID = sa.FID  where sa.FBIZTAG = ? and sa.FSOURCE = ?", params, (ResultHandler)new ResultHandler<List<OutsideReference>>(){

            public List<OutsideReference> handle(ResultSet rs) throws SQLException {
                ArrayList<OutsideReference> list = new ArrayList<OutsideReference>(10);
                while (rs.next()) {
                    OutsideReference outsideRef = new OutsideReference();
                    outsideRef.setRefToId(rs.getString("FRefToId"));
                    outsideRef.setRefToFullPath(rs.getString("FFullPath"));
                    outsideRef.setRefType(SchemaRefType.getSchemaRefType(rs.getInt("FRefType")).toString());
                    outsideRef.setUid(rs.getString("FUID"));
                    list.add(outsideRef);
                }
                return list;
            }
        });
    }

    public void deleteSchemaRef(String schemaId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_Schema_Ref WHERE FSchemaID=?", new Object[]{schemaId});
    }

    public List<String> loadRefToIdIsNullOutSideRef(String fullPath, String refType) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FID,FUID,FRefToId,FFullPath,FRefType FROM T_QING_Schema_Ref WHERE FFullPath = ? AND FRefType = ? AND (FRefToId IS NULL OR FRefToId=' ')", new Object[]{fullPath, refType}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> list = new ArrayList<String>(10);
                while (rs.next()) {
                    list.add(rs.getString("FID"));
                }
                return list;
            }
        });
    }

    public void updateRefToId(String fId, String mapId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{mapId, null, fId};
        this.dbExcuter.execute("UPDATE T_QING_Schema_Ref SET FRefToID = ?, FFullPath=? WHERE FId = ?", params);
    }

    public List<String> loadRefByRefToId(String mapId, String refType) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FID,FUID,FRefToId,FFullPath,FRefType FROM T_QING_Schema_Ref WHERE FRefToId = ? AND FRefType = ? AND FFullPath IS NULL", new Object[]{mapId, refType}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> list = new ArrayList<String>(10);
                while (rs.next()) {
                    list.add(rs.getString("FID"));
                }
                return list;
            }
        });
    }

    public void updateRefFullPath(String mapPath, String fId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{mapPath, null, fId};
        this.dbExcuter.execute("UPDATE T_QING_Schema_Ref SET FFullPath = ?, FRefToId = ? WHERE FID = ?", params);
    }

    public void updateSchemaSeq(String schemaId, int seq) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{seq, schemaId};
        this.dbExcuter.execute("UPDATE T_QING_SASchema SET FSEQ = ? WHERE FID = ?", params);
    }

    public List<String> getNotRelatedSystemSchemaIds(String bizTag, String userId, int source) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID FROM T_QING_SASCHEMA SAS WHERE SAS.FSCHEMATYPE ='2' AND FBIZTAG = ? AND SAS.FSOURCE= ? AND SAS.FID NOT IN (SELECT SAR.FSCHEMAID FROM T_QING_SARELATION SAR WHERE SAR.FUSERID = ?) order by fseq DESC";
        Object[] params = new Object[]{bizTag, "" + source, userId};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> list = new ArrayList<String>(10);
                while (rs.next()) {
                    list.add(rs.getString("FID"));
                }
                return list;
            }
        });
    }

    public List<String> getFullBizTagByPrefix(String bizTagPrefix) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FBIZTAG FROM T_QING_SASCHEMA WHERE FBIZTAG LIKE ?";
        return (List)this.dbExcuter.query(sql, new Object[]{bizTagPrefix + "%"}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> bizTags = new ArrayList<String>(10);
                while (rs.next()) {
                    bizTags.add(rs.getString("FBIZTAG"));
                }
                return bizTags;
            }
        });
    }

    public List<SchemaAttrVO> getSchemaAttrByPublishId(String fid, String userId, int source) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{userId, fid, "" + source};
        return (List)this.dbExcuter.query("select t_qing_saschema.fid,fschemaname,fbiztag,fschematype,fsource,fseq,fuserid,fisdefault from t_qing_saschema left join t_qing_sarelation on t_qing_saschema.fid = t_qing_sarelation.fschemaid and fuserid = ? where fbiztag = ? and fsource = ? and fschematype = '2' ORDER BY FSEQ DESC , FSCHEMATYPE DESC , FCREATETIME DESC", params, (ResultHandler)new ResultHandler<List<SchemaAttrVO>>(){

            public List<SchemaAttrVO> handle(ResultSet rs) throws SQLException {
                ArrayList<SchemaAttrVO> schemaAttrVOList = new ArrayList<SchemaAttrVO>(10);
                while (rs.next()) {
                    SchemaAttrVO schemaAttrVO = new SchemaAttrVO();
                    schemaAttrVO.setfId(rs.getString("fid"));
                    schemaAttrVO.setSchemaName(rs.getString("fschemaname"));
                    schemaAttrVO.setSource(rs.getInt("fsource"));
                    schemaAttrVO.setSchemaType(Integer.parseInt(rs.getString("fschematype")));
                    if (rs.getString("fisdefault") == null) {
                        schemaAttrVO.setIsDefault(false);
                    } else {
                        int fisdefault = Integer.parseInt(rs.getString("fisdefault"));
                        schemaAttrVO.setIsDefault(1 == fisdefault);
                    }
                    schemaAttrVO.setSeq(rs.getInt("fseq"));
                    schemaAttrVOList.add(schemaAttrVO);
                }
                return schemaAttrVOList;
            }
        });
    }

    public List<String> findSetDefaultPlanUserId(PublishPO publishPO) throws AbstractQingIntegratedException, SQLException {
        String sql = "Select fuserid from t_qing_sarelation where fschemaid = ?";
        Object[] params = new Object[]{publishPO.getSchemaId()};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> existUserId = new ArrayList<String>(20);
                while (rs.next()) {
                    String fuserid = rs.getString("fuserid");
                    if (!Objects.equals(fuserid, "SystemUser")) continue;
                    existUserId.add(fuserid);
                }
                return existUserId;
            }
        });
    }

    public boolean checkPublishInfoSource(String bizTag, String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "select count(1) as c from t_qing_publish where fid = ? and fcreatorid = ?";
        Object[] params = new Object[]{bizTag, userId};
        return (Boolean)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("c") > 0;
                }
                return false;
            }
        });
    }

    public boolean judgePublishInfoIsDel(String bizTag) throws AbstractQingIntegratedException, SQLException {
        String sql = "select count(1) as c from t_qing_publish where fid = ?";
        Object[] params = new Object[]{bizTag};
        return (Boolean)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("c") > 0;
                }
                return false;
            }
        });
    }

    public void updatePublishInfoByFid(String bizTag, String userId, String defaultSchemaId) throws AbstractQingIntegratedException, SQLException {
        String sql = "update t_qing_publish set fschemaid = ? where fid = ? and fcreatorid = ?";
        Object[] params = new Object[]{defaultSchemaId, bizTag, userId};
        this.dbExcuter.execute(sql, params);
    }

    public String getPublishInfoUserName(String fId, final String userId) throws AbstractQingIntegratedException, SQLException {
        String sql = "select fviewerid, fcreatorid, t_qing_permpublish.ftype as ftype from T_QING_PERMPUBLISH right join t_qing_publish on t_qing_permpublish.fpublishid = t_qing_publish.fid where fpublishid = ?";
        Object[] params = new Object[]{fId};
        return (String)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String authorityUserId = "";
                while (rs.next()) {
                    String checkUserId = rs.getString("fviewerid");
                    if (Objects.equals(userId, checkUserId)) {
                        return null;
                    }
                    authorityUserId = rs.getString("fcreatorid");
                }
                try {
                    return "".equals(authorityUserId) ? authorityUserId : IntegratedHelper.getUserName(null, (IDBExcuter)SchemaManageDao.this.dbExcuter, (String)authorityUserId);
                }
                catch (IntegratedRuntimeException e) {
                    return null;
                }
            }
        });
    }

    public String getUserIdByPublishId(String fid) throws AbstractQingIntegratedException, SQLException {
        String sql = "select fcreatorid from t_qing_publish where fid = ?";
        Object[] param = new Object[]{fid};
        return (String)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("fcreatorid");
                }
                return null;
            }
        });
    }

    public Map<String, byte[]> loadSchemaContentList(final List<String> schemaIdList) throws SQLException, AbstractQingIntegratedException {
        StringBuilder sqlBuilder = new StringBuilder("SELECT FSCHEMAID, FCONTENTINDEX, FCONTENT FROM T_QING_SAContent where FSCHEMAID in ( ");
        Object[] params = new Object[schemaIdList.size()];
        for (int i = 0; i < schemaIdList.size(); ++i) {
            params[i] = schemaIdList.get(i);
            sqlBuilder.append(i != schemaIdList.size() - 1 ? "?, " : "?)");
        }
        sqlBuilder.append(" order by FSCHEMAID, FCONTENTINDEX");
        return (Map)this.dbExcuter.query(sqlBuilder.toString(), params, (ResultHandler)new ResultHandler<Map<String, byte[]>>(){

            public Map<String, byte[]> handle(ResultSet rs) throws SQLException {
                HashMap<String, byte[]> schemaContentMap = new HashMap<String, byte[]>(schemaIdList.size());
                String schemaId = "";
                while (rs.next()) {
                    try {
                        schemaId = rs.getString("FSCHEMAID");
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        byte[] existSchemaContentBlock = (byte[])schemaContentMap.get(schemaId);
                        if (existSchemaContentBlock != null) {
                            os.write(existSchemaContentBlock);
                        }
                        os.write(rs.getBytes("FCONTENT"));
                        schemaContentMap.put(schemaId, os.toByteArray());
                    }
                    catch (IOException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                }
                return schemaContentMap;
            }
        });
    }

    public String getLastBizTagByFId(String bizTag) throws AbstractQingIntegratedException, SQLException {
        String sql = "select fparentpubidfullpath, flastbiztag from T_QING_PUBLISH where fid = ?";
        Object[] params = new Object[]{bizTag};
        return (String)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    String lastBizTag = rs.getString("flastbiztag");
                    return lastBizTag;
                }
                return null;
            }
        });
    }

    public String getThemeIdByBizTag(String bizTag) throws AbstractQingIntegratedException, SQLException {
        String sql = "select ftagid from T_QING_PUBLISH where fid = ?";
        Object[] param = new Object[]{bizTag};
        return (String)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("ftagid");
                }
                return null;
            }
        });
    }

    public List<String> getAllPublishedRecordName(String userId, String publishSourceType, String publishTargetType) throws AbstractQingIntegratedException, SQLException {
        String sql = "select fname from t_qing_publish where fcreatorid = ? and fsource = ? and ftype = ? group by fname order by max(fupdatetime) desc";
        Object[] params = new Object[]{userId, publishSourceType, Integer.parseInt(publishTargetType)};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> publishedName = new ArrayList<String>(20);
                while (rs.next()) {
                    String fname = rs.getString("fname");
                    publishedName.add(fname);
                }
                return publishedName;
            }
        });
    }

    public List<String> getTargetAllPublishedRecordName(String userId, String publishTargetType) throws AbstractQingIntegratedException, SQLException {
        String sql = "select fname from t_qing_publish where fcreatorid = ? and ftype = ? group by fname order by max(fupdatetime) desc";
        Object[] params = new Object[]{userId, Integer.parseInt(publishTargetType)};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> publishedName = new ArrayList<String>(20);
                while (rs.next()) {
                    String fname = rs.getString("fname");
                    publishedName.add(fname);
                }
                return publishedName;
            }
        });
    }

    public List<String> checkPublishSourceToTheme(String bizTag) throws AbstractQingIntegratedException, SQLException {
        String sql = "select flastbiztag, fcarrydata from T_QING_PUBLISH where fid = ? and fsource = 'subject'";
        Object[] params = new Object[]{bizTag};
        return (List)this.dbExcuter.query(sql, params, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    ArrayList<String> publishInfo = new ArrayList<String>(2);
                    String fLastBiztag = rs.getString("flastbiztag");
                    String fCarryData = rs.getString("fcarrydata");
                    publishInfo.add(fLastBiztag);
                    publishInfo.add(fCarryData);
                    return publishInfo;
                }
                return null;
            }
        });
    }

    public boolean checkThemeIsDelByFid(String lastBizTagByFId) throws AbstractQingIntegratedException, SQLException {
        String sql = "select count(1) as c from t_qing_theme where fid = ?";
        Object[] param = new Object[]{lastBizTagByFId};
        return (Boolean)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return Integer.parseInt(rs.getString("c")) == 0;
                }
                return false;
            }
        });
    }

    public List<String> getAllAuthorizeRole(String bizTag) throws AbstractQingIntegratedException, SQLException {
        String sql = "select fviewerid, fcreatorid, t_qing_permpublish.ftype as ftype from T_QING_PERMPUBLISH right join t_qing_publish on t_qing_permpublish.fpublishid = t_qing_publish.fid where fpublishid = ?";
        Object[] param = new Object[]{bizTag};
        return (List)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> roleList = new ArrayList<String>(10);
                while (rs.next()) {
                    String fviewerid = rs.getString("fviewerid");
                    String ftype = rs.getString("ftype");
                    if (!"1".equals(ftype)) continue;
                    roleList.add(fviewerid);
                }
                return roleList;
            }
        });
    }

    public void updatePublishSchemaSeq(List<SchemaAttrVO> updateSchemaSeq) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_SASchema SET FSEQ = ? WHERE FID = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(updateSchemaSeq.size());
        for (SchemaAttrVO schemaAttrVO : updateSchemaSeq) {
            Object[] params = new Object[]{schemaAttrVO.getSeq(), schemaAttrVO.getfId()};
            paramsList.add(params);
        }
        this.dbExcuter.executeBatch(sql, paramsList);
    }

    public Map<String, String> loadExtRptDefaultSchemaInfo(String extreportID) throws AbstractQingIntegratedException, SQLException {
        String loadExtRptDefaultSchemaSql = "SELECT R.FSCHEMEID, S.FNAME FROM T_QING_EXTRPT_SC_REL R  LEFT JOIN T_QING_EXTRPT_SCHEME S ON S.FID = R.FSCHEMEID WHERE R.FREPORTID = ? ";
        return (Map)this.dbExcuter.query(loadExtRptDefaultSchemaSql, new Object[]{extreportID}, (ResultHandler)new ResultHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> defaultSchemaInfoMap = new HashMap<String, String>(3);
                if (rs.next()) {
                    defaultSchemaInfoMap.put("defaultSchemaId", rs.getString("FSCHEMEID"));
                    defaultSchemaInfoMap.put("defaultSchemaName", rs.getString("FNAME"));
                }
                return defaultSchemaInfoMap;
            }
        });
    }

    public String saveExtReportSchemaInfo(String publishId, String schemaName, String userID) throws AbstractQingIntegratedException, SQLException {
        String insertExtreportDefaultSchemaInfoSql = "INSERT INTO T_QING_EXTRPT_SCHEME(FID, FCREATORID, FCREATEDATE, FUPDATERID, FMODIFYDATE, FREPORTID, FNAME, FSHARESTRATEGY, FOWNERID) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String newSchemaId = this.dbExcuter.genStringId("T_QING_EXTRPT_SCHEME");
        Date createTime = new Date();
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(newSchemaId);
        params.add(userID);
        params.add(createTime);
        params.add(userID);
        params.add(createTime);
        params.add(publishId);
        params.add(schemaName);
        params.add("0");
        params.add(userID);
        this.dbExcuter.execute(insertExtreportDefaultSchemaInfoSql, params.toArray());
        return newSchemaId;
    }

    public void saveExtReportDefaultSchemaConfig(String publishId, String schemaId, String userID) throws AbstractQingIntegratedException, SQLException {
        String insertExtRptDefaultSchemaRelSql = "INSERT INTO T_QING_EXTRPT_SC_REL (FID, FREPORTID, FUSERID, FSCHEMEID) VALUES(?, ?, ?, ?)";
        String schemaRelId = this.dbExcuter.genStringId("T_QING_EXTRPT_SC_REL");
        this.dbExcuter.execute(insertExtRptDefaultSchemaRelSql, new Object[]{schemaRelId, publishId, userID, schemaId});
    }

    public void saveExtReportDefaultSchemaContent(String defaultSchemaId, String newSchemaId) throws AbstractQingIntegratedException, SQLException {
        String loadExtRptDefaultSchemaContentSql = "SELECT FCONTENT, FCONTENTINDEX FROM T_QING_EXTRPT_SC_CONT WHERE FSCHEMEID = ? ORDER BY FCONTENTINDEX ASC ";
        byte[] defaultSchemaContent = this.readBlock(loadExtRptDefaultSchemaContentSql, defaultSchemaId);
        if (defaultSchemaContent != null) {
            String insertExtRptDefaultSchemaContentSql = "INSERT INTO T_QING_EXTRPT_SC_CONT (FID, FSCHEMEID, FCONTENTINDEX, FCONTENT) VALUES(?,?,?,?)";
            this.writeBlockWithPrimaryKey(insertExtRptDefaultSchemaContentSql, newSchemaId, defaultSchemaContent);
        }
    }

    public void clearExtRptSchemaInfos(String publishId) throws AbstractQingIntegratedException, SQLException {
        String deleteExtRptDefaultSchemaConfigSql = "DELETE FROM T_QING_EXTRPT_SC_REL WHERE FREPORTID = ?";
        this.dbExcuter.execute(deleteExtRptDefaultSchemaConfigSql, new Object[]{publishId});
        List<String> deletePublishSchemaIdList = this.loadExtRptSchemaIds(publishId);
        String deleteExtRptSchemaInfoSql = "DELETE FROM T_QING_EXTRPT_SCHEME WHERE FREPORTID = ?";
        this.dbExcuter.execute(deleteExtRptSchemaInfoSql, new Object[]{publishId});
        if (deletePublishSchemaIdList != null && deletePublishSchemaIdList.size() > 0) {
            StringBuilder deletePublishSchemaContentSql = new StringBuilder("DELETE FROM T_QING_EXTRPT_SC_CONT WHERE FSCHEMEID IN (");
            Object[] params = new Object[deletePublishSchemaIdList.size()];
            for (int i = 0; i < deletePublishSchemaIdList.size(); ++i) {
                params[i] = deletePublishSchemaIdList.get(i);
                deletePublishSchemaContentSql.append(i != deletePublishSchemaIdList.size() - 1 ? "?, " : "?)");
            }
            this.dbExcuter.execute(deletePublishSchemaContentSql.toString(), params);
        }
    }

    private List<String> loadExtRptSchemaIds(String extreportID) throws AbstractQingIntegratedException, SQLException {
        String loadExtRptDefaultSchemaSql = "SELECT FID FROM T_QING_EXTRPT_SCHEME WHERE FREPORTID = ? ";
        return (List)this.dbExcuter.query(loadExtRptDefaultSchemaSql, new Object[]{extreportID}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> schemaIdList = new ArrayList<String>(10);
                while (rs.next()) {
                    schemaIdList.add(rs.getString("FID"));
                }
                return schemaIdList;
            }
        });
    }

    public boolean isExtReport(String extreportID) throws SQLException, AbstractQingIntegratedException {
        String sql = "SELECT FNAME FROM T_QING_EXTRPT_INFO WHERE FID=?";
        return (Boolean)this.dbExcuter.query(sql, new Object[]{extreportID}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    private void writeBlockWithPrimaryKey(String blockSql, String fSchemaId, byte[] blockData) throws AbstractQingIntegratedException, SQLException {
        Integer length = blockData.length;
        if (length > 0) {
            int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
            int contentSize = 0;
            int offset = 0;
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (int i = 0; i < count; ++i) {
                contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                int index = 0;
                Object[] param = new Object[4];
                param[index++] = UUID.randomUUID().toString();
                param[index++] = fSchemaId;
                param[index++] = i;
                param[index++] = this.dbExcuter.createSqlParameterBytes(blockData, offset, contentSize);
                offset += contentSize;
                params.add(param);
            }
            this.dbExcuter.executeBatch(blockSql, params);
        }
    }

    public boolean judgeSchemaIsDel(String schemaId) throws AbstractQingIntegratedException, SQLException {
        String sql = "select 1 from t_qing_saschema where fid = ?";
        Object[] param = new Object[]{schemaId};
        return (Boolean)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return true;
                }
                return false;
            }
        });
    }

    public void updateSchemaBoList(String publishInfoId, List<SchemaModel> schemaModelList) throws AbstractQingIntegratedException, SQLException {
        this.deleteSchemaByBizTag(publishInfoId);
        this.insertSchemaList(schemaModelList);
    }
}

