/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schema.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.exception.PersistentModelTooModernException;
import com.kingdee.bos.qing.core.model.analysis.ModelBook;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.filesystem.exception.IntegratedIOException;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.IThemeGroupDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.dao.impl.ThemeGroupDaoImpl;
import com.kingdee.bos.qing.manage.model.ThemeGroupVO;
import com.kingdee.bos.qing.manage.model.ThemePO;
import com.kingdee.bos.qing.map.dao.MapManageDao;
import com.kingdee.bos.qing.map.model.MapVO;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.publish.PublishManageDomianFactory;
import com.kingdee.bos.qing.publish.dao.PublishInfoDao;
import com.kingdee.bos.qing.publish.domain.AbstractPublishManageDomain;
import com.kingdee.bos.qing.publish.domain.CommonPublishDomain;
import com.kingdee.bos.qing.publish.exception.MapNotFoundException;
import com.kingdee.bos.qing.publish.exception.PublishNoOperAuthException;
import com.kingdee.bos.qing.publish.exception.PublishSourcePublishNotExistException;
import com.kingdee.bos.qing.publish.model.OperCodeEnum;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishVO;
import com.kingdee.bos.qing.publish.util.PublishUtil;
import com.kingdee.bos.qing.schema.dao.SchemaManageDao;
import com.kingdee.bos.qing.schema.domain.ISchemaExportStrategy;
import com.kingdee.bos.qing.schema.exception.SchemaManagerException;
import com.kingdee.bos.qing.schema.exception.SchemaNameDuplicateException;
import com.kingdee.bos.qing.schema.exception.SchemaNotFoundException;
import com.kingdee.bos.qing.schema.model.SchemaAttrVO;
import com.kingdee.bos.qing.schema.model.SchemaBO;
import com.kingdee.bos.qing.schema.model.SchemaContentBO;
import com.kingdee.bos.qing.schema.model.SchemaContentVO;
import com.kingdee.bos.qing.schema.model.SchemaTypeEnum;
import com.kingdee.bos.qing.schema.model.SchemaVO;
import com.kingdee.bos.qing.schema.oplog.SchemeOpLog;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.ModelBookUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class SchemaDomain
implements IDBAccessable {
    private QingContext context;
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private SchemaManageDao schemaDao;
    private MapManageDao mapManageDao;
    private PublishInfoDao publishInfoDao;
    private CommonPublishDomain commonPublishDomain;
    private IThemeDao iThemeDao;
    private IThemeGroupDao iThemeGroupDao;

    protected SchemaManageDao getSchemaDao() {
        if (this.schemaDao == null) {
            this.schemaDao = new SchemaManageDao(this.dbExcuter);
        }
        return this.schemaDao;
    }

    private MapManageDao getMapManageDao() {
        if (this.mapManageDao == null) {
            this.mapManageDao = new MapManageDao();
            this.mapManageDao.setDbExcuter(this.dbExcuter);
        }
        return this.mapManageDao;
    }

    private PublishInfoDao getPublishInfoDao() {
        if (this.publishInfoDao == null) {
            this.publishInfoDao = new PublishInfoDao(this.dbExcuter);
        }
        return this.publishInfoDao;
    }

    private CommonPublishDomain getCommonPublishDomain() {
        if (this.commonPublishDomain == null) {
            this.commonPublishDomain = new CommonPublishDomain(this.context, this.tx, this.dbExcuter);
        }
        return this.commonPublishDomain;
    }

    private IThemeDao getThemeDao() {
        if (this.iThemeDao == null) {
            this.iThemeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.iThemeDao;
    }

    protected IThemeGroupDao getThemeGroupDao() {
        if (this.iThemeGroupDao == null) {
            this.iThemeGroupDao = new ThemeGroupDaoImpl(this.dbExcuter);
        }
        return this.iThemeGroupDao;
    }

    public void setQingContext(QingContext context) {
        this.context = context;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public ArrayList<SchemaAttrVO> loadSchemaAttrs(String bizTag, String userId, int source) throws AbstractQingIntegratedException, SchemaManagerException {
        try {
            SchemaBO schemaBO2;
            this.tx.beginRequired();
            ArrayList<SchemaBO> listBO = this.getSchemaDao().loadSchemaAttrs(bizTag, userId, source);
            ArrayList<SchemaAttrVO> listVO = new ArrayList<SchemaAttrVO>();
            int seq = listBO.size() - 1;
            for (int i = 0; i < listBO.size() && (schemaBO2 = listBO.get(i)).getSeq() == 0; ++i) {
                this.getSchemaDao().updateSchemaSeq(schemaBO2.getfId(), seq);
                schemaBO2.setSeq(seq);
                --seq;
            }
            for (SchemaBO schemaBO2 : listBO) {
                SchemaAttrVO schemaAttrVO = new SchemaAttrVO();
                schemaAttrVO.setfId(schemaBO2.getfId());
                schemaAttrVO.setSchemaName(schemaBO2.getSchemaName());
                schemaAttrVO.setSchemaType(schemaBO2.getSchemaType());
                schemaAttrVO.setIsDefault(schemaBO2.IsDefault());
                schemaAttrVO.setSource(schemaBO2.getSource());
                schemaAttrVO.setSeq(schemaBO2.getSeq());
                listVO.add(schemaAttrVO);
            }
            ArrayList<SchemaAttrVO> arrayList = listVO;
            return arrayList;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new SchemaManagerException(e);
        }
        finally {
            this.tx.end();
        }
    }

    public List<String> loadAuthorityRoles(String bizTag) throws AbstractQingIntegratedException, SQLException {
        return this.getSchemaDao().getAllAuthorizeRole(bizTag);
    }

    public List<SchemaBO> loadAllPublishSchemaAttrByBizTag(String bizTag, String userId, int source) throws SchemaManagerException {
        try {
            return this.getSchemaDao().loadAllPublishSchemaAttrByBizTag(bizTag, userId, source);
        }
        catch (AbstractQingIntegratedException e) {
            throw new SchemaManagerException(e);
        }
        catch (SQLException e) {
            throw new SchemaManagerException(e);
        }
    }

    public ArrayList<SchemaAttrVO> loadSchemaAttrsForDsb(String bizTag, String userId, int source) throws AbstractQingIntegratedException, SchemaManagerException {
        try {
            ArrayList<SchemaBO> listBO = this.getSchemaDao().loadSchemaAttrs(bizTag, userId, source);
            ArrayList<SchemaAttrVO> listVO = new ArrayList<SchemaAttrVO>();
            if (listVO.size() == 0) {
                this.initSystemSchemaRelation(bizTag, userId, source);
                listBO = this.getSchemaDao().loadSchemaAttrs(bizTag, userId, source);
            }
            for (SchemaBO schemaBO : listBO) {
                SchemaAttrVO schemaAttrVO = new SchemaAttrVO();
                schemaAttrVO.setfId(schemaBO.getfId());
                schemaAttrVO.setSchemaName(schemaBO.getSchemaName());
                schemaAttrVO.setSchemaType(schemaBO.getSchemaType());
                schemaAttrVO.setIsDefault(schemaBO.IsDefault());
                schemaAttrVO.setSource(schemaBO.getSource());
                listVO.add(schemaAttrVO);
            }
            return listVO;
        }
        catch (SQLException e) {
            throw new SchemaManagerException(e);
        }
    }

    private void initSystemSchemaRelation(String bizTag, String userId, int source) throws AbstractQingIntegratedException, SQLException {
        List<String> fIds = this.getSchemaDao().getNotRelatedSystemSchemaIds(bizTag, userId, source);
        if (fIds.size() > 0) {
            boolean hasUserDefalutSchema = this.getSchemaDao().hasUserDefalutSchema(bizTag, userId, source);
            boolean isDefalut = !hasUserDefalutSchema;
            try {
                this.tx.beginRequired();
                for (String systemFId : fIds) {
                    SchemaBO schemaBORelation = new SchemaBO();
                    schemaBORelation.setfId(systemFId);
                    schemaBORelation.setUserId(userId);
                    schemaBORelation.setIsDefault(isDefalut);
                    this.getSchemaDao().insertSchemaRelation(schemaBORelation);
                    isDefalut = false;
                }
            }
            catch (AbstractQingIntegratedException e) {
                this.tx.markRollback();
                throw e;
            }
            catch (SQLException e) {
                this.tx.markRollback();
                throw e;
            }
            finally {
                this.tx.end();
            }
        }
    }

    public SchemaContentVO loadSchemaContent(String fId, String bizTag, String userId, int source) throws AbstractQingIntegratedException, SchemaManagerException {
        try {
            if (fId == null || fId.length() == 0) {
                this.initSystemSchemaRelation(bizTag, userId, source);
                fId = this.getSchemaDao().getDefaultUserSchemaId(bizTag, userId, source);
            }
            if (fId == null || fId.length() == 0) {
                return null;
            }
            byte[] schemaContent = this.getSchemaDao().loadSchemaContent(fId);
            if (schemaContent == null || schemaContent.length == 0) {
                return null;
            }
            ModelBook modelBook = SchemaDomain.byteToModel(schemaContent);
            List<OutsideReference> outSideRefList = this.getSchemaDao().loadSchemaRef(fId);
            this.setOutSideRefName(outSideRefList);
            if (outSideRefList != null && outSideRefList.size() > 0) {
                modelBook.fixReferences(outSideRefList);
            }
            SchemaContentVO contentVO = new SchemaContentVO();
            SchemaBO bo = this.getSchemaDao().findSchemaById(fId);
            contentVO.setSchemaName(bo.getSchemaName());
            contentVO.setSchemaType(bo.getSchemaType());
            contentVO.setfId(fId);
            contentVO.setSchemaContent(modelBook);
            return contentVO;
        }
        catch (SQLException e) {
            throw new SchemaManagerException(e);
        }
        catch (PersistentModelParseException e) {
            throw new SchemaManagerException(e);
        }
        catch (PersistentModelTooModernException e) {
            throw new SchemaManagerException(e);
        }
    }

    public void setOutSideRefName(List<OutsideReference> outSideRefList) throws AbstractQingIntegratedException, SQLException {
        for (int i = 0; i < outSideRefList.size(); ++i) {
            OutsideReference outSideRef = outSideRefList.get(i);
            String mapId = outSideRef.getRefToId();
            MapVO mapVO = this.getMapManageDao().getMapPath(mapId);
            if (outSideRef.getRefToFullPath() == null) {
                outSideRef.setRefToFullPath(mapVO.getMapGroupName() + "/" + mapVO.getMapName());
            }
            outSideRef.setRefName(mapVO.getMapName());
        }
    }

    public String saveSchema(String bizTag, String userId, SchemaVO vo) throws AbstractQingIntegratedException, SchemaManagerException, MapNotFoundException {
        SchemaBO bo;
        OpLogActionType opLogActionType;
        SchemaAttrVO attrVO = vo.getSchemaAttr();
        int source = attrVO.getSource();
        ModelBook modelBook = vo.getSchemaContent();
        List outsideRefList = modelBook.pickReferences();
        byte[] fContent = XmlUtil.toByteArray((Element)modelBook.toXml());
        if (attrVO.getfId() == null) {
            boolean isNameExist;
            opLogActionType = OpLogActionType.NEW;
            try {
                isNameExist = this.getSchemaDao().isNameExist(attrVO.getSchemaName(), bizTag, userId, source, attrVO.getSchemaType());
            }
            catch (SQLException e) {
                throw new SchemaManagerException(e);
            }
            if (isNameExist) {
                throw new SchemaNameDuplicateException(attrVO.getSchemaName() + " existed.");
            }
            bo = new SchemaBO();
            attrVO.setfId(this.dbExcuter.genStringId("T_QING_SASchema"));
            SchemaDomain.createBO(attrVO, bizTag, source, bo, userId);
            try {
                this.tx.beginRequired();
                if (attrVO.IsDefault().booleanValue()) {
                    this.getSchemaDao().setNoDefaultSchema(bizTag, userId, source, attrVO.getfId());
                }
                this.saveSchemaRef(outsideRefList, bo.getfId());
                this.getSchemaDao().insertSchema(bo, fContent);
                this.getSchemaDao().insertSchemaRelation(bo);
            }
            catch (AbstractQingIntegratedException e) {
                this.tx.markRollback();
                throw e;
            }
            catch (SQLException e) {
                this.tx.markRollback();
                throw new SchemaManagerException(e);
            }
            finally {
                this.tx.end();
            }
        }
        opLogActionType = OpLogActionType.EDIT;
        try {
            this.tx.beginRequired();
            bo = this.getSchemaDao().findSchemaById(attrVO.getfId());
            if (bo == null) {
                throw new SchemaNotFoundException("schema has been deleted.");
            }
            this.getSchemaDao().deleteSchemaRef(attrVO.getfId());
            this.saveSchemaRef(outsideRefList, attrVO.getfId());
            this.getSchemaDao().updateSchema(attrVO.getfId(), fContent);
            if (PublishUtil.isPublish((String)bo.getBizTag())) {
                this.getPublishInfoDao().updateModifyDate(bo.getBizTag(), userId);
            }
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new SchemaManagerException(e);
        }
        finally {
            this.tx.end();
        }
        if (PublishUtil.isPublish((String)bo.getBizTag())) {
            this.addPublishOpLog(bo, opLogActionType, attrVO);
        } else {
            ArrayList<String> params = new ArrayList<String>(3);
            params.add(attrVO.getSchemaName());
            this.addSchemeOpLog(opLogActionType, bizTag, source, "\u201c$param\u201d", params);
        }
        return attrVO.getfId();
    }

    private void addPublishOpLog(SchemaBO schemaBO, OpLogActionType opLogActionType, SchemaAttrVO attrVO) {
        try {
            SchemeOpLog schemeOpLog = SchemeOpLog.CARD_PUBLISH_LOG_DIR;
            int schemaType = schemaBO.getSchemaType();
            String opLogParam = "\u201c$param\u201d\u7684\u53d1\u5e03\u65b9\u6848\u201c$param\u201d";
            ArrayList<String> params = new ArrayList<String>(4);
            PublishPO publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(schemaBO.getBizTag());
            if (publishPO != null) {
                PublishVO publishVO = null;
                AbstractPublishManageDomain publishManageDomain = PublishManageDomianFactory.getPublishManageDomian((Integer)publishPO.getPublishTargetType(), (QingContext)this.context, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, null);
                if (publishManageDomain != null) {
                    publishVO = publishManageDomain.getPublishVO(schemaBO.getBizTag());
                }
                if (publishVO != null) {
                    if (schemaType == 2) {
                        params.add(publishVO.getName());
                        params.add(attrVO.getSchemaName());
                        params.add(publishVO.getPathText());
                        switch (publishPO.getPublishTargetType()) {
                            case 0: {
                                schemeOpLog = SchemeOpLog.APPMENU_PUBLISH_LOG_DIR;
                                break;
                            }
                            case 1: {
                                schemeOpLog = SchemeOpLog.ANALYSIS_CENTER_PUBLISH_LOG_DIR;
                                break;
                            }
                            case 2: {
                                schemeOpLog = SchemeOpLog.LAPP_PUBLISH_LOG_DIR;
                                break;
                            }
                            case 5: {
                                schemeOpLog = SchemeOpLog.CARD_PUBLISH_LOG_DIR;
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        schemeOpLog.setLogScene("\u53d1\u5e03\u8bb0\u5f55");
                    } else if (schemaType == 1 && publishPO.getPublishTargetType() == 1) {
                        opLogParam = "\u201c$param\u201d";
                        params.add(attrVO.getSchemaName());
                        params.add(publishVO.getPathText() + "/" + publishVO.getName());
                        schemeOpLog = SchemeOpLog.DATA_ANALYSIS_CENTER_SCHEME;
                        schemeOpLog.setLogScene("\u5206\u6790\u65b9\u6848");
                    }
                    schemeOpLog.setParamsDesc(opLogParam);
                    OpLogUtil.addLog((OpLogBO)new OpLogBO(opLogActionType, (IOpLogConstant)schemeOpLog, params));
                }
            }
        }
        catch (Exception e) {
            LogUtil.error((String)"add oplog error at edit publish record", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addSchemeOpLog(OpLogActionType opLogActionType, String bizTag, int source, String opLogParam, List<String> params) {
        try {
            SchemeOpLog schemeOpLog = SchemeOpLog.THEME_SQUARE_SCHEME;
            String regex = "^[0-9]+";
            if (Pattern.matches(regex, bizTag)) {
                ThemePO themePO;
                if (source == SchemaTypeEnum.longer.getType()) {
                    schemeOpLog = SchemeOpLog.THEME_ANALYSIS_SCHEME;
                }
                if ((themePO = this.getThemeDao().getThemeByID(bizTag)) != null) {
                    ThemeGroupVO groupVO = this.getThemeGroupDao().loadThemeGroupByGroupId(themePO.getUserID(), themePO.getGroupID());
                    String groupName = groupVO.getThemeGroupName();
                    params.add(groupName);
                    params.add(themePO.getThemeName());
                }
            } else if (PublishUtil.isPublish((String)bizTag)) {
                PublishPO publishPO = this.getPublishInfoDao().getPublishInfoByInfoId(bizTag);
                if (publishPO == null || publishPO.getPublishTargetType() != 1 && publishPO.getPublishTargetType() != 0) return;
                PublishVO publishVO = null;
                AbstractPublishManageDomain publishManageDomain = PublishManageDomianFactory.getPublishManageDomian((Integer)publishPO.getPublishTargetType(), (QingContext)this.context, (ITransactionManagement)this.tx, (IDBExcuter)this.dbExcuter, null);
                if (publishManageDomain != null) {
                    publishVO = publishManageDomain.getPublishVO(bizTag);
                }
                if (publishVO != null) {
                    params.add(publishVO.getPathText() + "/" + publishVO.getName());
                }
                schemeOpLog = SchemeOpLog.APPMENU_PUBLISH_LOG_DIR;
                if (publishPO.getPublishTargetType() == 1) {
                    schemeOpLog = SchemeOpLog.DATA_ANALYSIS_CENTER_SCHEME;
                }
            } else {
                schemeOpLog = SchemeOpLog.EMBED_DATA_SQUARE_SCHEME;
                if (source == SchemaTypeEnum.longer.getType()) {
                    schemeOpLog = SchemeOpLog.EMBED_DATA_ANALYSIS_SCHEME;
                }
            }
            schemeOpLog.setLogScene("\u5206\u6790\u65b9\u6848");
            schemeOpLog.setParamsDesc(opLogParam);
            OpLogUtil.addLog((OpLogBO)new OpLogBO(opLogActionType, (IOpLogConstant)schemeOpLog, params));
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String saveSchemaWithoutTx(String bizTag, String userId, SchemaVO vo) throws AbstractQingIntegratedException, SchemaManagerException, MapNotFoundException {
        SchemaAttrVO attrVO = vo.getSchemaAttr();
        int source = attrVO.getSource();
        ModelBook modelBook = vo.getSchemaContent();
        List outsideRefList = modelBook.pickReferences();
        byte[] fContent = XmlUtil.toByteArray((Element)modelBook.toXml());
        if (attrVO.getfId() == null) {
            boolean isNameExist;
            try {
                isNameExist = this.getSchemaDao().isNameExist(attrVO.getSchemaName(), bizTag, userId, source, attrVO.getSchemaType());
            }
            catch (SQLException e) {
                throw new SchemaManagerException(e);
            }
            if (isNameExist) {
                throw new SchemaNameDuplicateException(attrVO.getSchemaName() + " existed.");
            }
            SchemaBO bo = new SchemaBO();
            attrVO.setfId(this.dbExcuter.genStringId("T_QING_SASchema"));
            SchemaDomain.createBO(attrVO, bizTag, source, bo, userId);
            try {
                if (attrVO.IsDefault().booleanValue()) {
                    this.getSchemaDao().setNoDefaultSchema(bizTag, userId, source, attrVO.getfId());
                }
                this.saveSchemaRef(outsideRefList, bo.getfId());
                this.getSchemaDao().insertSchema(bo, fContent);
                this.getSchemaDao().insertSchemaRelation(bo);
            }
            catch (AbstractQingIntegratedException e) {
                throw e;
            }
            catch (SQLException e) {
                throw new SchemaManagerException(e);
            }
        }
        try {
            SchemaBO bo = this.getSchemaDao().findSchemaById(attrVO.getfId());
            if (bo == null) {
                throw new SchemaNotFoundException("schema has been deleted.");
            }
            this.getSchemaDao().deleteSchemaRef(attrVO.getfId());
            this.saveSchemaRef(outsideRefList, attrVO.getfId());
            this.getSchemaDao().updateSchema(attrVO.getfId(), fContent);
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new SchemaManagerException(e);
        }
        return attrVO.getfId();
    }

    private void saveSchemaRef(List<OutsideReference> outsideRefList, String schemaId) throws AbstractQingIntegratedException, SQLException, MapNotFoundException {
        for (int i = 0; i < outsideRefList.size(); ++i) {
            OutsideReference outerRef = outsideRefList.get(i);
            String mapId = outerRef.getRefToId();
            if (outerRef.getUid() == null) {
                throw new MapNotFoundException();
            }
            MapVO mapVO = this.getMapManageDao().loadMap(mapId);
            if (mapVO.getMapName() != null) {
                outerRef.setRefToFullPath(null);
            } else {
                outerRef.setRefToId(null);
            }
            this.getSchemaDao().saveSchemaRef(outerRef, schemaId);
        }
    }

    public Boolean setSchemaDefaultAttr(String bizTag, String userId, int source, SchemaAttrVO vo) throws AbstractQingIntegratedException, SchemaManagerException {
        try {
            this.tx.beginRequired();
            if (!this.getSchemaDao().checkUserRelation(vo.getfId(), userId)) {
                SchemaBO schemaBORelation = new SchemaBO();
                schemaBORelation.setfId(vo.getfId());
                schemaBORelation.setUserId(userId);
                schemaBORelation.setIsDefault(true);
                this.getSchemaDao().setNoDefaultSchema(bizTag, userId, source, vo.getfId());
                this.getSchemaDao().insertSchemaRelation(schemaBORelation);
            } else {
                this.getSchemaDao().setSchemaDefaultAttr(bizTag, userId, source, vo.getfId(), vo.IsDefault());
            }
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new SchemaManagerException(e);
        }
        finally {
            this.tx.end();
        }
        return true;
    }

    public boolean checkPublishInfoSource(String bizTag, String userId) throws AbstractQingIntegratedException, SQLException {
        return this.getSchemaDao().checkPublishInfoSource(bizTag, userId);
    }

    public List<SchemaBO> findSchemaByBiztag(String bizTag, String userId, int source, String fId) throws AbstractQingIntegratedException, SQLException {
        List<SchemaBO> schemaByBiztagList = this.getSchemaDao().findSchemaByBiztag(bizTag, userId, source);
        if (fId != null) {
            for (SchemaBO schemaBO : schemaByBiztagList) {
                if (!fId.equals(schemaBO.getfId())) continue;
                schemaByBiztagList.remove(schemaBO);
                break;
            }
        }
        return schemaByBiztagList;
    }

    public SchemaBO findDefaultSchemaInPublish(String bizTag, String userId, int source) throws AbstractQingIntegratedException, SQLException {
        return this.getSchemaDao().findDefaultSchemaInPublish(bizTag, userId, source);
    }

    public Boolean deleteSchema(String fId, String userId) throws AbstractQingIntegratedException, SchemaManagerException {
        SchemaBO schemaBO = new SchemaBO();
        try {
            this.tx.beginRequired();
            schemaBO = this.getSchemaDao().findSchemaById(fId);
            this.getSchemaDao().deleteSchema(fId, userId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new SchemaManagerException(e);
        }
        finally {
            this.tx.end();
        }
        ArrayList<String> params = new ArrayList<String>(3);
        params.add(schemaBO.getSchemaName());
        this.addSchemeOpLog(OpLogActionType.DELETE, schemaBO.getBizTag(), schemaBO.getSource(), "\u201c$param\u201d", params);
        return true;
    }

    public void updatePublishInfoByFid(String bizTag, String userId, String schemaId) throws AbstractQingIntegratedException, SQLException {
        try {
            this.tx.beginRequired();
            this.getSchemaDao().updatePublishInfoByFid(bizTag, userId, schemaId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    public void renameSchema(String fId, String name, String bizTag, int source, String userId, int schemaType) throws AbstractQingIntegratedException, SchemaManagerException {
        String lastName = null;
        try {
            this.tx.beginRequired();
            if (this.getSchemaDao().isNameExist(name, bizTag, userId, source, schemaType).booleanValue()) {
                throw new SchemaNameDuplicateException("name exist");
            }
            SchemaBO schemaBO = this.getSchemaDao().findSchemaById(fId);
            if (schemaBO != null) {
                lastName = schemaBO.getSchemaName();
            }
            this.getSchemaDao().renameSchema(fId, name);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new SchemaManagerException(e);
        }
        finally {
            this.tx.end();
        }
        ArrayList<String> params = new ArrayList<String>(4);
        params.add(lastName);
        params.add(name);
        this.addSchemeOpLog(OpLogActionType.EDIT, bizTag, source, "\u201c$param\u201d\u540d\u79f0\u4e3a\u201c$param\u201d", params);
    }

    public static ModelBook byteToModel(byte[] content) throws PersistentModelParseException, PersistentModelTooModernException {
        try {
            return ModelBookUtil.fromByte(content);
        }
        catch (JDOMException e) {
            throw new PersistentModelParseException((Throwable)e);
        }
        catch (IOException e) {
            throw new PersistentModelParseException((Throwable)e);
        }
    }

    private static void createBO(SchemaAttrVO vo, String bizTag, int source, SchemaBO bo, String userId) {
        if (vo != null) {
            bo.setfId(vo.getfId());
            bo.setSchemaName(vo.getSchemaName());
            bo.setSchemaType(vo.getSchemaType());
            bo.setIsDefault(vo.IsDefault());
            bo.setSeq(vo.getSeq());
        }
        bo.setUserId(userId);
        bo.setBizTag(bizTag);
        bo.setSource(source);
    }

    public void export(IQingFile exportFile, String schemaId) throws AbstractQingIntegratedException, SchemaManagerException {
        try {
            final SchemaBO bo = this.getSchemaDao().findSchemaById(schemaId);
            if (bo == null) {
                throw new SchemaNotFoundException(schemaId + " not found in schema.");
            }
            final List<SchemaContentBO> boList = this.getSchemaDao().getSchemaContent(schemaId);
            exportFile.write(new IWriteCall(){

                public void call(OutputStream outputStream) throws IOException {
                    ISchemaExportStrategy schemaExportStrategy = (ISchemaExportStrategy)CustomStrategyRegistrar.getStrategy(ISchemaExportStrategy.class);
                    schemaExportStrategy.doExport(bo, boList, outputStream);
                }
            }, true);
        }
        catch (IntegratedIOException e) {
            throw e.getCause();
        }
        catch (IOException e) {
            throw new SchemaManagerException(e);
        }
        catch (SQLException e) {
            throw new SchemaManagerException(e);
        }
    }

    public void updateSeq(List<SchemaAttrVO> schemaAttrVOList) throws AbstractQingIntegratedException, SchemaManagerException {
        try {
            this.tx.beginRequired();
            for (int i = 0; i < schemaAttrVOList.size(); ++i) {
                SchemaAttrVO schemaAttrVO = schemaAttrVOList.get(i);
                this.getSchemaDao().updateSchemaSeq(schemaAttrVO.getfId(), schemaAttrVO.getSeq());
            }
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new SchemaManagerException(e);
        }
        finally {
            this.tx.end();
        }
    }

    public void judgePublishOper(String publishId, String dsbPublishId, String isEdit) throws PublishNoOperAuthException, AbstractQingIntegratedException, SQLException {
        if (StringUtils.isNotEmpty((CharSequence)publishId) && !PublishUtil.isPublish((String)publishId) && StringUtils.isEmpty((CharSequence)dsbPublishId)) {
            return;
        }
        try {
            this.getCommonPublishDomain().judgePublishOperAuth(publishId, dsbPublishId, OperCodeEnum.analysis_editable, !"true".equals(isEdit));
        }
        catch (PublishSourcePublishNotExistException e) {
            return;
        }
    }

    public List<SchemaAttrVO> getSchemaAttrByPublishId(String fid, String userId, int source) throws AbstractQingIntegratedException, SQLException {
        try {
            return this.getSchemaDao().getSchemaAttrByPublishId(fid, userId, source);
        }
        catch (AbstractQingIntegratedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
    }

    public boolean judgePublishInfoIsDel(String fId) throws AbstractQingIntegratedException, SQLException {
        return this.getSchemaDao().judgePublishInfoIsDel(fId);
    }

    public boolean judgeUserOfPublishInfoByBizTag(String bizTag, String userId) throws AbstractQingIntegratedException, SQLException {
        String createId = this.getSchemaDao().getUserIdByPublishId(bizTag);
        if (createId != null) {
            return Objects.equals(userId, createId) || Objects.equals(IntegratedHelper.getPresetUserId(), createId);
        }
        return false;
    }

    public String getPublishInfoUserName(String fId, String userId) throws AbstractQingIntegratedException, SQLException {
        String publishUserName = this.getSchemaDao().getPublishInfoUserName(fId, userId);
        if ("".equals(publishUserName)) {
            String customerId = this.getSchemaDao().getUserIdByPublishId(fId);
            publishUserName = IntegratedHelper.getUserName((QingContext)this.context, (IDBExcuter)this.dbExcuter, (String)customerId);
        }
        return publishUserName;
    }

    public boolean checkCusotmRoleInfo(Set<String> RoleIds, String bizTag) throws AbstractQingIntegratedException, SQLException {
        List<String> allAuthorizeRoleList = this.getSchemaDao().getAllAuthorizeRole(bizTag);
        if (allAuthorizeRoleList.size() > 0) {
            for (String role : RoleIds) {
                for (String allAuthorizeRole : allAuthorizeRoleList) {
                    if (!Objects.equals(role, allAuthorizeRole)) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean checkPublishPlanIsDel(SchemaAttrVO schemaAttrVO) throws AbstractQingIntegratedException, SQLException {
        return this.getSchemaDao().findSchemaById(schemaAttrVO.getfId()) == null;
    }

    public Map<String, String> checkPublishInfoAndPermission(String bizTag, String modelJsonString, String userId) throws AbstractQingIntegratedException, SQLException {
        HashMap<String, String> checkResult = new HashMap<String, String>(2);
        List<String> publishInfo = this.checkPublishSourceToTheme(bizTag);
        if (publishInfo != null) {
            String publishSourceToTheme = publishInfo.get(0);
            String fCarryData = publishInfo.get(1);
            if (publishSourceToTheme != null && !PublishUtil.isPublish((String)publishSourceToTheme) && "0".equals(fCarryData)) {
                boolean checkThemeIsDelByFid;
                String lastBizTagByFId = this.getLastBizTagByFId(bizTag);
                if (lastBizTagByFId == null) {
                    lastBizTagByFId = this.getThemeIdByBizTag(bizTag);
                }
                if (checkThemeIsDelByFid = this.checkThemeIsDelByFid(lastBizTagByFId)) {
                    checkResult.put("publishInfoPerCheck", "Theme is Delete");
                }
            }
        }
        if (checkResult.size() == 0) {
            if (!this.judgePublishInfoIsDel(bizTag)) {
                checkResult.put("publishInfoPerCheck", "PublishInfo Not Exist");
            } else {
                boolean isPublishPerson = this.judgeUserOfPublishInfoByBizTag(bizTag, userId);
                if (isPublishPerson) {
                    this.checkPublishSchema(modelJsonString, checkResult);
                } else {
                    Set RoleIds = IntegratedHelper.getUserRoleIds((QingContext)this.context, (IDBExcuter)this.dbExcuter, (String)userId);
                    boolean cusotmRoleInfo = this.checkCusotmRoleInfo(RoleIds, bizTag);
                    if (!cusotmRoleInfo) {
                        String publishUserName = this.getPublishInfoUserName(bizTag, userId);
                        if (publishUserName == null) {
                            this.checkPublishSchema(modelJsonString, checkResult);
                        } else {
                            checkResult.put("publishInfoPerCheck", "Not Permission");
                            checkResult.put("publishInfoUserName", publishUserName);
                        }
                    } else {
                        this.checkPublishSchema(modelJsonString, checkResult);
                    }
                }
            }
        }
        return checkResult;
    }

    public void checkPublishSchema(String modelJsonString, Map<String, String> checkResult) throws AbstractQingIntegratedException, SQLException {
        if (modelJsonString != null) {
            SchemaAttrVO schemaAttrVO = (SchemaAttrVO)JsonUtil.decodeFromString((String)modelJsonString, SchemaAttrVO.class);
            boolean planIsDel = this.checkPublishPlanIsDel(schemaAttrVO);
            if (planIsDel) {
                checkResult.put("publishInfoPerCheck", "Publish Not Exist");
            } else {
                checkResult.put("publishInfoPerCheck", "success");
            }
        } else {
            checkResult.put("publishInfoPerCheck", "success");
        }
    }

    public String getDefaultSchemaFid(String bizTag, int source, String userId) throws AbstractQingIntegratedException, SQLException {
        String fId = this.getSchemaDao().getDefaultPlanFidByUserId(bizTag, userId, source, false);
        if (fId == null) {
            fId = this.getSchemaDao().getDefaultPlanFidByUserId(bizTag, "SystemUser", source, true);
        }
        return fId;
    }

    public String getLastBizTagByFId(String bizTag) throws AbstractQingIntegratedException, SQLException {
        return this.getSchemaDao().getLastBizTagByFId(bizTag);
    }

    public String getThemeIdByBizTag(String bizTag) throws AbstractQingIntegratedException, SQLException {
        return this.getSchemaDao().getThemeIdByBizTag(bizTag);
    }

    public List<String> getPublishedRecordNameByInputText(String userId, String inputText, String publishSourceType, String publishTargetType) throws AbstractQingIntegratedException, SQLException {
        List<String> allPublishedRecordName;
        boolean isDashboardOrExtreport = PublishSourceEnum.dashboard.toString().equals(publishSourceType) || PublishSourceEnum.extreport.toString().equals(publishSourceType);
        List<String> list = allPublishedRecordName = !isDashboardOrExtreport ? this.getSchemaDao().getTargetAllPublishedRecordName(userId, publishTargetType) : this.getSchemaDao().getAllPublishedRecordName(userId, publishSourceType, publishTargetType);
        if (allPublishedRecordName.size() > 0) {
            ArrayList<String> fuzzyPublishedName = new ArrayList<String>(allPublishedRecordName.size());
            for (int i = 0; i < allPublishedRecordName.size(); ++i) {
                String publishedName = allPublishedRecordName.get(i);
                if (publishedName.indexOf(inputText) <= -1) continue;
                fuzzyPublishedName.add(publishedName);
            }
            return fuzzyPublishedName.size() > 0 ? fuzzyPublishedName : null;
        }
        return null;
    }

    public List<String> checkPublishSourceToTheme(String bizTag) throws AbstractQingIntegratedException, SQLException {
        return this.getSchemaDao().checkPublishSourceToTheme(bizTag);
    }

    public boolean checkThemeIsDelByFid(String lastBizTagByFId) throws AbstractQingIntegratedException, SQLException {
        return this.getSchemaDao().checkThemeIsDelByFid(lastBizTagByFId);
    }

    public void updatePublishInfoByBiztag(String bizTag, String userId, String defaultSchemaId) throws SchemaManagerException, AbstractQingIntegratedException {
        try {
            this.tx.beginRequired();
            this.getSchemaDao().updatePublishInfoByFid(bizTag, userId, defaultSchemaId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new SchemaManagerException(e);
        }
        finally {
            this.tx.end();
        }
    }

    public boolean judgeSchemaIsDel(String schemaId) throws AbstractQingIntegratedException, SQLException {
        return this.getSchemaDao().judgeSchemaIsDel(schemaId);
    }
}

