/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.subject.dao.impl;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.ModelPersistenceException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.source.IFileSavable;
import com.kingdee.bos.qing.data.model.vo.RecentUsedSources;
import com.kingdee.bos.qing.data.model.vo.Sources;
import com.kingdee.bos.qing.data.util.SourceFactory;
import com.kingdee.bos.qing.manage.dao.IThemeDao;
import com.kingdee.bos.qing.manage.dao.impl.ThemeDaoImpl;
import com.kingdee.bos.qing.manage.exception.EncryptedLicenseCheckException;
import com.kingdee.bos.qing.publish.dao.PublishSubjectModelDao;
import com.kingdee.bos.qing.subject.dao.BoxSerializationUtil;
import com.kingdee.bos.qing.subject.dao.ISubjectDao;
import com.kingdee.bos.qing.subject.model.SubjectDataBO;
import com.kingdee.bos.qing.util.BoxUtil;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jdom2.Element;

public class SubjectDaoImpl
implements ISubjectDao {
    private static final int BLOB_SIZE = 32768;
    private IDBExcuter dbExcuter;
    private static final int RECENT_SOURCE_SHOW_COUNT = 4;
    private IThemeDao themeDao;
    private PublishSubjectModelDao publishSubjectModelDao;

    private IThemeDao getThemeDao() {
        if (this.themeDao == null) {
            this.themeDao = new ThemeDaoImpl(this.dbExcuter);
        }
        return this.themeDao;
    }

    public SubjectDaoImpl(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    private PublishSubjectModelDao getPublishSubjectModelDao() {
        if (this.publishSubjectModelDao == null) {
            this.publishSubjectModelDao = new PublishSubjectModelDao(this.dbExcuter);
        }
        return this.publishSubjectModelDao;
    }

    @Override
    public void saveSubjectModel(String themeID, Box box, InputStream boxModelOrignalStream) throws AbstractQingIntegratedException, SQLException, EncryptedLicenseCheckException, ModelPersistenceException {
        InputStream dbStream = this.loadSubjectModelStreamByThemeID(themeID);
        byte[] boxModelBytes = BoxSerializationUtil.toBytes(box, boxModelOrignalStream, dbStream);
        if (boxModelBytes == null) {
            return;
        }
        int length = boxModelBytes.length;
        if (length > 0) {
            byte[] modelStartByte = new byte[1];
            System.arraycopy(boxModelBytes, 0, modelStartByte, 0, 1);
            try {
                String magicFlag = new String(modelStartByte, "UTF-8");
                if (!"<".equals(magicFlag)) {
                    this.getThemeDao().updateThemeEncryptedStatus(themeID, 1);
                }
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
            this.dbExcuter.execute("DELETE FROM T_QING_THEME_DATA WHERE FTHEMEID=?", new Object[]{themeID});
            this.dbExcuter.execute("DELETE FROM T_QING_Theme_Model WHERE FThemeID=?", new Object[]{themeID});
            int count = length % 32768 == 0 ? length / 32768 : length / 32768 + 1;
            int contentSize = 0;
            int offset = 0;
            ArrayList<Object[]> params = new ArrayList<Object[]>(count);
            for (int i = 0; i < count; ++i) {
                contentSize = length - i * 32768 > 32768 ? 32768 : length - i * 32768;
                int index = 0;
                Object[] param = new Object[4];
                param[index++] = UUID.randomUUID().toString();
                param[index++] = themeID;
                param[index++] = i;
                param[index++] = this.dbExcuter.createSqlParameterBytes(boxModelBytes, offset, contentSize);
                offset += contentSize;
                params.add(param);
            }
            this.dbExcuter.executeBatch("INSERT INTO T_QING_Theme_Model (FID,FThemeID,FContentIndex,FContent) VALUES(?,?,?,?)", params);
        }
        this.dbExcuter.execute("DELETE FROM T_QING_THEME_DATA_FILE WHERE FTHEMEID = ?", new Object[]{themeID});
        this.dbExcuter.execute("DELETE FROM T_QING_THEME_DATA WHERE FTHEMEID=?", new Object[]{themeID});
    }

    @Override
    public InputStream loadSubjectModelStreamByThemeID(String themeID) throws AbstractQingIntegratedException, SQLException {
        byte[] content = (byte[])this.dbExcuter.query("SELECT FContent FROM T_QING_THEME_MODEL WHERE FTHEMEID=? ORDER BY FCONTENTINDEX ASC", new Object[]{themeID}, (ResultHandler)new ResultHandler<byte[]>(){

            public byte[] handle(ResultSet rs) throws SQLException {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                while (rs.next()) {
                    try {
                        outputStream.write(rs.getBytes("FContent"));
                    }
                    catch (IOException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                }
                if (outputStream.size() > 0) {
                    return outputStream.toByteArray();
                }
                return null;
            }
        });
        return BoxUtil.parseByteToInputStream(content);
    }

    @Override
    public void deleteSubject(String themeID) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_Theme_Model WHERE FThemeID=?", new Object[]{themeID});
        this.dbExcuter.execute("DELETE FROM T_QING_THEME_DATA_FILE WHERE FTHEMEID = ?", new Object[]{themeID});
        this.dbExcuter.execute("DELETE FROM T_QING_THEME_DATA WHERE FTHEMEID=?", new Object[]{themeID});
        this.dbExcuter.execute("DELETE FROM T_QING_THEME_SCHEDULE_BOX WHERE FTHEMEID=?", new Object[]{themeID});
    }

    @Override
    public void deleteSubjectData(String dataId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_THEME_DATA WHERE FID=?", new Object[]{dataId});
        this.dbExcuter.execute("DELETE FROM T_QING_THEME_SCHEDULE_BOX WHERE FID=?", new Object[]{dataId});
        this.dbExcuter.execute("DELETE FROM T_QING_THEME_DATA_FILE WHERE FTHEMEDATAID=?", new Object[]{dataId});
    }

    @Override
    public void deleteSubjectDataByThemeId(String themeId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_THEME_DATA_FILE WHERE FTHEMEID = ?", new Object[]{themeId});
        this.dbExcuter.execute("DELETE FROM T_QING_THEME_DATA WHERE FTHEMEID=?", new Object[]{themeId});
    }

    @Override
    public Box loadSubjectModelIncludePreset(String userID, String themeID) throws AbstractQingIntegratedException, SQLException, ModelParseException, EncryptedLicenseCheckException {
        InputStream content = this.loadSubjectModelStream(userID, themeID);
        if (content == null) {
            return null;
        }
        return BoxSerializationUtil.toModel(content, true);
    }

    @Override
    public RecentUsedSources loadUserRecentUsedSourceList(String userId, final Sources needexcludeSources, final boolean showMoreFlag) throws AbstractQingIntegratedException, SQLException, ModelParseException {
        return (RecentUsedSources)this.dbExcuter.query("SELECT TS.FCONTENT FROM T_QING_RECENT_USED_SOURCE TS WHERE TS.FUSERID = ? ORDER BY TS.FCREATETIME DESC", new Object[]{userId}, (ResultHandler)new ResultHandler<RecentUsedSources>(){

            public RecentUsedSources handle(ResultSet rs) throws SQLException {
                RecentUsedSources recentUsedSources = new RecentUsedSources();
                Set needexcludeSourceHashCodeSet = needexcludeSources.getSourceHashCodeSet();
                ArrayList recentSourceList = new ArrayList();
                HashSet hashCodeSet = new HashSet();
                while (rs.next()) {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    try {
                        outputStream.write(rs.getBytes("FContent"));
                    }
                    catch (IOException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                    if (outputStream.size() <= 0) continue;
                    SubjectDaoImpl.this.getUserRecentUesdSource(outputStream, recentSourceList, hashCodeSet, needexcludeSourceHashCodeSet, showMoreFlag, recentUsedSources);
                    if (!recentUsedSources.isShowMoreFlag()) continue;
                    break;
                }
                recentUsedSources.setSources(recentSourceList);
                return recentUsedSources;
            }
        });
    }

    private void getUserRecentUesdSource(ByteArrayOutputStream outputStream, List<AbstractSource> recentSourceList, Set<String> hashCodeSet, Set<String> needexcludeSourceHashCodeSet, boolean showMoreFlag, RecentUsedSources recentUsedSources) throws SQLException {
        try {
            Element model = XmlUtil.loadRootElement((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
            AbstractSource source = SourceFactory.instanceFromXml((Element)model);
            source.fromXml(model);
            String hashCode = source.getSourceHashCode();
            if (!hashCodeSet.contains(hashCode) && !needexcludeSourceHashCodeSet.contains(hashCode)) {
                if (showMoreFlag) {
                    recentSourceList.add(source);
                } else {
                    if (recentSourceList.size() == 4) {
                        recentUsedSources.setShowMoreFlag(true);
                        return;
                    }
                    recentSourceList.add(source);
                }
            }
            hashCodeSet.add(hashCode);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean getFromToUserRecentUsedSourceFlag(String userId, String themeId, String hashCode, final String newPath) throws AbstractQingIntegratedException, SQLException {
        return (Boolean)this.dbExcuter.query("SELECT TS.FCONTENT FROM T_QING_RECENT_USED_SOURCE TS WHERE TS.FUSERID = ? AND TS.FTHEMEID != ? AND TS.FHASHCODE =?", new Object[]{userId, themeId, hashCode}, (ResultHandler)new ResultHandler<Boolean>(){
            private boolean fromToUserRecentUsedSourceFlag = false;

            public Boolean handle(ResultSet rs) throws SQLException {
                AbstractSource source = null;
                while (rs.next()) {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    try {
                        outputStream.write(rs.getBytes("FContent"));
                    }
                    catch (IOException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                    if (outputStream.size() <= 0) continue;
                    try {
                        Element model = XmlUtil.loadRootElement((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
                        source = SourceFactory.instanceFromXml((Element)model);
                        source.fromXml(model);
                        if (!newPath.equals(((IFileSavable)source).getFileUrl())) continue;
                        this.fromToUserRecentUsedSourceFlag = true;
                        break;
                    }
                    catch (Exception e) {
                        throw new SQLException(e);
                    }
                }
                return this.fromToUserRecentUsedSourceFlag;
            }
        });
    }

    @Override
    public void saveUserRecentUsedSource(String userId, List<AbstractSource> sources, String themeId) throws AbstractQingIntegratedException, SQLException {
        Date createTime = new Date();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (AbstractSource source : sources) {
            AbstractSource recentUsedSource = source.cloneUserRecentUsedSource();
            byte[] boxModelBytes = XmlUtil.toByteArray((Element)recentUsedSource.toXml());
            int length = boxModelBytes.length;
            if (length <= 0) continue;
            Object[] param = new Object[6];
            String fId = this.dbExcuter.genStringId("T_QING_RECENT_USED_SOURCE");
            param[0] = fId;
            param[1] = userId;
            param[2] = this.dbExcuter.createSqlParameterBytes(boxModelBytes, 0, length);
            param[3] = recentUsedSource.getSourceHashCode();
            param[4] = createTime;
            param[5] = themeId;
            params.add(param);
        }
        this.dbExcuter.executeBatch("INSERT INTO T_QING_RECENT_USED_SOURCE (FID,FUSERID,FCONTENT,FHASHCODE,FCREATETIME,FTHEMEID) VALUES(?,?,?,?,?,?)", params);
    }

    @Override
    public void deleteUserRecentUsedSources(Set<String> haveDeletedSourceSet, String userId, String themeId) throws AbstractQingIntegratedException, SQLException {
        for (String hashCode : haveDeletedSourceSet) {
            this.dbExcuter.execute("DELETE FROM T_QING_RECENT_USED_SOURCE WHERE FUSERID = ? AND FHASHCODE = ? AND FTHEMEID = ?", new Object[]{userId, hashCode, themeId});
        }
    }

    @Override
    public String saveSubjectDataBO(String userId, SubjectDataBO subjectDataBO) throws AbstractQingIntegratedException, SQLException {
        String themeID = subjectDataBO.getThemeID();
        String dataID = this.dbExcuter.genStringId("T_QING_Theme_Data");
        this.dbExcuter.execute("INSERT INTO T_QING_THEME_DATA (FID, FThemeID, FUserId, FCREATEDATE,FMODIFYDATE) VALUES (?,?,?,?,?)", new Object[]{dataID, themeID, userId, subjectDataBO.getCreateTime(), subjectDataBO.getUpdateTime()});
        String boxFileName = subjectDataBO.getBoxModelFile();
        if (null != boxFileName) {
            this.dbExcuter.execute("INSERT INTO T_QING_THEME_SCHEDULE_BOX (FID, FThemeID, FUserId, FCREATEDATE,FBOXFILE) VALUES (?,?,?,?,?)", new Object[]{dataID, themeID, userId, subjectDataBO.getCreateTime(), subjectDataBO.getBoxModelFile()});
        }
        Map<String, String> dataFiles = subjectDataBO.getDataFile();
        ArrayList<Object[]> params = new ArrayList<Object[]>(dataFiles.size());
        String[] fIDs = this.dbExcuter.genStringId("T_QING_Theme_Data_File", dataFiles.size());
        int index = 0;
        for (Map.Entry<String, String> entryName : dataFiles.entrySet()) {
            String fID = fIDs[index++];
            String dataPath = dataFiles.get(entryName.getKey());
            params.add(new Object[]{fID, dataID, themeID, entryName.getKey(), dataPath});
        }
        this.dbExcuter.executeBatch("INSERT INTO T_QING_Theme_Data_File (FID, FThemeDataID, FThemeID, FEntityName, FDataPath) VALUES (?,?,?,?,?)", params);
        return dataID;
    }

    @Override
    public SubjectDataBO findNewData(String userID, String themeId) throws AbstractQingIntegratedException, SQLException {
        SubjectDataBO dataBO = (SubjectDataBO)this.dbExcuter.query("SELECT FID,FCREATEDATE FROM T_QING_THEME_DATA WHERE FTHEMEID=? AND FUSERID = ? ORDER BY FCREATEDATE DESC", new Object[]{themeId, userID}, (ResultHandler)new ResultHandler<SubjectDataBO>(){

            public SubjectDataBO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    SubjectDataBO subjectDataBO = new SubjectDataBO();
                    subjectDataBO.setId(rs.getString("FID"));
                    subjectDataBO.setCreateTime(rs.getTimestamp("FCREATEDATE"));
                    return subjectDataBO;
                }
                return null;
            }
        });
        if (dataBO == null) {
            return null;
        }
        dataBO.setThemeID(themeId);
        Map<String, String> dataPathMap = this.findDataPathMap(dataBO.getId());
        dataBO.setDataFile(dataPathMap);
        String boxFile = this.findScheduleBoxFileByDataID(dataBO.getId());
        dataBO.setBoxModelFile(boxFile);
        return dataBO;
    }

    public SubjectDataBO findData(String themeId, String dataId) throws AbstractQingIntegratedException, SQLException {
        Boolean dataExist = (Boolean)this.dbExcuter.query("SELECT FID,FCREATEDATE FROM T_QING_Theme_Data WHERE FID=? ORDER BY FCREATEDATE DESC", new Object[]{dataId}, (ResultHandler)new ResultHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
        if (!dataExist.booleanValue()) {
            return null;
        }
        SubjectDataBO dataBO = new SubjectDataBO();
        dataBO.setId(dataId);
        dataBO.setThemeID(themeId);
        Map<String, String> dataPathMap = this.findDataPathMap(dataBO.getId());
        dataBO.setDataFile(dataPathMap);
        String boxFile = this.findScheduleBoxFileByDataID(dataBO.getId());
        dataBO.setBoxModelFile(boxFile);
        return dataBO;
    }

    private String findScheduleBoxFileByDataID(String dataId) throws AbstractQingIntegratedException, SQLException {
        return (String)this.dbExcuter.query("SELECT FBoxFile FROM T_QING_THEME_SCHEDULE_BOX WHERE FID=?", new Object[]{dataId}, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString("FBoxFile");
                }
                return null;
            }
        });
    }

    @Override
    public Map<String, String> findDataPathMap(String dataId) throws AbstractQingIntegratedException, SQLException {
        return (Map)this.dbExcuter.query("SELECT FEntityName,FDataPath FROM T_QING_Theme_Data_File WHERE FThemeDataID=?", new Object[]{dataId}, (ResultHandler)new ResultHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> dataPathMap = new HashMap<String, String>(16);
                while (rs.next()) {
                    String entityName = rs.getString("FEntityName");
                    String dataPath = rs.getString("FDataPath");
                    dataPathMap.put(entityName, dataPath);
                }
                return dataPathMap;
            }
        });
    }

    @Override
    public List<String> findAllSubjectDataIds(String userId, String themeId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID FROM T_QING_THEME_DATA WHERE FUSERID = ? and FTHEMEID=? ORDER BY FCREATEDATE DESC";
        Object[] param = new Object[]{userId, themeId};
        return (List)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> ids = new ArrayList<String>(10);
                while (rs.next()) {
                    ids.add(rs.getString("FID"));
                }
                return ids;
            }
        });
    }

    @Override
    public List<String> findAllDataPath(String themeId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FEntityName,FDataPath FROM T_QING_Theme_Data_File WHERE FThemeID=?", new Object[]{themeId}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> dataPathMap = new ArrayList<String>(10);
                while (rs.next()) {
                    String dataPath = rs.getString("FDataPath");
                    dataPathMap.add(dataPath);
                }
                return dataPathMap;
            }
        });
    }

    @Override
    public String findScheduleBoxFile(String themeId) throws AbstractQingIntegratedException, SQLException {
        return (String)this.dbExcuter.query("SELECT FBoxFile FROM T_QING_THEME_SCHEDULE_BOX WHERE FThemeID=?", new Object[]{themeId}, (ResultHandler)new ResultHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    String boxFile = rs.getString("FBoxFile");
                    return boxFile;
                }
                return null;
            }
        });
    }

    @Override
    public InputStream loadSubjectModelStream(String userID, String themeID) throws AbstractQingIntegratedException, SQLException {
        byte[] content = (byte[])this.dbExcuter.query("SELECT MODEL.FContent FROM T_QING_THEME_MODEL MODEL LEFT JOIN T_QING_THEME THEME ON MODEL.FTHEMEID = THEME.FID Where (THEME.FUserID=? or THEME.FUserID=?) AND THEME.FID=? ORDER BY MODEL.FCONTENTINDEX ASC", new Object[]{userID, IntegratedHelper.getPresetUserId(), themeID}, (ResultHandler)new ResultHandler<byte[]>(){

            public byte[] handle(ResultSet rs) throws SQLException {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                while (rs.next()) {
                    try {
                        outputStream.write(rs.getBytes("FContent"));
                    }
                    catch (IOException e) {
                        LogUtil.error((String)e.getMessage(), (Throwable)e);
                    }
                }
                if (outputStream.size() > 0) {
                    return outputStream.toByteArray();
                }
                return null;
            }
        });
        return BoxUtil.parseByteToInputStream(content);
    }
}

