/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.qing.common.cache.BoxFileNameCache;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.jdom2.Element;

public class BoxUtil {
    public static InputStream getBoxStreamByFileName(String filename, AbstractQingFileType fileType) throws IOException {
        IQingFileVisitor fileVisitor = FileFactory.newFileVisitor((AbstractQingFileType)fileType, (String)filename);
        if (fileVisitor == null) {
            return null;
        }
        try {
            return fileVisitor.getInputStream();
        }
        catch (IOException e) {
            LogUtil.error((String)"BoxUtil.getBoxBytesByFileName error:", (Throwable)e);
            throw new IOException(e);
        }
    }

    private static byte[] parseInputStream2Byte(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (null == inputStream) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[10240];
        int n = 0;
        try {
            while (-1 != (n = inputStream.read(buffer))) {
                output.write(buffer, 0, n);
            }
            byArray = output.toByteArray();
        }
        catch (IOException e) {
            try {
                LogUtil.error((String)"BoxUtil.parseInputStream2Byte error:", (Throwable)e);
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputStream});
        return byArray;
    }

    public static InputStream parseByteToInputStream(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public static byte[] parseXml2Byte(Element xml) throws IOException {
        if (xml == null) {
            return null;
        }
        return XmlUtil.toByteArray((Element)xml);
    }

    public static void cacheBoxStream(InputStream boxStream) {
        BoxFileNameCache boxFileNameCache = new BoxFileNameCache();
        IQingFile qingTempFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
        try {
            qingTempFile.write((IWriteCall)new CopyWriteCall(boxStream, false), true);
        }
        catch (IOException e) {
            LogUtil.error((String)"BoxUtil.cacheBoxStream error:", (Throwable)e);
        }
        boxFileNameCache.setFilename(qingTempFile.getName());
        BoxFileNameCache.setCache(boxFileNameCache);
    }

    public static InputStream getCacheBoxStream() {
        String filename;
        BoxFileNameCache boxFileNameCache = BoxFileNameCache.getCache();
        if (boxFileNameCache != null && (filename = boxFileNameCache.getFilename()) != null) {
            try {
                return BoxUtil.parseByteToInputStream(FileFactory.getFileContent((AbstractQingFileType)QingTempFileType.EXPORT, (String)filename));
            }
            catch (IOException e) {
                LogUtil.error((String)"BoxUtil.getCacheBoxStream error:", (Throwable)e);
            }
        }
        return null;
    }

    public static void clearBoxFileCache() {
        BoxFileNameCache boxFileNameCache = BoxFileNameCache.getCache();
        if (boxFileNameCache != null) {
            FileFactory.clearTempFile((QingTempFileType)QingTempFileType.EXPORT, (String)boxFileNameCache.getFilename());
        }
    }
}

