/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.IWfJobHandler;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.core.JobDefCache;
import com.kingdee.bos.service.job.core.JobEvent;
import com.kingdee.bos.service.job.core.JobGardian;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.JobSignal;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.core.ReadyJobs;
import com.kingdee.bos.service.job.core.RunningJobs;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.service.job.util.ICacheElement;
import com.kingdee.bos.service.job.util.IHeapElement;
import com.kingdee.bos.service.job.util.IListener;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.job.util.Serialization;
import com.kingdee.bos.service.job.wrapper.SqlExecutor;
import com.kingdee.bos.util.md5;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public final class Job
implements ICacheElement,
IHeapElement,
Serializable {
    private static final long serialVersionUID = 6774042140483722689L;
    public static final String GLOBAL_MUTEX_PREFIX = "G::";
    public static final String SYSTEM_JOB_TITLE_PREFIX = "~";
    private static Logger log = Logger.getLogger((String)Job.class.getName());
    private String id;
    private String title;
    private Context ctx;
    private Date createdTime;
    private Date scheduledTime;
    private Date expiredTime;
    private volatile Date startedTime;
    private Date finishTime;
    private JobState priorState;
    private JobState state;
    private Date stateChangedTime;
    private Object parameters;
    private Object result;
    private String exception;
    private JobDef def;
    private String defId;
    private JobInstanceConfig dyn;
    private String isolationBoundary;
    private int hashCode;
    private String priorJobId;
    private String serviceType;
    private HashMap<String, List<IListener>> listeners = new HashMap();
    private String progress = null;
    private boolean isPersistent;
    private JobSignal signal;
    private volatile String holderId;
    private boolean isSmall;
    private int finishFailedCount = 0;
    private volatile transient Thread thread;

    public Job(Context ctx, JobDef def, String title, Object parameters) {
        this(ctx, title, def, parameters, new Timestamp(System.currentTimeMillis()));
    }

    public Job(Context ctx, String title, JobDef def, Object parameters, Timestamp scheduledTime) {
        this.isPersistent = def.isPersistent;
        this.init(ctx, title, def, null, parameters, scheduledTime, null, -1, null);
    }

    public Job(Context ctx, String title, JobInstanceConfig dyn, Object parameters) {
        this(ctx, title, dyn, parameters, new Timestamp(System.currentTimeMillis()));
    }

    public Job(String id, Context ctx, String title, JobInstanceConfig dyn, Object parameters) {
        this(ctx, title, dyn, parameters, new Timestamp(System.currentTimeMillis()));
        if (!dyn.isPersistent) {
            throw new IllegalArgumentException("Job must be persistent.");
        }
        this.id = id;
    }

    public Job(Context ctx, String title, JobInstanceConfig dyn, Object parameters, Timestamp scheduledTime) {
        this.isPersistent = dyn.isPersistent;
        this.init(ctx, title, null, dyn, parameters, scheduledTime, null, -1, null);
    }

    public Job(Context ctx, IJobHandler handler, Object parameters) {
        this(ctx, handler, parameters, true);
    }

    public Job(Context ctx, IJobHandler handler, Object parameters, boolean isPersistent) {
        this(ctx, null, handler, parameters, isPersistent, true);
    }

    public Job(Context ctx, String title, IJobHandler handler, Object parameters, boolean isPersistent, boolean isSmall) {
        this(ctx, title, handler, parameters, isPersistent, isSmall, 500);
    }

    public Job(Context ctx, String title, IJobHandler handler, Object parameters, boolean isPersistent, boolean isSmall, int priority) {
        JobInstanceConfig dyn = new JobInstanceConfig(handler, isPersistent, isSmall, priority);
        this.init(ctx, title, null, dyn, parameters, new Timestamp(System.currentTimeMillis()), null, -1, null);
    }

    public Job(Context ctx, String title, JobInstanceConfig dyn, Object parameters, Timestamp scheduledTime, Timestamp expiredTime, int hashCode) {
        this.isPersistent = dyn.isPersistent;
        this.init(ctx, title, null, dyn, parameters, scheduledTime, null, hashCode, null);
    }

    public Job(Context ctx, String title, JobInstanceConfig dyn, Object parameters, Timestamp scheduledTime, Timestamp expiredTime, int hashCode, String isolationBoundary) {
        this.isPersistent = dyn.isPersistent;
        this.init(ctx, title, null, dyn, parameters, scheduledTime, null, hashCode, isolationBoundary);
    }

    public Job(Context ctx, String title, JobDef def, Object parameters, Timestamp scheduledTime, Timestamp expiredTime, int hashCode, String priorJobId) {
        this.isPersistent = def.isPersistent;
        this.priorJobId = priorJobId;
        this.init(ctx, title, def, null, parameters, scheduledTime, expiredTime, hashCode, null);
    }

    public Job(Context ctx, String title, JobDef def, Object parameters, Timestamp scheduledTime, Timestamp expiredTime, int hashCode, String priorJobId, String isolationBoundary) {
        this.isPersistent = def.isPersistent;
        this.priorJobId = priorJobId;
        this.init(ctx, title, def, null, parameters, scheduledTime, expiredTime, hashCode, isolationBoundary);
    }

    private void init(Context ctx, String title, JobDef def, JobInstanceConfig dyn, Object parameters, Timestamp scheduledTime, Timestamp expiredTime, int hashCode, String isolationBoundary) {
        this.id = Uuid.randomUUID().toString() + "BGJOBINS";
        this.ctx = ctx;
        this.title = title;
        this.dyn = dyn;
        this.parameters = parameters;
        this.scheduledTime = scheduledTime;
        this.expiredTime = expiredTime;
        this.def = def;
        this.createdTime = new Timestamp(System.currentTimeMillis());
        String tmp = this.getMutex();
        if (tmp != null && tmp.startsWith(GLOBAL_MUTEX_PREFIX)) {
            md5 md = new md5(tmp, "UTF-8");
            md.processString();
            int h = md.getStringDigest().hashCode();
            if (h == Integer.MIN_VALUE) {
                h = 1;
            }
            hashCode = Math.abs(h) + 1;
        }
        this.hashCode = hashCode >= 0 ? hashCode % 1999 + 0 : Configuration.randomGenerator().next();
        if (def != null) {
            this.isSmall = def.isSmallJob;
            this.isPersistent = def.isPersistent;
            this.serviceType = def.serviceType;
        } else if (dyn != null) {
            this.isSmall = dyn.isSmallJob;
            this.isPersistent = dyn.isPersistent;
            this.serviceType = dyn.serviceType;
        }
        if (this.isPersistent) {
            String serversByServiceType;
            if (!StringUtils.isEmpty((String)isolationBoundary)) {
                this.isolationBoundary = isolationBoundary.startsWith("cluster@") ? (isolationBoundary = isolationBoundary.substring("cluster@".length())) : (Configuration.serviceInstanceIdGenerator().getServerId().equals(isolationBoundary) || Configuration.serviceInstanceIdGenerator().getNewServerId().equals(isolationBoundary) ? isolationBoundary : ClusterStateManager.validate(ctx, isolationBoundary));
            } else if (!StringUtils.isEmpty((String)this.serviceType) && !StringUtils.isEmpty((String)(serversByServiceType = this.getServersByServiceType(this.serviceType)))) {
                String[] strings = serversByServiceType.split(",");
                ArrayList<String> serverList = new ArrayList<String>(Arrays.asList(strings));
                this.isolationBoundary = this.getRandomServer(serverList);
            }
            if (this.isolationBoundary == null) {
                this.isolationBoundary = this.getIsolationLevel().getJobIsolationBoundary();
            }
        }
        this.mergeListeners();
    }

    private String getRandomServer(List<String> serverList) {
        if (serverList == null || serverList.size() <= 0) {
            return null;
        }
        Random random = new Random();
        int index = random.nextInt(serverList.size());
        String validate = ClusterStateManager.validate(this.ctx, serverList.get(index));
        if (validate == null) {
            serverList.remove(index);
            return this.getRandomServer(serverList);
        }
        return validate;
    }

    public String getServersByServiceType(String serviceType) {
        String servers = null;
        if (!StringUtils.isEmpty((String)serviceType)) {
            String sql = "select fservers from T_JOB_SERVERCONFIG WITH(READPAST) where fservicetype= ? ";
            int[] types = new int[]{12};
            Object[] params = new Object[]{serviceType};
            try {
                ArrayList result = SQL.executeQuery(this.ctx, sql, types, params);
                if (result.size() != 0) {
                    Map map = (Map)result.get(0);
                    servers = (String)map.get("fservers");
                }
            }
            catch (BOSException e) {
                log.error((Object)("getServersByServiceType catch error,serviceType: " + serviceType), (Throwable)e);
            }
        }
        return servers;
    }

    public JobIsolationLevel getIsolationLevel() {
        JobIsolationLevel level = null;
        if (this.def != null) {
            level = this.def.jobIsolationlevel;
        } else if (this.dyn != null) {
            level = this.dyn.jobIsolationlevel;
        }
        if (level == null) {
            level = Configuration.defaultJobIsolationLevel();
        }
        return level;
    }

    public Date getExpiredTime() {
        return this.expiredTime;
    }

    public String getHolderId() {
        return this.holderId;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    private Job() {
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        return this.getHandler().getClass().getName();
    }

    public final Context getContext() {
        return this.ctx;
    }

    final void setContext(Context ctx) {
        this.ctx = ctx;
    }

    public final String getPriorJobId() {
        return this.priorJobId;
    }

    public final boolean setState(JobState state) {
        if (state == this.state && !state.equals(JobState.Running)) {
            return true;
        }
        this.priorState = this.state;
        this.state = state;
        this.stateChangedTime = new Timestamp(System.currentTimeMillis());
        try {
            boolean b;
            boolean bl = b = state.save(this) == 1;
            if (b) {
                JobManager.instance().raiseEvent(JobEvent.OnStateChange, this);
            } else {
                if (JobState.Ready.equals(this.priorState) || JobState.Waiting.equals(this.priorState)) {
                    JobGardian.maybeLeaked(this);
                }
                log.error((Object)("change {" + this + "}'s state failed!"));
            }
            return b;
        }
        catch (Throwable t) {
            log.error((Object)("save {" + this + "}'s state failed!"), t);
            if (JobState.Running.equals(this.priorState)) {
                ++this.finishFailedCount;
                RunningJobs.addStateErrorJob(this);
            }
            return false;
        }
    }

    public final boolean reSetState() {
        if (this.finishFailedCount >= 10) {
            return true;
        }
        try {
            boolean b;
            boolean bl = b = this.state.save(this) == 1;
            if (b) {
                JobManager.instance().raiseEvent(JobEvent.OnStateChange, this);
                if (JobState.Complete.equals(this.state)) {
                    JobManager.instance().raiseEvent(JobEvent.OnComplete, this);
                } else if (JobState.Failed.equals(this.state)) {
                    JobManager.instance().raiseEvent(JobEvent.OnFailed, this);
                }
            } else {
                log.error((Object)("change {" + this + "}'s state failed! finishFailedCount=" + this.finishFailedCount));
            }
            return true;
        }
        catch (Throwable t) {
            log.error((Object)("save {" + this + "}'s state failed! finishFailedCount=" + this.finishFailedCount), t);
            ++this.finishFailedCount;
            return false;
        }
    }

    public final JobState getState() {
        return this.state;
    }

    final void setResult(Object result) {
        this.result = result;
    }

    public final Object getResult() {
        return this.result;
    }

    public final String getViewerUI() {
        return this.def != null ? this.def.viewerUI : this.dyn.viewerUI;
    }

    final void setException(Throwable t) {
        this.exception = Serialization.dump(t);
    }

    public final String getException() {
        return this.exception;
    }

    public final JobState getPriorState() {
        return this.priorState;
    }

    public final Date getStateChangedTime() {
        return this.stateChangedTime;
    }

    public final Date getCreatedTime() {
        return this.createdTime;
    }

    String getThreadName() {
        return this.dyn == null ? null : this.dyn.threadName;
    }

    int getThreadUBound() {
        return this.dyn == null ? 0 : this.dyn.threadUBound;
    }

    public final Date getFinishTime() {
        return this.finishTime;
    }

    final void setFinishTime() {
        this.finishTime = new Timestamp(System.currentTimeMillis());
    }

    public final String getIsolationBoundary() {
        return this.isolationBoundary;
    }

    public final void setIsolationBoundary(String isolationBoundary) {
        this.isolationBoundary = isolationBoundary;
    }

    public final void setProgress(String progress) {
        this.progress = progress;
        this.stateChangedTime = new Timestamp(System.currentTimeMillis());
        if (this.isPersistent) {
            String sql = "update T_JOB_INST set fprogress=?,fstatechangedtime=? where fjobinstid=? and fstate='" + JobState.Running.toString() + "'";
            int[] types = new int[]{12, 93, 12};
            Object[] values = new Object[]{progress, this.stateChangedTime, this.id};
            SqlExecutor.asynExecute(this.ctx, sql, types, values);
        }
    }

    public final void setProgress(double progress) {
        if (progress < 0.0 || progress > 1.0) {
            throw new IllegalArgumentException("job progress must between 0 and 1!");
        }
        DecimalFormat df = new DecimalFormat("#.##%");
        this.setProgress(df.format(progress));
    }

    public final String getProgress() {
        return this.progress;
    }

    public final Date getScheduledTime() {
        return this.scheduledTime;
    }

    public final Date getStartedTime() {
        return this.startedTime;
    }

    public final void setScheduledTime(Date d) {
        this.scheduledTime = d instanceof Timestamp ? d : new Timestamp(d.getTime());
    }

    final boolean addEventListener(JobEvent e, IListener h) {
        if (e == null) {
            return false;
        }
        ArrayList<IListener> list = (ArrayList<IListener>)this.listeners.get(e.toString());
        if (list == null) {
            list = new ArrayList<IListener>();
            this.listeners.put(e.toString(), list);
        } else if (list.contains(h)) {
            return false;
        }
        list.add(h);
        return true;
    }

    final ArrayList getEventListeners(JobEvent e) {
        return (ArrayList)this.listeners.get(e.toString());
    }

    public final HashMap<?, ?> getAllListeners() {
        return this.listeners;
    }

    @Override
    public final String getKey() {
        if (this.ctx == null) {
            return this.id;
        }
        return this.id + "@" + this.ctx.getAIS();
    }

    public final String getId() {
        return this.id;
    }

    public final int getStaticPriority() {
        if (this.def != null) {
            return this.def.priority;
        }
        if (this.dyn != null) {
            return this.dyn.priority;
        }
        return 500;
    }

    @Override
    public final long getPriority() {
        return this.scheduledTime.getTime();
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public boolean isSmallJob() {
        return this.isSmall;
    }

    public String getMutex() {
        String mutex = this.innerGetMutex();
        if (mutex == null || mutex.length() == 0) {
            return null;
        }
        if (this.ctx == null) {
            return mutex;
        }
        return mutex + "@" + this.ctx.getAIS();
    }

    private String innerGetMutex() {
        if (this.def != null) {
            return this.def.mutex;
        }
        if (this.dyn != null) {
            return this.dyn.mutex;
        }
        return null;
    }

    public String getJobType() {
        if (this.isSmall) {
            return ReadyJobs.Queue.SmallJobs.name();
        }
        if (this.getHandler() instanceof IWfJobHandler) {
            return ReadyJobs.Queue.WfJobs.name();
        }
        if (this.getStaticPriority() < 0) {
            return ReadyJobs.Queue.MajorJobs.name();
        }
        return ReadyJobs.Queue.BigJobs.name();
    }

    public void setSignal(JobSignal signal) {
        this.signal = signal;
    }

    boolean resetForRun() {
        this.signal = null;
        this.progress = null;
        this.startedTime = new Timestamp(System.currentTimeMillis());
        this.result = null;
        this.exception = null;
        this.finishTime = null;
        return this.setState(JobState.Running);
    }

    public JobSignal getSignal() {
        return this.signal;
    }

    final String getJobDefID() {
        return this.def != null ? this.def.defId : (this.defId != null ? this.defId : null);
    }

    public final JobDef getJobDef() {
        return this.def;
    }

    public final JobInstanceConfig getInstanceConfig() {
        return this.dyn;
    }

    public final IJobHandler getHandler() {
        if (this.def != null) {
            return this.def.handler;
        }
        if (this.dyn != null) {
            return this.dyn.handler;
        }
        return null;
    }

    public final Object getParameters() {
        return this.parameters;
    }

    public final void setParameters(Object parameters) {
        this.parameters = parameters;
    }

    public final void saveParameter(Object parameters) {
        this.setParameters(parameters);
        if (!this.isPersistent) {
            return;
        }
        int[] types = new int[]{-3, 12, 12};
        Object[] params = new Object[]{JobState.getParameters(this), this.id, this.state.toString()};
        String sql = "update T_JOB_INST set fparameters=? where fjobinstid=? and fstate=?";
        SqlExecutor.asynExecute(this.ctx, sql, types, params);
    }

    public String toString() {
        return "{" + this.title + "," + this.getKey() + "," + this.state + "}";
    }

    static Job load(String datacenter, String id) throws BOSException {
        String sql = "/*dialect*/select fjobinstid,ftitle,fuserid,forgid,fclientip,fcreatedtime,fscheduledtime,fexpiredtime,fstartedtime,ffinishtime,fstatechangedtime,fprogress,fpriorstate,fstate,fparameters,fresult,fexception,fjobdefid,finstanceconfig,fisolationboundary,fhashcode,fholderid,fpriorjobid from T_JOB_INST where fjobinstid='" + id + "'";
        ArrayList list = SQL.executeQuery(datacenter, sql);
        if (list.size() == 0 && (list = SQL.executeQuery(datacenter, sql = "/*dialect*/select fjobinstid,ftitle,fuserid,forgid,fclientip,fcreatedtime,fscheduledtime,fexpiredtime,fstartedtime,ffinishtime,fstatechangedtime,fprogress,fpriorstate,fstate,fparameters,fresult,fexception,fjobdefid,finstanceconfig,fisolationboundary,fhashcode,fholderid,fpriorjobid from T_JOB_INSTHST where fjobinstid='" + id + "'")).size() == 0) {
            return null;
        }
        HashMap item = (HashMap)list.get(0);
        return Job.from(datacenter, item, true);
    }

    static Job from(String datacenter, HashMap<?, ?> item, boolean forView) throws BOSException {
        String defid;
        Job job = new Job();
        job.id = (String)item.get("fjobinstid");
        job.title = (String)item.get("ftitle");
        String userid = (String)item.get("fuserid");
        String orgid = (String)item.get("forgid");
        String clientip = (String)item.get("fclientip");
        job.ctx = Ctx.getContext(datacenter, userid, orgid, clientip);
        job.ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        job.createdTime = (Date)item.get("fcreatedtime");
        job.scheduledTime = (Date)item.get("fscheduledtime");
        job.expiredTime = (Date)item.get("fexpiredtime");
        job.startedTime = (Date)item.get("fstartedtime");
        job.finishTime = (Date)item.get("ffinishtime");
        job.stateChangedTime = (Date)item.get("fstatechangedtime");
        job.progress = (String)item.get("fprogress");
        String tmp = (String)item.get("fpriorstate");
        job.priorState = tmp == null ? null : JobState.valueOf(tmp);
        job.state = JobState.valueOf((String)item.get("fstate"));
        job.parameters = Serialization.fromBytes((byte[])item.get("fparameters"));
        job.result = Serialization.fromBytes((byte[])item.get("fresult"));
        job.exception = (String)item.get("fexception");
        job.dyn = (JobInstanceConfig)Serialization.fromBytes((byte[])item.get("finstanceconfig"));
        if (job.dyn == null && (defid = (String)item.get("fjobdefid")) != null && defid.length() > 0) {
            job.def = JobDefCache.getJobDef(datacenter, defid);
        }
        job.isolationBoundary = (String)item.get("fisolationboundary");
        if (item.get("fhashcode") != null) {
            job.hashCode = Integer.parseInt(item.get("fhashcode").toString());
        }
        if (Configuration.serviceInstanceIdGenerator() != null) {
            job.holderId = Configuration.serviceInstanceIdGenerator().getInstanceId();
        }
        if (forView) {
            job.holderId = (String)item.get("fholderid");
        }
        job.isPersistent = true;
        job.priorJobId = (String)item.get("fpriorjobid");
        job.isSmall = job.def != null ? job.def.isSmallJob : (job.dyn != null ? job.dyn.isSmallJob : true);
        job.mergeListeners();
        return job;
    }

    private void mergeListeners() {
        HashMap list = null;
        if (this.def != null) {
            list = this.def.listeners;
        } else if (this.dyn != null) {
            list = this.dyn.listeners;
        }
        if (list == null) {
            return;
        }
        for (Object event : list.keySet()) {
            ArrayList l = (ArrayList)list.get(event);
            JobEvent e = event instanceof JobEvent ? (JobEvent)event : JobEvent.valueOf(event.toString());
            for (int i = 0; i < l.size(); ++i) {
                this.addEventListener(e, (IListener)l.get(i));
            }
        }
    }

    public void saveMessage(JobLog msg) {
        if (this.isPersistent) {
            msg.asyncSave(this.ctx, this.id);
        } else {
            log.warn((Object)(this + " is not persistent, so save message to logger: " + msg.getDescription()), msg.getException());
        }
    }

    void setThread(Thread thread) {
        this.thread = thread;
    }

    public Thread getThread() {
        return this.thread;
    }

    public int getRunTimeout() {
        if (this.def != null) {
            return this.def.getRunTimeout();
        }
        if (this.dyn != null) {
            return this.dyn.getRunTimeout();
        }
        return 0;
    }

    public void setDefId(String defId) {
        this.defId = defId;
    }

    public String getDefId() {
        return this.defId;
    }
}

