/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.ICoreJobHandler;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.IWfJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobGardian;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.core.JobThreadPoolManager;
import com.kingdee.bos.service.job.core.JobUtils;
import com.kingdee.bos.service.job.core.ReadyJobs;
import com.kingdee.bos.service.job.core.RunningJobs;
import com.kingdee.bos.service.job.core.WaitingJobs;
import com.kingdee.bos.service.job.returns.Delay;
import com.kingdee.bos.service.job.util.IListener;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class JobLoader
implements IJobHandler,
ICoreJobHandler {
    private static Logger log = Logger.getLogger((String)JobLoader.class.getName());
    private static final long serialVersionUID = -2872987810153191044L;
    private static final Map<String, List<JobLoader>> loaders = new HashMap<String, List<JobLoader>>();
    public static int loadJobSize = 0;
    private int flag = 0;
    private static final int MAX_COUNT = 512;
    private int count = 0;
    private final String dc;
    private final ReadyJobs.Queue q;
    private int top_count = 512;
    int TOP_SIZE = 200;

    static void init(String dc) {
        try {
            ArrayList<JobLoader> list = new ArrayList<JobLoader>();
            Timestamp scheduledTime = new Timestamp(System.currentTimeMillis() + Configuration.jobLoaderDelay());
            for (int i = 0; i < ReadyJobs.Queue.values().length; ++i) {
                JobLoader loader = new JobLoader(dc, ReadyJobs.Queue.values()[i]);
                JobInstanceConfig cfg = new JobInstanceConfig((IJobHandler)loader, false);
                cfg.priority = Integer.MIN_VALUE;
                Job job = new Job(null, "job loader of {" + dc + "_" + (Object)((Object)ReadyJobs.Queue.values()[i]) + "}", cfg, (Object)Boolean.TRUE, scheduledTime);
                JobManager.instance().add(job);
                list.add(loader);
                log.info((Object)("JobLoader of {" + dc + "_" + (Object)((Object)ReadyJobs.Queue.values()[i]) + "} is created!"));
            }
            JobGardian h = new JobGardian(dc);
            Job gard = new Job(null, "JobGardian of {" + dc + "}", h, null, false, true);
            gard.setScheduledTime(scheduledTime);
            JobManager.instance().add(gard);
            log.info((Object)("JobGardian of {" + dc + "} is created!"));
            JobLoader.registerLoader(dc, list);
        }
        catch (Throwable t) {
            log.error((Object)("init job loader of {" + dc + "} failed!"), t);
        }
    }

    public static void newJobEnqueued(Context ctx) {
        String dc = ctx.getAIS();
        JobLoader.newJobEnqueued(dc);
    }

    static void newJobEnqueued(String dc) {
        List<JobLoader> list = loaders.get(dc);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).resetTopCount();
            }
        }
    }

    private static synchronized void registerLoader(String dc, List<JobLoader> list) {
        loaders.put(dc, list);
    }

    private JobLoader(String dc, ReadyJobs.Queue q) {
        this.dc = dc;
        this.q = q;
    }

    private synchronized int getTopCount() {
        return this.top_count;
    }

    private synchronized void resetTopCount() {
        this.top_count = 1;
    }

    private synchronized void doubleTopCount() {
        this.top_count += this.top_count;
    }

    @Override
    public Object execute(Job job) {
        Object param = job.getParameters();
        try {
            Boolean first = (Boolean)param;
            if (!ClusterStateManager.isReady(this.dc)) {
                return new Delay(60);
            }
            if (first.booleanValue()) {
                this.cleanup();
                return new Delay(Boolean.FALSE, 60);
            }
            if (++this.count >= this.getTopCount()) {
                this.count = 0;
                this.load();
            }
            return new Delay(300L);
        }
        catch (Throwable e) {
            log.error((Object)("background scheduler service loading job from datacenter {" + this.dc + "} is failed!"), e);
            return new Delay(param, 10);
        }
    }

    private int cleanup() throws Exception {
        String[] sqls = JobLoader.sql4cleanup(Configuration.instanceId());
        for (int i = 0; i < sqls.length; ++i) {
            SQL.executeUpdate(this.dc, sqls[i]);
        }
        log.debug((Object)("job loader of background scheduler service for datacenter {" + this.dc + "} is initiated!"));
        return 10;
    }

    private int load() throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("select top ").append(this.TOP_SIZE);
        sql.append(" fjobinstid,ftitle,fuserid,forgid,fclientip,fcreatedtime,fscheduledtime,fexpiredtime,");
        sql.append("fstartedtime,ffinishtime,fstatechangedtime,fprogress,fpriorstate,fstate,fparameters,fresult,");
        sql.append("fexception,fjobdefid,finstanceconfig,fisolationboundary,fhashcode,fholderid,fpriorjobid");
        sql.append(" from T_JOB_INST WITH(READPAST) where fstate in('");
        sql.append(JobState.Created).append("','").append(JobState.ReScheduled).append("')");
        sql.append(" and (").append(JobIsolationLevel.sqlWhere(this.dc)).append(")");
        sql.append(" and fholderid is null");
        sql.append(" and (fjobtype ='").append((Object)this.q).append("' or fjobtype is null)");
        sql.append(" and fscheduledtime<=?");
        int[] types = new int[]{93};
        Timestamp time = new Timestamp(System.currentTimeMillis() + 102000L);
        Object[] values = new Object[]{time};
        if (!StringUtils.isEmpty((String)Configuration.clusterIsolation())) {
            sql.append(" and fcluster = ?");
            types = new int[]{93, 12};
            values = new Object[]{time, Configuration.clusterIsolation()};
        }
        sql.append(" order by fscheduledtime");
        ArrayList items = SQL.executeQuery(this.dc, sql.toString(), types, values);
        Date now = new Date();
        loadJobSize = items.size();
        int skipJobSize = 0;
        for (int i = 0; i < items.size(); ++i) {
            if (ReadyJobs.queueSize(this.q) + WaitingJobs.size() > 3000) {
                log.warn((Object)("job scheduler is too busy now, " + (items.size() - i) + " jobs of (" + this.dc + ") was left to next loading cycle."));
                break;
            }
            HashMap item = (HashMap)items.get(i);
            try {
                Job j = Job.from(this.dc, item, false);
                if (!JobLoader.isLoadBigJob(j)) {
                    ++skipJobSize;
                    continue;
                }
                if (j.getScheduledTime().after(now)) {
                    WaitingJobs.in(j);
                    continue;
                }
                ReadyJobs.in(j);
                continue;
            }
            catch (Throwable t) {
                try {
                    JobLog log;
                    if (t instanceof OutOfMemoryError || t.getCause() instanceof OutOfMemoryError) {
                        JobUtils.reSchedule(this.dc, (String)item.get("fjobinstid"), 1200000);
                        log = new JobLog(JobLog.Type.Error, "\u7531\u4e8eOOM\uff0c\u4efb\u52a1\u52a0\u8f7d\u5931\u8d25!\u5df2\u91cd\u65b0\u8c03\u5ea6\u523020\u5206\u949f\u540e.", t.getMessage(), null, t);
                        log.save(this.dc, (String)item.get("fjobinstid"));
                        continue;
                    }
                    sql = new StringBuffer();
                    sql.append("update T_JOB_INST set fpriorstate='").append(item.get("fstate")).append("', fstate='").append(JobState.Failed).append("'");
                    sql.append(", fholderid='").append(Configuration.serviceInstanceIdGenerator().getInstanceId()).append("'");
                    sql.append(" where fjobinstid='").append(item.get("fjobinstid")).append("'");
                    SQL.executeUpdate(this.dc, sql.toString());
                    log = new JobLog(JobLog.Type.Error, "\u4efb\u52a1\u52a0\u8f7d\u5931\u8d25!", t.getMessage(), null, t);
                    log.save(this.dc, (String)item.get("fjobinstid"));
                    continue;
                }
                catch (Throwable t1) {
                    log.error((Object)t1);
                }
            }
        }
        if (this.flag == 0) {
            this.flag = 1;
            log.info((Object)("load job instance from datacenter {" + this.dc + "}, sql is: \r\n\t" + sql.toString()));
        }
        if (skipJobSize > 0 || items.size() == this.TOP_SIZE) {
            this.resetTopCount();
        } else if (this.getTopCount() < 512) {
            this.doubleTopCount();
        }
        return Configuration.jobLoaderInterval();
    }

    private static boolean isLoadBigJob(Job job) {
        if (!job.isSmallJob() && !(job.getHandler() instanceof IWfJobHandler)) {
            int mutexJobSize = RunningJobs.getMutexJobSize(job.getMutex());
            if (mutexJobSize > 0) {
                return false;
            }
            int currentMajorJobSize = ReadyJobs.majorJobSize() + RunningJobs.majorJobSize();
            int currentBigJobSize = ReadyJobs.bigJobSize() + RunningJobs.bigJobSize();
            int majorJobThreadSize = Math.max(1, JobThreadPoolManager.getInstance().getThreadPool(ReadyJobs.Queue.MajorJobs).getMaximumPoolSize());
            int bigJobThreadSize = Math.max(1, JobThreadPoolManager.getInstance().getThreadPool(ReadyJobs.Queue.BigJobs).getMaximumPoolSize());
            if (job.getStaticPriority() < 0 ? currentMajorJobSize >= majorJobThreadSize + 1 : currentBigJobSize >= bigJobThreadSize + 1) {
                return false;
            }
        }
        return true;
    }

    private static String[] sql4cleanup(String instanceId) {
        String sql1 = "update T_JOB_INST set fholderId=null, fstate ='" + JobState.ReScheduled + "' where (fholderId='" + instanceId + "' or fholderid is null) and fstate in('" + JobState.Waiting + "','" + JobState.Ready + "')";
        String sql2 = "update T_JOB_INST set fholderId=null, fstate ='" + JobState.ReScheduled + "', fexpiredtime=null where (fholderId='" + instanceId + "'  or fholderid is null) and fstate in('" + JobState.Running + "')";
        if (!StringUtils.isEmpty((String)Configuration.clusterIsolation())) {
            sql1 = sql1 + " and fcluster = '" + Configuration.clusterIsolation() + "'";
            sql2 = sql2 + " and fcluster = '" + Configuration.clusterIsolation() + "'";
        } else {
            sql1 = sql1 + " and fcluster is null";
            sql2 = sql2 + " and fcluster is null";
        }
        return new String[]{sql1, sql2};
    }

    static {
        ClusterStateManager.OnCleanUp.add(new IListener(){
            private static final long serialVersionUID = 3164061481102743232L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(Object p) throws Exception {
                ClusterStateManager.EventParam param = (ClusterStateManager.EventParam)p;
                try (Statement smt = param.cn.createStatement();){
                    String[] sqls = JobLoader.sql4cleanup(param.instanceId);
                    for (int i = 0; i < sqls.length; ++i) {
                        smt.executeUpdate(sqls[i]);
                    }
                    String sql = "update T_JOB_INST set fisolationboundary='" + Configuration.instanceId() + "' where fisolationboundary='" + param.instanceId + "' and fstate in('" + JobState.Created + "','" + JobState.ReScheduled + "')";
                    this.executeUpdate(smt, sql);
                }
            }

            private int executeUpdate(Statement smt, String sql) throws SQLException {
                return smt.executeUpdate(sql);
            }
        });
    }
}

