/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.BOSSchedulerService;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.DisableTrigger;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.core.JobEvent;
import com.kingdee.bos.service.job.core.JobLoader;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.core.ReadyJobs;
import com.kingdee.bos.service.job.core.Trigger;
import com.kingdee.bos.service.job.core.WaitingJobs;
import com.kingdee.bos.service.job.util.Cache;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.service.job.util.IListener;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class JobManager {
    private static final JobManager manager = new JobManager();
    private final Cache suspendedJobs;

    public static JobManager instance() {
        return manager;
    }

    private JobManager() {
        int suspended_job_cache_size = Configuration.suspendedTransientJobCacheSize();
        this.suspendedJobs = new Cache(suspended_job_cache_size);
    }

    public void add(Job job) {
        boolean b;
        if (!BOSSchedulerService.isRunning() && Configuration.isEnable()) {
            BOSSchedulerService.init();
            BOSSchedulerService.startWorkerThread();
        }
        if (job.getState() != null) {
            throw new RuntimeException("job " + job + "'s state is not null!");
        }
        if (!job.setState(JobState.Created)) {
            throw new RuntimeException("set job " + job + "'state to Created failed");
        }
        this.raiseEvent(JobEvent.OnAccepted, job);
        if (job.isPersistent()) {
            JobLoader.newJobEnqueued(job.getContext());
            return;
        }
        if (Configuration.isEnable() && !(b = job.getScheduledTime().after(new Date()) ? WaitingJobs.in(job) : ReadyJobs.in(job))) {
            throw new RuntimeException("accept job " + job + " failed, it's in job queues now or save its new state failed!");
        }
    }

    public Job removeWaitingJob(String key) {
        return WaitingJobs.remove(key);
    }

    public Job removeReadyJob(String key) {
        ReadyJobs.remove(key);
        return null;
    }

    void raiseEvent(JobEvent e, Job job) {
        if (e == null) {
            return;
        }
        ArrayList listeners = job.getEventListeners(e);
        if (listeners != null) {
            for (int i = 0; i < listeners.size(); ++i) {
                IListener listener = (IListener)listeners.get(i);
                try {
                    listener.handle(job);
                    continue;
                }
                catch (Throwable et) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("job{").append(job.getTitle()).append(", ").append(job.getKey()).append("}");
                    sb.append("' event {").append(e).append("}' listener {" + listener.getClass().getName() + "} failed.");
                    String description = sb.toString();
                    JobLog msg = new JobLog(JobLog.Type.Warn, description, null, null, et);
                    job.saveMessage(msg);
                }
            }
        }
    }

    void send2SuspendedJobCache(Job job) {
        if (!job.getState().equals(JobState.Suspended)) {
            throw new IllegalStateException("job" + job + "'s state is " + job.getState() + ", couldn't be sent to suspended job cache.");
        }
        if (!job.isPersistent()) {
            this.suspendedJobs.push(job);
        }
    }

    public void createJobDef(JobDef def, Trigger trigger, boolean enable) throws BOSException {
        if (trigger != null && !trigger.getJobDefID().equals(def.getDefId())) {
            throw new BOSException("trigger " + trigger + " is not jobdef " + def + "'s trigger.");
        }
        String dc = def.getDatacenter();
        Context ctx = Ctx.getDefaultContext(dc);
        String sql = "delete from T_JOB_DEF where fjobdefid='" + def.getDefId() + "'";
        int i = SQL.executeUpdate(ctx, sql);
        String expiredTriggerId = null;
        if (i > 0) {
            sql = "select fid from T_JOB_TRIGGER where fjobDefID='" + def.getDefId() + "'";
            ArrayList list = SQL.executeQuery(ctx, sql);
            if (list.size() > 0) {
                expiredTriggerId = (String)((HashMap)list.get(0)).get("fid");
            }
            sql = "delete from T_JOB_TRIGGER where fjobDefID='" + def.getDefId() + "'";
            SQL.executeUpdate(ctx, sql);
        }
        def.save();
        if (trigger != null) {
            trigger.save();
            if (enable) {
                trigger.enable();
            }
        }
        if (i > 0) {
            DisableTrigger.sendCommand(ctx, expiredTriggerId, def.getDefId());
        }
    }

    public void removeJobDef(Context ctx, String jobDefId) throws BOSException {
        if (ctx == null || StringUtils.isEmpty((String)jobDefId)) {
            return;
        }
        String sql = "delete from T_JOB_DEF where fjobdefid='" + jobDefId + "'";
        int i = SQL.executeUpdate(ctx, sql);
        String expiredTriggerId = null;
        if (i > 0) {
            sql = "select fid from T_JOB_TRIGGER where fjobDefID='" + jobDefId + "'";
            ArrayList list = SQL.executeQuery(ctx, sql);
            if (list.size() > 0) {
                expiredTriggerId = (String)((HashMap)list.get(0)).get("fid");
            }
            sql = "delete from T_JOB_TRIGGER where fjobDefID='" + jobDefId + "'";
            SQL.executeUpdate(ctx, sql);
            DisableTrigger.sendCommand(ctx, expiredTriggerId, jobDefId);
        }
    }

    public void enableTrigger(String triggerId, String datacenter) throws BOSException {
        String defId = triggerId.substring(0, 36) + "BGJOBDEF";
        String sql = "select * from T_JOB_TRIGGER where fid='" + triggerId + "' or fjobdefid='" + defId + "'";
        ArrayList list = SQL.executeQuery(datacenter, sql);
        if (list.size() == 0) {
            throw new BOSException("trigger {" + triggerId + "} dosn't exist.");
        }
        Trigger trigger = Trigger.from(datacenter, (HashMap)list.get(0));
        trigger.enable();
        JobLog msg = new JobLog(JobLog.Type.Info, "enable trigger {" + trigger.getJobDefID() + "} ", null, null, null);
        msg.save(datacenter, trigger.getJobDefID());
    }

    public void disableTrigger(String triggerId, String datacenter) throws BOSException {
        Context ctx = Ctx.getDefaultContext(datacenter);
        String defId = triggerId.substring(0, 36) + "BGJOBDEF";
        String sql = "select * from T_JOB_TRIGGER where fid='" + triggerId + "' or fjobdefid='" + defId + "'";
        ArrayList list = SQL.executeQuery(ctx, sql);
        if (list.size() == 0) {
            throw new BOSException("trigger {" + triggerId + "} dosn't exist.");
        }
        Trigger trigger = Trigger.from(datacenter, (HashMap)list.get(0));
        trigger.disable();
        JobLog msg = new JobLog(JobLog.Type.Info, "disable trigger {" + trigger.getJobDefID() + "} ", null, null, null);
        msg.save(datacenter, trigger.getJobDefID());
        DisableTrigger.sendCommand(ctx, triggerId, trigger.getJobDefID());
    }

    public int suspendedJobCacheSize() {
        return this.suspendedJobs.size();
    }
}

