/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobManager;
import org.apache.log4j.Logger;

public class MonitorJobSender {
    private static Logger log = Logger.getLogger((String)MonitorJobSender.class.getName());

    public static void createJob(Context ctx, IJobHandler handler, String title, Object param) {
        ClusterStateManager cluster = ClusterStateManager.get(ctx.getAIS());
        if (cluster == null) {
            log.error((Object)("couldn't find ClusterStateManager for datacenter {" + ctx.getAIS() + "}"));
            return;
        }
        String[] ids = cluster.getServiceInstanceIds();
        for (int i = 0; i < ids.length; ++i) {
            MonitorJobSender.createJob(ctx, handler, title, param, ids[i]);
        }
    }

    public static void createJob4SameVersionEngine(Context ctx, IJobHandler handler, String title, Object param, boolean includeMe) {
        ClusterStateManager cluster = ClusterStateManager.get(ctx.getAIS());
        if (cluster == null) {
            log.error((Object)("couldn't find ClusterStateManager for datacenter {" + ctx.getAIS() + "}"));
            return;
        }
        String[] ids = cluster.getSameVersionServiceInstanceIds();
        if (includeMe) {
            for (int i = 0; i < ids.length; ++i) {
                MonitorJobSender.createJob(ctx, handler, title, param, ids[i]);
            }
        } else {
            String me = Configuration.serviceInstanceIdGenerator().getInstanceId();
            for (int i = 0; i < ids.length; ++i) {
                if (me.equals(ids[i])) continue;
                MonitorJobSender.createJob(ctx, handler, title, param, ids[i]);
            }
        }
    }

    public static void createJob(Context ctx, IJobHandler handler, String title, Object param, String instanceId) {
        JobInstanceConfig cfg = new JobInstanceConfig(handler);
        Job job = new Job(ctx, title, cfg, param);
        job.setIsolationBoundary(instanceId);
        try {
            JobManager.instance().add(job);
        }
        catch (Exception e) {
            log.error((Object)("create monitor job " + job + "failed!"), (Throwable)e);
        }
    }
}

