/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.Trigger;
import com.kingdee.bos.service.job.pulse.TimerPulseSource;
import com.kingdee.util.ConfigurationItem;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class PulseSource {
    private static Logger log = Logger.getLogger((String)PulseSource.class.getName());
    private static final HashMap<String, PulseSource> sources = new HashMap();
    static TimerPulseSource timerPulseSource;
    protected String code;
    protected String source;
    protected String f7;

    public static PulseSource getInstance(String code) {
        if (timerPulseSource.getCode().equals(code)) {
            return timerPulseSource;
        }
        if (sources.containsKey(code)) {
            return (TimerPulseSource)sources.get(code);
        }
        TimerPulseSource timer = new TimerPulseSource(code);
        sources.put(timer.getCode(), timer);
        return timer;
    }

    public static int cachedTriggerCount() {
        Iterator<PulseSource> it = sources.values().iterator();
        int count = 0;
        while (it.hasNext()) {
            PulseSource ps = it.next();
            count += ps.triggerCount();
        }
        return count;
    }

    public static String dumpTriggers() {
        StringBuffer sb = new StringBuffer();
        int count = 0;
        for (PulseSource ps : sources.values()) {
            List<String> list = ps.getAllTriggers();
            for (int i = 0; i < list.size(); ++i) {
                sb.append(++count).append(".  ");
                sb.append(list.get(i));
            }
        }
        return sb.toString();
    }

    public static Timestamp getNextTriggerTime(String triggerId) {
        PulseSource ps;
        Timestamp nextTriggerTime = null;
        Iterator<PulseSource> it = sources.values().iterator();
        while (it.hasNext() && (nextTriggerTime = (ps = it.next()).getNextFireTime(triggerId)) == null) {
        }
        return nextTriggerTime;
    }

    public static TimerPulseSource timerPulseSource() {
        return timerPulseSource;
    }

    private static void loadDefaultPulseSource() {
        TimerPulseSource timer = new TimerPulseSource();
        sources.put(timer.getCode(), timer);
        timerPulseSource = timer;
    }

    public String getCode() {
        return this.code;
    }

    public String getSource() {
        return this.source;
    }

    public String getF7() {
        return this.f7;
    }

    public static void removePulseSource(String datacenter, String triggerId) {
        Object[] sources = PulseSource.sources.values().toArray();
        for (int i = 0; i < sources.length; ++i) {
            ((PulseSource)sources[i]).removeTrigger(datacenter, triggerId);
        }
    }

    protected abstract void verify(String var1) throws BOSException;

    protected abstract void addTrigger(Trigger var1) throws Exception;

    protected abstract void removeTrigger(Trigger var1);

    protected abstract void removeTrigger(String var1, String var2);

    protected abstract int triggerCount();

    protected abstract boolean isAutoLoad(Trigger var1);

    protected abstract List<String> getAllTriggers();

    protected abstract Timestamp getNextFireTime(String var1);

    static {
        PulseSource.loadDefaultPulseSource();
        try {
            List list;
            ConfigurationItem wrappers;
            ConfigurationItem root = Configuration.getConfiguration();
            if (root != null && (wrappers = root.getChild("pulses")) != null && (list = wrappers.getChildren("pulse")) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    ConfigurationItem item = (ConfigurationItem)list.get(i);
                    Map map = item.getProperties();
                    String code = (String)map.get("code");
                    String className = (String)map.get("class");
                    String source = (String)map.get("source");
                    String f7 = (String)map.get("f7");
                    try {
                        PulseSource fac = (PulseSource)Class.forName(className).newInstance();
                        fac.code = code;
                        fac.source = source;
                        fac.f7 = f7;
                        sources.put(code, fac);
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)("load job handler wrapper {" + className + "} failed, please check bosconfig.xml!"), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"read wrapper config from bosconfig.xml failed!", (Throwable)e);
        }
    }
}

