/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.core.JobThreadPoolManager;
import com.kingdee.bos.service.job.core.RunningJobs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class ReadyJobs {
    public static boolean in(Job job) {
        if (job.setState(JobState.Ready)) {
            return ReadyJobs.innerIn(job);
        }
        return false;
    }

    private static boolean innerIn(Job job) {
        ReadyJobs.getJobThreadPoolManager().submitJob(job);
        return true;
    }

    static Job out(Queue q) {
        throw new IllegalStateException();
    }

    static synchronized void remove(String key) {
        throw new IllegalStateException();
    }

    public static int size() {
        return ReadyJobs.innerSize() + RunningJobs.readyCount();
    }

    public static int queueSize(Queue q) {
        return ReadyJobs.getJobThreadPoolManager().getQueue(q).size() + RunningJobs.readyCount();
    }

    public static int bigJobSize() {
        return ReadyJobs.getJobThreadPoolManager().getQueue(Queue.BigJobs).size();
    }

    public static int majorJobSize() {
        return ReadyJobs.getJobThreadPoolManager().getQueue(Queue.MajorJobs).size();
    }

    static synchronized int innerSize() {
        return ReadyJobs.getJobThreadPoolManager().getQueue(Queue.SmallJobs).size() + ReadyJobs.getJobThreadPoolManager().getQueue(Queue.BigJobs).size() + ReadyJobs.getJobThreadPoolManager().getQueue(Queue.MajorJobs).size() + ReadyJobs.getJobThreadPoolManager().getQueue(Queue.WfJobs).size();
    }

    static synchronized String dump() {
        StringBuffer sb = new StringBuffer();
        sb.append("\u5c0f\u4efb\u52a1:\r\n");
        ReadyJobs.dump(sb, ReadyJobs.getJobThreadPoolManager().getQueueAsObjects(Queue.SmallJobs));
        sb.append("\u5927\u4efb\u52a1:\r\n");
        ReadyJobs.dump(sb, ReadyJobs.getJobThreadPoolManager().getQueueAsObjects(Queue.BigJobs));
        sb.append("\u91cd\u8981\u4efb\u52a1:\r\n");
        ReadyJobs.dump(sb, ReadyJobs.getJobThreadPoolManager().getQueueAsObjects(Queue.MajorJobs));
        sb.append("\u5de5\u4f5c\u6d41\u4efb\u52a1:\r\n");
        ReadyJobs.dump(sb, ReadyJobs.getJobThreadPoolManager().getQueueAsObjects(Queue.WfJobs));
        sb.append("\u4e92\u65a5\u961f\u5217\u4efb\u52a1:\r\n").append(RunningJobs.dumpExclusiveJobIds());
        return sb.toString();
    }

    private static void dump(StringBuffer sb, Object[] objs) {
        for (int i = 0; i < objs.length; ++i) {
            Job job = (Job)objs[i];
            sb.append(i + 1).append(".  ");
            String title = job.getTitle();
            if (title == null) {
                title = job.getHandler().getClass().getName();
                int j = title.lastIndexOf(46);
                title = title.substring(j + 1);
            }
            sb.append(title);
            if (job.getContext() != null) {
                sb.append("; datacenter{").append(job.getContext().getAIS()).append("}");
            }
            sb.append(job.getScheduledTime());
            sb.append(",");
            sb.append(job.getState());
            sb.append("\r\n");
        }
    }

    public static synchronized List getAllJobs() {
        ArrayList ret = new ArrayList();
        ReadyJobs.getAllJobs(ret, ReadyJobs.getJobThreadPoolManager().getQueueAsObjects(Queue.SmallJobs));
        ReadyJobs.getAllJobs(ret, ReadyJobs.getJobThreadPoolManager().getQueueAsObjects(Queue.BigJobs));
        ReadyJobs.getAllJobs(ret, ReadyJobs.getJobThreadPoolManager().getQueueAsObjects(Queue.MajorJobs));
        ReadyJobs.getAllJobs(ret, ReadyJobs.getJobThreadPoolManager().getQueueAsObjects(Queue.WfJobs));
        return ret;
    }

    private static void getAllJobs(ArrayList ret, Object[] objs) {
        for (int i = 0; i < objs.length; ++i) {
            Job job = (Job)objs[i];
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", job.getId());
            String title = job.getTitle();
            if (title == null) {
                title = job.getHandler().getClass().getName();
                int j = title.lastIndexOf(46);
                title = title.substring(j + 1);
            }
            map.put("title", title);
            map.put("handler", job.getHandler() == null ? null : job.getHandler().toString());
            map.put("createdTime", job.getCreatedTime());
            map.put("finishTime", job.getFinishTime());
            map.put("scheduledTime", job.getScheduledTime());
            map.put("state", job.getState().toString());
            map.put("priotity", job.getPriority());
            ret.add(map);
        }
    }

    public static synchronized Collection<String> getJobIds() {
        ArrayList<String> list = new ArrayList<String>(ReadyJobs.size());
        for (Job o : ReadyJobs.getJobThreadPoolManager().getQueueAsObjects(Queue.SmallJobs)) {
            list.add(o.getId());
        }
        for (Job o : ReadyJobs.getJobThreadPoolManager().getQueueAsObjects(Queue.WfJobs)) {
            list.add(o.getId());
        }
        for (Job o : ReadyJobs.getJobThreadPoolManager().getQueueAsObjects(Queue.MajorJobs)) {
            list.add(o.getId());
        }
        for (Job o : ReadyJobs.getJobThreadPoolManager().getQueueAsObjects(Queue.BigJobs)) {
            list.add(o.getId());
        }
        return list;
    }

    static JobThreadPoolManager getJobThreadPoolManager() {
        return JobThreadPoolManager.getInstance();
    }

    static enum Queue {
        SmallJobs,
        BigJobs,
        WfJobs,
        MajorJobs;

    }
}

