/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.core.JobDefCache;
import com.kingdee.bos.service.job.core.JobEvent;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.core.PulseSource;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.scheduler.util.SchedulerUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Trigger
implements Serializable {
    private static final long serialVersionUID = 174569677759421445L;
    public static final String BOSTYPE = "BGJOBTRI";
    private String id;
    private String jobDefID;
    private Date validateTime;
    private Date expiredTime;
    private PulseSource pulseSource;
    private String pulseSourceCode;
    private String schedulePlan;
    private boolean useCalendar;
    private int hashCode;
    private String isolationBoundary;
    private String holderId;
    private int triggeredCount;
    private Date lastTriggeredTime;
    private String lastjobinst;
    private boolean isValid;
    private boolean isAutoLoad;
    private String datacenter;
    private String selectedServer;
    private boolean inWorkingDay = true;
    private boolean isFireLastMissedJob = true;

    public String getLastjobinst() {
        return this.lastjobinst;
    }

    public void setLastjobinst(String lastjobinst) {
        this.lastjobinst = lastjobinst;
    }

    public boolean isFireLastMissedJob() {
        return this.isFireLastMissedJob;
    }

    public String getSelectedServer() {
        return this.selectedServer;
    }

    public String getId() {
        return this.id;
    }

    public String getJobDefID() {
        return this.jobDefID;
    }

    public Date getValidateTime() {
        return this.validateTime;
    }

    public Date getExpiredTime() {
        return this.expiredTime;
    }

    public PulseSource getPulseSource() {
        return this.pulseSource;
    }

    public String getSchedulePlan() {
        return this.schedulePlan;
    }

    public boolean isUseCalendar() {
        return this.useCalendar;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public String getIsolationBoundary() {
        return this.isolationBoundary;
    }

    public String getHolderId() {
        return this.holderId;
    }

    public int getTriggeredCount() {
        return this.triggeredCount;
    }

    public Date getLastTriggeredTime() {
        return this.lastTriggeredTime;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public Trigger(Date validateTime, Date expiredTime, JobDef jobDef, PulseSource pulseSource, String schedulePlan, boolean useCalendar) throws BOSException {
        pulseSource.verify(schedulePlan);
        this.id = Uuid.randomUUID().toString() + BOSTYPE;
        this.expiredTime = expiredTime;
        this.jobDefID = jobDef.getDefId();
        this.pulseSource = pulseSource;
        this.schedulePlan = schedulePlan;
        this.useCalendar = useCalendar;
        this.validateTime = validateTime;
        this.datacenter = jobDef.getDatacenter();
        this.isValid = true;
        this.hashCode = Configuration.randomGenerator().next();
        this.isAutoLoad = pulseSource.isAutoLoad(this);
    }

    public Trigger(Date validateTime, Date expiredTime, JobDef jobDef, String pulseSourceCode, boolean isAutoLoad, String schedulePlan, boolean useCalendar) throws BOSException {
        this.id = Trigger.newId();
        this.expiredTime = expiredTime;
        this.jobDefID = jobDef.getDefId();
        this.pulseSourceCode = pulseSourceCode;
        this.schedulePlan = schedulePlan;
        this.useCalendar = useCalendar;
        this.validateTime = validateTime;
        this.datacenter = jobDef.getDatacenter();
        this.isValid = true;
        this.hashCode = Configuration.randomGenerator().next();
        this.isAutoLoad = isAutoLoad;
    }

    public Trigger(Date validateTime, Date expiredTime, JobDef jobDef, String pulseSourceCode, boolean isAutoLoad, String schedulePlan, boolean useCalendar, String selectedServer) throws BOSException {
        this(validateTime, expiredTime, jobDef, pulseSourceCode, isAutoLoad, schedulePlan, useCalendar);
        this.selectedServer = selectedServer;
    }

    public Trigger(Date validateTime, Date expiredTime, JobDef jobDef, String pulseSourceCode, boolean isAutoLoad, String schedulePlan, boolean useCalendar, String selectedServer, boolean inWorkingDay) throws BOSException {
        this(validateTime, expiredTime, jobDef, pulseSourceCode, isAutoLoad, schedulePlan, useCalendar, selectedServer);
        this.inWorkingDay = inWorkingDay;
    }

    public Trigger(Date validateTime, Date expiredTime, JobDef jobDef, String pulseSourceCode, boolean isAutoLoad, String schedulePlan, boolean useCalendar, String selectedServer, boolean inWorkingDay, boolean isFireLastMissedJob) throws BOSException {
        this(validateTime, expiredTime, jobDef, pulseSourceCode, isAutoLoad, schedulePlan, useCalendar, selectedServer, inWorkingDay);
        this.isFireLastMissedJob = isFireLastMissedJob;
    }

    private Trigger() {
    }

    public static String newId() {
        return Uuid.randomUUID().toString() + BOSTYPE;
    }

    void save() throws BOSException {
        String sql = "insert into T_JOB_TRIGGER(fid, fjobDefID, fvalidateTime, fexpiredTime, fpulseSource, fschedulePlan, fuseCalendar, fhashCode, fisolationBoundary, fholderId, ftriggeredCount, flastTriggeredTime, fisValid,fisAutoLoad,fcluster,fselectedserver,finWorkingDay,fisfirelastmissedjob)values(?,?,?,?,?,?,?,?,?,?,0,NULL,'N',?,?,?,?,?)";
        if (this.isolationBoundary == null) {
            this.isolationBoundary = Configuration.defaultTriggerIsolationBoundary();
        }
        int[] types = new int[]{12, 12, 93, 93, 12, 12, 12, 4, 12, 12, 12, 12, 12, 12, 12};
        Object[] values = new Object[]{this.id, this.jobDefID, new Timestamp(this.validateTime.getTime()), new Timestamp(this.expiredTime.getTime()), this.pulseSource != null ? this.pulseSource.getCode() : this.pulseSourceCode, this.schedulePlan, this.useCalendar ? "Y" : "N", new Integer(this.hashCode), this.isolationBoundary, this.holderId, this.isAutoLoad ? "Y" : "N", Configuration.clusterIsolation(), this.selectedServer, this.inWorkingDay ? "Y" : "N", this.isFireLastMissedJob ? "Y" : "N"};
        SQL.executeUpdate(this.datacenter, sql, types, values);
    }

    public boolean setLoaded() {
        String sql = "update T_JOB_TRIGGER set fholderid=? where fid=? and fholderid is null";
        int[] types = new int[]{12, 12};
        Object[] values = new Object[]{this.holderId, this.id};
        try {
            return SQL.executeUpdate(this.datacenter, sql, types, values) == 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return "{trigger: " + this.id + ", jobdefid=" + this.jobDefID + "}";
    }

    static Trigger from(String datacenter, HashMap item) {
        Trigger t = new Trigger();
        ClusterStateManager cm = ClusterStateManager.get(datacenter);
        t.datacenter = datacenter;
        t.id = (String)item.get("fid");
        t.expiredTime = cm.toDbTime((Date)item.get("fexpiredtime"));
        t.hashCode = Integer.parseInt(item.get("fhashcode").toString());
        t.holderId = item.get("fholderid") != null ? (String)item.get("fholderid") : Configuration.serviceInstanceIdGenerator().getInstanceId();
        t.isolationBoundary = (String)item.get("fisolationboundary");
        t.isValid = "Y".equals(item.get("fisvalid"));
        t.jobDefID = (String)item.get("fjobdefid");
        t.lastTriggeredTime = (Date)item.get("flasttriggeredtime");
        t.pulseSource = PulseSource.getInstance((String)item.get("fpulsesource") + "@" + datacenter);
        t.schedulePlan = (String)item.get("fscheduleplan");
        t.triggeredCount = Integer.parseInt(item.get("ftriggeredcount").toString());
        t.useCalendar = "Y".equals(item.get("fusecalendar"));
        t.validateTime = cm.toDbTime((Date)item.get("fvalidatetime"));
        t.isAutoLoad = "Y".equals(item.get("fisautoload"));
        t.selectedServer = (String)item.get("fselectedserver");
        t.inWorkingDay = "Y".equals(item.get("finworkingday")) || item.get("finworkingday") == null;
        t.isFireLastMissedJob = "Y".equals(item.get("fisfirelastmissedjob")) || item.get("fisfirelastmissedjob") == null;
        return t;
    }

    public boolean triggered(Date lastTriggeredTime) {
        try {
            Job job = this.newJob(lastTriggeredTime);
            if (job != null) {
                if (!this.modifyState(lastTriggeredTime, job.getId())) {
                    return false;
                }
                JobManager.instance().add(job);
            }
            return true;
        }
        catch (Throwable t) {
            JobLog msg = new JobLog(JobLog.Type.Error, "create job failed!", null, null, t);
            msg.save(this.datacenter, this.jobDefID);
            return false;
        }
    }

    public String getKey() {
        return Trigger.generateKey(this.id, this.datacenter);
    }

    public static String generateKey(String triggerId, String datacenter) {
        return triggerId + "@" + datacenter;
    }

    private boolean modifyState(Date lastTriggeredTime, String lastjobinst) {
        ++this.triggeredCount;
        this.lastTriggeredTime = lastTriggeredTime;
        this.lastjobinst = lastjobinst;
        StringBuffer sql = new StringBuffer();
        sql.append("update t_job_trigger set");
        sql.append(" ftriggeredCount=").append(this.triggeredCount);
        sql.append(", flastTriggeredTime=?");
        sql.append(", flastjobinst=?");
        sql.append(" where fid=? and fholderId=? and fisvalid='Y'");
        int[] types = new int[]{93, 12, 12, 12};
        Object[] values = new Object[]{new Timestamp(lastTriggeredTime.getTime()), this.lastjobinst, this.id, this.holderId};
        try {
            this.isValid = SQL.executeUpdate(this.datacenter, sql.toString(), types, values) == 1;
        }
        catch (Throwable t) {
            JobLog msg = new JobLog(JobLog.Type.Error, "update trigger {" + this.jobDefID + "}'s last triggered time failed!", null, null, t);
            msg.save(this.datacenter, this.jobDefID);
            this.isValid = t.getMessage() != null && t.getMessage().contains("Socket read timed out");
        }
        return this.isValid;
    }

    private void disable(String flag) {
        if (!"X".equals(flag)) {
            flag = "N";
        }
        this.isValid = false;
        StringBuffer sql = new StringBuffer();
        sql.append("update t_job_trigger set fholderid=null,fisValid='" + flag + "'");
        sql.append(" where fid=?");
        int[] types = new int[]{12};
        Object[] values = new Object[]{this.id};
        try {
            SQL.executeUpdate(this.datacenter, sql.toString(), types, values);
        }
        catch (Throwable t) {
            JobLog msg = new JobLog(JobLog.Type.Error, "disable trigger {" + this.jobDefID + "} failed!", null, null, t);
            msg.save(this.datacenter, this.jobDefID);
        }
    }

    public void inValid() {
        this.disable("X");
    }

    public void disable() {
        this.disable("N");
    }

    public void enable() {
        this.isValid = true;
        try {
            String sql = "update t_job_trigger set fholderid=null, fisValid='Y' where fid=?";
            int[] types = new int[]{12};
            Object[] values = new Object[]{this.id};
            SQL.executeUpdate(this.datacenter, sql.toString(), types, values);
        }
        catch (Throwable t) {
            JobLog msg = new JobLog(JobLog.Type.Error, "enable trigger {" + this.jobDefID + "} failed!", null, null, t);
            msg.save(this.datacenter, this.jobDefID);
        }
    }

    private Job newJob(Date lastTriggeredTime) throws BOSException {
        Map map;
        String state;
        JobState jobState;
        Object[] params;
        int[] types;
        String sql;
        ArrayList result;
        JobDef def = JobDefCache.getJobDef(this.datacenter, this.jobDefID);
        if (this.useCalendar) {
            Context ctx = Ctx.newShadowContext(this.datacenter, def.getProxyUserID());
            boolean isWorkDay = SchedulerUtils.isWorkDay(ctx, def.getProxyOrgID(), lastTriggeredTime);
            if (this.inWorkingDay && !isWorkDay) {
                String description = "trigger in work day, " + lastTriggeredTime + " is not work day, and is skipped!";
                JobLog msg = new JobLog(JobLog.Type.Info, description, null, null, null);
                msg.save(this.datacenter, this.jobDefID);
                return null;
            }
            if (!this.inWorkingDay && isWorkDay) {
                String description = "trigger in nonwork day, " + lastTriggeredTime + " is work day, and is skipped!";
                JobLog msg = new JobLog(JobLog.Type.Info, description, null, null, null);
                msg.save(this.datacenter, this.jobDefID);
                return null;
            }
        }
        if (this.getLastjobinst() != null && def.mutex != null && (result = SQL.executeQuery(this.datacenter, sql = "select fstate from T_JOB_INST WITH(READPAST) where fjobinstid= ? ", types = new int[]{12}, params = new Object[]{this.getLastjobinst()})).size() != 0 && (jobState = JobState.valueOf(state = (String)(map = (Map)result.get(0)).get("fstate"))) != JobState.Complete && jobState != JobState.Aborted && jobState != JobState.Failed && jobState != JobState.Suspended && jobState != JobState.Missed) {
            String description = this.getLastjobinst() + " 's state is " + jobState + ", has unfinished job, and is skipped!";
            JobLog msg = new JobLog(JobLog.Type.Info, description, null, null, null);
            msg.save(this.datacenter, this.jobDefID);
            Context ctx = Ctx.newShadowContext(this.datacenter, def.getProxyUserID());
            Job job = JobServiceFactory.getLocalInstance(ctx).getJobInstance(this.getLastjobinst());
            JobManager.instance().raiseEvent(JobEvent.OnSlow, job);
            return null;
        }
        ClusterStateManager cm = ClusterStateManager.get(this.getDatacenter());
        Timestamp local = cm.toLocalTime(lastTriggeredTime);
        if (StringUtils.isEmpty((String)this.selectedServer) && (Configuration.serviceInstanceIdGenerator().getServerId().equals(this.isolationBoundary) || Configuration.serviceInstanceIdGenerator().getNewServerId().equals(this.isolationBoundary))) {
            this.selectedServer = this.isolationBoundary;
        }
        return def.newInstance(null, local, null, this.selectedServer);
    }
}

