/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.ICoreJobHandler;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.PulseSource;
import com.kingdee.bos.service.job.core.Trigger;
import com.kingdee.bos.service.job.core.TriggerIsolationLevel;
import com.kingdee.bos.service.job.returns.Delay;
import com.kingdee.bos.service.job.util.IListener;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.util.StringUtils;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

class TriggerLoader
implements IJobHandler,
ICoreJobHandler {
    private static final long serialVersionUID = -4773017874745423654L;
    private static Logger log = Logger.getLogger((String)TriggerLoader.class.getName());
    private final String dc;
    private int flag = 0;

    static void init(String dc) {
        try {
            JobInstanceConfig cfg = new JobInstanceConfig((IJobHandler)new TriggerLoader(dc), false);
            cfg.priority = Integer.MIN_VALUE;
            Job job = new Job(null, "trigger loader of {" + dc + "}", cfg, (Object)Boolean.TRUE, new Timestamp(System.currentTimeMillis() + Configuration.jobLoaderDelay()));
            JobManager.instance().add(job);
            log.info((Object)("TriggerLoader of {" + dc + "} is created!"));
        }
        catch (Throwable t) {
            log.error((Object)("init TriggerLoader of {" + dc + "} failed!"), t);
        }
    }

    TriggerLoader(String datacenter) {
        this.dc = datacenter;
    }

    @Override
    public Object execute(Job job) {
        int t = 180;
        Boolean first = (Boolean)job.getParameters();
        try {
            if (!ClusterStateManager.isReady(this.dc)) {
                return new Delay(60);
            }
            if (first.booleanValue()) {
                t = this.cleanup();
                return new Delay(Boolean.FALSE, t);
            }
            t = this.load();
            return new Delay(t);
        }
        catch (Throwable e) {
            log.error((Object)("background scheduler service loading trigger from datacenter {" + this.dc + "} is failed!"), e);
            return new Delay(first, t);
        }
    }

    private int cleanup() throws Exception {
        SQL.executeUpdate(this.dc, TriggerLoader.sql4cleanup(Configuration.instanceId()));
        log.debug((Object)("trigger loader of background scheduler service for datacenter {" + this.dc + "} is initiated!"));
        return 10;
    }

    private int load() throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from T_JOB_TRIGGER where fisvalid='Y' AND fisAutoLoad='Y' AND ");
        sql.append("(").append(TriggerIsolationLevel.sqlWhere(this.dc)).append(")");
        sql.append(" and fholderid is null");
        sql.append(" and fvalidateTime<=?");
        int[] types = null;
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Object[] values = null;
        if (!StringUtils.isEmpty((String)Configuration.clusterIsolation())) {
            sql.append(" and fcluster = ?");
            types = new int[]{93, 12};
            values = new Object[]{now, Configuration.clusterIsolation()};
        } else {
            types = new int[]{93};
            values = new Object[]{now};
        }
        ArrayList items = SQL.executeQuery(this.dc, sql.toString(), types, values);
        for (int i = 0; i < items.size(); ++i) {
            Trigger tr = null;
            try {
                tr = Trigger.from(this.dc, (HashMap)items.get(i));
                PulseSource ps = tr.getPulseSource();
                if (ps == null) {
                    throw new BOSException("couldn't find pulse source for this trigger!");
                }
                ps.addTrigger(tr);
                continue;
            }
            catch (Throwable t) {
                if (tr != null) {
                    tr.inValid();
                }
                String description = "trigger loading failed and it's disabled.";
                JobLog msg = new JobLog(JobLog.Type.Error, description, t.getMessage(), null, t);
                msg.save(this.dc, ((HashMap)items.get(i)).get("fjobdefid").toString());
            }
        }
        if (this.flag == 0 || items.size() > 0) {
            this.flag = 1;
            log.debug((Object)("load job trigger for datacenter {" + this.dc + "} at " + new Timestamp(System.currentTimeMillis()) + ", {" + items.size() + "} triggers are loaded!"));
            log.debug((Object)("load job trigger from datacenter {" + this.dc + "}, sql is: \r\n\t" + sql.toString()));
        }
        return 300;
    }

    private static String sql4cleanup(String instanceId) {
        String sql = "update T_JOB_TRIGGER set fholderId=null where fisvalid='Y' AND fholderId='" + instanceId + "'";
        sql = !StringUtils.isEmpty((String)Configuration.clusterIsolation()) ? sql + " and fcluster = '" + Configuration.clusterIsolation() + "'" : sql + " and fcluster is null";
        return sql;
    }

    static {
        ClusterStateManager.OnCleanUp.add(new IListener(){
            private static final long serialVersionUID = 3164061481102743232L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(Object p) throws Exception {
                ClusterStateManager.EventParam param = (ClusterStateManager.EventParam)p;
                try (Statement smt = param.cn.createStatement();){
                    String sql = TriggerLoader.sql4cleanup(param.instanceId);
                    smt.executeUpdate(sql);
                }
            }
        });
    }
}

