/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.pulse;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobDefCache;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.PulseSource;
import com.kingdee.bos.service.job.core.Trigger;
import com.kingdee.bos.service.job.pulse.TimerHandler;
import com.kingdee.bos.service.job.pulse.TimerPulse;
import com.kingdee.bos.service.job.util.Heap;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TimerPulseSource
extends PulseSource {
    public static final String CODE = "timer";
    private static Logger log = Logger.getLogger((String)TimerPulseSource.class.getName());
    private Heap pulses = new Heap();
    static boolean initiated = false;
    private Job timerJob;

    public TimerPulseSource() {
        if (initiated) {
            throw new RuntimeException("Timer pulse source is sington, and has been initated.");
        }
        this.code = CODE;
        this.source = "";
        this.f7 = "";
        this.createJob();
    }

    public TimerPulseSource(String code) {
        this.code = code;
        this.source = "";
        this.f7 = "";
        this.createJob();
    }

    private void createJob() {
        Job job;
        JobInstanceConfig cfg = new JobInstanceConfig(new TimerHandler(this), false, true, 0);
        this.timerJob = job = new Job(null, "\u5b9a\u65f6\u5668" + this.code, cfg, (Object)Boolean.TRUE);
        try {
            JobManager.instance().add(job);
            log.debug((Object)("timer pulse source " + this.code + " is initiated!"));
        }
        catch (Exception e) {
            log.debug((Object)("timer pulse source " + this.code + " initiation failed!"), (Throwable)e);
        }
    }

    public Job getTimerJob() {
        return this.timerJob;
    }

    @Override
    protected synchronized void addTrigger(Trigger tr) throws Exception {
        TimerPulse pulse = new TimerPulse(tr);
        if (pulse.nextFireTime() == null) {
            tr.inValid();
            JobLog msg = new JobLog(JobLog.Type.Info, "inValid trigger {" + tr.getJobDefID() + "} because has no fire time! schedulerPlan is " + tr.getSchedulePlan(), null, null, null);
            msg.save(tr.getDatacenter(), tr.getJobDefID());
            throw new IllegalArgumentException("trigger {" + tr.getKey() + "} has no fire time!");
        }
        if (pulse.setLoaded()) {
            this.add(pulse);
            Job job = JobManager.instance().removeWaitingJob(((TimerPulseSource)tr.getPulseSource()).getTimerJob().getKey());
            if (job != null) {
                this.createJob();
            }
        }
    }

    @Override
    protected synchronized void removeTrigger(Trigger tr) {
        this.remove(tr.getKey());
    }

    private void remove(String key) {
        this.pulses.remove(key);
    }

    synchronized TimerPulse top() {
        if (this.pulses.size() == 0) {
            return null;
        }
        return (TimerPulse)this.pulses.top();
    }

    synchronized TimerPulse pop() {
        if (this.pulses.size() == 0) {
            return null;
        }
        TimerPulse pulse = (TimerPulse)this.pulses.pop();
        this.remove(pulse.getKey());
        return pulse;
    }

    synchronized void add(TimerPulse pulse) {
        this.pulses.push(pulse);
    }

    @Override
    protected void verify(String schedulePlan) throws BOSException {
        TimerPulse.verify(schedulePlan);
    }

    @Override
    protected boolean isAutoLoad(Trigger tr) {
        return true;
    }

    @Override
    protected synchronized void removeTrigger(String datacenter, String triggerId) {
        this.remove(Trigger.generateKey(triggerId, datacenter));
    }

    @Override
    protected int triggerCount() {
        return this.pulses.size();
    }

    @Override
    protected synchronized List<String> getAllTriggers() {
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList list = this.pulses.toArray();
        for (int i = 0; i < list.size(); ++i) {
            StringBuffer sb = new StringBuffer();
            Trigger trigger = ((TimerPulse)list.get(i)).getTrigger();
            try {
                sb.append(JobDefCache.getJobDef(trigger.getDatacenter(), trigger.getJobDefID()).getTitle()).append(",");
            }
            catch (BOSException e) {
                log.error((Object)"getJobDef failed ", (Throwable)e);
            }
            sb.append(trigger.getId());
            sb.append("; datacenter{").append(trigger.getDatacenter()).append("}").append("\r\n");
            sb.append(trigger.getSchedulePlan()).append(",");
            sb.append("\u9694\u79bb\u8fb9\u754c\uff1a").append(trigger.getIsolationBoundary()).append(",");
            sb.append("\u52a0\u8f7d\u5b9e\u4f8b\uff1a").append(trigger.getHolderId()).append(",");
            sb.append("\u5df2\u89e6\u53d1\u6b21\u6570\uff1a").append(trigger.getTriggeredCount()).append("\r\n");
            if (!StringUtils.isEmpty((String)trigger.getLastjobinst())) {
                sb.append("\u6700\u540e\u89e6\u53d1\u4efb\u52a1ID:").append(trigger.getLastjobinst()).append(",");
                sb.append("\u6700\u540e\u89e6\u53d1\u65f6\u95f4\uff1a").append(trigger.getLastTriggeredTime()).append("\r\n");
            }
            if (!StringUtils.isEmpty((String)trigger.getSelectedServer())) {
                sb.append("\u6307\u5b9a\u5b9e\u4f8b\uff1a").append(trigger.getSelectedServer()).append("\r\n");
            }
            ret.add(sb.toString());
        }
        return ret;
    }

    @Override
    protected synchronized Timestamp getNextFireTime(String triggerId) {
        for (TimerPulse tp : this.pulses.toArray()) {
            if (!triggerId.equals(tp.getTrigger().getId())) continue;
            return tp.nextFireTime();
        }
        return null;
    }
}

