/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.util;

import com.kingdee.bos.service.job.util.HeapNode;
import com.kingdee.bos.service.job.util.IHeapElement;
import java.util.ArrayList;
import java.util.HashMap;

public class Heap {
    private ArrayList list;
    private HashMap map;
    private String name;

    public Heap(int initCapacity) {
        this.list = new ArrayList(initCapacity);
        this.map = new HashMap(initCapacity);
    }

    public Heap(String name) {
        this(50);
        this.name = name;
    }

    public Heap() {
        this(50);
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        return this.list.size();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public IHeapElement remove(String key) {
        HeapNode node = (HeapNode)this.map.get(key);
        if (node == null) {
            return null;
        }
        int i = node.index;
        HeapNode tail = this.tail();
        if (i < this.list.size() && this.list.size() > 0) {
            this.set(i, tail);
            if (!this.shiftR(i)) {
                this.shiftL(i);
            }
        }
        this.map.remove(node.key);
        return node.obj;
    }

    public boolean push(IHeapElement obj) {
        if (this.map.containsKey(obj.getKey())) {
            return false;
        }
        HeapNode node = new HeapNode(obj);
        int i = this.add(node);
        this.shiftL(i);
        return true;
    }

    public IHeapElement top() {
        return ((HeapNode)this.list.get((int)0)).obj;
    }

    public IHeapElement get(String key) {
        HeapNode node = (HeapNode)this.map.get(key);
        if (node == null) {
            return null;
        }
        return node.obj;
    }

    public IHeapElement pop() {
        HeapNode head = (HeapNode)this.list.get(0);
        HeapNode tail = this.tail();
        if (this.list.size() > 0) {
            this.set(0, tail);
            this.shiftR(0);
        }
        this.map.remove(head.key);
        return head.obj;
    }

    public ArrayList toArray() {
        ArrayList<IHeapElement> tmp = new ArrayList<IHeapElement>(this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            tmp.add(((HeapNode)this.list.get((int)i)).obj);
        }
        return tmp;
    }

    private boolean shiftL(int i) {
        HeapNode current = (HeapNode)this.list.get(i);
        int index = i;
        while (index > 0) {
            int j = index - 1 >> 1;
            HeapNode node = (HeapNode)this.list.get(j);
            if (current.priority > node.priority) break;
            this.set(index, node);
            index = j;
        }
        this.set(index, current);
        return index != i;
    }

    private boolean shiftR(int i) {
        HeapNode current = (HeapNode)this.list.get(i);
        int index = i;
        int j = (index << 1) + 1;
        int size = this.list.size();
        while (j < size) {
            HeapNode node = (HeapNode)this.list.get(j);
            if (j + 1 < size) {
                HeapNode node2 = (HeapNode)this.list.get(j + 1);
                if (node2.priority < node.priority) {
                    ++j;
                    node = node2;
                }
            }
            if (current.priority < node.priority) break;
            this.set(index, node);
            index = j;
            j = (index << 1) + 1;
        }
        this.set(index, current);
        return index != i;
    }

    private HeapNode tail() {
        int i = this.list.size() - 1;
        return (HeapNode)this.list.remove(i);
    }

    private void set(int i, HeapNode node) {
        this.list.set(i, node);
        node.index = i;
    }

    private int add(HeapNode node) {
        int i = this.list.size();
        this.list.add(node);
        node.index = i;
        this.map.put(node.key, node);
        return i;
    }

    public String toString() {
        return this.name == null ? "Heap" : this.name;
    }
}

