/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.wrapper;

import com.kingdee.bos.BOSClassNotFoundException;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.function.FunctionInvoke;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobLoader;
import com.kingdee.bos.service.job.core.Wrapper;
import com.kingdee.bos.service.job.util.IListener;
import com.kingdee.bos.service.job.util.Xml;
import com.kingdee.bos.service.job.wrapper.FacadeInvoke;
import com.kingdee.bos.service.job.wrapper.FunctionHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.enums.EnumUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.axis.utils.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FunctionWrapper
extends Wrapper
implements IJobHandler,
IListener {
    private static Logger log = Logger.getLogger((String)JobLoader.class.getName());
    private static ThreadLocal currentJob = new ThreadLocal();
    public static final String JOBREF = "$JOB_REF$";
    private static final long serialVersionUID = -1159298530076862467L;
    private String function;
    private String operation;
    private Parameter[] params;

    public static Job currentJob() {
        try {
            return (Job)currentJob.get();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public FunctionWrapper(String function, String operation, Parameter[] params) {
        this.function = function;
        this.operation = operation;
        this.params = params;
    }

    public FunctionWrapper(String config) throws BOSException {
        int i = config.indexOf(";");
        int j = config.indexOf("-");
        this.function = config.substring(0, j);
        this.operation = config.substring(j + 1, i);
        Document doc = Xml.parse(config.substring(i + 1));
        this.params = Parameter.parse(doc);
    }

    public String getFunction() {
        return this.function;
    }

    public String getOperation() {
        return this.operation;
    }

    @Override
    public IJobHandler toHandler() {
        return this;
    }

    @Override
    public IListener toListener() {
        return this;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("function").append(":");
        sb.append(this.function).append("-");
        sb.append(this.operation).append(";");
        sb.append("<doc>").append(Parameter.toXml(this.params)).append("</doc>");
        return sb.toString();
    }

    @Override
    public Object execute(Job job) throws Exception {
        Object o = job.getParameters();
        Object[] array = o instanceof Object[] ? (Object[])o : (o == null ? this.getParams(job.getContext()) : (o.getClass().isArray() ? (Object[])o : new Object[]{o}));
        return this.invoke(job, array);
    }

    private Object[] getParams(Context ctx) throws BOSException {
        if (this.params == null) {
            return new Object[0];
        }
        Object[] values = new Object[this.params.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                String s = this.params[i].value;
                String t = this.params[i].type;
                String e = this.params[i].entityMetaData;
                values[i] = FunctionWrapper.transform(t, s, e, ctx);
                continue;
            }
            catch (Exception ex) {
                log.error((Object)("transform params error! the param seq is " + (i + 1) + ", param value is " + this.params[i].value + ", param type is " + this.params[i].type), (Throwable)ex);
                throw new BOSException("transform params error! the param seq is " + (i + 1) + ", param value is " + this.params[i].value + ", param type is " + this.params[i].type, (Throwable)ex);
            }
        }
        return values;
    }

    public static Object transform(String type, String value, Context ctx) throws BOSException {
        Object v;
        Object object = v = value != null ? value.trim() : "";
        if (type.equals("INTEGER")) {
            v = new Integer(value.length() == 0 ? "0" : value);
        } else if (type.equals("FLOAT")) {
            v = new Float(value.length() == 0 ? "0" : value);
        } else if (type.equals("BOOLEAN")) {
            v = new Boolean(value.length() == 0 ? "false" : value);
        } else if (type.equals("BOID")) {
            v = value.length() == 0 ? null : BOSUuid.read((String)value);
        } else if (type.equals("PK")) {
            v = value.length() == 0 ? null : FunctionHelper.createPKbyBoId(value);
        } else if (type.equals("OBJECTVALUE")) {
            v = value.length() == 0 ? null : FunctionHelper.createObjectValueByBoId(value, ctx);
        } else if (type.equals("DATETIME")) {
            if (value.length() == 0) {
                v = null;
            } else {
                String d = value.indexOf(45) > 0 ? "yyyy-MM-dd" : "yyyy/MM/dd";
                String s = value.indexOf(32) < 0 ? "" : " ";
                String t = "";
                if (s.length() > 0) {
                    t = value.indexOf(58) == value.lastIndexOf(58) ? "HH:mm" : "HH:mm:ss";
                }
                SimpleDateFormat df = new SimpleDateFormat(d + s + t);
                try {
                    v = df.parse(value);
                }
                catch (ParseException e) {
                    throw new BOSException("value {" + value + "} is not a valid datetime.", (Throwable)e);
                }
            }
        }
        return v;
    }

    public static Object transform(String type, String value, String entityMetaData, Context ctx) throws BOSException {
        Object v;
        Object object = v = value != null ? value.trim() : "";
        if (type.equals("INTEGER")) {
            v = new Integer(value.length() == 0 ? "0" : value);
        } else if (type.equals("FLOAT")) {
            v = new Float(value.length() == 0 ? "0" : value);
        } else if (type.equals("BOOLEAN")) {
            v = new Boolean(value.length() == 0 ? "false" : value);
        } else if (type.equals("BOID")) {
            v = value.length() == 0 ? null : BOSUuid.read((String)value);
        } else if (type.equals("PK")) {
            v = value.length() == 0 ? null : FunctionHelper.createPKbyBoId(value);
        } else if (type.equals("OBJECTVALUE")) {
            v = value.length() == 0 ? null : FunctionHelper.createObjectValueByEntityTypeAndBoid(entityMetaData, value, ctx);
        } else if (type.equals("DATETIME")) {
            if (value.length() == 0) {
                v = null;
            } else {
                String d = value.indexOf(45) > 0 ? "yyyy-MM-dd" : "yyyy/MM/dd";
                String s = value.indexOf(32) < 0 ? "" : " ";
                String t = "";
                if (s.length() > 0) {
                    t = value.indexOf(58) == value.lastIndexOf(58) ? "HH:mm" : "HH:mm:ss";
                }
                SimpleDateFormat df = new SimpleDateFormat(d + s + t);
                try {
                    v = df.parse(value);
                }
                catch (ParseException e) {
                    throw new BOSException("value {" + value + "} is not a valid datetime.", (Throwable)e);
                }
            }
        } else if (type.equals("ENUM")) {
            if (!StringUtils.isEmpty((String)entityMetaData)) {
                try {
                    v = EnumUtils.getEnum(Class.forName(entityMetaData), (String)value);
                }
                catch (ClassNotFoundException e) {
                    throw new BOSClassNotFoundException("Get data type error.", (Throwable)e);
                }
            } else {
                v = null;
            }
        } else if (type.equals("OBJECTCOLLECTION")) {
            if (!StringUtils.isEmpty((String)value)) {
                try {
                    v = FunctionHelper.createObjectCollectionByEntityTypeAndBoids(entityMetaData, value, ctx);
                }
                catch (Exception e) {
                    throw new BOSClassNotFoundException("Get data type error.", (Throwable)e);
                }
            } else {
                v = null;
            }
        }
        return v;
    }

    private static EntityObjectInfo getEntityObjectInfoByMetaDataName(Context ctx, String metaDataName) throws ClassNotFoundException {
        String metaRef = metaDataName;
        String metaPack = metaRef.substring(0, metaRef.lastIndexOf(46));
        String metaName = metaRef.substring(metaRef.lastIndexOf(46) + 1);
        MetaDataPK metaPK = MetaDataPK.create((String)metaPack, (String)metaName);
        EntityObjectInfo entity = MetaDataLoader.getEntity((Context)ctx, (IMetaDataPK)metaPK);
        return entity;
    }

    @Override
    public void handle(Object o) throws Exception {
        Job job = (Job)o;
        this.invoke(job, this.getParams(job.getContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke(Job job, Object[] params) throws Exception {
        MetaDataPK func = new MetaDataPK(this.function);
        Context ctx = job.getContext();
        for (int i = 0; i < params.length; ++i) {
            if (!JOBREF.equals(params[i])) continue;
            params[i] = job;
        }
        currentJob.set(job);
        try {
            ctx = (Context)ObjectUtils.createCopy((Object)ctx);
            ctx.put((Object)"jobInstId", (Object)job.getId());
            Object object = this.call(ctx, (IMetaDataPK)func, this.operation, params);
            return object;
        }
        finally {
            currentJob.set(null);
        }
    }

    Object call(Context ctx, IMetaDataPK func, String operation, Object[] params) throws BOSException {
        log.error((Object)("invoke job method: func:" + func + ",operation:" + operation + ",function:" + this.function));
        BusinessObjectInfo businessObject = null;
        try {
            businessObject = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getBusinessObject(func);
        }
        finally {
            if ("fade".equals(businessObject.getBOSType().toString())) {
                return FacadeInvoke.localInvoke(ctx, func, operation, params);
            }
            return FunctionInvoke.localInvoke((Context)ctx, (IMetaDataPK)func, (String)operation, (Object[])params);
        }
    }

    public static class Parameter
    implements Serializable {
        private static final long serialVersionUID = 7530248459218282820L;
        public String name;
        public String alias;
        public String type;
        public String entityMetaData;
        public String value;
        public String valueText;

        public Parameter(String name, String alias, String type, String entityMetaData, String value, String valueText) {
            this.name = name;
            this.alias = alias;
            this.type = type;
            this.entityMetaData = entityMetaData;
            this.value = value;
            this.valueText = valueText;
        }

        public String toXml() {
            StringBuffer sb = new StringBuffer();
            sb.append("<parameter");
            sb.append(" name='").append(Xml.escape(this.name)).append("'");
            sb.append(" alias='").append(Xml.escape(this.alias)).append("'");
            sb.append(" type='").append(Xml.escape(this.type)).append("'");
            sb.append(" entityMetaData='").append(Xml.escape(this.entityMetaData)).append("'");
            sb.append(" value='").append(Xml.escape(this.value)).append("'");
            sb.append(" valueText='").append(Xml.escape(this.valueText)).append("'");
            sb.append("/>");
            return sb.toString();
        }

        public String toString() {
            return this.toXml();
        }

        public static String toXml(Parameter[] parameters) {
            if (parameters == null || parameters.length == 0) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < parameters.length; ++i) {
                sb.append("\r\n\t").append(parameters[i].toXml());
            }
            return sb.toString();
        }

        public static Parameter[] parse(Document doc) {
            NodeList list = doc.getElementsByTagName("parameter");
            Parameter[] params = new Parameter[list.getLength()];
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                NamedNodeMap attributes = node.getAttributes();
                String name = attributes.getNamedItem("name").getNodeValue();
                String alias = attributes.getNamedItem("alias").getNodeValue();
                String type = attributes.getNamedItem("type").getNodeValue();
                String entityMetaData = attributes.getNamedItem("entityMetaData").getNodeValue();
                String value = attributes.getNamedItem("value").getNodeValue();
                String valueText = attributes.getNamedItem("valueText").getNodeValue();
                params[i] = new Parameter(name, alias, type, entityMetaData, value, valueText);
            }
            return params;
        }
    }
}

