/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.wrapper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Wrapper;
import com.kingdee.bos.service.job.util.IListener;

public class InterfaceWrapper
extends Wrapper {
    private static final long serialVersionUID = -8044889395584739912L;
    private Object ins;

    public InterfaceWrapper(Object o) {
        this.init(o);
    }

    InterfaceWrapper(String className) throws BOSException {
        try {
            Class<?> cls = Class.forName(className);
            Object o = cls.newInstance();
            this.init(o);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void init(Object o) {
        if (!(o instanceof IJobHandler) && !(o instanceof IListener)) {
            throw new IllegalArgumentException("{" + o.getClass().getName() + "} dosn't implement interface IHandler or IListener, and couldn't be wrapped!");
        }
        this.ins = o;
    }

    @Override
    public IJobHandler toHandler() {
        if (this.ins instanceof IJobHandler) {
            return (IJobHandler)this.ins;
        }
        throw new RuntimeException("{" + this.ins.getClass().getName() + "} dosn't implement interface IHandler");
    }

    @Override
    public IListener toListener() {
        if (this.ins instanceof IListener) {
            return (IListener)this.ins;
        }
        throw new RuntimeException("{" + this.ins.getClass().getName() + "} dosn't implement interface IListener");
    }

    @Override
    public String toString() {
        return "interface:" + this.ins.getClass().getName();
    }
}

