/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.scheduler;

import com.kingdee.bos.service.scheduler.MultiSchedulerFactory1;
import com.kingdee.util.objbuddy.BuddyObjectFactory;
import com.kingdee.util.objbuddy.IBuddyObject;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class BOSSchedulerService
implements ServletContextListener {
    boolean isEnableScheduler = false;
    boolean running = false;
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.service.scheduler.BOSSchedulerService");
    private final IBuddyObject buddy = BuddyObjectFactory.getInstance((Object)this);

    public BOSSchedulerService() {
        com.kingdee.bos.service.job.core.BOSSchedulerService.init();
        log.debug((Object)"BOSSchedulerService is initiated!");
    }

    public void contextInitialized(ServletContextEvent event) {
        this.isEnableScheduler = BOSSchedulerService.loadSchedulerConfig();
        this.startSchedulerService();
        this.buddy.initialize();
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.stopSchedulerService();
        this.buddy.terminate();
    }

    public static boolean loadSchedulerConfig() {
        return false;
    }

    public static int getIdelWaiteTime() {
        return MultiSchedulerFactory1.IDEL_WAITE_TIME;
    }

    public static int getWorkThreadPoolSize() {
        return MultiSchedulerFactory1.WORK_THREAD_POOL_SIZE;
    }

    public static void setIdelWaiteTime(int idelWaiteTime) {
        MultiSchedulerFactory1.IDEL_WAITE_TIME = idelWaiteTime < 100 ? 100 : idelWaiteTime;
    }

    public static void setWorkThreadPoolSize(int workThreadPoolSize) {
        int iSize = workThreadPoolSize;
        if (iSize < 3) {
            iSize = 3;
        } else if (iSize > 50) {
            iSize = 50;
        }
        MultiSchedulerFactory1.WORK_THREAD_POOL_SIZE = iSize;
    }

    public void startSchedulerService() {
        if (this.running) {
            return;
        }
        com.kingdee.bos.service.job.core.BOSSchedulerService.startWorkerThread();
        log.debug((Object)"BOSSchedulerService is started!");
        this.running = true;
        this.buddy.operationPerformed("startSchedulerService");
    }

    public void stopSchedulerService() {
        if (!this.running) {
            return;
        }
        com.kingdee.bos.service.job.core.BOSSchedulerService.stopWorkerThread();
        this.running = false;
        log.debug((Object)"BOSSchedulerService is stopped!");
        this.buddy.operationPerformed("stopSchedulerService");
    }
}

