/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.scheduler;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.utils.DBConnectionManager;

class BosJdbcStoreImpl
extends JobStoreSupport {
    BosJdbcStoreImpl() {
    }

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        this.setUseDBLocks(true);
        super.initialize(loadHelper, signaler);
    }

    protected void recoverJobs() throws JobPersistenceException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
            this.recoverJobs(conn);
        }
        catch (Exception e) {
            throw new JobPersistenceException("Error recovering jobs: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                this.getLockHandler().releaseLock("TRIGGER_ACCESS");
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected void cleanVolatileTriggerAndJobs() throws JobPersistenceException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
            this.recoverJobs(conn);
        }
        catch (Exception e) {
            throw new JobPersistenceException("Error cleaning volatile data: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                this.getLockHandler().releaseLock("TRIGGER_ACCESS");
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeJobAndTrigger(JobDetail newJob, Trigger newTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
            this.storeJob(conn, newJob, false);
            this.storeTrigger(conn, (OperableTrigger)newTrigger, newJob, false, "WAITING", false, false);
        }
        finally {
            this.getLockHandler().releaseLock("TRIGGER_ACCESS");
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeJob(JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
            this.storeJob(conn, newJob, replaceExisting);
        }
        finally {
            this.getLockHandler().releaseLock("TRIGGER_ACCESS");
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeJob(String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
            boolean bl = this.removeJob(conn, new JobKey(jobName, groupName));
            return bl;
        }
        finally {
            this.getLockHandler().releaseLock("TRIGGER_ACCESS");
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobDetail retrieveJob(String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            JobDetail jobDetail = this.retrieveJob(conn, new JobKey(jobName, groupName));
            return jobDetail;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTrigger(Trigger newTrigger, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
            this.storeTrigger(conn, (OperableTrigger)newTrigger, null, replaceExisting, "WAITING", false, false);
        }
        finally {
            this.getLockHandler().releaseLock("TRIGGER_ACCESS");
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTrigger(String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
            boolean bl = this.removeTrigger(conn, new TriggerKey(triggerName, groupName));
            return bl;
        }
        finally {
            this.getLockHandler().releaseLock("TRIGGER_ACCESS");
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger retrieveTrigger(String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            OperableTrigger operableTrigger = this.retrieveTrigger(conn, new TriggerKey(triggerName, groupName));
            return operableTrigger;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeCalendar(String calName, Calendar calendar, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.storeCalendar(conn, calName, calendar, replaceExisting, false);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCalendar(String calName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            boolean bl = this.removeCalendar(conn, calName);
            return bl;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Calendar retrieveCalendar(String calName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            Calendar calendar = this.retrieveCalendar(conn, calName);
            return calendar;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfJobs() throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            int n = this.getNumberOfJobs(conn);
            return n;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfTriggers() throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            int n = this.getNumberOfTriggers(conn);
            return n;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCalendars() throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            int n = this.getNumberOfCalendars(conn);
            return n;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getJobNames(String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            JobKey[] jobs = this.getJobNames(conn, GroupMatcher.jobGroupEquals((String)groupName)).toArray(new JobKey[0]);
            String[] names = new String[jobs.length];
            for (int i = 0; i < jobs.length; ++i) {
                names[i] = jobs[i].getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTriggerNames(String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            TriggerKey[] trs = this.getTriggerNames(conn, GroupMatcher.triggerGroupEquals((String)groupName)).toArray(new TriggerKey[0]);
            String[] names = new String[trs.length];
            for (int i = 0; i < trs.length; ++i) {
                names[i] = trs[i].getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getJobGroupNames() throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            List list = this.getJobGroupNames(conn);
            return list;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTriggerGroupNames() throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            List list = this.getTriggerGroupNames(conn);
            return list;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCalendarNames() throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            List list = this.getCalendarNames(conn);
            return list;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OperableTrigger> getTriggersForJob(String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            List list = this.getTriggersForJob(conn, new JobKey(jobName, groupName));
            return list;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTriggerState(String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            int n = this.getTriggerState(conn, new TriggerKey(triggerName, groupName)).ordinal();
            return n;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseTrigger(String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
            this.pauseTrigger(conn, new TriggerKey(triggerName, groupName));
        }
        finally {
            this.getLockHandler().releaseLock("TRIGGER_ACCESS");
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseTriggerGroup(String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
            this.pauseTriggerGroup(conn, GroupMatcher.triggerGroupEquals((String)groupName));
        }
        finally {
            this.getLockHandler().releaseLock("TRIGGER_ACCESS");
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public void pauseJob(String jobName, String groupName) throws JobPersistenceException {
        throw new UnsupportedOperationException("TODO: not implemented ...");
    }

    public void pauseJobGroup(String groupName) throws JobPersistenceException {
        throw new UnsupportedOperationException("TODO: not implemented ...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTrigger(String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
            this.resumeTrigger(conn, new TriggerKey(triggerName, groupName));
        }
        finally {
            this.getLockHandler().releaseLock("TRIGGER_ACCESS");
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTriggerGroup(String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
            this.resumeTriggerGroup(conn, GroupMatcher.triggerGroupEquals((String)groupName));
        }
        finally {
            this.getLockHandler().releaseLock("TRIGGER_ACCESS");
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public void resumeJob(String jobName, String groupName) throws JobPersistenceException {
        throw new UnsupportedOperationException("TODO: not implemented ...");
    }

    public void resumeJobGroup(String groupName) throws JobPersistenceException {
        throw new UnsupportedOperationException("TODO: not implemented ...");
    }

    public void pauseAll() throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
            this.pauseAll(conn);
        }
        finally {
            this.getLockHandler().releaseLock("TRIGGER_ACCESS");
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public void resumeAll() throws JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
            this.resumeAll(conn);
        }
        finally {
            this.getLockHandler().releaseLock("TRIGGER_ACCESS");
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public Trigger acquireNextTrigger() throws JobPersistenceException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
            List triggers = this.acquireNextTrigger(conn, 0L, 0, 1L);
            Trigger trigger = (Trigger)triggers.get(0);
            return trigger;
        }
        catch (Exception e) {
            throw new JobPersistenceException("Error acquiring next firable trigger: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                this.getLockHandler().releaseLock("TRIGGER_ACCESS");
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void releaseAcquiredTrigger(Trigger trigger) throws JobPersistenceException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
            this.releaseAcquiredTrigger(conn, (OperableTrigger)trigger);
        }
        catch (Exception e) {
            throw new JobPersistenceException("Error releasing acquired trigger: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                this.getLockHandler().releaseLock("TRIGGER_ACCESS");
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public TriggerFiredBundle triggerFired(Trigger trigger) throws JobPersistenceException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
            TriggerFiredBundle tfb = null;
            tfb = this.triggerFired(conn, (OperableTrigger)trigger);
            TriggerFiredBundle triggerFiredBundle = tfb;
            return triggerFiredBundle;
        }
        catch (JobPersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobPersistenceException("trigger Fired meet error : " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                this.getLockHandler().releaseLock("TRIGGER_ACCESS");
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void triggeredJobComplete(Trigger trigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction triggerInstCode) throws JobPersistenceException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
            this.triggeredJobComplete(conn, (OperableTrigger)trigger, jobDetail, triggerInstCode);
        }
        catch (JobPersistenceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobPersistenceException("triggeredJobComplete failure: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                this.getLockHandler().releaseLock("TRIGGER_ACCESS");
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected JobStoreSupport.RecoverMisfiredJobsResult doRecoverMisfires() throws JobPersistenceException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
            try {
                JobStoreSupport.RecoverMisfiredJobsResult recoverMisfiredJobsResult = this.recoverMisfiredJobs(conn, false);
                return recoverMisfiredJobsResult;
            }
            catch (Exception e) {
                try {
                    throw new JobPersistenceException(e.getMessage(), (Throwable)e);
                }
                catch (JobPersistenceException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new JobPersistenceException("doRecoverMisfires failure: " + e3.getMessage(), (Throwable)e3);
                }
            }
        }
        finally {
            if (conn != null) {
                this.getLockHandler().releaseLock("TRIGGER_ACCESS");
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected boolean doCheckin() throws JobPersistenceException {
        Connection conn = null;
        boolean obtainedTriggerLock = false;
        boolean recovered = false;
        try {
            conn = this.getConnection();
            this.getLockHandler().obtainLock(conn, "STATE_ACCESS");
            List failedRecords = this.clusterCheckIn(conn);
            if (failedRecords.size() > 0) {
                this.getLockHandler().obtainLock(conn, "TRIGGER_ACCESS");
                obtainedTriggerLock = true;
                this.clusterRecover(conn, failedRecords);
                recovered = true;
            }
        }
        catch (Exception e) {
            throw new JobPersistenceException("doCheckin failure: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                if (obtainedTriggerLock) {
                    this.getLockHandler().releaseLock("TRIGGER_ACCESS");
                }
                this.getLockHandler().releaseLock("STATE_ACCESS");
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        this.firstCheckIn = false;
        return recovered;
    }

    protected Connection getConnection() throws JobPersistenceException {
        try {
            Connection conn = DBConnectionManager.getInstance().getConnection(this.getDataSource());
            if (conn == null) {
                throw new SQLException("Could not get connection from DataSource '" + this.getDataSource() + "'");
            }
            return conn;
        }
        catch (SQLException sqle) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getDataSource() + "': " + sqle.toString(), (Throwable)sqle);
        }
        catch (Exception e) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getDataSource() + "': " + e.toString(), (Throwable)e);
        }
    }

    public boolean replaceTrigger(String arg1, String arg2, Trigger arg3) throws JobPersistenceException {
        return false;
    }

    public Set getPausedTriggerGroups() throws JobPersistenceException {
        return null;
    }

    public void storeCalendar(String calName, Calendar calendar, boolean replaceExisting, boolean arg4) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.storeCalendar(calName, calendar, replaceExisting);
    }

    public Trigger acquireNextTrigger(long arg1) throws JobPersistenceException {
        return this.acquireNextTrigger();
    }

    protected Object executeInLock(String arg0, JobStoreSupport.TransactionCallback arg1) throws JobPersistenceException {
        return null;
    }

    protected Connection getNonManagedTXConnection() throws JobPersistenceException {
        return null;
    }
}

