/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.scheduler;

import com.kingdee.bos.service.scheduler.BOSStdSchedulerFactory;
import com.kingdee.bos.service.scheduler.util.SchedulerUtils;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.XMLConfiguration;
import com.kingdee.util.objbuddy.BuddyObjectFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.impl.SchedulerRepository;

public class MultiSchedulerFactory1
implements SchedulerFactory {
    public static final String DEFAULT_INSTANCE_ID = "SIMPLE_NON_CLUSTERED";
    public static final String DEFAULT_SCHEDULER_NAME = "SimpleQuartzScheduler";
    public static final String DEFAULT_AIS_INSTANCE_ID = "BOS_INSTANCE";
    public static final String SCHEDULER_NAME_BOS_PREFIX = "BOSScheduler";
    public static int IDEL_WAITE_TIME = -1;
    public static int WORK_THREAD_POOL_SIZE = 5;
    private boolean initialized = false;
    private static MultiSchedulerFactory1 instance = null;
    Properties baseProps = new Properties();
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.service.scheduler.MultiSchedulerFactory1");

    private static Logger getLog() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MultiSchedulerFactory1() throws SchedulerException {
        if (this.initialized) {
            return;
        }
        boolean useDefault = false;
        String requestedFile = System.getProperty("org.quartz.properties");
        if (requestedFile != null) {
            FileInputStream propFile = null;
            try {
                propFile = new FileInputStream(requestedFile);
                this.baseProps = new Properties();
                this.baseProps.load(propFile);
            }
            catch (IOException ioe) {
                logger.error((Object)("quartz properties file: '" + requestedFile + "' could not be read. use default quartz.properties"), (Throwable)ioe);
                useDefault = true;
            }
            finally {
                try {
                    if (propFile != null) {
                        ((InputStream)propFile).close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"InputStream close error!", (Throwable)e);
                }
            }
        } else {
            logger.warn((Object)"jvm option '-Dorg.quartz.properties' not setted,use default quartz.properties");
            useDefault = true;
        }
        if (useDefault) {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("com/kingdee/bos/service/scheduler/quartz.properties");
            this.baseProps = new Properties();
            try {
                this.baseProps.load(in);
            }
            catch (IOException ioe) {
                throw new SchedulerException("Resource properties file: 'quartz.properties' could not be read from the classpath.", (Throwable)ioe);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"InputStream close error!", (Throwable)e);
                }
            }
        }
    }

    private void repairStorePath(Properties properties) {
        File storePathFile;
        if (properties == null) {
            return;
        }
        String jobStoreClass = properties.getProperty("org.quartz.jobStore.class");
        if (!"com.kingdee.bos.support.quartz.FileJobStore".equals(jobStoreClass)) {
            return;
        }
        String storePath = System.getProperty("org.quartz.jobStore.StorePath");
        if (storePath != null && storePath.trim().length() > 0 && (storePathFile = new File(storePath)) != null && storePathFile.isDirectory() && storePathFile.exists()) {
            properties.put("org.quartz.jobStore.StorePath", storePath);
            logger.debug((Object)("org.quartz.jobStore.StorePath is " + storePath));
            return;
        }
        String serverConfigFileName = System.getProperty("bos.config", "bosconfig.xml");
        File serverConfigFile = new File(serverConfigFileName);
        if (serverConfigFile != null && serverConfigFile.exists()) {
            String serverConfigFilePath = serverConfigFile.getParent();
            properties.put("org.quartz.jobStore.StorePath", serverConfigFilePath);
            logger.debug((Object)("org.quartz.jobStore.StorePath is " + serverConfigFilePath));
        }
    }

    public Scheduler createScheduler(String aisName, String dataSource, String jndiUrl, String contextFactory, String securityCredential, String securityPrincipal, String solution) throws SchedulerException {
        Properties quartzProps = new Properties();
        quartzProps.putAll((Map<?, ?>)this.baseProps);
        this.repairStorePath(quartzProps);
        String jndiName = null;
        jndiName = dataSource == null ? "jdbc/" + aisName : dataSource;
        quartzProps.setProperty("org.quartz.scheduler.instanceName", SchedulerUtils.getSchedulerKey(aisName, solution));
        quartzProps.setProperty("org.quartz.scheduler.instanceId", SchedulerUtils.getSchedulerKey(aisName, solution));
        this.saftySetProperty(quartzProps, "org.quartz.scheduler.idleWaitTime", Long.toString(IDEL_WAITE_TIME));
        if (jndiUrl != null) {
            quartzProps.setProperty("org.quartz.jobStore.url", jndiUrl);
        }
        if (jndiName != null) {
            quartzProps.setProperty("org.quartz.jobStore.jndiURL", jndiName);
        }
        if (contextFactory != null) {
            quartzProps.setProperty("org.quartz.jobStore.initial", contextFactory);
        }
        if (securityCredential != null) {
            quartzProps.setProperty("org.quartz.jobStore.credentials", securityCredential);
        }
        if (securityPrincipal != null) {
            quartzProps.setProperty("org.quartz.jobStore.principal", securityPrincipal);
        }
        BOSStdSchedulerFactory factory = new BOSStdSchedulerFactory(quartzProps);
        Scheduler sched = factory.getScheduler();
        BuddyObjectFactory.getInstance((Object)sched).initialize();
        return sched;
    }

    public Scheduler getScheduler() throws SchedulerException {
        if (!this.initialized) {
            throw new SchedulerException("you must call createRemoteScheduler or createScheduler methods before calling getScheduler()");
        }
        SchedulerRepository schedRep = SchedulerRepository.getInstance();
        Scheduler sched = schedRep.lookup(DEFAULT_SCHEDULER_NAME);
        return sched;
    }

    public Scheduler getScheduler(String ais, String solution) throws SchedulerException {
        String schedulerKey;
        SchedulerRepository schedRep = SchedulerRepository.getInstance();
        Scheduler sched = schedRep.lookup(schedulerKey = SchedulerUtils.getSchedulerKey(ais, solution));
        if (sched == null) {
            this.createScheduler(ais, solution);
            sched = schedRep.lookup(schedulerKey);
        }
        if (sched == null) {
            MultiSchedulerFactory1.getLog().warn((Object)("Scheduler instance not found with AIS name '" + ais + "'"));
        }
        return sched;
    }

    public void createScheduler(String aisName, String solution) {
        ConfigurationItem ejbItem;
        ConfigurationItem aisItem;
        ConfigurationItem aisInfoItem;
        String message;
        String schedulerKey;
        if (aisName == null || aisName.trim().length() <= 0) {
            String message2 = "\"aisName\" is null!";
            throw new IllegalArgumentException(message2);
        }
        if (solution == null || solution.trim().length() <= 0) {
            String message3 = "\"solution\" is null!";
            throw new IllegalArgumentException(message3);
        }
        SchedulerRepository schedulerRepository = SchedulerRepository.getInstance();
        Scheduler scheduler = schedulerRepository.lookup(schedulerKey = SchedulerUtils.getSchedulerKey(aisName, solution));
        if (scheduler != null) {
            return;
        }
        String serverConfigFileName = System.getProperty("bos.config", "bosconfig.xml");
        if (serverConfigFileName == null || serverConfigFileName.trim().length() <= 0) {
            logger.debug((Object)"\"bosconfig\" file path is null!");
            return;
        }
        logger.debug((Object)"\"bosconfig\" file path is \"fileName\"!");
        File serverConfigFile = new File(serverConfigFileName);
        if (serverConfigFile == null || !serverConfigFile.exists()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Can't find bosconfig file!");
            buffer.append("The config file name is \"" + serverConfigFileName + "\"");
            String message4 = buffer.toString();
            logger.error((Object)message4);
            return;
        }
        XMLConfiguration configuration = XMLConfiguration.getInstance((File)serverConfigFile);
        ConfigurationItem solutionInfoItem = configuration.getConfigItem("SolutionInfo");
        if (solutionInfoItem == null) {
            String message5 = "The configitem of SolutionInfo is null!";
            logger.error((Object)message5);
            return;
        }
        ConfigurationItem solutionItem = solutionInfoItem.getChild(solution);
        if (solutionItem == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("The solution that it's name is " + solution + " is't exist!");
            message = buffer.toString();
            logger.error((Object)message);
        }
        ConfigurationItem configurationItem = aisInfoItem = solutionItem == null ? null : solutionItem.getChild("AISInfo");
        if (aisInfoItem == null) {
            message = "The configitem of AISInfo is null!";
            logger.error((Object)message);
        }
        ConfigurationItem configurationItem2 = aisItem = aisInfoItem == null ? null : aisInfoItem.getChild(aisName);
        if (aisItem == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("The ais that it's name is " + aisName + " is't exist!");
            String message6 = buffer.toString();
            logger.error((Object)message6);
        }
        String dataSource = null;
        String jndiRL = null;
        String contextFactory = null;
        String securityCredential = null;
        String securityPrincipal = null;
        ConfigurationItem configurationItem3 = ejbItem = aisItem == null ? null : aisItem.getChild("EJBService");
        if (ejbItem == null) {
            String message7 = "The configitem of EJBService is null!";
            logger.error((Object)message7);
            dataSource = null;
            jndiRL = null;
            contextFactory = "com.apusic.naming.jndi.CNContextFactory";
            securityCredential = "admin";
            securityPrincipal = "admin";
        } else {
            dataSource = ejbItem.getProperty("datasource");
            jndiRL = ejbItem.getProperty("jndiURL");
            contextFactory = ejbItem.getProperty("contextFactory");
            securityCredential = ejbItem.getProperty("securityCredential");
            securityPrincipal = ejbItem.getProperty("securityPrincipal");
        }
        try {
            this.createScheduler(aisName, dataSource, jndiRL, contextFactory, securityCredential, securityPrincipal, solution);
        }
        catch (SchedulerException e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("cannot init scheduler for ais =");
            buffer.append(aisName);
            buffer.append(";datasource=");
            buffer.append(dataSource);
            String message8 = buffer.toString();
            logger.error((Object)message8, (Throwable)e);
        }
    }

    public Collection getAllSchedulers() throws SchedulerException {
        return SchedulerRepository.getInstance().lookupAll();
    }

    public static MultiSchedulerFactory1 getInstance() {
        return instance;
    }

    private void saftySetProperty(Properties prop, String key, String value) {
        if (prop != null && prop.getProperty(key) == null) {
            prop.setProperty(key, value);
        }
    }

    public Scheduler getScheduler(String schedulername) throws SchedulerException {
        return this.getScheduler(schedulername, schedulername);
    }

    static {
        try {
            instance = new MultiSchedulerFactory1();
        }
        catch (SchedulerException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

