/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.scheduler;

import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.bos.service.scheduler.IORMScheduler;
import com.kingdee.bos.service.scheduler.MultiSchedulerFactory1;
import com.kingdee.bos.service.scheduler.util.SchedulerUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.matchers.GroupMatcher;

public class ORMScheduler
extends ORMObject
implements IORMScheduler {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.service.scheduler.ORMScheduler");
    public static final String CONFIG_ITEM_SCHEDULER = "scheduler";
    private Scheduler sched = null;
    private static boolean bInited = false;

    public static IORMScheduler getInstance(String schedulerKey) throws SchedulerException {
        return ORMScheduler.getInstance(schedulerKey, false);
    }

    public static IORMScheduler getInstance(String schedulerKey, boolean ingnoreInit) throws SchedulerException {
        String ais = SchedulerUtils.getAIS(schedulerKey);
        String solution = SchedulerUtils.getSolution(schedulerKey);
        return ORMScheduler.getInstance(ais, solution, ingnoreInit);
    }

    public static IORMScheduler getInstance(String aisName, String solution) throws SchedulerException {
        return ORMScheduler.getInstance(aisName, solution, false);
    }

    public static IORMScheduler getInstance(String aisName, String solution, boolean ingnoreInit) throws SchedulerException {
        try {
            ORMServiceLocation loc = new ORMServiceLocation(CONFIG_ITEM_SCHEDULER);
            if (loc.isLocal()) {
                return new ORMScheduler(aisName, solution);
            }
            IORMModel sch = RPCEngineFactory.getEngine((String)loc.getServiceURL()).createObject("com.kingdee.bos.service.scheduler.ORMScheduler", IORMScheduler.class, new Class[]{String.class, String.class}, new Object[]{aisName, solution});
            return (IORMScheduler)sch;
        }
        catch (SchedulerException e) {
            if (ingnoreInit) {
                return new ORMScheduler();
            }
            throw e;
        }
    }

    private static void initMySelf() {
        String[][] aisInfo = SchedulerUtils.getDataCenterInfos();
        try {
            ORMScheduler.initAllSchedulerInstances(aisInfo);
        }
        catch (Exception e) {
            log.error((Object)"initMySelf()", (Throwable)e);
        }
    }

    public static void initAllSchedulerInstances(String[][] aisInfo) throws SchedulerException {
        ORMScheduler.initAllSchedulerInstances(aisInfo, true);
    }

    public static void initAllSchedulerInstances(String[][] aisInfo, boolean start) throws SchedulerException {
        if (bInited) {
            return;
        }
        if (aisInfo == null || aisInfo.length == 0) {
            log.warn((Object)"cannot found any  AISInfo in SolutionInfo configuration, no scheduler instance initialized!");
            return;
        }
        if (aisInfo[0].length < 6) {
            throw new SchedulerException("aisInfo format error!");
        }
        for (int i = 0; i < aisInfo.length; ++i) {
            try {
                Scheduler scheduler = MultiSchedulerFactory1.getInstance().createScheduler(aisInfo[i][0], aisInfo[i][1], aisInfo[i][2], aisInfo[i][3], aisInfo[i][4], aisInfo[i][5], aisInfo[i][6]);
                Scheduler my_sched = MultiSchedulerFactory1.getInstance().getScheduler(aisInfo[i][0], aisInfo[i][6]);
                if (my_sched != null) {
                    my_sched.start();
                    log.debug((Object)("start scheduler for ais =" + aisInfo[i][0] + " successfully!"));
                    continue;
                }
                scheduler.start();
                log.warn((Object)("cannot start scheduler for ais =" + aisInfo[i][0] + ";datasource=" + aisInfo[i][1] + "; it's not in respository but created."));
                continue;
            }
            catch (SchedulerException e) {
                log.warn((Object)("cannot init scheduler for ais =" + aisInfo[i][0] + ";datasource=" + aisInfo[i][1]));
                log.debug((Object)("cannot init scheduler for ais =" + aisInfo[i][0] + ";datasource=" + aisInfo[i][1]), (Throwable)e);
            }
        }
        bInited = true;
    }

    public ORMScheduler() {
        log.debug((Object)"empty ormscheduler created");
    }

    public ORMScheduler(String aisName, String solution) throws SchedulerException {
        if (!bInited) {
            ORMScheduler.initMySelf();
        }
        this.sched = MultiSchedulerFactory1.getInstance().getScheduler(aisName, solution);
        if (this.sched == null) {
            throw new SchedulerException("Cannot init ORMScheduler");
        }
        super.registerInterface(IORMScheduler.class, (Object)this);
    }

    @Override
    public String getSchedulerName() throws SchedulerException {
        return this.sched.getSchedulerName();
    }

    @Override
    public String getSchedulerInstanceId() throws SchedulerException {
        return this.sched.getSchedulerInstanceId();
    }

    @Override
    public SchedulerContext getContext() throws SchedulerException {
        return this.sched.getContext();
    }

    @Override
    public void start() throws SchedulerException {
        if (this.sched == null) {
            return;
        }
        this.sched.start();
    }

    @Override
    public void pause() throws SchedulerException {
        if (this.sched == null) {
            return;
        }
        this.sched.pauseAll();
    }

    @Override
    public boolean isPaused() throws SchedulerException {
        return false;
    }

    @Override
    public void shutdown() throws SchedulerException {
        if (this.sched == null || this.isShutdown()) {
            return;
        }
        this.sched.shutdown();
    }

    @Override
    public void shutdown(boolean waitForJobsToComplete) throws SchedulerException {
        if (this.sched == null || this.isShutdown()) {
            return;
        }
        this.sched.shutdown(waitForJobsToComplete);
    }

    @Override
    public boolean isShutdown() throws SchedulerException {
        return this.sched.isShutdown();
    }

    @Override
    public SchedulerMetaData getMetaData() throws SchedulerException {
        return this.sched.getMetaData();
    }

    @Override
    public List getCurrentlyExecutingJobs() throws SchedulerException {
        return this.sched.getCurrentlyExecutingJobs();
    }

    @Override
    public Date scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        if (log.isDebugEnabled() && trigger instanceof CronTrigger) {
            log.debug((Object)("scheduleJob Cron Expression is :" + ((CronTrigger)trigger).getCronExpression()));
        }
        return this.sched.scheduleJob(jobDetail, trigger);
    }

    @Override
    public Date scheduleJob(Trigger trigger) throws SchedulerException {
        if (log.isDebugEnabled() && trigger instanceof CronTrigger) {
            log.debug((Object)("scheduleJob Cron Expression is :" + ((CronTrigger)trigger).getCronExpression()));
        }
        return this.sched.scheduleJob(trigger);
    }

    @Override
    public boolean unscheduleJob(String triggerName, String groupName) throws SchedulerException {
        return this.sched.unscheduleJob(new TriggerKey(triggerName, groupName));
    }

    @Override
    public void addJob(JobDetail jobDetail, boolean replace) throws SchedulerException {
        this.sched.addJob(jobDetail, replace);
    }

    @Override
    public boolean deleteJob(String jobName, String groupName) throws SchedulerException {
        return this.sched.deleteJob(new JobKey(jobName, groupName));
    }

    @Override
    public void triggerJob(String jobName, String groupName) throws SchedulerException {
        this.sched.triggerJob(new JobKey(jobName, groupName));
    }

    @Override
    public void triggerJobWithVolatileTrigger(String jobName, String groupName) throws SchedulerException {
        this.sched.triggerJob(new JobKey(jobName, groupName));
    }

    @Override
    public void pauseJob(String jobName, String groupName) throws SchedulerException {
        this.sched.pauseJob(new JobKey(jobName, groupName));
    }

    @Override
    public void pauseJobGroup(String groupName) throws SchedulerException {
        this.sched.pauseJobs(GroupMatcher.jobGroupEquals((String)groupName));
    }

    @Override
    public void pauseTrigger(String triggerName, String groupName) throws SchedulerException {
        this.sched.pauseTrigger(new TriggerKey(triggerName, groupName));
    }

    @Override
    public void pauseTriggerGroup(String groupName) throws SchedulerException {
        this.sched.pauseTriggers(GroupMatcher.triggerGroupEquals((String)groupName));
    }

    @Override
    public void resumeJob(String jobName, String groupName) throws SchedulerException {
        this.sched.resumeJob(new JobKey(jobName, groupName));
    }

    @Override
    public void resumeJobGroup(String groupName) throws SchedulerException {
        this.sched.resumeJobs(GroupMatcher.jobGroupEquals((String)groupName));
    }

    @Override
    public void resumeTrigger(String triggerName, String groupName) throws SchedulerException {
        this.sched.resumeTrigger(new TriggerKey(triggerName, groupName));
    }

    @Override
    public void resumeTriggerGroup(String groupName) throws SchedulerException {
        this.sched.resumeTriggers(GroupMatcher.triggerGroupEquals((String)groupName));
    }

    @Override
    public void pauseAll() throws SchedulerException {
        this.sched.pauseAll();
    }

    @Override
    public void resumeAll() throws SchedulerException {
        this.sched.resumeAll();
    }

    @Override
    public String[] getJobGroupNames() throws SchedulerException {
        return this.sched.getJobGroupNames().toArray(new String[0]);
    }

    @Override
    public String[] getJobNames(String groupName) throws SchedulerException {
        JobKey[] jobs = this.sched.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName)).toArray(new JobKey[0]);
        String[] jobNames = new String[jobs.length];
        for (int i = 0; i < jobs.length; ++i) {
            jobNames[i] = jobs[i].getName();
        }
        return jobNames;
    }

    @Override
    public Trigger[] getTriggersOfJob(String jobName, String groupName) throws SchedulerException {
        return this.sched.getTriggersOfJob(new JobKey(jobName, groupName)).toArray(new Trigger[0]);
    }

    @Override
    public String[] getTriggerGroupNames() throws SchedulerException {
        return this.sched.getTriggerGroupNames().toArray(new String[0]);
    }

    @Override
    public String[] getTriggerNames(String groupName) throws SchedulerException {
        TriggerKey[] triggers = this.sched.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)groupName)).toArray(new TriggerKey[0]);
        String[] triggerNames = new String[triggers.length];
        for (int i = 0; i < triggers.length; ++i) {
            triggerNames[i] = triggers[i].getName();
        }
        return triggerNames;
    }

    @Override
    public JobDetail getJobDetail(String jobName, String jobGroup) throws SchedulerException {
        return this.sched.getJobDetail(new JobKey(jobName, jobGroup));
    }

    @Override
    public Trigger getTrigger(String triggerName, String triggerGroup) throws SchedulerException {
        return this.sched.getTrigger(new TriggerKey(triggerName, triggerGroup));
    }

    @Override
    public int getTriggerState(String triggerName, String triggerGroup) throws SchedulerException {
        return this.sched.getTriggerState(new TriggerKey(triggerName, triggerGroup)).ordinal();
    }

    @Override
    public void addCalendar(String calName, Calendar calendar, boolean replace) throws SchedulerException {
        this.sched.addCalendar(calName, calendar, replace, false);
    }

    @Override
    public boolean deleteCalendar(String calName) throws SchedulerException {
        return this.sched.deleteCalendar(calName);
    }

    @Override
    public Calendar getCalendar(String calName) throws SchedulerException {
        return this.sched.getCalendar(calName);
    }

    @Override
    public String[] getCalendarNames() throws SchedulerException {
        return this.sched.getCalendarNames().toArray(new String[0]);
    }

    @Override
    public void addGlobalJobListener(JobListener JobListener2) throws SchedulerException {
    }

    @Override
    public void addJobListener(JobListener JobListener2) throws SchedulerException {
        this.sched.getListenerManager().addJobListener(JobListener2);
    }

    @Override
    public boolean removeGlobalJobListener(JobListener JobListener2) throws SchedulerException {
        return false;
    }

    @Override
    public boolean removeJobListener(String name) throws SchedulerException {
        return this.sched.getListenerManager().removeJobListener(name);
    }

    @Override
    public List getGlobalJobListeners() throws SchedulerException {
        return null;
    }

    @Override
    public Set getJobListenerNames() throws SchedulerException {
        HashSet<String> listenerNames = new HashSet<String>();
        for (JobListener ls : this.sched.getListenerManager().getJobListeners()) {
            listenerNames.add(ls.getName());
        }
        return listenerNames;
    }

    @Override
    public JobListener getJobListener(String name) throws SchedulerException {
        return this.sched.getListenerManager().getJobListener(name);
    }

    @Override
    public void addGlobalTriggerListener(TriggerListener triggerListener) throws SchedulerException {
    }

    @Override
    public void addTriggerListener(TriggerListener triggerListener) throws SchedulerException {
        this.sched.getListenerManager().addTriggerListener(triggerListener);
    }

    @Override
    public boolean removeGlobalTriggerListener(TriggerListener triggerListener) throws SchedulerException {
        return false;
    }

    @Override
    public boolean removeTriggerListener(String name) throws SchedulerException {
        return this.sched.getListenerManager().removeTriggerListener(name);
    }

    @Override
    public List getGlobalTriggerListeners() throws SchedulerException {
        return null;
    }

    @Override
    public Set getTriggerListenerNames() throws SchedulerException {
        HashSet<String> listenerNames = new HashSet<String>();
        for (TriggerListener ls : this.sched.getListenerManager().getTriggerListeners()) {
            listenerNames.add(ls.getName());
        }
        return listenerNames;
    }

    @Override
    public TriggerListener getTriggerListener(String name) throws SchedulerException {
        return this.sched.getListenerManager().getTriggerListener(name);
    }

    @Override
    public void addSchedulerListener(SchedulerListener schedulerListener) throws SchedulerException {
        this.sched.getListenerManager().addSchedulerListener(schedulerListener);
    }

    @Override
    public boolean removeSchedulerListener(SchedulerListener schedulerListener) throws SchedulerException {
        return this.sched.getListenerManager().removeSchedulerListener(schedulerListener);
    }

    @Override
    public List getSchedulerListeners() throws SchedulerException {
        return this.sched.getListenerManager().getSchedulerListeners();
    }

    static {
        ORMScheduler.initMySelf();
    }
}

