/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.celleditors;

import com.kingdee.bos.tool.widgets.DatePickerCombo;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DateCellEditor
extends CellEditor {
    private Date date;
    private DateFormat format;
    private DatePickerCombo comboBox;
    private ILabelProvider labelProvider;
    private static final int defaultStyle = 0;

    public DateCellEditor(Composite parent) {
        this(parent, 0);
    }

    public DateCellEditor(Composite parent, ILabelProvider provider) {
        this(parent, 0);
        this.labelProvider = provider;
    }

    public DateCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    public DateCellEditor(Composite parent, ILabelProvider provider, int style) {
        super(parent, style);
        this.labelProvider = provider;
    }

    public void setFormat(DateFormat format) {
        this.format = format;
    }

    public DateFormat getFormat() {
        return this.format;
    }

    protected Control createControl(Composite parent) {
        this.comboBox = new DatePickerCombo(parent, this.labelProvider, this.getStyle());
        this.comboBox.setFont(parent.getFont());
        this.comboBox.setDate(this.date);
        this.populateFormat();
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                DateCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DateCellEditor.this.applyEditorValueAndDeactivate();
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                DateCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent event) {
                DateCellEditor.this.applyEditorValueAndDeactivate();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        return this.comboBox;
    }

    protected Object doGetValue() {
        return this.date;
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.comboBox == null || this.comboBox.isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gc = new GC((Drawable)this.comboBox);
            layoutData.minimumWidth = gc.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gc.dispose();
        }
        return layoutData;
    }

    protected void doSetValue(Object value) {
        if (!(value instanceof Date)) {
            value = new Date();
        }
        this.date = (Date)value;
        this.comboBox.setDate(this.date);
    }

    void applyEditorValueAndDeactivate() {
        this.date = this.comboBox.getDate();
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.date));
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        }
    }

    private void populateFormat() {
        if (this.comboBox != null && !this.comboBox.isDisposed()) {
            this.comboBox.setFormat(this.format);
        }
    }
}

