/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.common;

import com.kingdee.bos.tool.common.GloalContext;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;

public class IDESystem {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.common.IDESystem");
    private static final String LOCALE_RESOURCE = "ideconfig.properties";
    static Locale IDE_LOCALE = new Locale("zh", "CN");
    public static final String MAIN_PERSPECTIVE_ID = "com.kingdee.bos.studio.perspective.MainPerspective";
    public static final String BUSINESSVIEW_ID = "com.kingdee.bos.studio.view.BusinessView";
    public static final String PACKAGEVIEW_ID = "com.kingdee.bos.studio.view.PackageView";
    public static final String NAVIGATORVIEW_ID = "com.kingdee.bos.ide.ideplugin.BOSResourceNavigator";
    public static final String CVSVIEW_ID = "org.eclipse.team.ccvs.ui.RepositoriesView";
    public static final String TYPEVIEW_ID = "com.kingdee.bos.studio.view.TypeView";
    public static String[] ALL_SUPPORT_LANGUAG = new String[]{"zh_CN", "zh_TW", "en_US", "ja_JP", "ko_KR"};
    public static final String DECORATOR_RESOURCE_ID = "com.kingdee.bos.ide.decorators.ResourceDecorator";
    public static final String DECORATOR_LOCAL_NAME = "lockresource";
    public static final String TABLE_PLUGIN_ID = "com.kingdee.bos.ide.ideplugin.BaseTableView";
    public static final String PROPERTYSHEET_ID = "org.eclipse.ui.views.PropertySheet";
    public static final String CONTENT_ID = "org.eclipse.ui.views.ContentOutline";
    public static final String SEPARATOR = System.getProperty("file.separator");
    public static final String POPUPMENU_METHOD_NAME = "popmethodname";
    public static final String POPUPMENU_IMAGE_NAME = "popimagename";
    public static final String ADD_NODES = "addnodes";
    public static final String DEL_NODES = "delnodes";
    public static final String REFRESH_NODES = "refreshnodes";
    public static final String ADD_SINGLE_NODES = "addsinglenodes";
    public static final String DEL_SINGLE_NODES = "delsinglenodes";
    public static final String LOCK_NODES = "locknodes";
    public static final String UNLOCK_NODES = "unlocknodes";
    public static final String SYNC_LOCK = "synclocknodes";
    public static final String ADD_MODELING_NODES = "addmodelnodes";
    public static final String DEL_MODELING_NODES = "delmodelnodes";
    public static final String MODIFY_NODES = "modifynodes";
    public static final String CONTROLLER = "controller";
    public static final String SOLUTION_INIT_NAME = "solution";
    public static final String PICTURE_NODE_EXT = "picturenode";
    public static final String PICTURE_LEAF_EXT = "pictureleaf";
    public static final String NODE_TYPE = "nodetype";
    public static final String LEAF_TYPE = "leaftype";
    public static final String APPLICATION_NODE = "application";
    public static final String SOLUTION_NODE = "solutionnode";
    public static final String SUBSYSTEM_NODE = "subsystemnode";
    public static final String SOLUTION_CONFIG_FILENAME = ".solution.xml";
    public static final String APPLICATION_VIEW_NAME = "bos.appview";
    public static final String ERROR = "error!";
    public static final String LOCK_FILENAME = ".lock";
    public static final String CVS_FOLDER = "CVS";
    public static final String STATE_FILE = "bosstudio.ini";
    public static final String STATE_FILE_SOLUTION_KEY = "solution";
    public static final String SYSTEM_SEPARATOR = "/";
    public static final String DOT = ".";
    public static final String ALL = "*.*";
    public static final String POPUPMENU = "popupmenu";
    public static final String IMAGEOBJECT = "imageobject";
    public static final String LOCKIMAGEOBJECT = "lockimageobject";
    public static final String MENU_SEPARATOR = "separator";
    public static final String ONE = "a.";
    public static final String TWO = "b.";
    public static final String THREE = "c.";
    public static final String FOUR = "d.";
    public static final String FIVE = "e.";
    public static final String SIX = "f.";
    public static final String SEVEN = "g.";
    public static final String EIGHT = "h.";
    public static final String NINE = "i.";
    public static final String TEN = "j.";
    public static final String ELEVEN = "k.";
    public static final String TWELVE = "l.";
    public static final String THIRTEEN = "m.";
    public static final String FOURTEEN = "n.";
    public static final String FIFTEEN = "o.";
    public static final String SIXTEEN = "p.";
    public static final String SEVENTEEN = "q.";
    public static final String EIGHTEEN = "r.";
    public static final String NINETEEN = "s.";
    public static final String TWENTY = "t.";
    public static final String WIZARD_IMAGE_URL = "";
    public static final String DEFAULT_IMAGE_URL = "icons/";
    public static final String DEFAULT_IMAGE_PATH = "icons/";

    public static String getUrlPath(String filename) {
        String base = null;
        if (filename.indexOf(SEPARATOR) == -1) {
            base = "icons/" + filename;
        } else {
            try {
                base = new File(filename).toURL().toString();
            }
            catch (Exception e) {
                logger.error((Object)WIZARD_IMAGE_URL, (Throwable)e);
                base = null;
            }
        }
        return base;
    }

    public static String getImagePath(String filename) {
        String base = null;
        base = filename.indexOf(SEPARATOR) == -1 ? "icons/" + filename : filename;
        return base;
    }

    public static IFile getFileResource(String res) {
        if (res == null) {
            return null;
        }
        IFolder cfolder = null;
        IFile cfile = null;
        String del = SYSTEM_SEPARATOR;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String projectname = res = res.substring(res.indexOf(del) + 1);
        if (res.indexOf(del) != -1) {
            projectname = res.substring(0, res.indexOf(del));
        }
        res = res.substring(res.indexOf(del));
        IProject cproject = root.getProject(projectname);
        if (!cproject.exists()) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(res, del, false);
        String filename = res.substring(res.lastIndexOf(del) + 1);
        boolean isfirst = true;
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            if (isfirst) {
                if (str.equals(filename)) {
                    cfile = cproject.getFile(str);
                } else {
                    cfolder = cproject.getFolder(str);
                    if (!cfolder.exists()) {
                        return null;
                    }
                }
                isfirst = false;
                continue;
            }
            if (cfolder == null) continue;
            if (str.equals(filename)) {
                cfile = cfolder.getFile(str);
                continue;
            }
            if ((cfolder = cfolder.getFolder(str)).exists()) continue;
            return null;
        }
        return cfile;
    }

    public static IResource getResource(String res) {
        if (res == null || res.length() == 0) {
            return null;
        }
        Object resource = null;
        resource = res.lastIndexOf(SYSTEM_SEPARATOR) == res.length() - 1 ? IDESystem.getFolderResource(res) : IDESystem.getFileResource(res);
        return resource;
    }

    public static IResource[] getResource(List res) {
        if (res == null || res.size() == 0) {
            return null;
        }
        int len = res.size();
        IResource[] resources = new IResource[len];
        for (int i = 0; i < len; ++i) {
            IResource r = IDESystem.getResource((String)res.get(i));
            if (r == null) continue;
            resources[i] = r;
        }
        return resources;
    }

    public static IFolder getFolderResource(String res) {
        if (res == null) {
            return null;
        }
        IFolder cfolder = null;
        IFile cfile = null;
        String del = SYSTEM_SEPARATOR;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        res = res.substring(res.indexOf(del) + 1);
        String projectname = res.substring(0, res.indexOf(del));
        res = res.substring(res.indexOf(del));
        IProject cproject = root.getProject(projectname);
        if (!cproject.exists()) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(res, del, false);
        String filename = res.substring(res.lastIndexOf(del) + 1);
        boolean isfirst = true;
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            if (isfirst) {
                if (str.equals(filename)) {
                    cfile = cproject.getFile(str);
                } else {
                    cfolder = cproject.getFolder(str);
                    if (!cfolder.exists()) {
                        return null;
                    }
                }
                isfirst = false;
                continue;
            }
            if (cfolder == null) continue;
            if (str.equals(filename)) {
                cfile = cfolder.getFile(str);
                continue;
            }
            if ((cfolder = cfolder.getFolder(str)).exists()) continue;
            return null;
        }
        return cfolder;
    }

    public static void arrayToHashtable(String[][] col, Hashtable ht) {
        if (col == null || ht == null) {
            return;
        }
        int len = col.length;
        for (int i = 0; i < len; ++i) {
            if (col[i][0] == null || col[i][1] == null) continue;
            ht.put(col[i][0], col[i][1]);
        }
    }

    public static String replaceAll(String str, String source, String targe) {
        if (str == null || str.length() == 0) {
            return WIZARD_IMAGE_URL;
        }
        StringBuffer newstr = new StringBuffer();
        StringTokenizer st = new StringTokenizer(str, source, false);
        while (st.hasMoreTokens()) {
            newstr.append(st.nextToken()).append(targe);
        }
        String str1 = newstr.toString();
        return str1.substring(0, str1.length() - 1);
    }

    public static void putHashtable(Hashtable ht1, Object key, Object value) {
        if (ht1 == null) {
            return;
        }
        if (key != null && value != null) {
            ht1.put(key, value);
        }
    }

    public static void mergeList(List source, List targe) {
        if (source == null || targe == null) {
            return;
        }
        int len = targe.size();
        for (int i = 0; i < len; ++i) {
            source.add(targe.get(i));
        }
    }

    public static void mergeVectorToList(List source, Vector targe) {
        if (source == null || targe == null) {
            return;
        }
        int len = targe.size();
        for (int i = 0; i < len; ++i) {
            source.add(targe.get(i));
        }
    }

    public static String getWorkSpaceRootOSPath() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace.getRoot().getLocation().toOSString();
    }

    public static String osResourceToEResource(String file) {
        File osfile;
        String rootpath = IDESystem.getWorkSpaceRootOSPath();
        if (!GloalContext.SOLUTION_FOLDER.equals(rootpath)) {
            rootpath = GloalContext.SOLUTION_FOLDER;
        }
        String fpath = file.substring(rootpath.length());
        fpath = SYSTEM_SEPARATOR + IDESystem.replaceAll(fpath, SEPARATOR, SYSTEM_SEPARATOR);
        if (!GloalContext.SOLUTION_FOLDER.equals(IDESystem.getWorkSpaceRootOSPath())) {
            fpath = GloalContext.CURRENT_SOLUTION + fpath.substring(1);
        }
        if ((osfile = new File(file)).isDirectory()) {
            fpath = fpath + SYSTEM_SEPARATOR;
        }
        return fpath;
    }

    public static String EResourceToOSResource(String file) {
        int loc;
        String rootpath = IDESystem.getWorkSpaceRootOSPath();
        if (!GloalContext.SOLUTION_FOLDER.equals(rootpath)) {
            rootpath = GloalContext.SOLUTION_FOLDER;
        }
        String fpath = IDESystem.replaceAll(file, SYSTEM_SEPARATOR, SEPARATOR);
        fpath = !GloalContext.SOLUTION_FOLDER.equals(IDESystem.getWorkSpaceRootOSPath()) ? ((loc = fpath.indexOf(SEPARATOR)) != -1 ? rootpath + fpath.substring(loc) : rootpath) : rootpath + SEPARATOR + fpath;
        return fpath;
    }

    public static Locale getLocale() {
        return IDE_LOCALE;
    }

    public static void main(String[] args) {
    }
}

