/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.console;

import com.kingdee.bos.tool.console.ConsoleDocument;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jface.text.IDocumentListener;

public class ConsoleDocumentManager {
    private HashMap fDocuments = new HashMap();
    private ConsoleDocument fCurrentDocument;
    private static ConsoleDocument NULL_DOC = new ConsoleDocument("NULL");

    public void addDocumentListener(IDocumentListener lsnr) {
        for (ConsoleDocument doc : this.getDocuments()) {
            doc.addDocumentListener(lsnr);
        }
    }

    public void removeDocumentListener(IDocumentListener lsnr) {
        for (ConsoleDocument doc : this.getDocuments()) {
            doc.removeDocumentListener(lsnr);
        }
    }

    public Collection getDocuments() {
        return this.fDocuments.values();
    }

    public ConsoleDocument createDocument(String streamId) {
        ConsoleDocument doc = new ConsoleDocument(streamId);
        this.fDocuments.put(streamId, doc);
        this.fCurrentDocument = doc;
        return doc;
    }

    public ConsoleDocument getDocument(String streamId) {
        return (ConsoleDocument)((Object)this.fDocuments.get(streamId));
    }

    public void removeDocument(String streamId) {
        if (!this.fDocuments.containsKey(streamId)) {
            return;
        }
        this.fDocuments.remove(streamId);
        this.fCurrentDocument = this.fDocuments.size() == 0 ? NULL_DOC : (ConsoleDocument)((Object)this.getDocuments().iterator().next());
    }

    public ConsoleDocument getCurrentDocument() {
        if (this.fCurrentDocument == null) {
            this.fCurrentDocument = NULL_DOC;
        }
        return this.fCurrentDocument;
    }

    public void setCurrentDocment(String streamId) {
        this.fCurrentDocument = this.getDocument(streamId);
    }
}

