/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.console;

import com.kingdee.bos.tool.ToolBasePlugin;
import com.kingdee.bos.tool.console.ConsoleDocument;
import com.kingdee.bos.tool.console.IHyperLink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ConsoleViewer
extends TextViewer
implements MouseTrackListener,
MouseMoveListener,
MouseListener,
PaintListener,
Listener {
    private Cursor fHandCursor;
    private Cursor fTextCursor;
    private IHyperLink fCurrentLink;

    public ConsoleDocument getConsoleDocument() {
        return (ConsoleDocument)this.getDocument();
    }

    public ConsoleViewer(Composite parent) {
        super(parent, 768);
        this.getTextWidget().addMouseTrackListener((MouseTrackListener)this);
        this.getTextWidget().addPaintListener((PaintListener)this);
    }

    protected void linkEntered(IHyperLink link) {
        StyledText control = this.getTextWidget();
        control.setRedraw(false);
        if (this.fCurrentLink != null) {
            this.linkExited(this.fCurrentLink);
        }
        this.fCurrentLink = link;
        control.setCursor(this.getHandCursor());
        control.setRedraw(true);
        control.redraw();
        control.addMouseListener((MouseListener)this);
    }

    protected void linkExited(IHyperLink link) {
        this.fCurrentLink = null;
        StyledText control = this.getTextWidget();
        control.setCursor(this.getTextCursor());
        control.redraw();
        control.removeMouseListener((MouseListener)this);
    }

    private static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected Cursor getHandCursor() {
        if (this.fHandCursor == null) {
            this.fHandCursor = new Cursor((Device)ConsoleViewer.getStandardDisplay(), 21);
        }
        return this.fHandCursor;
    }

    protected Cursor getTextCursor() {
        if (this.fTextCursor == null) {
            this.fTextCursor = new Cursor((Device)ConsoleViewer.getStandardDisplay(), 19);
        }
        return this.fTextCursor;
    }

    public void mouseEnter(MouseEvent e) {
        this.getTextWidget().addMouseMoveListener((MouseMoveListener)this);
    }

    public void mouseExit(MouseEvent e) {
        this.getTextWidget().removeMouseMoveListener((MouseMoveListener)this);
        if (this.fCurrentLink != null) {
            this.linkExited(this.fCurrentLink);
        }
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseMove(MouseEvent e) {
        int offset = -1;
        try {
            Point p = new Point(e.x, e.y);
            offset = this.getTextWidget().getOffsetAtLocation(p);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.updateLinks(offset);
    }

    public void mouseDoubleClick(MouseEvent arg0) {
    }

    public void mouseDown(MouseEvent arg0) {
    }

    public void mouseUp(MouseEvent e) {
        String selection;
        if (this.fCurrentLink != null && (selection = this.getTextWidget().getSelectionText()).length() <= 0 && e.button == 1) {
            this.fCurrentLink.linkActivated();
        }
    }

    public void paintControl(PaintEvent e) {
        int line;
        if (this.fCurrentLink != null && (line = this.getConsoleDocument().getLineOfLink(this.fCurrentLink)) != -1) {
            try {
                IRegion lineRegion = this.getConsoleDocument().getLineInformation(line);
                int lineStart = lineRegion.getOffset();
                int lineEnd = lineStart + lineRegion.getLength();
                Point p1 = this.getTextWidget().getLocationAtOffset(lineStart);
                Point p2 = this.getTextWidget().getLocationAtOffset(lineEnd);
                FontMetrics metrics = e.gc.getFontMetrics();
                int height = metrics.getHeight();
                e.gc.drawLine(p1.x, p1.y + height, p2.x, p2.y + height);
            }
            catch (BadLocationException e1) {
                ToolBasePlugin.log(e1);
            }
        }
    }

    public void handleEvent(Event e) {
        int offset = this.getTextWidget().getCaretOffset();
        this.updateLinks(offset);
    }

    protected void updateLinks(int offset) {
        IHyperLink link;
        if (offset >= 0 && (link = this.getConsoleDocument().getLineLink(offset)) != null) {
            if (link.equals(this.fCurrentLink)) {
                return;
            }
            this.linkEntered(link);
            return;
        }
        if (this.fCurrentLink != null) {
            this.linkExited(this.fCurrentLink);
        }
    }
}

