/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.console;

import com.kingdee.bos.tool.console.IHyperLink;
import com.kingdee.bos.tool.console.IUserStream;
import com.kingdee.bos.tool.console.IUserStreamListener;
import com.kingdee.bos.tool.console.UserStreamManager;
import java.util.Vector;
import org.eclipse.swt.graphics.Color;

public class UserStreamImpl
implements IUserStream {
    private Vector fListenerList;
    private String fStreamId;
    private boolean fIsClosed;
    private Color fColor;
    private Color fLinkColor;

    public UserStreamImpl(String streamId) {
        this.fStreamId = streamId;
        this.fListenerList = new Vector(10);
        this.fColor = UserStreamManager.NORMAL_COLOR;
        this.fLinkColor = UserStreamManager.LINK_COLOR;
    }

    @Override
    public String getStreamId() {
        return this.fStreamId;
    }

    @Override
    public boolean isClosed() {
        return this.fIsClosed;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.fIsClosed = true;
        this.fireStreamClosed();
        this.fListenerList.removeAllElements();
        this.fListenerList = null;
    }

    private void fireStreamClosed() {
        for (IUserStreamListener listener : this.fListenerList) {
            listener.streamStopped(this.getStreamId());
        }
    }

    @Override
    public Color getColor() {
        return this.fColor;
    }

    @Override
    public void setColor(Color color) {
        this.fColor = color;
    }

    @Override
    public void println(String line) {
        this.println(line, this.getColor());
    }

    @Override
    public void println(String line, Color color) {
        this.fireLineAdded(line, color, null);
    }

    private void fireLineAdded(String line, Color color, IHyperLink link) {
        if (this.isClosed()) {
            return;
        }
        for (IUserStreamListener listener : this.fListenerList) {
            listener.streamLineAdded(this.getStreamId(), line, color, link);
        }
    }

    @Override
    public void addStreamListener(IUserStreamListener listener) {
        this.fListenerList.add(listener);
    }

    @Override
    public void removeStreamListener(IUserStreamListener listener) {
        this.fListenerList.remove(listener);
    }

    @Override
    public Color getLinkColor() {
        return this.fLinkColor;
    }

    @Override
    public void setLinkColor(Color color) {
        this.fLinkColor = color;
    }

    @Override
    public void println(String line, IHyperLink link) {
        this.fireLineAdded(line, this.getLinkColor(), link);
    }
}

