/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dialogs;

import com.kingdee.bos.tool.dialogs.BidirectionalSelectDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TwoTableBiSelectionDialog
extends BidirectionalSelectDialog {
    private TableViewer leftTableViewer;
    private TableViewer rightTableViewer;
    private List model;
    private ITableLabelProvider tableLabelProvider;
    private String[] columnProperties;

    public TwoTableBiSelectionDialog(Shell parentShell, String title, List model) {
        this(parentShell, title, model, 0);
    }

    public TwoTableBiSelectionDialog(Shell parentShell, String title, List model, int layoutStyle) {
        super(parentShell, title, layoutStyle);
        this.setModel(model);
    }

    public TwoTableBiSelectionDialog(Shell parentShell, String title) {
        this(parentShell, title, Collections.EMPTY_LIST);
    }

    public TwoTableBiSelectionDialog(Shell parentShell, String title, int layoutStyle) {
        this(parentShell, title, Collections.EMPTY_LIST, layoutStyle);
    }

    public final void setModel(List model) {
        this.model = model;
    }

    public final void setTableLabelProvider(ITableLabelProvider labelProvider) {
        this.tableLabelProvider = labelProvider;
    }

    public final void setColumnProperties(String[] columnProperties) {
        this.columnProperties = columnProperties;
    }

    public final List getSelectedModel() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object obj : this.model) {
            if (!(obj instanceof BidirectionalSelectDialog.ModelWrapper) || 2 != ((BidirectionalSelectDialog.ModelWrapper)obj).getPosition()) continue;
            result.add(((BidirectionalSelectDialog.ModelWrapper)obj).getObject());
        }
        return result;
    }

    @Override
    protected final Control createLeftAreaControl(Composite parent) {
        Table table = this.createTable(parent);
        this.leftTableViewer = new TableViewer(table);
        if (this.columnProperties == null) {
            this.columnProperties = new String[0];
        }
        this.leftTableViewer.setColumnProperties(this.columnProperties);
        this.leftTableViewer.setContentProvider((IContentProvider)new InnerTableContentProvider(1));
        if (this.tableLabelProvider == null) {
            this.tableLabelProvider = new InnerTableLabelProvider();
        }
        this.leftTableViewer.setLabelProvider((IBaseLabelProvider)this.tableLabelProvider);
        this.leftTableViewer.setInput((Object)this.model);
        return table;
    }

    @Override
    protected final Control createRightAreaControl(Composite parent) {
        Table table = this.createTable(parent);
        this.rightTableViewer = new TableViewer(table);
        if (this.columnProperties == null) {
            this.columnProperties = new String[0];
        }
        this.rightTableViewer.setColumnProperties(this.columnProperties);
        this.rightTableViewer.setContentProvider((IContentProvider)new InnerTableContentProvider(2));
        if (this.tableLabelProvider == null) {
            this.tableLabelProvider = new InnerTableLabelProvider();
        }
        this.rightTableViewer.setLabelProvider((IBaseLabelProvider)this.tableLabelProvider);
        this.rightTableViewer.setInput((Object)this.model);
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TwoTableBiSelectionDialog.this.handleRightTableSelect();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return table;
    }

    protected void handleRightTableSelect() {
        Table table = this.rightTableViewer.getTable();
        TableItem[] items = table.getSelection();
        if (items.length != 1) {
            return;
        }
        int index = table.getSelectionIndex();
        boolean first = false;
        boolean last = false;
        if (index == 0) {
            first = true;
        }
        if (index == table.getItemCount() - 1) {
            last = true;
        }
        this.fireRightAreaSelected(first, last);
    }

    public Table createTable(Composite parent) {
        Table table = new Table(parent, 68354);
        return table;
    }

    @Override
    protected final void handleAllToLeft() {
        this.setModelWrapperPosition(1);
        this.refreshTable();
    }

    @Override
    protected final void handleAllToRight() {
        this.setModelWrapperPosition(2);
        this.refreshTable();
    }

    @Override
    protected final void handleSelectToLeft() {
        TableItem[] items = this.rightTableViewer.getTable().getSelection();
        int index = 0;
        int j = items.length;
        for (int i = 0; i < j; ++i) {
            BidirectionalSelectDialog.ModelWrapper wrapper = (BidirectionalSelectDialog.ModelWrapper)items[i].getData();
            if (!this.canDelete(wrapper.getObject())) continue;
            wrapper.switchToLeft();
            index = this.rightTableViewer.getTable().indexOf(items[i]);
        }
        this.refreshTable();
        int count = this.rightTableViewer.getTable().getItemCount();
        if (count > 0 && index >= count) {
            index = count - 1;
        }
        if (index > -1 && count > 0 && index < count) {
            this.rightTableViewer.getTable().select(index);
        }
    }

    public boolean canDelete(Object model) {
        return true;
    }

    public boolean canAdd(Object model) {
        return true;
    }

    public boolean canIndex(Object model) {
        return true;
    }

    @Override
    protected final void handleSelectToRight() {
        TableItem[] items = this.leftTableViewer.getTable().getSelection();
        int index = 0;
        int j = items.length;
        for (int i = 0; i < j; ++i) {
            BidirectionalSelectDialog.ModelWrapper wrapper = (BidirectionalSelectDialog.ModelWrapper)items[i].getData();
            if (!this.canAdd(wrapper.getObject())) continue;
            wrapper.switchToRight();
            index = this.leftTableViewer.getTable().indexOf(items[i]);
        }
        this.refreshTable();
        int count = this.leftTableViewer.getTable().getItemCount();
        if (count > 0 && index >= count) {
            index = count - 1;
        }
        if (index > -1 && count > 0 && index < count) {
            this.leftTableViewer.getTable().select(index);
        }
    }

    @Override
    protected final void handleToBottom() {
        TableItem[] items = this.rightTableViewer.getTable().getSelection();
        int j = items.length;
        int k = this.model.size();
        for (int i = 0; i < j; ++i) {
            int index = this.index((BidirectionalSelectDialog.ModelWrapper)items[i].getData());
            Collections.swap(this.model, index, k - i - 1);
        }
        this.refreshTable();
    }

    @Override
    protected final void handleToDown() {
        Table table = this.rightTableViewer.getTable();
        TableItem[] items = table.getSelection();
        if (items.length != 1) {
            return;
        }
        int index = this.index((BidirectionalSelectDialog.ModelWrapper)items[0].getData());
        Collections.swap(this.model, index, index + 1);
        this.refreshTable();
        this.handleRightTableSelect();
    }

    @Override
    protected final void handleToTop() {
        TableItem[] items = this.rightTableViewer.getTable().getSelection();
        int j = items.length;
        for (int i = 0; i < j; ++i) {
            int index = this.index((BidirectionalSelectDialog.ModelWrapper)items[i].getData());
            Collections.swap(this.model, index, i);
        }
        this.refreshTable();
    }

    @Override
    protected final void handleToUp() {
        Table table = this.rightTableViewer.getTable();
        TableItem[] items = table.getSelection();
        if (items.length != 1) {
            return;
        }
        int index = this.index((BidirectionalSelectDialog.ModelWrapper)items[0].getData());
        Collections.swap(this.model, index, index - 1);
        this.refreshTable();
        this.handleRightTableSelect();
    }

    private void setModelWrapperPosition(int position) {
        for (BidirectionalSelectDialog.ModelWrapper wrapper : this.model) {
            if (!this.canIndex(wrapper.getObject())) continue;
            wrapper.setPosition(position);
        }
    }

    private void refreshTable() {
        this.leftTableViewer.getTable().setRedraw(false);
        this.leftTableViewer.refresh();
        this.leftTableViewer.getTable().setRedraw(true);
        this.rightTableViewer.getTable().setRedraw(false);
        this.rightTableViewer.refresh();
        this.rightTableViewer.getTable().setRedraw(true);
    }

    private int index(BidirectionalSelectDialog.ModelWrapper item) {
        Iterator iter = this.model.iterator();
        int index = -1;
        while (iter.hasNext()) {
            if (iter.next() == item) {
                return ++index;
            }
            ++index;
        }
        return index;
    }

    @Override
    protected String getLeftAreaDescription() {
        return "left table";
    }

    @Override
    protected String getRightAreaDescription() {
        return "right table";
    }

    public void setRightTableEditable(CellEditor[] editors, ICellModifier cellModifier) {
        this.rightTableViewer.setCellEditors(editors);
        this.rightTableViewer.setCellModifier(cellModifier);
    }

    public void setLeftTableEditable(CellEditor[] editors, ICellModifier cellModifier) {
        this.leftTableViewer.setCellEditors(editors);
        this.leftTableViewer.setCellModifier(cellModifier);
    }

    public TableViewer getRightTableViewer() {
        return this.rightTableViewer;
    }

    public TableViewer getLeftTableViewer() {
        return this.leftTableViewer;
    }

    private class InnerTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private InnerTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof BidirectionalSelectDialog.ModelWrapper)) {
                return "error";
            }
            return super.getText(element);
        }
    }

    private class InnerTableContentProvider
    extends LabelProvider
    implements IStructuredContentProvider {
        private int position = 0;

        InnerTableContentProvider(int position) {
            this.position = position;
        }

        public Object[] getElements(Object inputElement) {
            assert (inputElement instanceof List);
            ArrayList ret = new ArrayList();
            for (Object obj : (List)inputElement) {
                if (!(obj instanceof BidirectionalSelectDialog.ModelWrapper) || this.position != ((BidirectionalSelectDialog.ModelWrapper)obj).getPosition()) continue;
                ret.add(obj);
            }
            return ret.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

